/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Min;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MinValidatorForNumber
implements ConstraintValidator<Min, Number> {
    private long minValue;

    @Override
    public void initialize(Min annotation) {
        this.minValue = annotation.value();
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(this.minValue)) >= 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(this.minValue)) >= 0;
        }
        return value.longValue() >= this.minValue;
    }
}

