/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2I_10_3;
import org.apache.derby.impl.store.access.btree.index.B2I_v10_2;
import org.apache.derby.shared.common.error.StandardException;

public class B2IFactory
implements ConglomerateFactory,
ModuleControl {
    private static final String IMPLEMENTATIONID = "BTREE";
    private static final String FORMATUUIDSTRING = "C6CEEEF0-DAD3-11d0-BB01-0060973F0942";
    private UUID formatUUID;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String string) {
        return string.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID uUID) {
        return uUID.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    @Override
    public int getConglomerateFactoryId() {
        return 1;
    }

    @Override
    public Conglomerate createConglomerate(TransactionManager transactionManager, int n, long l, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n2) throws StandardException {
        B2I b2I = null;
        b2I = (n2 & 1) != 0 && transactionManager.getAccessManager().isReadOnly() ? new B2I() : (transactionManager.checkVersion(10, 4, null) ? new B2I() : (transactionManager.checkVersion(10, 3, null) ? new B2I_10_3() : new B2I_v10_2()));
        b2I.create(transactionManager, n, l, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n2);
        return b2I;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conglomerate readConglomerate(TransactionManager transactionManager, ContainerKey containerKey) throws StandardException {
        BTree bTree = null;
        ContainerHandle containerHandle = null;
        ControlRow controlRow = null;
        try {
            containerHandle = transactionManager.getRawStoreXact().openContainer(containerKey, null, 8);
            if (containerHandle == null) {
                throw StandardException.newException((String)"XSAI2.S", (Object[])new Object[]{containerKey.getContainerId()});
            }
            controlRow = ControlRow.get(containerHandle, 1L);
            bTree = controlRow.getConglom(470);
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
            if (containerHandle != null) {
                containerHandle.close();
            }
        }
        return bTree;
    }

    @Override
    public void insertUndoNotify(AccessFactory accessFactory, Transaction transaction, PageKey pageKey) throws StandardException {
    }

    @Override
    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.access.Conglomerate.type");
        if (string == null) {
            return false;
        }
        return this.supportsImplementation(string);
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        UUIDFactory uUIDFactory = B2IFactory.getMonitor().getUUIDFactory();
        this.formatUUID = uUIDFactory.recreateUUID(FORMATUUIDSTRING);
    }

    @Override
    public void stop() {
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

