/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.StorablePreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

public class GenericStorablePreparedStatement
extends GenericPreparedStatement
implements Formatable,
StorablePreparedStatement {
    private ByteArray byteCode;
    private String className;

    public GenericStorablePreparedStatement() {
    }

    GenericStorablePreparedStatement(Statement statement) {
        super(statement);
    }

    @Override
    ByteArray getByteCodeSaver() {
        if (this.byteCode == null) {
            this.byteCode = new ByteArray();
        }
        return this.byteCode;
    }

    @Override
    public GeneratedClass getActivationClass() throws StandardException {
        if (this.activationClass == null) {
            this.loadGeneratedClass();
        }
        return this.activationClass;
    }

    @Override
    void setActivationClass(GeneratedClass generatedClass) {
        super.setActivationClass(generatedClass);
        if (generatedClass != null) {
            this.className = generatedClass.getName();
            if (this.byteCode != null && this.byteCode.getArray() == null) {
                this.byteCode = null;
            }
        }
    }

    @Override
    public void loadGeneratedClass() throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)GenericStorablePreparedStatement.getContext("LanguageConnectionContext");
        ClassFactory classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
        GeneratedClass generatedClass = classFactory.loadGeneratedClass(this.className, this.byteCode);
        this.setActivationClass(generatedClass);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getCursorInfo());
        objectOutput.writeBoolean(this.needsSavepoint());
        objectOutput.writeBoolean(this.isAtomic);
        objectOutput.writeObject(this.executionConstants);
        objectOutput.writeObject(this.resultDesc);
        if (this.savedObjects == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            ArrayUtil.writeArrayLength((ObjectOutput)objectOutput, (Object[])this.savedObjects);
            ArrayUtil.writeArrayItems((ObjectOutput)objectOutput, (Object[])this.savedObjects);
        }
        objectOutput.writeObject(this.className);
        objectOutput.writeBoolean(this.byteCode != null);
        if (this.byteCode != null) {
            this.byteCode.writeExternal(objectOutput);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setCursorInfo((CursorInfo)objectInput.readObject());
        this.setNeedsSavepoint(objectInput.readBoolean());
        this.isAtomic = objectInput.readBoolean();
        this.executionConstants = (ConstantAction)objectInput.readObject();
        this.resultDesc = (ResultDescription)objectInput.readObject();
        if (objectInput.readBoolean()) {
            this.savedObjects = new Object[ArrayUtil.readArrayLength((ObjectInput)objectInput)];
            ArrayUtil.readArrayItems((ObjectInput)objectInput, (Object[])this.savedObjects);
        }
        this.className = (String)objectInput.readObject();
        if (objectInput.readBoolean()) {
            this.byteCode = new ByteArray();
            this.byteCode.readExternal(objectInput);
        } else {
            this.byteCode = null;
        }
    }

    @Override
    public int getTypeFormatId() {
        return 225;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public String toString() {
        return "";
    }

    private static Context getContext(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }
}

