/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class UnaryDateTimestampOperatorNode
extends UnaryOperatorNode {
    private static final String TIMESTAMP_METHOD_NAME = "getTimestamp";
    private static final String DATE_METHOD_NAME = "getDate";
    static final int K_DATE = 0;
    static final int K_TIMESTAMP = 1;
    final int kind;

    UnaryDateTimestampOperatorNode(ValueNode valueNode, int n, ContextManager contextManager) throws StandardException {
        super(valueNode, n == 0 ? "date" : "timestamp", n == 0 ? DATE_METHOD_NAME : TIMESTAMP_METHOD_NAME, contextManager);
        this.kind = n;
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(n == 0 ? 91 : 93));
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        this.bindOperand(fromList, subqueryList, list);
        DataTypeDescriptor dataTypeDescriptor = this.operand.getTypeServices();
        switch (dataTypeDescriptor.getJDBCTypeId()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                bl2 = true;
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 91: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                bl = true;
                break;
            }
            case 0: {
                break;
            }
            case 93: {
                if (!TIMESTAMP_METHOD_NAME.equals(this.methodName)) break;
                bl = true;
                break;
            }
            default: {
                this.invalidOperandType();
            }
        }
        if (this.operand instanceof ConstantNode) {
            DataValueFactory dataValueFactory = this.getLanguageConnectionContext().getDataValueFactory();
            DataValueDescriptor dataValueDescriptor = ((ConstantNode)this.operand).getValue();
            DateTimeDataValue dateTimeDataValue = dataValueDescriptor.isNull() ? (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dataValueFactory.getNullTimestamp(null) : dataValueFactory.getNullDate(null)) : (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dataValueFactory.getTimestamp(dataValueDescriptor) : dataValueFactory.getDate(dataValueDescriptor));
            return new UserTypeConstantNode(dateTimeDataValue, this.getContextManager());
        }
        if (bl) {
            return this.operand;
        }
        return this;
    }

    private void invalidOperandType() throws StandardException {
        throw StandardException.newException("42X25", this.getOperatorString(), this.getOperand().getTypeServices().getSQLstring());
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushDataValueFactory(methodBuilder);
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.callMethod((short)185, null, this.methodName, this.getTypeCompiler().interfaceName(), 1);
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((UnaryDateTimestampOperatorNode)valueNode).kind == this.kind;
    }
}

