/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class GroupByColumn
extends OrderedColumn {
    private ValueNode columnExpression;

    GroupByColumn(ValueNode valueNode, ContextManager contextManager) {
        super(contextManager);
        this.columnExpression = valueNode;
    }

    @Override
    void printSubNodes(int n) {
    }

    String getColumnName() {
        return this.columnExpression.getColumnName();
    }

    void bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        int n = this.orReliability(16384);
        this.columnExpression = this.columnExpression.bindExpression(fromList, subqueryList, list);
        this.getCompilerContext().setReliability(n);
        if (this.columnExpression.isParameterNode()) {
            throw StandardException.newException("42Y36", this.columnExpression);
        }
        TypeId typeId = this.columnExpression.getTypeId();
        if (!typeId.orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
        }
    }

    ValueNode getColumnExpression() {
        return this.columnExpression;
    }

    void setColumnExpression(ValueNode valueNode) {
        this.columnExpression = valueNode;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.columnExpression != null) {
            this.columnExpression = (ValueNode)this.columnExpression.accept(visitor);
        }
    }
}

