/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.iapi.types.StreamHeaderGenerator;

public final class ReaderToUTF8Stream
extends InputStream {
    private LimitReader reader;
    private static final int FIRST_READ = Integer.MIN_VALUE;
    private static final int READ_BUFFER_RESERVATION = 6;
    private static final int MARK_UNSET_OR_EXCEEDED = -1;
    private byte[] buffer;
    private int boff;
    private int blen = -1;
    private int mark = -1;
    private int readAheadLimit;
    private boolean eof;
    private boolean multipleBuffer;
    private final StreamHeaderGenerator hdrGen;
    private int headerLength;
    private final int charsToTruncate;
    private static final char SPACE = ' ';
    private final int valueLength;
    private final String typeName;
    private int charCount;

    public ReaderToUTF8Stream(Reader reader, int n, int n2, String string, StreamHeaderGenerator streamHeaderGenerator) {
        this.reader = new LimitReader(reader);
        this.charsToTruncate = n2;
        this.valueLength = n;
        this.typeName = string;
        this.hdrGen = streamHeaderGenerator;
        int n3 = Math.abs(n);
        this.reader.setLimit(n3);
        int n4 = 32768;
        if (n3 < n4 / 3) {
            n4 = this.hdrGen.getMaxHeaderLength() + Math.max(6, n3 * 3 + 3);
        }
        this.buffer = new byte[n4];
    }

    public ReaderToUTF8Stream(Reader reader, int n, String string, StreamHeaderGenerator streamHeaderGenerator) {
        this(reader, -1 * n, 0, string, streamHeaderGenerator);
        if (n < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + n);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.blen < 0) {
            this.fillBuffer(Integer.MIN_VALUE);
        }
        while (this.boff == this.blen) {
            if (this.eof) {
                this.close();
                return -1;
            }
            this.fillBuffer(0);
        }
        return this.buffer[this.boff++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.blen < 0) {
            this.fillBuffer(Integer.MIN_VALUE);
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.blen - this.boff;
            if (n4 == 0) {
                if (this.eof) {
                    if (n3 > 0) {
                        return n3;
                    }
                    this.close();
                    return -1;
                }
                this.fillBuffer(0);
                continue;
            }
            if (n2 < n4) {
                n4 = n2;
            }
            System.arraycopy(this.buffer, this.boff, byArray, n, n4);
            this.boff += n4;
            n2 -= n4;
            n3 += n4;
            n += n4;
        }
        return n3;
    }

    private void fillBuffer(int n) throws IOException {
        int n2;
        if (n == Integer.MIN_VALUE) {
            this.headerLength = this.hdrGen.expectsCharCount() && this.valueLength >= 0 ? this.hdrGen.generateInto(this.buffer, 0, this.valueLength) : this.hdrGen.generateInto(this.buffer, 0, -1L);
            n = this.headerLength;
        }
        int n3 = n;
        this.boff = 0;
        if (n3 == 0) {
            this.multipleBuffer = true;
        }
        if (this.mark >= 0) {
            n2 = this.readAheadLimit + 6;
            if (this.mark + n2 > this.buffer.length) {
                if (this.blen != -1) {
                    this.boff = n3 = this.blen - this.mark;
                }
                byte[] byArray = this.buffer;
                if (n2 > this.buffer.length) {
                    this.buffer = new byte[n2];
                }
                System.arraycopy(byArray, this.mark, this.buffer, 0, n3);
                this.mark = 0;
            } else if (this.blen != -1) {
                this.mark = -1;
            }
        }
        while (n3 <= this.buffer.length - 6) {
            n2 = this.reader.read();
            if (n2 < 0) {
                this.eof = true;
                break;
            }
            ++this.charCount;
            if (n2 >= 1 && n2 <= 127) {
                this.buffer[n3++] = (byte)n2;
                continue;
            }
            if (n2 > 2047) {
                this.buffer[n3++] = (byte)(0xE0 | n2 >> 12 & 0xF);
                this.buffer[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
                this.buffer[n3++] = (byte)(0x80 | n2 >> 0 & 0x3F);
                continue;
            }
            this.buffer[n3++] = (byte)(0xC0 | n2 >> 6 & 0x1F);
            this.buffer[n3++] = (byte)(0x80 | n2 >> 0 & 0x3F);
        }
        this.blen = n3;
        if (this.eof) {
            this.checkSufficientData();
        }
    }

    private void checkSufficientData() throws IOException {
        int n;
        if (this.charsToTruncate > 0) {
            this.reader.setLimit(this.charsToTruncate);
            this.truncate();
        }
        if ((n = this.reader.clearLimit()) > 0 && this.valueLength > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
        }
        if (n == 0 && this.reader.read() >= 0) {
            if (this.valueLength > -1) {
                throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
            }
            if (this.canTruncate()) {
                this.truncate();
            } else {
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "<stream-value>", String.valueOf(Math.abs(this.valueLength))), "22001");
            }
        }
        if (!this.multipleBuffer) {
            int n2 = -1;
            n2 = this.hdrGen.expectsCharCount() ? this.charCount : this.blen - this.headerLength;
            int n3 = this.hdrGen.generateInto(this.buffer, 0, n2);
            if (n3 != this.headerLength) {
                throw new IOException("Data corruption detected; user data overwritten by header bytes");
            }
            this.blen += this.hdrGen.writeEOF(this.buffer, this.blen, n2);
        } else {
            this.blen += this.hdrGen.writeEOF(this.buffer, this.blen, Math.max(this.valueLength, -1));
        }
    }

    private boolean canTruncate() {
        if (this.typeName.equals("CLOB")) {
            return true;
        }
        if (this.typeName.equals("VARCHAR")) {
            return true;
        }
        return this.typeName.equals("CHAR");
    }

    private void truncate() throws IOException {
        int n = 0;
        while ((n = this.reader.read()) >= 0) {
            if (n == 32) continue;
            throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "<stream-value>", String.valueOf(Math.abs(this.valueLength))), "22001");
        }
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public final int available() {
        int n = this.reader.getLimit();
        return this.buffer.length > n ? n : this.buffer.length;
    }

    @Override
    public void mark(int n) {
        if (n > 0) {
            this.readAheadLimit = n;
            this.mark = this.boff;
        } else {
            this.mark = -1;
            this.readAheadLimit = -1;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.mark == -1) {
            throw new IOException(MessageService.getTextMessage("I027", new Object[0]));
        }
        this.boff = this.mark;
        this.mark = -1;
        this.readAheadLimit = -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

