/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.io.Serializable;
import java.util.List;
import javax.validation.ElementKind;
import javax.validation.Path;

public class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INDEX_OPEN = "[";
    private static final String INDEX_CLOSE = "]";
    private List<Class<?>> parameterTypes;
    private String name;
    private boolean inIterable;
    private Integer index;
    private int parameterIndex;
    private Object key;
    private ElementKind kind;

    public static StringBuilder appendNode(Path.Node node, StringBuilder to) {
        if (node.isInIterable()) {
            to.append(INDEX_OPEN);
            if (node.getIndex() != null) {
                to.append(node.getIndex());
            } else if (node.getKey() != null) {
                to.append(node.getKey());
            }
            to.append(INDEX_CLOSE);
        }
        if (node.getName() != null) {
            if (to.length() > 0) {
                to.append(".");
            }
            to.append(node.getName());
        }
        return to;
    }

    public static NodeImpl atIndex(Integer index) {
        NodeImpl result = new NodeImpl();
        result.setIndex(index);
        return result;
    }

    public static NodeImpl atKey(Object key) {
        NodeImpl result = new NodeImpl();
        result.setKey(key);
        return result;
    }

    public NodeImpl(String name) {
        this.name = name;
    }

    NodeImpl(Path.Node node) {
        this.name = node.getName();
        this.inIterable = node.isInIterable();
        this.index = node.getIndex();
        this.key = node.getKey();
        this.kind = node.getKind();
    }

    private NodeImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isInIterable() {
        return this.inIterable;
    }

    public void setInIterable(boolean inIterable) {
        this.inIterable = inIterable;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.inIterable = true;
        this.index = index;
        this.key = null;
    }

    public void setParameterIndex(Integer parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.inIterable = true;
        this.key = key;
        this.index = null;
    }

    @Override
    public ElementKind getKind() {
        return this.kind;
    }

    public void setKind(ElementKind kind) {
        this.kind = kind;
    }

    @Override
    public <T extends Path.Node> T as(Class<T> nodeType) {
        if (nodeType.isInstance(this)) {
            return (T)((Path.Node)nodeType.cast(this));
        }
        throw new ClassCastException("Type " + nodeType + " not supported");
    }

    public String toString() {
        return NodeImpl.appendNode(this, new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        if (this.inIterable != node.inIterable) {
            return false;
        }
        if (this.index != null ? !this.index.equals(node.index) : node.index != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(node.key) : node.key != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(node.name) : node.name != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals((Object)node.kind) : node.kind != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.inIterable ? 1 : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        return result;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(List<Class<?>> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public static class BeanNodeImpl
    extends NodeImpl
    implements Path.BeanNode {
        public BeanNodeImpl() {
        }

        public BeanNodeImpl(Path.Node cast) {
            super(cast);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.BEAN;
        }
    }

    public static class PropertyNodeImpl
    extends NodeImpl
    implements Path.PropertyNode {
        public PropertyNodeImpl(String name) {
            super(name);
        }

        public PropertyNodeImpl(Path.Node cast) {
            super(cast);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PROPERTY;
        }
    }

    public static class ReturnValueNodeImpl
    extends NodeImpl
    implements Path.ReturnValueNode {
        public ReturnValueNodeImpl(Path.Node cast) {
            super(cast);
        }

        public ReturnValueNodeImpl() {
            super("<return value>");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RETURN_VALUE;
        }
    }

    public static class MethodNodeImpl
    extends NodeImpl
    implements Path.MethodNode {
        public MethodNodeImpl(Path.Node cast) {
            super(cast);
            if (MethodNodeImpl.class.isInstance(cast)) {
                this.setParameterTypes(((MethodNodeImpl)MethodNodeImpl.class.cast(cast)).getParameterTypes());
            }
        }

        public MethodNodeImpl(String name, List<Class<?>> classes) {
            super(name);
            this.setParameterTypes(classes);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }

    public static class CrossParameterNodeImpl
    extends NodeImpl
    implements Path.CrossParameterNode {
        public CrossParameterNodeImpl() {
            super("<cross-parameter>");
        }

        public CrossParameterNodeImpl(Path.Node cast) {
            super(cast);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CROSS_PARAMETER;
        }
    }

    public static class ConstructorNodeImpl
    extends NodeImpl
    implements Path.ConstructorNode {
        public ConstructorNodeImpl(Path.Node cast) {
            super(cast);
            if (NodeImpl.class.isInstance(cast)) {
                this.setParameterTypes(((NodeImpl)NodeImpl.class.cast(cast)).parameterTypes);
            }
        }

        public ConstructorNodeImpl(String simpleName, List<Class<?>> paramTypes) {
            super(simpleName);
            this.setParameterTypes(paramTypes);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    public static class ParameterNodeImpl
    extends NodeImpl
    implements Path.ParameterNode {
        public ParameterNodeImpl(Path.Node cast) {
            super(cast);
            if (ParameterNodeImpl.class.isInstance(cast)) {
                this.setParameterIndex(((ParameterNodeImpl)ParameterNodeImpl.class.cast(cast)).getParameterIndex());
            }
        }

        public ParameterNodeImpl(String name, int idx) {
            super(name);
            this.setParameterIndex(idx);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }
    }
}

