/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Min;

public class MinValidatorForNumber
implements ConstraintValidator<Min, Number> {
    private long minValue;

    public void initialize(Min annotation) {
        this.minValue = annotation.value();
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(this.minValue)) != -1;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(this.minValue)) != -1;
        }
        return value.longValue() >= this.minValue;
    }
}

