/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateSequenceConstantAction
extends DDLConstantAction {
    private String _sequenceName;
    private String _schemaName;
    private DataTypeDescriptor _dataType;
    private long _initialValue;
    private long _stepValue;
    private long _maxValue;
    private long _minValue;
    private boolean _cycle;

    public CreateSequenceConstantAction(String string, String string2, DataTypeDescriptor dataTypeDescriptor, long l, long l2, long l3, long l4, boolean bl) {
        this._schemaName = string;
        this._sequenceName = string2;
        this._dataType = dataTypeDescriptor;
        this._initialValue = l;
        this._stepValue = l2;
        this._maxValue = l3;
        this._minValue = l4;
        this._cycle = bl;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this._schemaName);
        SequenceDescriptor sequenceDescriptor = dataDictionary.getSequenceDescriptor(schemaDescriptor, this._sequenceName);
        if (sequenceDescriptor != null) {
            throw StandardException.newException("X0Y68.S", (Object)sequenceDescriptor.getDescriptorType(), (Object)this._sequenceName);
        }
        sequenceDescriptor = dataDescriptorGenerator.newSequenceDescriptor(schemaDescriptor, dataDictionary.getUUIDFactory().createUUID(), this._sequenceName, this._dataType, new Long(this._initialValue), this._initialValue, this._minValue, this._maxValue, this._stepValue, this._cycle);
        dataDictionary.addDescriptor(sequenceDescriptor, null, 20, false, transactionController);
    }

    public String toString() {
        return "CREATE SEQUENCE " + this._sequenceName;
    }
}

