/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SQLParserConstants;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.compile.Token;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowList;

public class SQLParser
implements SQLParserConstants {
    private static final String[] SAVEPOINT_CLAUSE_NAMES = new String[]{"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
    private static final String[] ROUTINE_CLAUSE_NAMES = new String[]{null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "DETERMINISTIC", "ON NULL INPUT", "RETURN TYPE", "EXTERNAL SECURITY"};
    private static final int[] JAVA_ROUTINE_CLAUSES = new int[]{3, 4, 5};
    private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = new String[]{"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 1;
    private static final int ON_OR_USING_CLAUSE_SIZE = 2;
    private static final int ON_CLAUSE = 0;
    private static final int USING_CLAUSE = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_SIZE = 3;
    private static final int OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
    private static final int OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;
    private static final int MAX_UTF8_LENGTH = 65535;
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;
    private static final int IDX_DATA_TYPE = 0;
    private static final int IDX_START_WITH_OPTION = 1;
    private static final int IDX_INCREMENT_BY_OPTION = 2;
    private static final int IDX_MAX_VALUE_OPTION = 3;
    private static final int IDX_MIN_VALUE_OPTION = 4;
    private static final int IDX_CYCLE_OPTION = 5;
    private static final int IDX_OPTION_COUNT = 6;
    private Object[] paramDefaults;
    private String statementSQLText;
    private NodeFactory nodeFactory;
    private ContextManager cm;
    private CompilerContext compilerContext;
    private int parameterNumber;
    private Vector parameterList;
    private Boolean lastTokenDelimitedIdentifier = Boolean.FALSE;
    private Boolean nextToLastTokenDelimitedIdentifier = Boolean.FALSE;
    private Token lastIdentifierToken;
    private Token nextToLastIdentifierToken;
    static final String SINGLEQUOTES = "''";
    static final String DOUBLEQUOTES = "\"\"";
    static final String DEFAULT_INDEX_TYPE = "BTREE";
    boolean explicitNotNull = false;
    boolean explicitNull = false;
    Vector explicitlyNullableColumnsList = new Vector();
    private static final String[] ESCAPED_SYSFUN_FUNCTIONS = new String[]{"ACOS", "ASIN", "ATAN", "ATAN2", "COS", "SIN", "TAN", "PI", "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR", "SIGN", "RAND", "COT"};
    public SQLParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[359];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private static int[] jj_la1_15;
    private final JJCalls[] jj_2_rtns = new JJCalls[85];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    final void setCompilerContext(CompilerContext compilerContext) {
        this.compilerContext = compilerContext;
        this.cm = compilerContext.getContextManager();
    }

    private final NodeFactory getNodeFactory() throws StandardException {
        if (this.nodeFactory == null) {
            this.nodeFactory = this.getCompilerContext().getNodeFactory();
        }
        return this.nodeFactory;
    }

    private final CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    private DataTypeDescriptor getDataTypeServices(int n, int n2, int n3, int n4) throws StandardException {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(n), n2, n3, true, n4);
    }

    private DataTypeDescriptor getJavaClassDataTypeDescriptor(TableName tableName) throws StandardException {
        return new DataTypeDescriptor(TypeId.getUserDefinedTypeId(tableName.getSchemaName(), tableName.getTableName(), null), true);
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
    }

    private boolean checkVersion(int n, String string) throws StandardException {
        return this.getLanguageConnectionContext().getDataDictionary().checkVersion(n, string);
    }

    private void checkSqlStandardAccess(String string) throws StandardException {
        if (this.getLanguageConnectionContext().usesSqlAuthorization()) {
            return;
        }
        throw StandardException.newException("42Z60", (Object)string, (Object)"derby.database.sqlAuthorization", (Object)"TRUE");
    }

    private void forbidNextValueFor() {
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.setReliability(compilerContext.getReliability() | 0x4000);
    }

    private void checkInternalFeature(String string) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        if ((compilerContext.getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", string);
        }
    }

    private void checkTypeLimits(int n, int n2) throws StandardException {
        boolean bl = true;
        switch (n) {
            case -2: 
            case 1: {
                if (n2 <= 254) break;
                bl = false;
                break;
            }
            case -3: 
            case 12: {
                if (n2 <= 32672) break;
                bl = false;
                break;
            }
        }
        if (!bl) {
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2);
            throw StandardException.newException("42611", dataTypeDescriptor.getSQLstring());
        }
    }

    private final ContextManager getContextManager() {
        return this.cm;
    }

    private static void verifyImageLength(String string) throws StandardException {
        if (string.length() > 65535) {
            throw StandardException.newException("42Z99");
        }
    }

    private static String normalizeDelimitedID(String string) {
        string = StringUtil.compressQuotes(string, DOUBLEQUOTES);
        return string;
    }

    private static boolean isDATETIME(int n) {
        return n == 285 || n == 346 || n == 347;
    }

    ValueNode multOp(ValueNode valueNode, ValueNode valueNode2, int n) throws StandardException {
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 3: {
                return (ValueNode)this.nodeFactory.getNode(49, valueNode, valueNode2, this.getContextManager());
            }
            case 4: {
                return (ValueNode)this.nodeFactory.getNode(40, valueNode, valueNode2, this.getContextManager());
            }
            case 5: {
                return (ValueNode)this.nodeFactory.getNode(50, valueNode, valueNode2, this.getContextManager());
            }
        }
        return null;
    }

    private void setUpAndLinkParameters() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.setParameterList(this.parameterList);
        DataTypeDescriptor[] dataTypeDescriptorArray = compilerContext.getParameterTypes();
        int n = -1;
        int n2 = this.parameterList.size();
        for (int i = 0; i < n2; ++i) {
            ++n;
            ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(i);
            parameterNode.setDescriptors(dataTypeDescriptorArray);
        }
    }

    void initUnnamedParameterList() {
        this.parameterList = new Vector();
    }

    ParameterNode makeParameterNode() throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        if (this.paramDefaults != null && this.parameterNumber < this.paramDefaults.length) {
            dataValueDescriptor = (DataValueDescriptor)this.paramDefaults[this.parameterNumber];
        }
        ParameterNode parameterNode = (ParameterNode)this.nodeFactory.getNode(88, ReuseFactory.getInteger(this.parameterNumber), dataValueDescriptor, this.getContextManager());
        ++this.parameterNumber;
        this.parameterList.addElement(parameterNode);
        return parameterNode;
    }

    ParameterNode lookupUnnamedParameter(int n) {
        ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(n);
        return parameterNode;
    }

    NumericConstantNode getNumericNode(String string, boolean bl) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        try {
            return (NumericConstantNode)this.nodeFactory.getNode(70, new Integer(string), contextManager);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return (NumericConstantNode)this.nodeFactory.getNode(71, new Long(string), contextManager);
            }
            catch (NumberFormatException numberFormatException2) {
                if (bl) {
                    throw numberFormatException2;
                }
                return (NumericConstantNode)this.nodeFactory.getNode(67, string, contextManager);
            }
        }
    }

    private boolean isBuiltInAlias() {
        boolean bl = false;
        switch (this.token.kind) {
            case 271: 
            case 272: 
            case 307: 
            case 371: 
            case 396: 
            case 397: 
            case 431: 
            case 437: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    boolean commonDatatypeName(boolean bl) {
        return this.commonDatatypeName(1, bl);
    }

    boolean dataTypeCheck(int n) {
        if (this.commonDatatypeName(n, false)) {
            return true;
        }
        boolean bl = true;
        switch (this.getToken((int)n).kind) {
            case 446: 
            case 447: 
            case 450: {
                bl = false;
            }
        }
        return bl;
    }

    boolean commonDatatypeName(int n, boolean bl) {
        boolean bl2 = false;
        switch (this.getToken((int)n).kind) {
            case 80: 
            case 81: 
            case 88: 
            case 89: 
            case 116: 
            case 117: 
            case 128: 
            case 143: 
            case 167: 
            case 168: 
            case 187: 
            case 193: 
            case 214: 
            case 228: 
            case 261: 
            case 275: 
            case 278: 
            case 285: 
            case 314: 
            case 346: 
            case 347: 
            case 355: 
            case 363: 
            case 372: 
            case 404: {
                bl2 = true;
                break;
            }
            case 364: {
                if (bl) {
                    switch (this.getToken((int)(n + 1)).kind) {
                        case 80: 
                        case 81: 
                        case 260: 
                        case 261: 
                        case 404: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                bl2 = true;
                break;
            }
            case 185: {
                if (bl) {
                    switch (this.getToken((int)(n + 1)).kind) {
                        case 88: 
                        case 89: {
                            bl2 = true;
                        }
                    }
                    break;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private StatementNode getDeleteNode(FromTable fromTable, TableName tableName, ValueNode valueNode) throws StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, null, null, fromList, valueNode, null, null, null, this.getContextManager());
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(101, tableName, selectNode, this.getContextManager());
        this.setUpAndLinkParameters();
        return statementNode;
    }

    private StatementNode getUpdateNode(FromTable fromTable, TableName tableName, ResultColumnList resultColumnList, ValueNode valueNode) throws StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, resultColumnList, null, fromList, valueNode, null, null, null, this.getContextManager());
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(102, tableName, selectNode, this.getContextManager());
        this.setUpAndLinkParameters();
        return statementNode;
    }

    private ValueNode getTrimOperatorNode(Integer n, ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) throws StandardException {
        if (valueNode == null) {
            valueNode = (CharConstantNode)this.nodeFactory.getNode(61, " ", this.getContextManager());
        }
        return (ValueNode)this.nodeFactory.getNode(127, valueNode2, valueNode, null, ReuseFactory.getInteger(0), n, contextManager == null ? this.getContextManager() : contextManager);
    }

    private boolean ansiTrimSpecFollows() {
        return this.getToken((int)2).kind == 176 || this.getToken((int)2).kind == 247 || this.getToken((int)2).kind == 82;
    }

    private boolean remainingPredicateFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 79: 
            case 160: 
            case 178: 
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 461: 
            case 462: 
            case 463: {
                bl = true;
                break;
            }
            case 190: {
                switch (this.getToken((int)2).kind) {
                    case 79: 
                    case 160: 
                    case 178: {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    private boolean dropFollows() {
        return this.getToken((int)1).kind == 129;
    }

    private boolean escapedValueFunctionFollows() {
        if (this.getToken((int)1).kind != 444) {
            return false;
        }
        return this.getToken((int)2).kind == 392;
    }

    private String getEscapedSYSFUN(String string) {
        string = StringUtil.SQLToUpperCase(string);
        for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; ++i) {
            if (!ESCAPED_SYSFUN_FUNCTIONS[i].equals(string)) continue;
            return string;
        }
        return null;
    }

    private boolean columnMethodInvocationFollows() {
        int n = this.getToken((int)1).kind;
        if (n == 0) {
            return false;
        }
        if (this.getToken((int)1).image.charAt(0) == '?') {
            return false;
        }
        if (n == 109 || n == 110 || n == 111 || n == 108 && SQLParser.isDATETIME(this.getToken((int)2).kind)) {
            return false;
        }
        if (this.getToken((int)2).kind != 452) {
            return false;
        }
        n = this.getToken((int)4).kind;
        if (n == 446) {
            return true;
        }
        if (n != 452) {
            return false;
        }
        n = this.getToken((int)6).kind;
        if (n == 446) {
            return true;
        }
        if (n != 452) {
            return false;
        }
        n = this.getToken((int)8).kind;
        return n == 446;
    }

    private boolean aggregateFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 77: 
            case 181: 
            case 182: 
            case 236: {
                bl = true;
                break;
            }
            case 105: {
                if (this.getToken((int)2).kind == 446) {
                    bl = true;
                }
            }
            default: {
                if (this.getToken((int)2).kind != 446 || this.getToken((int)3).kind != 127) break;
                bl = true;
            }
        }
        return bl;
    }

    private boolean windowOrAggregateFunctionFollows() {
        boolean bl = false;
        switch (this.getToken((int)1).kind) {
            case 369: {
                bl = true;
                break;
            }
            default: {
                bl = this.aggregateFollows();
            }
        }
        return bl;
    }

    private boolean miscBuiltinFollows() {
        boolean bl = false;
        int n = this.getToken((int)1).kind;
        if (this.getToken((int)0).kind == 356) {
            bl = true;
        }
        switch (n) {
            case 109: 
            case 110: 
            case 111: 
            case 361: {
                bl = true;
                break;
            }
            case 108: {
                if (!SQLParser.isDATETIME(this.getToken((int)2).kind)) break;
                bl = true;
                break;
            }
            case 87: 
            case 446: {
                bl = false;
                break;
            }
            default: {
                if (this.getToken((int)2).kind != 446) break;
                bl = true;
            }
        }
        return bl;
    }

    private boolean subqueryFollows() {
        boolean bl = false;
        int n = 1;
        while (true) {
            int n2;
            if ((n2 = this.getToken((int)n).kind) != 446) {
                if (n2 != 225 && n2 != 259) break;
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean seeingOffsetClause() {
        boolean bl = false;
        int n = 2;
        int n2 = this.getToken((int)n).kind;
        if (n2 == 449 || n2 == 451 ? (n2 = this.getToken((int)(++n)).kind) == 478 : n2 == 478 || n2 == 464) {
            n2 = this.getToken((int)(++n)).kind;
            return n2 == 328 || n2 == 221;
        }
        return false;
    }

    private boolean rowValueConstructorListFollows() {
        boolean bl = false;
        if (this.getToken((int)1).kind == 446) {
            int n = 1;
            int n2 = 2;
            while (true) {
                int n3 = this.getToken((int)n2).kind;
                if (n2 == 2 && (n3 == 191 || n3 == 119)) {
                    bl = true;
                    break;
                }
                if (n == 1 && n3 == 450) {
                    bl = true;
                    break;
                }
                if (n3 == 0) break;
                if (n3 == 446) {
                    ++n;
                } else if (n3 == 447) {
                    --n;
                }
                if (n == 0) break;
                ++n2;
            }
        }
        return bl;
    }

    private boolean derbyPropertiesListFollows() {
        return this.getToken((int)1).kind == 59;
    }

    private boolean newInvocationFollows(int n) {
        boolean bl = false;
        if (this.getToken((int)n).kind == 402) {
            int n2 = 2 + n;
            while (true) {
                int n3;
                if ((n3 = this.getToken((int)n2).kind) == 446) {
                    bl = true;
                    break;
                }
                if (n3 != 452) break;
                n2 += 2;
            }
        }
        return bl;
    }

    boolean javaClassFollows() {
        boolean bl = false;
        int n = 2;
        while (true) {
            int n2;
            if ((n2 = this.getToken((int)n).kind) == 455) {
                bl = true;
                break;
            }
            if (n2 != 452) break;
            n += 2;
        }
        return bl;
    }

    private boolean fromNewInvocationFollows() {
        boolean bl = false;
        return this.getToken((int)1).kind == 147 && this.newInvocationFollows(2);
    }

    private boolean joinedTableExpressionFollows() {
        boolean bl = false;
        int n = this.getToken((int)1).kind;
        int n2 = this.getToken((int)2).kind;
        if (n == 173) {
            bl = true;
        } else if (n == 163 && n2 == 173) {
            bl = true;
        } else if (n == 107 && n2 == 173) {
            bl = true;
        } else if (n == 186) {
            bl = true;
        } else if ((n == 177 || n == 219) && n2 == 201) {
            if (this.getToken((int)3).kind == 173) {
                bl = true;
            }
        } else if ((n == 177 || n == 219) && n2 == 173) {
            bl = true;
        }
        return bl;
    }

    private static String aggName(Token token) {
        String string = null;
        switch (token.kind) {
            case 181: {
                string = "MAX";
                break;
            }
            case 77: {
                string = "AVG";
                break;
            }
            case 182: {
                string = "MIN";
                break;
            }
            case 236: {
                string = "SUM";
                break;
            }
            case 105: {
                string = "COUNT";
                break;
            }
        }
        return string;
    }

    private static Class aggClass(Token token) {
        Class clazz = null;
        switch (token.kind) {
            case 181: 
            case 182: {
                clazz = MaxMinAggregateDefinition.class;
                break;
            }
            case 77: 
            case 236: {
                clazz = SumAvgAggregateDefinition.class;
                break;
            }
            case 105: {
                clazz = CountAggregateDefinition.class;
                break;
            }
        }
        return clazz;
    }

    private boolean anotherPropertyFollows() {
        boolean bl = false;
        if (this.getToken((int)1).kind == 450) {
            int n;
            int n2 = 3;
            do {
                if ((n = this.getToken((int)n2).kind) == 459) {
                    bl = true;
                    break;
                }
                n2 += 2;
            } while (n == 452);
        }
        return bl;
    }

    StatementNode getCreateAliasNode(Object object, String string, Object object2, char c, Boolean bl) throws StandardException {
        StatementNode statementNode = (StatementNode)this.getNodeFactory().getCreateAliasNode(object, string, object2, c, bl, this.getContextManager());
        return statementNode;
    }

    StatementNode dropAliasNode(Object object, char c) throws StandardException {
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(156, object, new Character(c), this.getContextManager());
        return statementNode;
    }

    ValueNode getSubstringNode(ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, Boolean bl) throws StandardException {
        return (ValueNode)this.nodeFactory.getNode(154, valueNode, valueNode2, valueNode3, ReuseFactory.getInteger(2), null, this.getContextManager());
    }

    public final TableName qualifiedName(int n) throws ParseException, StandardException {
        return this.qualifiedName(34, n);
    }

    private void initStatement(String string, Object[] objectArray) throws StandardException {
        this.parameterNumber = 0;
        this.statementSQLText = string;
        this.paramDefaults = objectArray;
        this.nodeFactory = this.getNodeFactory();
        this.initUnnamedParameterList();
    }

    private ValueNode getJdbcIntervalNode(int n) throws StandardException {
        return (ValueNode)this.nodeFactory.getNode(70, ReuseFactory.getInteger(n), this.getContextManager());
    }

    void checkRequiredRoutineClause(int[] nArray, Object[] objectArray) throws StandardException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (objectArray[n] != null) continue;
            throw StandardException.newException("42X01", ROUTINE_CLAUSE_NAMES[n]);
        }
    }

    boolean isPrivilegeKeywordExceptTrigger(int n) {
        return n == 225 || n == 122 || n == 166 || n == 254 || n == 215 || n == 137 || n == 353 || n == 66;
    }

    TableElementNode wrapAlterColumnDefaultValue(ValueNode valueNode, String string, long[] lArray) throws StandardException {
        if (lArray[2] == 0L) {
            lArray = null;
        }
        return (TableElementNode)this.nodeFactory.getNode(97, string, valueNode, null, lArray, this.getContextManager());
    }

    private boolean isTableValueConstructor(ResultSetNode resultSetNode) throws StandardException {
        return resultSetNode instanceof RowResultSetNode || resultSetNode instanceof UnionNode && ((UnionNode)resultSetNode).tableConstructor();
    }

    private JoinNode newJoinNode(ResultSetNode resultSetNode, ResultSetNode resultSetNode2, ValueNode valueNode, ResultColumnList resultColumnList, int n) throws StandardException {
        switch (n) {
            case 1: {
                return (JoinNode)this.nodeFactory.getNode(139, resultSetNode, resultSetNode2, valueNode, resultColumnList, null, null, null, this.getContextManager());
            }
            case 3: {
                return (JoinNode)this.nodeFactory.getNode(144, resultSetNode, resultSetNode2, valueNode, resultColumnList, Boolean.FALSE, null, this.getContextManager());
            }
            case 4: {
                return (JoinNode)this.nodeFactory.getNode(144, resultSetNode, resultSetNode2, valueNode, resultColumnList, Boolean.TRUE, null, this.getContextManager());
            }
        }
        return null;
    }

    public final StatementNode Statement(String string, Object[] objectArray) throws ParseException, StandardException {
        this.initStatement(string, objectArray);
        StatementNode statementNode = this.StatementPart(null);
        this.jj_consume_token(0);
        return statementNode;
    }

    public final StatementNode proceduralStatement(Token[] tokenArray) throws ParseException, StandardException {
        StatementNode statementNode;
        tokenArray[0] = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 166: {
                statementNode = this.insertStatement();
                break;
            }
            case 254: {
                statementNode = this.preparableUpdateStatement();
                break;
            }
            case 122: {
                statementNode = this.preparableDeleteStatement();
                break;
            }
            case 225: 
            case 259: 
            case 446: {
                statementNode = this.preparableSelectStatement(true);
                break;
            }
            case 356: 
            case 444: 
            case 464: {
                statementNode = this.callStatement();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode StatementPart(Token[] tokenArray) throws ParseException, StandardException {
        this.explicitNotNull = false;
        this.explicitNull = false;
        this.explicitlyNullableColumnsList = new Vector();
        if (tokenArray != null) {
            tokenArray[0] = this.getToken(1);
        }
        switch (this.jj_nt.kind) {
            case 398: 
            case 417: {
                StatementNode statementNode;
                switch (this.jj_nt.kind) {
                    case 417: {
                        statementNode = this.spsRenameStatement();
                        break;
                    }
                    case 398: {
                        statementNode = this.lockStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return statementNode;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_4(1)) {
            StatementNode statementNode;
            block7 : switch (this.jj_nt.kind) {
                case 106: {
                    statementNode = this.createStatements();
                    break;
                }
                case 129: {
                    statementNode = this.dropStatements();
                    break;
                }
                case 68: {
                    statementNode = this.spsAlterStatement();
                    break;
                }
                case 118: {
                    statementNode = this.globalTemporaryTableDeclaration();
                    break;
                }
                case 122: 
                case 166: 
                case 220: 
                case 225: 
                case 254: 
                case 259: 
                case 323: 
                case 329: 
                case 356: 
                case 444: 
                case 446: 
                case 464: {
                    statementNode = this.preparableSQLDataStatement();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    if (this.jj_2_1(1)) {
                        statementNode = this.spsSetStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 350: {
                            statementNode = this.truncateTableStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    if (this.jj_2_2(1)) {
                        statementNode = this.grantStatement();
                        break;
                    }
                    if (this.jj_2_3(1)) {
                        statementNode = this.revokeStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 137: {
                            statementNode = this.execStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode createStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        Token token = this.jj_consume_token(106);
        block0 : switch (this.jj_nt.kind) {
            case 222: 
            case 263: 
            case 344: 
            case 368: 
            case 425: 
            case 435: {
                switch (this.jj_nt.kind) {
                    case 222: {
                        statementNode = this.schemaDefinition();
                        break block0;
                    }
                    case 263: {
                        statementNode = this.viewDefinition(token);
                        break block0;
                    }
                    case 435: {
                        statementNode = this.triggerDefinition();
                        break block0;
                    }
                    case 344: {
                        statementNode = this.synonymDefinition();
                        break block0;
                    }
                    case 368: {
                        statementNode = this.roleDefinition();
                        break block0;
                    }
                    case 425: {
                        statementNode = this.sequenceDefinition();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 239: {
                statementNode = this.tableDefinition();
                break;
            }
            case 211: {
                statementNode = this.procedureDefinition();
                break;
            }
            case 149: {
                statementNode = this.functionDefinition();
                break;
            }
            case 351: {
                statementNode = this.udtDefinition();
                break;
            }
            case 252: 
            case 393: {
                statementNode = this.indexDefinition();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode dropStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(129);
        switch (this.jj_nt.kind) {
            case 222: {
                statementNode = this.dropSchemaStatement();
                break;
            }
            case 239: {
                statementNode = this.dropTableStatement();
                break;
            }
            case 393: {
                statementNode = this.dropIndexStatement();
                break;
            }
            case 149: 
            case 211: 
            case 344: 
            case 351: {
                statementNode = this.dropAliasStatement();
                break;
            }
            case 263: {
                statementNode = this.dropViewStatement();
                break;
            }
            case 435: {
                statementNode = this.dropTriggerStatement();
                break;
            }
            case 368: {
                statementNode = this.dropRoleStatement();
                break;
            }
            case 425: {
                statementNode = this.dropSequenceStatement();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode spsAlterStatement() throws ParseException, StandardException {
        this.jj_consume_token(68);
        StatementNode statementNode = this.alterTableStatement();
        return statementNode;
    }

    public final StatementNode spsSetStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 227 && this.getToken((int)2).kind != 108) {
            StatementNode statementNode;
            this.jj_consume_token(227);
            if (this.jj_2_5(1)) {
                statementNode = this.setIsolationStatement();
            } else if (this.jj_2_6(1)) {
                statementNode = this.setSchemaStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 399: {
                        statementNode = this.setMessageLocaleStatement();
                        break;
                    }
                    case 368: {
                        statementNode = this.setRoleStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 108) {
            StatementNode statementNode;
            this.jj_consume_token(227);
            if (this.jj_2_7(1)) {
                statementNode = this.setSchemaStatement();
            } else if (this.jj_2_8(1)) {
                statementNode = this.setIsolationStatement();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableSQLDataStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 122: {
                StatementNode statementNode = this.preparableDeleteStatement();
                return statementNode;
            }
            case 225: 
            case 259: 
            case 446: {
                CursorNode cursorNode = this.preparableSelectStatement(true);
                return cursorNode;
            }
            case 166: {
                StatementNode statementNode = this.insertStatement();
                return statementNode;
            }
            case 254: {
                StatementNode statementNode = this.preparableUpdateStatement();
                return statementNode;
            }
            case 356: 
            case 444: 
            case 464: {
                StatementNode statementNode = this.callStatement();
                return statementNode;
            }
            case 220: 
            case 323: 
            case 329: {
                StatementNode statementNode = this.savepointStatement();
                return statementNode;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableDeleteStatement() throws ParseException, StandardException {
        this.jj_consume_token(122);
        StatementNode statementNode = this.deleteBody();
        return statementNode;
    }

    public final StatementNode deleteBody() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        TableName tableName = null;
        ValueNode valueNode = null;
        FromTable fromTable = null;
        Properties properties = null;
        Token token = null;
        if (this.fromNewInvocationFollows()) {
            this.jj_consume_token(147);
            javaToSQLValueNode = this.newInvocation();
            switch (this.jj_nt.kind) {
                case 265: {
                    token = this.jj_consume_token(265);
                    valueNode = this.whereClause(token);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                }
            }
            fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getDeleteNode(fromTable, tableName, valueNode);
        }
        switch (this.jj_nt.kind) {
            case 147: {
                this.jj_consume_token(147);
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 0 && this.getToken((int)1).kind != 265 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 72: {
                            this.jj_consume_token(72);
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                        }
                    }
                    string = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 265: {
                        token = this.jj_consume_token(265);
                        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 194) {
                            fromTable = this.currentOfClause(string);
                            break;
                        }
                        if (this.jj_2_9(1)) {
                            valueNode = this.whereClause(token);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, string, ReuseFactory.getInteger(2), null, this.getContextManager());
                }
                if (properties != null) {
                    ((FromBaseTable)fromTable).setTableProperties(properties);
                }
                return this.getDeleteNode(fromTable, tableName, valueNode);
            }
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FromTable currentOfClause(String string) throws ParseException, StandardException {
        String string2 = null;
        this.jj_consume_token(108);
        this.jj_consume_token(194);
        string2 = this.identifier(128, true);
        return (FromTable)this.nodeFactory.getNode(99, string, string2, null, this.getContextManager());
    }

    public final CursorNode preparableSelectStatement(boolean bl) throws ParseException, StandardException {
        Vector vector = new Vector();
        int n = 0;
        int n2 = 0;
        OrderByList orderByList = null;
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 319: {
                valueNode = this.offsetClause();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 141: {
                valueNode2 = this.fetchFirstClause();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                this.jj_consume_token(144);
                n = this.forUpdateClause(vector);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 267: {
                n2 = this.atIsolationLevel();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        CursorNode cursorNode = (CursorNode)this.nodeFactory.getNode(147, "SELECT", resultSetNode, null, orderByList, valueNode, valueNode2, ReuseFactory.getInteger(n), n == 1 ? null : vector, this.getContextManager());
        if (bl) {
            this.setUpAndLinkParameters();
        }
        if (n2 != 0) {
            this.getCompilerContext().setScanIsolationLevel(n2);
        }
        return cursorNode;
    }

    public final StatementNode insertStatement() throws ParseException, StandardException {
        this.jj_consume_token(166);
        this.jj_consume_token(170);
        QueryTreeNode queryTreeNode = this.targetTable();
        StatementNode statementNode = this.insertColumnsAndSource(queryTreeNode);
        this.setUpAndLinkParameters();
        return statementNode;
    }

    public final QueryTreeNode targetTable() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        Object var2_2 = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLValueNode = this.newInvocation();
            return this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), var2_2, null, null, this.getContextManager());
        }
        if (this.jj_2_10(1)) {
            TableName tableName = this.qualifiedName(128);
            return tableName;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableUpdateStatement() throws ParseException, StandardException {
        this.jj_consume_token(254);
        StatementNode statementNode = this.updateBody();
        return statementNode;
    }

    public final boolean tableOrIndex() throws ParseException {
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                return true;
            }
            case 393: {
                this.jj_consume_token(393);
                return false;
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode updateBody() throws ParseException, StandardException {
        String string = null;
        JavaToSQLValueNode javaToSQLValueNode = null;
        TableName tableName = null;
        ValueNode valueNode = null;
        FromTable fromTable = null;
        Properties properties = null;
        Token token = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLValueNode = this.newInvocation();
            this.jj_consume_token(227);
            ResultColumnList resultColumnList = this.setClauseList();
            switch (this.jj_nt.kind) {
                case 265: {
                    token = this.jj_consume_token(265);
                    valueNode = this.whereClause(token);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                }
            }
            fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getUpdateNode(fromTable, tableName, resultColumnList, valueNode);
        }
        if (this.jj_2_12(1)) {
            tableName = this.qualifiedName(128);
            if (this.getToken((int)1).kind != 227 && !this.derbyPropertiesListFollows()) {
                switch (this.jj_nt.kind) {
                    case 72: {
                        this.jj_consume_token(72);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                string = this.identifier(128, true);
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            this.jj_consume_token(227);
            ResultColumnList resultColumnList = this.setClauseList();
            block9 : switch (this.jj_nt.kind) {
                case 265: {
                    token = this.jj_consume_token(265);
                    if (this.jj_2_11(1)) {
                        valueNode = this.whereClause(token);
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 108: {
                            fromTable = this.currentOfClause(string);
                            break block9;
                        }
                    }
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                }
            }
            if (fromTable == null) {
                fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, string, ReuseFactory.getInteger(1), null, this.getContextManager());
            }
            if (properties != null) {
                ((FromBaseTable)fromTable).setTableProperties(properties);
            }
            return this.getUpdateNode(fromTable, tableName, resultColumnList, valueNode);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode callStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        switch (this.jj_nt.kind) {
            case 356: 
            case 464: {
                statementNode = this.bareCallStatement();
                break;
            }
            case 444: {
                this.jj_consume_token(444);
                statementNode = this.bareCallStatement();
                this.jj_consume_token(445);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode bareCallStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 356: {
                this.jj_consume_token(356);
                ValueNode valueNode = this.primaryExpression();
                if (!(valueNode instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)valueNode).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74");
                }
                StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(95, valueNode, this.getContextManager());
                this.setUpAndLinkParameters();
                return statementNode;
            }
            case 464: {
                ParameterNode parameterNode = this.dynamicParameterSpecification();
                this.getCompilerContext().setReturnParameterFlag();
                this.jj_consume_token(459);
                this.jj_consume_token(356);
                ResultSetNode resultSetNode = this.rowValueConstructor(null);
                ResultColumnList resultColumnList = resultSetNode.getResultColumns();
                if (resultColumnList == null || resultColumnList.size() > 1) {
                    throw StandardException.newException("42X74");
                }
                ValueNode valueNode = ((ResultColumn)resultColumnList.elementAt(0)).getExpression();
                if (!(valueNode instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)valueNode).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74");
                }
                StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(147, "SELECT", resultSetNode, null, null, null, null, ReuseFactory.getInteger(1), null, this.getContextManager());
                parameterNode.setReturnOutputParam(valueNode);
                this.setUpAndLinkParameters();
                return statementNode;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpression() throws ParseException, StandardException {
        ValueNode valueNode = null;
        if (this.getToken((int)2).kind == 452 && this.getToken((int)4).kind == 446) {
            valueNode = this.routineInvocation();
            return valueNode;
        }
        if (this.jj_2_13(1)) {
            valueNode = this.primaryExpressionXX();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode savepointStatement() throws ParseException, StandardException {
        int n;
        String string = null;
        Object[] objectArray = new Object[3];
        switch (this.jj_nt.kind) {
            case 329: {
                this.jj_consume_token(329);
                string = this.identifier(128, true);
                block14: while (true) {
                    this.savepointStatementClause(objectArray);
                    switch (this.jj_nt.kind) {
                        case 195: 
                        case 252: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[29] = this.jj_gen;
                if (objectArray[2] == null) {
                    throw StandardException.newException("42X01", "MISSING ON ROLLBACK RETAIN CURSORS");
                }
                n = 1;
                break;
            }
            case 220: {
                this.jj_consume_token(220);
                switch (this.jj_nt.kind) {
                    case 268: {
                        this.jj_consume_token(268);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                this.jj_consume_token(243);
                this.jj_consume_token(329);
                if (this.jj_2_14(1)) {
                    string = this.identifier(128, true);
                }
                n = 2;
                break;
            }
            case 323: {
                this.jj_consume_token(323);
                switch (this.jj_nt.kind) {
                    case 243: {
                        this.jj_consume_token(243);
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                    }
                }
                this.jj_consume_token(329);
                string = this.identifier(128, true);
                n = 3;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (StatementNode)this.nodeFactory.getNode(198, string, ReuseFactory.getInteger(n), this.getContextManager());
    }

    public final void savepointStatementClause(Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 252: {
                this.jj_consume_token(252);
                n = 0;
                break;
            }
            case 195: {
                this.jj_consume_token(195);
                this.jj_consume_token(220);
                this.jj_consume_token(420);
                n = this.LocksOrCursors();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = SAVEPOINT_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = Boolean.TRUE;
        }
    }

    public final int LocksOrCursors() throws ParseException {
        switch (this.jj_nt.kind) {
            case 302: {
                this.jj_consume_token(302);
                return 1;
            }
            case 383: {
                this.jj_consume_token(383);
                return 2;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {
        Object[] objectArray = new Object[3];
        this.jj_consume_token(118);
        this.jj_consume_token(151);
        this.jj_consume_token(240);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        TableElementList tableElementList = this.tableElementList();
        do {
            this.declareTableClause(objectArray);
        } while (this.jj_2_15(1));
        if (objectArray[0] == null) {
            throw StandardException.newException("42X01", "MISSING NOT LOGGED");
        }
        if (objectArray[1] == null) {
            objectArray[1] = Boolean.TRUE;
        }
        if (objectArray[2] == null) {
            objectArray[2] = Boolean.TRUE;
        }
        return (StatementNode)this.nodeFactory.getNode(141, tableName, tableElementList, null, (Boolean)objectArray[1], (Boolean)objectArray[2], this.getContextManager());
    }

    public final void declareTableClause(Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        Boolean bl = null;
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(304);
                bl = Boolean.TRUE;
                n = 0;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                if (this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 97) {
                    this.jj_consume_token(195);
                    this.jj_consume_token(97);
                    bl = this.onCommit();
                    this.jj_consume_token(221);
                    n = 1;
                    break;
                }
                if (this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 220) {
                    this.jj_consume_token(195);
                    this.jj_consume_token(220);
                    this.jj_consume_token(122);
                    this.jj_consume_token(221);
                    bl = Boolean.TRUE;
                    n = 2;
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = TEMPORARY_TABLE_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = bl;
        }
    }

    public final Boolean onCommit() throws ParseException {
        switch (this.jj_nt.kind) {
            case 207: {
                this.jj_consume_token(207);
                return Boolean.FALSE;
            }
            case 122: {
                this.jj_consume_token(122);
                return Boolean.TRUE;
            }
        }
        this.jj_la1[36] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementList tableElementList() throws ParseException, StandardException {
        TableElementList tableElementList = (TableElementList)this.nodeFactory.getNode(12, this.getContextManager());
        this.jj_consume_token(446);
        this.tableElement(tableElementList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.tableElement(tableElementList);
        }
        this.jj_consume_token(447);
        return tableElementList;
    }

    public final void tableElement(TableElementList tableElementList) throws ParseException, StandardException {
        this.explicitNotNull = false;
        this.explicitNull = false;
        if (this.jj_2_16(1)) {
            TableElementNode tableElementNode = this.columnDefinition(tableElementList);
            tableElementList.addTableElement(tableElementNode);
        } else {
            switch (this.jj_nt.kind) {
                case 91: 
                case 100: 
                case 145: 
                case 208: 
                case 252: {
                    TableElementNode tableElementNode = this.tableConstraintDefinition();
                    tableElementList.addTableElement(tableElementNode);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[1];
        ValueNode valueNode = null;
        long[] lArray = new long[4];
        String string = this.identifier(128, true);
        if (this.jj_2_17(1)) {
            dataTypeDescriptorArray[0] = this.dataTypeDDL();
        }
        switch (this.jj_nt.kind) {
            case 91: 
            case 100: 
            case 119: 
            case 190: 
            case 208: 
            case 215: 
            case 252: 
            case 267: 
            case 291: {
                valueNode = this.defaultAndConstraints(dataTypeDescriptorArray, tableElementList, string, lArray);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        if (lArray[2] == 0L) {
            lArray = null;
        }
        return (TableElementNode)this.nodeFactory.getNode(116, string, valueNode, dataTypeDescriptorArray[0], lArray, this.getContextManager());
    }

    public final ValueNode defaultAndConstraints(DataTypeDescriptor[] dataTypeDescriptorArray, TableElementList tableElementList, String string, long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        switch (this.jj_nt.kind) {
            case 91: 
            case 100: 
            case 190: 
            case 208: 
            case 215: 
            case 252: {
                this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                block16: while (true) {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 190: 
                        case 208: 
                        case 215: 
                        case 252: {
                            break;
                        }
                        default: {
                            this.jj_la1[40] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                }
                block7 : switch (this.jj_nt.kind) {
                    case 119: 
                    case 267: 
                    case 291: {
                        valueNode = this.defaultClause(lArray, string);
                        while (true) {
                            switch (this.jj_nt.kind) {
                                case 91: 
                                case 100: 
                                case 190: 
                                case 208: 
                                case 215: 
                                case 252: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[41] = this.jj_gen;
                                    break block7;
                                }
                            }
                            this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                        }
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                    }
                }
                return valueNode;
            }
            case 119: 
            case 267: 
            case 291: {
                valueNode = this.defaultClause(lArray, string);
                block18: while (true) {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 190: 
                        case 208: 
                        case 215: 
                        case 252: {
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.columnConstraintDefinition(dataTypeDescriptorArray, tableElementList, string);
                }
                return valueNode;
            }
        }
        this.jj_la1[44] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {
        if (this.commonDatatypeName(false)) {
            DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
            return dataTypeDescriptor;
        }
        if (this.getToken((int)1).kind != 291) {
            DataTypeDescriptor dataTypeDescriptor = this.javaType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TypeDescriptor catalogType() throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        return dataTypeDescriptor.getCatalogType();
    }

    public final DataTypeDescriptor dataTypeCast() throws ParseException, StandardException {
        if (this.commonDatatypeName(true)) {
            DataTypeDescriptor dataTypeDescriptor = this.dataTypeCommon();
            return dataTypeDescriptor;
        }
        if (this.jj_2_18(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.javaType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        boolean bl = false;
        if (this.jj_2_19(1)) {
            if (this.getToken((int)2).kind == 299) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            dataTypeDescriptor = this.characterStringType();
        } else if (this.jj_2_20(1)) {
            if (this.getToken((int)3).kind == 299) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            dataTypeDescriptor = this.nationalCharacterStringType();
        } else if (this.jj_2_21(1)) {
            dataTypeDescriptor = this.numericType();
        } else {
            switch (this.jj_nt.kind) {
                case 285: 
                case 346: 
                case 347: {
                    dataTypeDescriptor = this.datetimeType();
                    break;
                }
                case 355: {
                    this.jj_consume_token(355);
                    if ((this.getCompilerContext().getReliability() & 0x400) != 0) {
                        this.checkVersion(190, "BOOLEAN");
                    }
                    dataTypeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
                    break;
                }
                case 364: {
                    dataTypeDescriptor = this.longType();
                    break;
                }
                case 80: 
                case 88: 
                case 89: 
                case 185: 
                case 275: 
                case 278: 
                case 314: {
                    dataTypeDescriptor = this.LOBType();
                    break;
                }
                case 372: {
                    dataTypeDescriptor = this.XMLType();
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor characterStringType() throws ParseException, StandardException {
        int n;
        int n2 = 1;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 261: {
                this.jj_consume_token(261);
                n2 = this.charLength();
                n = 12;
                break;
            }
            case 88: 
            case 89: {
                this.charOrCharacter();
                block4 : switch (this.jj_nt.kind) {
                    case 262: {
                        token = this.jj_consume_token(262);
                        n2 = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 446: {
                                n2 = this.charLength();
                                break block4;
                            }
                        }
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                n = token == null ? 1 : 12;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                n = this.forBitData(n);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        this.checkTypeLimits(n, n2);
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2);
        return dataTypeDescriptor;
    }

    public final void charOrCharacter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int charLength() throws ParseException, StandardException {
        this.jj_consume_token(446);
        int n = this.length();
        this.jj_consume_token(447);
        return n;
    }

    public final int forBitData(int n) throws ParseException {
        this.jj_consume_token(144);
        this.jj_consume_token(81);
        this.jj_consume_token(284);
        if (n == 1) {
            n = -2;
        } else if (n == 12) {
            n = -3;
        } else if (n == -1) {
            n = -4;
        }
        return n;
    }

    public final DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {
        int n = 1;
        String string = null;
        Token token = null;
        switch (this.jj_nt.kind) {
            case 185: {
                this.jj_consume_token(185);
                this.charOrCharacter();
                block5 : switch (this.jj_nt.kind) {
                    case 262: {
                        token = this.jj_consume_token(262);
                        n = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 446: {
                                n = this.charLength();
                                break block5;
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                string = token == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                block11 : switch (this.jj_nt.kind) {
                    case 262: {
                        token = this.jj_consume_token(262);
                        n = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 446: {
                                n = this.charLength();
                                break block11;
                            }
                        }
                        this.jj_la1[53] = this.jj_gen;
                    }
                }
                string = token == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 404: {
                this.jj_consume_token(404);
                n = this.charLength();
                string = "NATIONAL CHAR VARYING";
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw StandardException.newException("0A000.S", string);
    }

    public final DataTypeDescriptor LOBType() throws ParseException, StandardException {
        String string;
        int n = Integer.MAX_VALUE;
        switch (this.jj_nt.kind) {
            case 275: {
                this.jj_consume_token(275);
                switch (this.jj_nt.kind) {
                    case 446: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                string = "BLOB";
                break;
            }
            case 278: {
                this.jj_consume_token(278);
                switch (this.jj_nt.kind) {
                    case 446: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                    }
                }
                string = "CLOB";
                break;
            }
            case 314: {
                this.jj_consume_token(314);
                n = this.lengthAndModifier();
                String string2 = "NCLOB";
                throw StandardException.newException("0A000.S", string2);
            }
            case 80: {
                this.jj_consume_token(80);
                this.jj_consume_token(299);
                this.jj_consume_token(318);
                switch (this.jj_nt.kind) {
                    case 446: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                string = "BLOB";
                break;
            }
            case 88: 
            case 89: {
                this.charOrCharacter();
                this.jj_consume_token(299);
                this.jj_consume_token(318);
                switch (this.jj_nt.kind) {
                    case 446: {
                        n = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                    }
                }
                string = "CLOB";
                break;
            }
            case 185: {
                this.jj_consume_token(185);
                this.jj_consume_token(89);
                this.jj_consume_token(299);
                this.jj_consume_token(318);
                n = this.lengthAndModifier();
                String string3 = "NCLOB";
                throw StandardException.newException("0A000.S", string3);
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(string, n);
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor numericType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 116: 
            case 117: 
            case 167: 
            case 168: 
            case 193: 
            case 228: 
            case 363: {
                DataTypeDescriptor dataTypeDescriptor = this.exactNumericType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[61] = this.jj_gen;
        if (this.jj_2_22(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.approximateNumericType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactNumericType() throws ParseException, StandardException {
        int n = 5;
        int n2 = 0;
        int n3 = 3;
        String string = "DECIMAL";
        DataTypeDescriptor dataTypeDescriptor = null;
        switch (this.jj_nt.kind) {
            case 116: 
            case 117: 
            case 193: {
                switch (this.jj_nt.kind) {
                    case 193: {
                        this.jj_consume_token(193);
                        n3 = 2;
                        string = "NUMERIC";
                        break;
                    }
                    case 117: {
                        this.jj_consume_token(117);
                        break;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 446: {
                        this.jj_consume_token(446);
                        n = this.precision();
                        switch (this.jj_nt.kind) {
                            case 450: {
                                this.jj_consume_token(450);
                                n2 = this.scale();
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(447);
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                    }
                }
                if (n <= 0 || n > 31) {
                    throw StandardException.newException("42X48", (Object)string, (Object)String.valueOf(n));
                }
                if (n2 < 0 || n2 > 31) {
                    throw StandardException.newException("42Y42", (Object)string, (Object)String.valueOf(n2));
                }
                if (n2 > n) {
                    throw StandardException.newException("42Y43", (Object)String.valueOf(n2), (Object)String.valueOf(n));
                }
                int n4 = DataTypeUtilities.computeMaxWidth(n, n2);
                return this.getDataTypeServices(n3, n, n2, n4);
            }
            case 167: 
            case 168: 
            case 228: 
            case 363: {
                dataTypeDescriptor = this.exactIntegerType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 167: 
            case 168: {
                switch (this.jj_nt.kind) {
                    case 168: {
                        this.jj_consume_token(168);
                        break;
                    }
                    case 167: {
                        this.jj_consume_token(167);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(4);
            }
            case 228: {
                this.jj_consume_token(228);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(5);
            }
            case 363: {
                this.jj_consume_token(363);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5);
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        DataTypeDescriptor dataTypeDescriptor = null;
        switch (this.jj_nt.kind) {
            case 143: {
                this.jj_consume_token(143);
                switch (this.jj_nt.kind) {
                    case 446: {
                        this.jj_consume_token(446);
                        n4 = this.precision();
                        this.jj_consume_token(447);
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                    }
                }
                if (n4 == -1) {
                    n4 = 52;
                }
                if (n4 > 0 && n4 <= 23) {
                    n = 7;
                    n4 = 23;
                    n2 = 0;
                    n3 = 4;
                } else if (n4 > 23 && n4 <= 52) {
                    n = 8;
                    n4 = 52;
                    n2 = 0;
                    n3 = 8;
                } else {
                    throw StandardException.newException("42X48", (Object)"FLOAT", (Object)String.valueOf(n4));
                }
                return this.getDataTypeServices(n, n4, n2, n3);
            }
            case 214: {
                this.jj_consume_token(214);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(7);
            }
        }
        this.jj_la1[69] = this.jj_gen;
        if (this.jj_2_23(1)) {
            dataTypeDescriptor = this.doubleType();
            return dataTypeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor doubleType() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 322) {
            this.jj_consume_token(128);
            this.jj_consume_token(322);
        } else {
            switch (this.jj_nt.kind) {
                case 128: {
                    this.jj_consume_token(128);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
    }

    public final DataTypeDescriptor longType() throws ParseException, StandardException {
        this.jj_consume_token(364);
        DataTypeDescriptor dataTypeDescriptor = this.longSubType();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor longSubType() throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 261: {
                this.jj_consume_token(261);
                switch (this.jj_nt.kind) {
                    case 144: {
                        n = this.forBitData(n);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n);
            }
            case 404: {
                this.jj_consume_token(404);
                throw StandardException.newException("0A000.S", "LONG NVARCHAR");
            }
        }
        this.jj_la1[72] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor XMLType() throws ParseException, StandardException {
        this.jj_consume_token(372);
        this.checkVersion(130, "XML");
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009);
    }

    public final void xmlDocOrContent() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 388 && this.getToken((int)1).kind != 381) {
            throw StandardException.newException("42Z72", (Object)"DOCUMENT", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        if (this.getToken((int)1).kind == 381) {
            this.jj_consume_token(381);
            throw StandardException.newException("42Z74", "CONTENT");
        }
        if (this.getToken((int)1).kind == 388) {
            this.jj_consume_token(388);
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor javaType() throws ParseException, StandardException {
        TableName tableName = this.qualifiedName(128);
        return this.getJavaClassDataTypeDescriptor(tableName);
    }

    public final String javaDSL() throws ParseException {
        String string = this.caseSensitiveIdentifierPlusReservedWords();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 452: {
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    break block3;
                }
            }
            string = this.javaDSLNameExtender(string);
        }
        return string;
    }

    public final String javaClassName() throws ParseException {
        String string = this.javaDSL();
        return string;
    }

    public final String javaDSLNameExtender(String string) throws ParseException {
        this.jj_consume_token(452);
        String string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return string + "." + string2;
    }

    public final int lengthAndModifier() throws ParseException, StandardException {
        Token token;
        Token token2 = null;
        this.jj_consume_token(446);
        block1 : switch (this.jj_nt.kind) {
            case 480: {
                token = this.jj_consume_token(480);
                break;
            }
            case 478: {
                token = this.jj_consume_token(478);
                switch (this.jj_nt.kind) {
                    case 471: {
                        token2 = this.jj_consume_token(471);
                        break block1;
                    }
                }
                this.jj_la1[74] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(447);
        String string = token.image + (token2 == null ? "" : token2.image);
        try {
            long l;
            char c = string.charAt(string.length() - 1);
            String string2 = string.substring(0, string.length() - 1);
            switch (c) {
                case 'G': 
                case 'g': {
                    l = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    l = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    l = 1024L;
                    break;
                }
                default: {
                    l = 1L;
                    string2 = string;
                }
            }
            long l2 = Long.parseLong(string2) * l;
            if (l2 > 0L && l2 <= Integer.MAX_VALUE) {
                return (int)l2;
            }
            if (l != 1L && l2 == 0x80000000L) {
                return Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", string);
    }

    public final int length() throws ParseException, StandardException {
        Token token = this.jj_consume_token(478);
        try {
            int n = Integer.parseInt(token.image);
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", token.image);
    }

    public final long exactNumber() throws ParseException, StandardException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 449: 
            case 451: {
                string = this.sign();
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(478);
        try {
            if (string.equals("-")) {
                return Long.parseLong("-" + token.image);
            }
            return Long.parseLong(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X49", token.image);
        }
    }

    public final int precision() throws ParseException, StandardException {
        int n = this.uint_value();
        return n;
    }

    public final int uint_value() throws ParseException, StandardException {
        Token token = this.jj_consume_token(478);
        try {
            return Integer.parseInt(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X49", token.image);
        }
    }

    public final int scale() throws ParseException, StandardException {
        int n = this.uint_value();
        return n;
    }

    public final DataTypeDescriptor datetimeType() throws ParseException, StandardException {
        Object var1_1 = null;
        int n = -1;
        switch (this.jj_nt.kind) {
            case 285: {
                this.jj_consume_token(285);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(91);
            }
            case 346: {
                this.jj_consume_token(346);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(92);
            }
            case 347: {
                this.jj_consume_token(347);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(93);
            }
        }
        this.jj_la1[77] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void qualifiedNameList(Vector vector, int n) throws ParseException, StandardException {
        this.qualifiedNameElement(vector, n);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.qualifiedNameElement(vector, n);
        }
    }

    public final void qualifiedNameElement(Vector vector, int n) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(n);
        vector.addElement(tableName);
    }

    public final TableName qualifiedName(int n, int n2) throws ParseException, StandardException {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string3 = this.identifier(128, false);
        if (this.getToken((int)1).kind == 452 && this.getToken((int)2).kind != 448) {
            this.jj_consume_token(452);
            string4 = this.identifier(128, false);
        }
        if (string4 == null) {
            string = string3;
        } else {
            string2 = string3;
            string = string4;
        }
        IdUtil.checkIdentifierLengthLimit(string, n2);
        if (string2 != null) {
            IdUtil.checkIdentifierLengthLimit(string2, 128);
        }
        return (TableName)this.nodeFactory.getNode(n, string2, string, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
    }

    public final ResultSetNode queryExpression(ResultSetNode resultSetNode, int n) throws ParseException, StandardException {
        ResultSetNode resultSetNode2 = this.nonJoinQueryTerm(resultSetNode, n);
        switch (this.jj_nt.kind) {
            case 134: 
            case 251: {
                resultSetNode2 = this.unionOrExcept(resultSetNode2);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        return resultSetNode2;
    }

    public final ResultSetNode unionOrExcept(ResultSetNode resultSetNode) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 251: {
                this.jj_consume_token(251);
                block4 : switch (this.jj_nt.kind) {
                    case 66: 
                    case 127: {
                        switch (this.jj_nt.kind) {
                            case 66: {
                                token = this.jj_consume_token(66);
                                break block4;
                            }
                            case 127: {
                                this.jj_consume_token(127);
                                break block4;
                            }
                        }
                        this.jj_la1[80] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                    }
                }
                ResultSetNode resultSetNode2 = this.queryExpression(resultSetNode, token != null ? 2 : 1);
                if (token != null && token.kind == 127) {
                    this.forbidNextValueFor();
                }
                return resultSetNode2;
            }
            case 134: {
                this.jj_consume_token(134);
                block11 : switch (this.jj_nt.kind) {
                    case 66: 
                    case 127: {
                        switch (this.jj_nt.kind) {
                            case 66: {
                                token = this.jj_consume_token(66);
                                break block11;
                            }
                            case 127: {
                                this.jj_consume_token(127);
                                break block11;
                            }
                        }
                        this.jj_la1[82] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                    }
                }
                ResultSetNode resultSetNode3 = this.queryExpression(resultSetNode, token != null ? 4 : 3);
                if (token != null && token.kind == 127) {
                    this.forbidNextValueFor();
                }
                return resultSetNode3;
            }
        }
        this.jj_la1[84] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode nonJoinQueryTerm(ResultSetNode resultSetNode, int n) throws ParseException, StandardException {
        ResultSetNode resultSetNode2 = this.nonJoinQueryPrimary();
        switch (this.jj_nt.kind) {
            case 169: {
                resultSetNode2 = this.intersect(resultSetNode2);
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
            }
        }
        switch (n) {
            case 0: {
                return resultSetNode2;
            }
            case 1: {
                return (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode2, Boolean.FALSE, Boolean.FALSE, null, this.getContextManager());
            }
            case 2: {
                return (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode2, Boolean.TRUE, Boolean.FALSE, null, this.getContextManager());
            }
            case 3: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(2), resultSetNode, resultSetNode2, Boolean.FALSE, null, this.getContextManager());
            }
            case 4: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(2), resultSetNode, resultSetNode2, Boolean.TRUE, null, this.getContextManager());
            }
            case 5: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(1), resultSetNode, resultSetNode2, Boolean.FALSE, null, this.getContextManager());
            }
            case 6: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(1), resultSetNode, resultSetNode2, Boolean.TRUE, null, this.getContextManager());
            }
        }
        return null;
    }

    public final ResultSetNode intersect(ResultSetNode resultSetNode) throws ParseException, StandardException {
        Token token = null;
        this.jj_consume_token(169);
        block0 : switch (this.jj_nt.kind) {
            case 66: 
            case 127: {
                switch (this.jj_nt.kind) {
                    case 66: {
                        token = this.jj_consume_token(66);
                        break block0;
                    }
                    case 127: {
                        this.jj_consume_token(127);
                        break block0;
                    }
                }
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        ResultSetNode resultSetNode2 = this.nonJoinQueryTerm(resultSetNode, token != null ? 6 : 5);
        if (token != null && token.kind == 127) {
            this.forbidNextValueFor();
        }
        return resultSetNode2;
    }

    public final ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 225: 
            case 259: {
                ResultSetNode resultSetNode = this.simpleTable();
                return resultSetNode;
            }
            case 446: {
                this.jj_consume_token(446);
                ResultSetNode resultSetNode = this.queryExpression(null, 0);
                this.jj_consume_token(447);
                return resultSetNode;
            }
        }
        this.jj_la1[88] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode simpleTable() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 225: {
                ResultSetNode resultSetNode = this.querySpecification();
                return resultSetNode;
            }
            case 259: {
                ResultSetNode resultSetNode = this.tableValueConstructor();
                return resultSetNode;
            }
        }
        this.jj_la1[89] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode querySpecification() throws ParseException, StandardException {
        boolean bl = false;
        this.jj_consume_token(225);
        if (this.jj_2_24(1)) {
            bl = this.setQuantifier();
        }
        ResultColumnList resultColumnList = this.selectList();
        SelectNode selectNode = this.tableExpression(resultColumnList);
        if (bl) {
            selectNode.makeDistinct();
        }
        return selectNode;
    }

    public final boolean setQuantifier() throws ParseException {
        if (this.getToken((int)1).kind == 127 && this.getToken((int)2).kind != 452 && this.getToken((int)2).kind != 455) {
            this.jj_consume_token(127);
            this.forbidNextValueFor();
            return true;
        }
        if (this.getToken((int)1).kind == 66 && this.getToken((int)2).kind != 452 && this.getToken((int)2).kind != 455) {
            this.jj_consume_token(66);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList selectList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        switch (this.jj_nt.kind) {
            case 448: {
                this.jj_consume_token(448);
                ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(16, null, this.getContextManager());
                resultColumnList.addResultColumn(resultColumn);
                return resultColumnList;
            }
        }
        this.jj_la1[90] = this.jj_gen;
        if (this.jj_2_25(1)) {
            this.selectColumnList(resultColumnList);
            return resultColumnList;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void selectColumnList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.selectSublist(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.selectSublist(resultColumnList);
        }
    }

    public final void selectSublist(ResultColumnList resultColumnList) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 452 && (this.getToken((int)3).kind == 448 || this.getToken((int)4).kind == 452 && this.getToken((int)5).kind == 448)) {
            TableName tableName = this.qualifiedName(128);
            this.jj_consume_token(452);
            this.jj_consume_token(448);
            ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(16, tableName, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        } else if (this.jj_2_26(1)) {
            ResultColumn resultColumn = this.derivedColumn(resultColumnList);
            resultColumnList.addResultColumn(resultColumn);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ResultColumn derivedColumn(ResultColumnList resultColumnList) throws ParseException, StandardException {
        String string = null;
        ValueNode valueNode = this.orExpression(null);
        if (this.jj_2_27(1)) {
            string = this.asClause();
        }
        if (string == null && valueNode instanceof ColumnReference) {
            string = ((ColumnReference)valueNode).columnName;
        }
        return (ResultColumn)this.nodeFactory.getNode(80, string, valueNode, this.getContextManager());
    }

    public final String asClause() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
            }
        }
        String string = this.identifier(128, true);
        return string;
    }

    public final ValueNode valueExpression() throws ParseException, StandardException {
        ValueNode valueNode = this.orExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 199: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(199);
            valueNode = this.orExpression(valueNode);
        }
        return valueNode;
    }

    public final ValueNode orExpression(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = this.andExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 69: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(69);
            valueNode2 = this.andExpression(valueNode2);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        return (ValueNode)this.nodeFactory.getNode(52, valueNode, valueNode2, this.getContextManager());
    }

    public final ValueNode andExpression(ValueNode valueNode) throws ParseException, StandardException {
        Token token = null;
        if (this.getToken((int)1).kind == 190 && this.getToken((int)2).kind != 452 && this.getToken((int)2).kind != 455) {
            token = this.jj_consume_token(190);
        }
        ValueNode valueNode2 = this.isSearchCondition();
        if (token != null) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(26, valueNode2, this.getContextManager());
        }
        if (valueNode != null) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(39, valueNode, valueNode2, this.getContextManager());
        }
        return valueNode2;
    }

    public final ValueNode isSearchCondition() throws ParseException, StandardException {
        ValueNode valueNode;
        Token token = null;
        Token token2 = null;
        Object var5_3 = null;
        ValueNode valueNode2 = this.booleanPrimary();
        switch (this.jj_nt.kind) {
            case 171: {
                token = this.jj_consume_token(171);
                switch (this.jj_nt.kind) {
                    case 190: {
                        token2 = this.jj_consume_token(190);
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                    }
                }
                this.jj_consume_token(191);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
            }
        }
        if (token != null) {
            valueNode = (ValueNode)this.nodeFactory.getNode(25, valueNode2, this.getContextManager());
            if (token2 != null) {
                valueNode = (ValueNode)this.nodeFactory.getNode(26, valueNode, this.getContextManager());
            }
        } else {
            valueNode = valueNode2;
        }
        return valueNode;
    }

    public final ValueNode booleanPrimary() throws ParseException, StandardException {
        ValueNode valueNode = this.predicate();
        return valueNode;
    }

    public final ValueNode predicate() throws ParseException, StandardException {
        ValueNode valueNode;
        if (this.jj_2_28(1)) {
            valueNode = this.additiveExpression(null, 0);
        } else {
            switch (this.jj_nt.kind) {
                case 138: {
                    valueNode = this.existsExpression();
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        while (this.remainingPredicateFollows()) {
            valueNode = this.remainingPredicate(valueNode);
        }
        return valueNode;
    }

    public final ValueNode remainingPredicate(ValueNode valueNode) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 457: 
            case 458: 
            case 459: 
            case 460: 
            case 461: 
            case 462: 
            case 463: {
                valueNode = this.remainingNonNegatablePredicate(valueNode);
                return valueNode;
            }
            case 79: 
            case 160: 
            case 178: 
            case 190: {
                switch (this.jj_nt.kind) {
                    case 190: {
                        token = this.jj_consume_token(190);
                        break;
                    }
                    default: {
                        this.jj_la1[98] = this.jj_gen;
                    }
                }
                valueNode = this.remainingNegatablePredicate(valueNode);
                if (token != null) {
                    valueNode = (ValueNode)this.nodeFactory.getNode(26, valueNode, this.getContextManager());
                }
                return valueNode;
            }
        }
        this.jj_la1[99] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode remainingNonNegatablePredicate(ValueNode valueNode) throws ParseException, StandardException {
        Object var4_2 = null;
        Object var5_3 = null;
        int n = this.compOp();
        if ((this.getToken((int)1).kind == 66 || this.getToken((int)1).kind == 70 || this.getToken((int)1).kind == 229) && this.getToken((int)2).kind == 446) {
            n = this.quantifier(n);
            this.jj_consume_token(446);
            valueNode = this.tableSubquery(n, valueNode);
            this.jj_consume_token(447);
        } else if (this.jj_2_29(1)) {
            valueNode = this.additiveExpression(valueNode, n);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return valueNode;
    }

    public final ValueNode remainingNegatablePredicate(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = null;
        ValueNode valueNode3 = null;
        switch (this.jj_nt.kind) {
            case 160: {
                this.jj_consume_token(160);
                valueNode2 = this.inPredicateValue(valueNode);
                return valueNode2;
            }
            case 178: {
                this.jj_consume_token(178);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                block5 : switch (this.jj_nt.kind) {
                    case 133: 
                    case 444: {
                        switch (this.jj_nt.kind) {
                            case 133: {
                                this.jj_consume_token(133);
                                valueNode3 = this.additiveExpression(null, 0);
                                break block5;
                            }
                            case 444: {
                                this.jj_consume_token(444);
                                this.jj_consume_token(133);
                                valueNode3 = this.additiveExpression(null, 0);
                                this.jj_consume_token(445);
                                break block5;
                            }
                        }
                        this.jj_la1[100] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                    }
                }
                valueNode2 = (ValueNode)this.nodeFactory.getNode(51, valueNode, valueNode4, valueNode3, this.getContextManager());
                return valueNode2;
            }
            case 79: {
                this.jj_consume_token(79);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                this.jj_consume_token(69);
                ValueNode valueNode6 = this.additiveExpression(null, 0);
                ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
                valueNodeList.addElement(valueNode5);
                valueNodeList.addElement(valueNode6);
                valueNode2 = (ValueNode)this.nodeFactory.getNode(53, valueNode, valueNodeList, this.getContextManager());
                return valueNode2;
            }
        }
        this.jj_la1[102] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int compOp() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 459: {
                this.jj_consume_token(459);
                return 6;
            }
            case 460: {
                this.jj_consume_token(460);
                return 7;
            }
            case 461: {
                this.jj_consume_token(461);
                return 7;
            }
            case 457: {
                this.jj_consume_token(457);
                return 10;
            }
            case 462: {
                this.jj_consume_token(462);
                return 8;
            }
            case 458: {
                this.jj_consume_token(458);
                return 11;
            }
            case 463: {
                this.jj_consume_token(463);
                return 9;
            }
        }
        this.jj_la1[103] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode additiveExpression(ValueNode valueNode, int n) throws ParseException, StandardException {
        int n2;
        ValueNode valueNode2 = this.multiplicativeExpression(null, 0);
        block11: while (true) {
            switch (this.jj_nt.kind) {
                case 449: 
                case 451: {
                    break;
                }
                default: {
                    this.jj_la1[104] = this.jj_gen;
                    break block11;
                }
            }
            int n3 = this.additiveOperator();
            valueNode2 = this.multiplicativeExpression(valueNode2, n3);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 6: {
                n2 = 41;
                break;
            }
            case 7: {
                n2 = 47;
                break;
            }
            case 10: {
                n2 = 45;
                break;
            }
            case 8: {
                n2 = 43;
                break;
            }
            case 11: {
                n2 = 44;
                break;
            }
            case 9: {
                n2 = 42;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return (ValueNode)this.nodeFactory.getNode(n2, valueNode, valueNode2, this.getContextManager());
    }

    public final int additiveOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 449: {
                Token token = this.jj_consume_token(449);
                return 1;
            }
            case 451: {
                Token token = this.jj_consume_token(451);
                return 2;
            }
        }
        this.jj_la1[105] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode multiplicativeExpression(ValueNode valueNode, int n) throws ParseException, StandardException {
        ValueNode valueNode2 = this.unaryExpression(null, 0);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 448: 
                case 453: 
                case 469: {
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                    break block7;
                }
            }
            int n2 = this.multiplicativeOperator();
            valueNode2 = this.unaryExpression(valueNode2, n2);
        }
        if (valueNode == null) {
            return valueNode2;
        }
        switch (n) {
            case 1: {
                return (ValueNode)this.nodeFactory.getNode(48, valueNode, valueNode2, this.getContextManager());
            }
            case 2: {
                return (ValueNode)this.nodeFactory.getNode(46, valueNode, valueNode2, this.getContextManager());
            }
        }
        return null;
    }

    public final int multiplicativeOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 448: {
                this.jj_consume_token(448);
                return 3;
            }
            case 453: {
                this.jj_consume_token(453);
                return 4;
            }
            case 469: {
                this.jj_consume_token(469);
                return 5;
            }
        }
        this.jj_la1[107] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode unaryExpression(ValueNode valueNode, int n) throws ParseException, StandardException {
        int n2;
        String string = null;
        int n3 = this.getToken((int)1).kind;
        if ((n3 == 449 || n3 == 451) && (n2 = this.getToken((int)2).kind) != 478 && n2 != 483) {
            string = this.sign();
        }
        ValueNode valueNode2 = this.primaryExpression();
        if ("-".equals(string)) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(29, valueNode2, this.getContextManager());
        } else if ("+".equals(string)) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(30, valueNode2, this.getContextManager());
        }
        return this.multOp(valueNode, valueNode2, n);
    }

    public final String sign() throws ParseException {
        switch (this.jj_nt.kind) {
            case 449: {
                Token token = this.jj_consume_token(449);
                return token.image;
            }
            case 451: {
                Token token = this.jj_consume_token(451);
                return token.image;
            }
        }
        this.jj_la1[108] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpressionXX() throws ParseException, StandardException {
        ValueNode valueNode = this.primary();
        while (this.jj_2_30(1)) {
            valueNode = this.nonStaticMethodCallOrFieldAccess(valueNode);
        }
        return valueNode;
    }

    public final ValueNode nonStaticMethodCallOrFieldAccess(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2 = this.nonStaticMethodInvocation(valueNode);
        return valueNode2;
    }

    public final ValueNode nonStaticMethodInvocation(ValueNode valueNode) throws ParseException, StandardException {
        Vector vector = new Vector();
        if (this.getToken((int)3).kind == 446) {
            switch (this.jj_nt.kind) {
                case 470: {
                    this.jj_consume_token(470);
                    break;
                }
                case 452: {
                    this.jj_consume_token(452);
                    break;
                }
                default: {
                    this.jj_la1[109] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MethodCallNode methodCallNode = this.methodName(valueNode);
            this.methodCallParameterList(vector);
            if (valueNode instanceof ParameterNode) {
                throw StandardException.newException("42X54", methodCallNode.getMethodName());
            }
            methodCallNode.addParms(vector);
            return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 452: {
                this.jj_consume_token(452);
                MethodCallNode methodCallNode = this.methodName(valueNode);
                if (valueNode instanceof ParameterNode) {
                    throw StandardException.newException("42X54", methodCallNode.getMethodName());
                }
                methodCallNode.addParms(vector);
                return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
            }
        }
        this.jj_la1[110] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final MethodCallNode methodName(ValueNode valueNode) throws ParseException, StandardException {
        String string = this.caseSensitiveIdentifierPlusReservedWords();
        return (MethodCallNode)this.nodeFactory.getNode(98, string, valueNode, this.getContextManager());
    }

    public final MethodCallNode staticMethodName(String string) throws ParseException, StandardException {
        String string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return (MethodCallNode)this.nodeFactory.getNode(85, string2, string, this.getContextManager());
    }

    public final void methodParameter(Vector vector) throws ParseException, StandardException {
        if (this.jj_2_31(1)) {
            ValueNode valueNode = this.orExpression(null);
            vector.addElement(valueNode);
        } else {
            switch (this.jj_nt.kind) {
                case 191: {
                    ValueNode valueNode = this.nullSpecification();
                    vector.addElement(valueNode);
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final ValueNode primary() throws ParseException, StandardException {
        if (this.javaClassFollows()) {
            ValueNode valueNode = this.staticClassReference();
            return valueNode;
        }
        if (this.jj_2_32(1)) {
            ValueNode valueNode = this.valueExpressionPrimary();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassReference() throws ParseException, StandardException {
        String string = this.javaClass();
        this.jj_consume_token(455);
        ValueNode valueNode = this.staticClassReferenceType(string);
        return valueNode;
    }

    public final ValueNode staticClassReferenceType(String string) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 446) {
            ValueNode valueNode = this.staticMethodInvocation(string);
            return valueNode;
        }
        if (this.jj_2_33(1)) {
            ValueNode valueNode = this.staticClassFieldReference(string);
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassFieldReference(String string) throws ParseException, StandardException {
        String string2 = null;
        string2 = this.caseSensitiveIdentifierPlusReservedWords();
        return (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(84, string, string2, this.nextToLastTokenDelimitedIdentifier, this.getContextManager()), this.getContextManager());
    }

    public final int nonSecondDatetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 270: {
                this.jj_consume_token(270);
                return 0;
            }
            case 310: {
                this.jj_consume_token(310);
                return 1;
            }
            case 286: {
                this.jj_consume_token(286);
                return 2;
            }
            case 157: {
                this.jj_consume_token(157);
                return 3;
            }
            case 183: {
                this.jj_consume_token(183);
                return 4;
            }
        }
        this.jj_la1[112] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedValueFunction() throws ParseException, StandardException {
        ValueNode valueNode = null;
        if (this.jj_2_34(1)) {
            ValueNode valueNode2 = this.miscBuiltinsCore(true);
            return valueNode2;
        }
        switch (this.jj_nt.kind) {
            case 235: {
                this.jj_consume_token(235);
                this.jj_consume_token(446);
                ValueNode valueNode3 = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 450: {
                        this.jj_consume_token(450);
                        valueNode = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[113] = this.jj_gen;
                    }
                }
                this.jj_consume_token(447);
                return this.getSubstringNode(valueNode3, valueNode4, valueNode, Boolean.FALSE);
            }
            case 357: {
                this.jj_consume_token(357);
                this.jj_consume_token(446);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
            }
            case 359: {
                this.jj_consume_token(359);
                this.jj_consume_token(446);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 281: {
                this.jj_consume_token(281);
                this.jj_consume_token(446);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode6 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(50, valueNode5, valueNode6, this.getContextManager());
            }
            case 112: 
            case 226: 
            case 256: {
                ValueNode valueNode7 = this.userNode();
                this.jj_consume_token(446);
                this.jj_consume_token(447);
                return valueNode7;
            }
            case 348: 
            case 349: {
                ValueNode valueNode8 = this.timestampArithmeticFuncion();
                return valueNode8;
            }
        }
        this.jj_la1[114] = this.jj_gen;
        if (this.getEscapedSYSFUN(this.getToken((int)1).image) != null) {
            ValueNode valueNode9 = this.escapedSYSFUNFunction();
            return valueNode9;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {
        Vector vector = new Vector();
        Token token = this.jj_consume_token(471);
        this.methodCallParameterList(vector);
        String string = this.getEscapedSYSFUN(token.image);
        TableName tableName = (TableName)this.nodeFactory.getNode(34, "SYSFUN", string, new Integer(0), new Integer(0), this.getContextManager());
        MethodCallNode methodCallNode = (MethodCallNode)this.nodeFactory.getNode(85, tableName, null, this.getContextManager());
        methodCallNode.addParms(vector);
        return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 348: {
                this.jj_consume_token(348);
                this.jj_consume_token(446);
                ValueNode valueNode = this.jdbcIntervalType();
                this.jj_consume_token(450);
                ValueNode valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode3 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(184, valueNode3, valueNode, valueNode2, ReuseFactory.getInteger(4), null, this.getContextManager());
            }
            case 349: {
                this.jj_consume_token(349);
                this.jj_consume_token(446);
                ValueNode valueNode = this.jdbcIntervalType();
                this.jj_consume_token(450);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(185, valueNode5, valueNode, valueNode4, ReuseFactory.getInteger(5), null, this.getContextManager());
            }
        }
        this.jj_la1[115] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode jdbcIntervalType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 333: {
                this.jj_consume_token(333);
                return this.getJdbcIntervalNode(0);
            }
            case 334: {
                this.jj_consume_token(334);
                return this.getJdbcIntervalNode(1);
            }
            case 335: {
                this.jj_consume_token(335);
                return this.getJdbcIntervalNode(2);
            }
            case 336: {
                this.jj_consume_token(336);
                return this.getJdbcIntervalNode(3);
            }
            case 337: {
                this.jj_consume_token(337);
                return this.getJdbcIntervalNode(4);
            }
            case 338: {
                this.jj_consume_token(338);
                return this.getJdbcIntervalNode(5);
            }
            case 339: {
                this.jj_consume_token(339);
                return this.getJdbcIntervalNode(6);
            }
            case 340: {
                this.jj_consume_token(340);
                return this.getJdbcIntervalNode(7);
            }
            case 341: {
                this.jj_consume_token(341);
                return this.getJdbcIntervalNode(8);
            }
        }
        this.jj_la1[116] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericValueFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 271: {
                this.jj_consume_token(271);
                ValueNode valueNode = this.absFunction();
                return valueNode;
            }
            case 272: {
                this.jj_consume_token(272);
                ValueNode valueNode = this.absFunction();
                return valueNode;
            }
            case 431: {
                this.jj_consume_token(431);
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(189, valueNode, this.getContextManager());
            }
            case 307: {
                this.jj_consume_token(307);
                ValueNode valueNode = this.modFunction();
                return valueNode;
            }
            case 292: {
                this.jj_consume_token(292);
                this.jj_consume_token(446);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(5, this.getContextManager());
            }
        }
        this.jj_la1[117] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode coalesceFunction(String string) throws ParseException, StandardException {
        ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
        this.jj_consume_token(446);
        this.coalesceExpression(valueNodeList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[118] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.coalesceExpression(valueNodeList);
        }
        this.jj_consume_token(447);
        return (ValueNode)this.nodeFactory.getNode(192, string, valueNodeList, this.getContextManager());
    }

    public final void coalesceExpression(ValueNodeList valueNodeList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        valueNodeList.addElement(valueNode);
    }

    public final ValueNode absFunction() throws ParseException, StandardException {
        this.jj_consume_token(446);
        ValueNode valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(447);
        return (ValueNode)this.nodeFactory.getNode(188, valueNode, this.getContextManager());
    }

    public final ValueNode modFunction() throws ParseException, StandardException {
        this.jj_consume_token(446);
        ValueNode valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(450);
        ValueNode valueNode2 = this.additiveExpression(null, 0);
        this.jj_consume_token(447);
        return (ValueNode)this.nodeFactory.getNode(194, valueNode, valueNode2, this.getContextManager());
    }

    public final int datetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 157: 
            case 183: 
            case 270: 
            case 286: 
            case 310: {
                int n = this.nonSecondDatetimeField();
                return n;
            }
            case 224: {
                this.jj_consume_token(224);
                return 5;
            }
        }
        this.jj_la1[119] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode characterValueFunction() throws ParseException, StandardException {
        ValueNode valueNode = null;
        Token token = null;
        Token token2 = null;
        ValueNode valueNode2 = null;
        switch (this.jj_nt.kind) {
            case 371: {
                this.jj_consume_token(371);
                this.jj_consume_token(446);
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode3 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 450: {
                        this.jj_consume_token(450);
                        valueNode2 = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[120] = this.jj_gen;
                    }
                }
                this.jj_consume_token(447);
                return this.getSubstringNode(valueNode, valueNode3, valueNode2, Boolean.FALSE);
            }
            case 179: 
            case 255: {
                switch (this.jj_nt.kind) {
                    case 255: {
                        token = this.jj_consume_token(255);
                        break;
                    }
                    case 179: {
                        token2 = this.jj_consume_token(179);
                        break;
                    }
                    default: {
                        this.jj_la1[121] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(446);
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(83, valueNode, token != null ? "upper" : "lower", this.getContextManager());
            }
            case 396: 
            case 437: {
                switch (this.jj_nt.kind) {
                    case 437: {
                        token = this.jj_consume_token(437);
                        break;
                    }
                    case 396: {
                        token2 = this.jj_consume_token(396);
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(446);
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(83, valueNode, token != null ? "upper" : "lower", this.getContextManager());
            }
            case 248: 
            case 365: 
            case 370: {
                valueNode = this.trimFunction();
                return valueNode;
            }
            case 397: {
                this.jj_consume_token(397);
                this.jj_consume_token(446);
                ValueNode valueNode4 = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode5 = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 450: {
                        this.jj_consume_token(450);
                        valueNode = this.additiveExpression(null, 0);
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                    }
                }
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(190, valueNode4, valueNode5, valueNode == null ? this.getNodeFactory().getNode(70, ReuseFactory.getInteger(1), this.getContextManager()) : valueNode, ReuseFactory.getInteger(1), null, this.getContextManager());
            }
        }
        this.jj_la1[124] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode trimFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 365: 
            case 370: {
                Integer n = this.trimType();
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return this.getTrimOperatorNode(n, null, valueNode, null);
            }
            case 248: {
                this.jj_consume_token(248);
                ValueNode valueNode = this.ansiTrim();
                return valueNode;
            }
        }
        this.jj_la1[125] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode ansiTrim() throws ParseException, StandardException {
        Integer n = ReuseFactory.getInteger(0);
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        if (this.ansiTrimSpecFollows()) {
            this.jj_consume_token(446);
            n = this.ansiTrimSpec();
            if (this.jj_2_35(Integer.MAX_VALUE)) {
                this.jj_consume_token(147);
                valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
            }
            if (this.jj_2_36(1)) {
                valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(147);
                valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (!this.ansiTrimSpecFollows()) {
            this.jj_consume_token(446);
            valueNode = this.additiveExpression(null, 0);
            switch (this.jj_nt.kind) {
                case 147: {
                    this.jj_consume_token(147);
                    valueNode2 = this.additiveExpression(null, 0);
                    this.jj_consume_token(447);
                    return this.getTrimOperatorNode(n, valueNode, valueNode2, null);
                }
                case 447: {
                    this.jj_consume_token(447);
                    return this.getTrimOperatorNode(n, null, valueNode, null);
                }
            }
            this.jj_la1[126] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer ansiTrimSpec() throws ParseException {
        switch (this.jj_nt.kind) {
            case 247: {
                this.jj_consume_token(247);
                return ReuseFactory.getInteger(1);
            }
            case 176: {
                this.jj_consume_token(176);
                return ReuseFactory.getInteger(2);
            }
            case 82: {
                this.jj_consume_token(82);
                return ReuseFactory.getInteger(0);
            }
        }
        this.jj_la1[127] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer trimType() throws ParseException {
        switch (this.jj_nt.kind) {
            case 370: {
                this.jj_consume_token(370);
                return ReuseFactory.getInteger(1);
            }
            case 365: {
                this.jj_consume_token(365);
                return ReuseFactory.getInteger(2);
            }
        }
        this.jj_la1[128] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode valueExpressionPrimary() throws ParseException, StandardException {
        if (this.escapedValueFunctionFollows()) {
            this.jj_consume_token(444);
            this.jj_consume_token(392);
            ValueNode valueNode = this.escapedValueFunction();
            this.jj_consume_token(445);
            return valueNode;
        }
        if (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 429) {
            this.jj_consume_token(108);
            switch (this.jj_nt.kind) {
                case 222: {
                    this.jj_consume_token(222);
                    break;
                }
                case 429: {
                    this.jj_consume_token(429);
                    break;
                }
                default: {
                    this.jj_la1[129] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return (ValueNode)this.nodeFactory.getNode(6, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 172) {
            this.jj_consume_token(108);
            this.jj_consume_token(172);
            return (ValueNode)this.nodeFactory.getNode(4, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 86: 
            case 112: 
            case 140: 
            case 192: 
            case 226: 
            case 249: 
            case 256: 
            case 358: 
            case 444: 
            case 449: 
            case 451: 
            case 464: 
            case 478: 
            case 481: 
            case 482: 
            case 483: {
                ValueNode valueNode = this.valueSpecification();
                return valueNode;
            }
        }
        this.jj_la1[130] = this.jj_gen;
        if (this.newInvocationFollows(1)) {
            JavaToSQLValueNode javaToSQLValueNode = this.newInvocation();
            return javaToSQLValueNode;
        }
        if (this.windowOrAggregateFunctionFollows()) {
            ValueNode valueNode = this.windowOrAggregateFunctionNode();
            return valueNode;
        }
        if (this.miscBuiltinFollows()) {
            ValueNode valueNode = this.miscBuiltins();
            return valueNode;
        }
        if (this.jj_2_38(1)) {
            ColumnReference columnReference = this.columnReference();
            return columnReference;
        }
        switch (this.jj_nt.kind) {
            case 446: {
                ValueNode valueNode;
                this.jj_consume_token(446);
                if (this.getToken((int)1).kind == 225 || this.getToken((int)1).kind == 259) {
                    valueNode = this.subquery(17, null);
                } else if (this.jj_2_37(1)) {
                    valueNode = this.valueExpression();
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(447);
                return valueNode;
            }
            case 87: {
                ValueNode valueNode = this.castSpecification();
                return valueNode;
            }
            case 188: {
                ValueNode valueNode = this.nextValueExpression();
                return valueNode;
            }
        }
        this.jj_la1[131] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltins() throws ParseException, StandardException {
        if ((this.getToken((int)1).kind == 361 || this.getToken((int)1).kind == 271 || this.getToken((int)1).kind == 272 || this.getToken((int)1).kind == 431 || this.getToken((int)1).kind == 307 || this.getToken((int)1).kind == 93 || this.getToken((int)1).kind == 258 || this.getToken((int)1).kind == 292 || this.getToken((int)1).kind == 235 || this.getToken((int)1).kind == 371 || this.getToken((int)1).kind == 255 || this.getToken((int)1).kind == 179 || this.getToken((int)1).kind == 437 || this.getToken((int)1).kind == 396 || this.getToken((int)1).kind == 365 || this.getToken((int)1).kind == 370 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 346 || this.getToken((int)1).kind == 347 || this.getToken((int)1).kind == 128 || this.getToken((int)1).kind == 88 || this.getToken((int)1).kind == 261 || this.getToken((int)1).kind == 168 || this.getToken((int)1).kind == 167 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 363 || this.getToken((int)1).kind == 270 || this.getToken((int)1).kind == 310 || this.getToken((int)1).kind == 286 || this.getToken((int)1).kind == 157 || this.getToken((int)1).kind == 183 || this.getToken((int)1).kind == 224 || this.getToken((int)1).kind == 300 || this.getToken((int)1).kind == 397 || this.getToken((int)1).kind == 374 || this.getToken((int)1).kind == 376 || this.getToken((int)1).kind == 373 || this.getToken((int)1).kind == 375) && this.getToken((int)2).kind == 446) {
            ValueNode valueNode = this.miscBuiltinsCore(false);
            return valueNode;
        }
        if (this.jj_2_39(1)) {
            ValueNode valueNode = this.datetimeValueFunction();
            return valueNode;
        }
        if (this.jj_2_40(1)) {
            ValueNode valueNode = this.routineInvocation();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltinsCore(boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 361: {
                this.jj_consume_token(361);
                this.jj_consume_token(446);
                this.jj_consume_token(447);
                this.checkInternalFeature("GETCURRENTCONNECTION()");
                return (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(18, this.getContextManager()), this.getContextManager());
            }
            case 271: 
            case 272: 
            case 292: 
            case 307: 
            case 431: {
                ValueNode valueNode = this.numericValueFunction();
                return valueNode;
            }
            case 179: 
            case 248: 
            case 255: 
            case 365: 
            case 370: 
            case 371: 
            case 396: 
            case 397: 
            case 437: {
                ValueNode valueNode = this.characterValueFunction();
                return valueNode;
            }
        }
        this.jj_la1[132] = this.jj_gen;
        if (this.jj_2_41(1)) {
            ValueNode valueNode = this.dataTypeScalarFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 93: {
                this.jj_consume_token(93);
                ValueNode valueNode = this.coalesceFunction("COALESCE");
                return valueNode;
            }
            case 258: {
                this.jj_consume_token(258);
                ValueNode valueNode = this.coalesceFunction("VALUE");
                return valueNode;
            }
            case 300: {
                this.jj_consume_token(300);
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                ContextManager contextManager = this.getContextManager();
                if (bl) {
                    return (ValueNode)this.nodeFactory.getNode(23, this.getTrimOperatorNode(ReuseFactory.getInteger(1), null, valueNode, contextManager), contextManager);
                }
                return (ValueNode)this.nodeFactory.getNode(20, valueNode, contextManager);
            }
            case 373: 
            case 374: 
            case 375: 
            case 376: {
                ValueNode valueNode = this.xmlFunction();
                return valueNode;
            }
        }
        this.jj_la1[133] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dataTypeScalarFunction() throws ParseException, StandardException {
        int n = -1;
        switch (this.jj_nt.kind) {
            case 157: 
            case 183: 
            case 224: 
            case 270: 
            case 285: 
            case 286: 
            case 310: 
            case 346: 
            case 347: {
                ValueNode valueNode = this.dateTimeScalarFunction();
                return valueNode;
            }
        }
        this.jj_la1[135] = this.jj_gen;
        if (this.jj_2_42(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.numericFunctionType();
            this.jj_consume_token(446);
            ValueNode valueNode = this.additiveExpression(null, 0);
            this.jj_consume_token(447);
            ValueNode valueNode2 = (ValueNode)this.nodeFactory.getNode(60, valueNode, dataTypeDescriptor, this.getContextManager());
            ((CastNode)valueNode2).setForDataTypeFunction(true);
            ((CastNode)valueNode2).setForExternallyGeneratedCASTnode();
            return valueNode2;
        }
        switch (this.jj_nt.kind) {
            case 88: 
            case 261: {
                int n2 = this.charOrVarchar();
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                switch (this.jj_nt.kind) {
                    case 450: {
                        this.jj_consume_token(450);
                        n = this.length();
                        break;
                    }
                    default: {
                        this.jj_la1[134] = this.jj_gen;
                    }
                }
                this.jj_consume_token(447);
                this.checkTypeLimits(n2, n);
                ValueNode valueNode3 = (ValueNode)this.nodeFactory.getNode(60, valueNode, new Integer(n2), new Integer(n), this.getContextManager());
                ((CastNode)valueNode3).setForDataTypeFunction(true);
                ((CastNode)valueNode3).setForExternallyGeneratedCASTnode();
                return valueNode3;
            }
        }
        this.jj_la1[136] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlFunction() throws ParseException, StandardException {
        this.checkVersion(130, "XML");
        XML.checkXMLRequirements();
        switch (this.jj_nt.kind) {
            case 374: {
                this.jj_consume_token(374);
                this.jj_consume_token(446);
                this.xmlDocOrContent();
                ValueNode valueNode = this.xmlParseValue();
                this.jj_consume_token(447);
                return valueNode;
            }
            case 376: {
                this.jj_consume_token(376);
                this.jj_consume_token(446);
                ValueNode valueNode = this.xmlSerializeValue();
                this.jj_consume_token(447);
                return valueNode;
            }
            case 373: {
                this.jj_consume_token(373);
                this.jj_consume_token(446);
                ValueNode valueNode = this.xmlQueryValue(true);
                this.jj_consume_token(447);
                return valueNode;
            }
            case 375: {
                this.jj_consume_token(375);
                this.jj_consume_token(446);
                ValueNode valueNode = this.xmlQueryValue(false);
                this.jj_consume_token(447);
                return valueNode;
            }
        }
        this.jj_la1[137] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlParseValue() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        boolean bl = this.xmlPreserveWhitespace();
        return (ValueNode)this.nodeFactory.getNode(200, valueNode, ReuseFactory.getInteger(0), new Object[]{bl ? Boolean.TRUE : Boolean.FALSE}, this.getContextManager());
    }

    public final boolean xmlPreserveWhitespace() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 433 && this.getToken((int)1).kind != 207) {
            throw StandardException.newException("42Z72", (Object)"PRESERVE WHITESPACE", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 433: {
                this.jj_consume_token(433);
                this.jj_consume_token(439);
                throw StandardException.newException("42Z74", "STRIP WHITESPACE");
            }
            case 207: {
                this.jj_consume_token(207);
                this.jj_consume_token(439);
                return true;
            }
        }
        this.jj_la1[138] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlSerializeValue() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        DataTypeDescriptor dataTypeDescriptor = this.xmlSerializeTargetType();
        return (ValueNode)this.nodeFactory.getNode(201, valueNode, ReuseFactory.getInteger(1), new Object[]{dataTypeDescriptor}, this.getContextManager());
    }

    public final DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 72) {
            throw StandardException.newException("42Z72", (Object)"AS", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 72: {
                this.jj_consume_token(72);
                DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[139] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlQueryValue(boolean bl) throws ParseException, StandardException {
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        int n = -1;
        valueNode = this.additiveExpression(null, 0);
        this.jj_consume_token(411);
        n = this.xmlPassingMechanism();
        valueNode2 = this.xqVarList();
        if (!bl) {
            if (this.jj_2_44(1)) {
                this.xqReturningClause();
                if (this.jj_2_43(1)) {
                    this.xmlPassingMechanism();
                }
            }
            this.xqEmptyHandlingClause();
        } else if (!bl) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        ValueNode valueNode3 = (ValueNode)this.nodeFactory.getNode(bl ? 202 : 203, valueNode, valueNode2, bl ? ReuseFactory.getInteger(0) : ReuseFactory.getInteger(1), this.getContextManager());
        return valueNode3;
    }

    public final ValueNode xqVarList() throws ParseException, StandardException {
        ValueNode[] valueNodeArray = new ValueNode[]{null};
        this.xqVariable(valueNodeArray);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[140] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.xqVariable(valueNodeArray);
        }
        return valueNodeArray[0];
    }

    public final void xqVariable(ValueNode[] valueNodeArray) throws ParseException, StandardException {
        String string = null;
        int n = -1;
        ValueNode valueNode = this.additiveExpression(null, 0);
        if (this.getToken((int)1).kind == 72) {
            this.jj_consume_token(72);
            string = this.identifier(128, true);
            throw StandardException.newException("42Z74", "PASSING ... AS");
        }
        if (this.jj_2_45(1)) {
            n = this.xmlPassingMechanism();
        }
        if (string == null) {
            if (valueNodeArray[0] != null) {
                throw StandardException.newException("42Z76");
            }
            valueNodeArray[0] = valueNode;
        }
    }

    public final short xmlPassingMechanism() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 415) {
            this.jj_consume_token(83);
            this.jj_consume_token(415);
            return 1;
        }
        switch (this.jj_nt.kind) {
            case 83: {
                this.jj_consume_token(83);
                this.jj_consume_token(258);
                throw StandardException.newException("42Z74", "BY VALUE");
            }
        }
        this.jj_la1[141] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqReturningClause() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 425) {
            this.jj_consume_token(421);
            this.jj_consume_token(425);
            return 3;
        }
        switch (this.jj_nt.kind) {
            case 421: {
                this.jj_consume_token(421);
                this.jj_consume_token(381);
                throw StandardException.newException("42Z74", "RETURNING CONTENT");
            }
        }
        this.jj_la1[142] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqEmptyHandlingClause() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 390) {
            this.jj_consume_token(390);
            this.jj_consume_token(195);
            this.jj_consume_token(390);
            return 5;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                this.jj_consume_token(191);
                this.jj_consume_token(195);
                this.jj_consume_token(390);
                throw StandardException.newException("42Z74", "NULL ON EMPTY");
            }
        }
        this.jj_la1[143] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {
        if (this.jj_2_46(1)) {
            DataTypeDescriptor dataTypeDescriptor = this.doubleType();
            return dataTypeDescriptor;
        }
        switch (this.jj_nt.kind) {
            case 167: 
            case 168: 
            case 228: 
            case 363: {
                DataTypeDescriptor dataTypeDescriptor = this.exactIntegerType();
                return dataTypeDescriptor;
            }
        }
        this.jj_la1[144] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeScalarFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 346: {
                this.jj_consume_token(346);
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                ValueNode valueNode2 = (ValueNode)this.nodeFactory.getNode(60, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(92), this.getContextManager());
                ((CastNode)valueNode2).setForExternallyGeneratedCASTnode();
                return valueNode2;
            }
            case 285: {
                this.jj_consume_token(285);
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(32, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(91), this.getContextManager());
            }
            case 347: {
                this.jj_consume_token(347);
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                ValueNode valueNode3 = this.timestampFunctionCompletion(valueNode);
                return valueNode3;
            }
            case 157: 
            case 183: 
            case 224: 
            case 270: 
            case 286: 
            case 310: {
                int n = this.datetimeField();
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(87, ReuseFactory.getInteger(n), valueNode, this.getContextManager());
            }
        }
        this.jj_la1[145] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode timestampFunctionCompletion(ValueNode valueNode) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 447: {
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(32, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(93), this.getContextManager());
            }
            case 450: {
                this.jj_consume_token(450);
                ValueNode valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                return (ValueNode)this.nodeFactory.getNode(33, valueNode, valueNode2, this.getContextManager());
            }
        }
        this.jj_la1[146] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token booleanLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 249: {
                Token token = this.jj_consume_token(249);
                return token;
            }
            case 140: {
                Token token = this.jj_consume_token(140);
                return token;
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generalValueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 464: {
                ParameterNode parameterNode = this.dynamicParameterSpecification();
                return parameterNode;
            }
            case 112: 
            case 226: 
            case 256: {
                ValueNode valueNode = this.userNode();
                return valueNode;
            }
            case 358: {
                ValueNode valueNode = this.currentRoleNode();
                return valueNode;
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode userNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 256: {
                this.jj_consume_token(256);
                return (ValueNode)this.nodeFactory.getNode(110, this.getContextManager());
            }
            case 112: {
                this.jj_consume_token(112);
                return (ValueNode)this.nodeFactory.getNode(109, this.getContextManager());
            }
            case 226: {
                this.jj_consume_token(226);
                return (ValueNode)this.nodeFactory.getNode(125, this.getContextManager());
            }
        }
        this.jj_la1[149] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode currentRoleNode() throws ParseException, StandardException {
        this.jj_consume_token(358);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("CURRENT_ROLE");
        return (ValueNode)this.nodeFactory.getNode(210, this.getContextManager());
    }

    public final JavaToSQLValueNode newInvocation() throws ParseException, StandardException {
        Vector vector = new Vector();
        this.jj_consume_token(402);
        String string = this.javaClassName();
        this.methodCallParameterList(vector);
        if (!(string.startsWith("org.apache.derby.diag.") || string.startsWith("org.apache.derby.catalog.") || string.startsWith("com.ibm.db2j."))) {
            this.checkInternalFeature(string);
        }
        QueryTreeNode queryTreeNode = this.nodeFactory.getNode(133, string, vector, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return (JavaToSQLValueNode)this.nodeFactory.getNode(36, queryTreeNode, this.getContextManager());
    }

    public final JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {
        NewInvocationNode newInvocationNode = null;
        MethodCallNode methodCallNode = null;
        Vector vector = new Vector();
        TableName tableName = null;
        this.jj_consume_token(239);
        this.jj_consume_token(446);
        tableName = this.qualifiedName(128);
        this.methodCallParameterList(vector);
        this.jj_consume_token(447);
        newInvocationNode = (NewInvocationNode)this.nodeFactory.getNode(133, tableName, null, vector, this.lastTokenDelimitedIdentifier, this.getContextManager());
        if (newInvocationNode.isBuiltinVTI()) {
            methodCallNode = newInvocationNode;
        } else {
            MethodCallNode methodCallNode2 = (MethodCallNode)this.nodeFactory.getNode(85, tableName, null, this.getContextManager());
            methodCallNode2.addParms(vector);
            methodCallNode = methodCallNode2;
        }
        return (JavaToSQLValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final ValueNode staticMethodInvocation(String string) throws ParseException, StandardException {
        Vector vector = new Vector();
        MethodCallNode methodCallNode = this.staticMethodName(string);
        this.methodCallParameterList(vector);
        methodCallNode.addParms(vector);
        return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final void methodCallParameterList(Vector vector) throws ParseException, StandardException {
        this.jj_consume_token(446);
        if (this.jj_2_47(1)) {
            this.methodParameter(vector);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 450: {
                        break;
                    }
                    default: {
                        this.jj_la1[150] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(450);
                this.methodParameter(vector);
            }
        }
        this.jj_consume_token(447);
    }

    public final ValueNode routineInvocation() throws ParseException, StandardException {
        Vector vector = new Vector();
        TableName tableName = this.qualifiedName(128);
        this.methodCallParameterList(vector);
        MethodCallNode methodCallNode = (MethodCallNode)this.nodeFactory.getNode(85, tableName, null, this.getContextManager());
        methodCallNode.addParms(vector);
        return (ValueNode)this.nodeFactory.getNode(36, methodCallNode, this.getContextManager());
    }

    public final String javaClass() throws ParseException, StandardException {
        String string = this.javaClassName();
        return string;
    }

    public final ValueNode columnMethodInvocation() throws ParseException, StandardException {
        ValueNode valueNode = this.columnNameForInvocation();
        ValueNode valueNode2 = this.nonStaticMethodInvocation(valueNode);
        return valueNode2;
    }

    public final ValueNode columnNameForInvocation() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TableName tableName = null;
        String string6 = this.identifier(128, true);
        if (this.getToken((int)1).kind == 452 && this.getToken((int)3).kind == 452) {
            this.jj_consume_token(452);
            string = this.identifier(128, true);
            if (this.getToken((int)1).kind == 452 && this.getToken((int)3).kind == 452) {
                this.jj_consume_token(452);
                string2 = this.identifier(128, true);
            }
        }
        if (string2 == null) {
            if (string == null) {
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string;
            }
        } else {
            string5 = string6;
            string4 = string;
            string3 = string2;
        }
        if (string4 != null) {
            tableName = (TableName)this.nodeFactory.getNode(34, string5, string4, new Integer(this.nextToLastIdentifierToken.beginOffset), new Integer(this.nextToLastIdentifierToken.endOffset), this.getContextManager());
        }
        ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(62, string3, tableName, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
        return valueNode;
    }

    public final ColumnReference columnReference() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TableName tableName = null;
        String string6 = this.identifier(128, false);
        if (this.getToken((int)1).kind == 452 && this.getToken((int)3).kind != 446) {
            this.jj_consume_token(452);
            string = this.identifier(128, false);
            if (this.getToken((int)1).kind == 452 && this.getToken((int)3).kind != 446) {
                this.jj_consume_token(452);
                string2 = this.identifier(128, false);
            }
        }
        if (string2 == null) {
            if (string == null) {
                string3 = string6;
            } else {
                string4 = string6;
                string3 = string;
            }
        } else {
            string5 = string6;
            string4 = string;
            string3 = string2;
        }
        IdUtil.checkIdentifierLengthLimit(string3, 128);
        if (string5 != null) {
            IdUtil.checkIdentifierLengthLimit(string5, 128);
        }
        if (string4 != null) {
            IdUtil.checkIdentifierLengthLimit(string4, 128);
        }
        if (string4 != null) {
            tableName = (TableName)this.nodeFactory.getNode(34, string5, string4, new Integer(this.nextToLastIdentifierToken.beginOffset), new Integer(this.nextToLastIdentifierToken.endOffset), this.getContextManager());
        }
        return (ColumnReference)this.nodeFactory.getNode(62, string3, tableName, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
    }

    public final OrderByList orderByClause() throws ParseException, StandardException {
        this.jj_consume_token(200);
        this.jj_consume_token(83);
        OrderByList orderByList = this.sortSpecificationList();
        this.forbidNextValueFor();
        return orderByList;
    }

    public final int atIsolationLevel() throws ParseException, StandardException {
        this.jj_consume_token(267);
        int n = this.isolationLevelDB2Abbrev();
        return n;
    }

    public final OrderByList sortSpecificationList() throws ParseException, StandardException {
        OrderByList orderByList = (OrderByList)this.nodeFactory.getNode(7, this.getContextManager());
        this.sortSpecification(orderByList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[151] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.sortSpecification(orderByList);
        }
        return orderByList;
    }

    public final void sortSpecification(OrderByList orderByList) throws ParseException, StandardException {
        OrderByColumn orderByColumn = this.sortKey();
        switch (this.jj_nt.kind) {
            case 73: 
            case 123: {
                this.orderingSpecification(orderByColumn);
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
            }
        }
        if (this.jj_2_48(1)) {
            this.nullOrdering(orderByColumn);
        }
        orderByList.addOrderByColumn(orderByColumn);
    }

    public final OrderByColumn sortKey() throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        return (OrderByColumn)this.nodeFactory.getNode(104, valueNode, this.getContextManager());
    }

    public final void orderingSpecification(OrderByColumn orderByColumn) throws ParseException {
        switch (this.jj_nt.kind) {
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                orderByColumn.setDescending();
                break;
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void nullOrdering(OrderByColumn orderByColumn) throws ParseException {
        if (this.getToken((int)2).kind == 175) {
            this.jj_consume_token(316);
            this.jj_consume_token(175);
            if (!orderByColumn.isAscending()) {
                orderByColumn.setNullsOrderedLow();
            }
        } else {
            switch (this.jj_nt.kind) {
                case 316: {
                    this.jj_consume_token(316);
                    this.jj_consume_token(142);
                    if (!orderByColumn.isAscending()) break;
                    orderByColumn.setNullsOrderedLow();
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final ValueNode offsetClause() throws ParseException, StandardException {
        ValueNode valueNode = null;
        this.jj_consume_token(319);
        switch (this.jj_nt.kind) {
            case 449: 
            case 451: 
            case 478: {
                valueNode = this.intLiteral();
                break;
            }
            case 464: {
                valueNode = this.dynamicParameterSpecification();
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 328: {
                this.jj_consume_token(328);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[156] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return valueNode;
    }

    public final ValueNode fetchFirstClause() throws ParseException, StandardException {
        ValueNode valueNode = this.getNumericNode("1", true);
        this.jj_consume_token(141);
        switch (this.jj_nt.kind) {
            case 142: {
                this.jj_consume_token(142);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                break;
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block4 : switch (this.jj_nt.kind) {
            case 449: 
            case 451: 
            case 464: 
            case 478: {
                switch (this.jj_nt.kind) {
                    case 449: 
                    case 451: 
                    case 478: {
                        valueNode = this.intLiteral();
                        break block4;
                    }
                    case 464: {
                        valueNode = this.dynamicParameterSpecification();
                        break block4;
                    }
                }
                this.jj_la1[158] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[159] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 328: {
                this.jj_consume_token(328);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            default: {
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(196);
        return valueNode;
    }

    public final int forUpdateClause(Vector vector) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        this.forUpdateColumnList(vector);
                        break;
                    }
                    default: {
                        this.jj_la1[161] = this.jj_gen;
                    }
                }
                return 2;
            }
            case 213: {
                this.jj_consume_token(213);
                this.jj_consume_token(196);
                return 1;
            }
            case 141: {
                this.jj_consume_token(141);
                this.jj_consume_token(196);
                return 1;
            }
        }
        this.jj_la1[162] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void forUpdateColumnList(Vector vector) throws ParseException, StandardException {
        this.forUpdateColumn(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[163] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.forUpdateColumn(vector);
        }
    }

    public final void forUpdateColumn(Vector vector) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        vector.addElement(string);
    }

    public final ResultColumnList setClauseList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.setClause(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.setClause(resultColumnList);
        }
        return resultColumnList;
    }

    public final void setClause(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ColumnReference columnReference = this.columnReference();
        this.jj_consume_token(459);
        ValueNode valueNode = this.updateSource(columnReference.getColumnName());
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnReference, valueNode, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final ValueNode updateSource(String string) throws ParseException, StandardException {
        if (this.jj_2_49(1)) {
            ValueNode valueNode = this.orExpression(null);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                ValueNode valueNode = this.nullSpecification();
                return valueNode;
            }
            case 119: {
                this.jj_consume_token(119);
                return (ValueNode)this.nodeFactory.getNode(100, string, this.getContextManager());
            }
        }
        this.jj_la1[165] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode nullSpecification() throws ParseException, StandardException {
        this.jj_consume_token(191);
        return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
    }

    public final StatementNode insertColumnsAndSource(QueryTreeNode queryTreeNode) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        OrderByList orderByList = null;
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        if (this.getToken((int)1).kind == 446 && !this.subqueryFollows()) {
            this.jj_consume_token(446);
            resultColumnList = this.insertColumnList();
            this.jj_consume_token(447);
        }
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[166] = this.jj_gen;
            }
        }
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 319: {
                valueNode = this.offsetClause();
                break;
            }
            default: {
                this.jj_la1[168] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 141: {
                valueNode2 = this.fetchFirstClause();
                break;
            }
            default: {
                this.jj_la1[169] = this.jj_gen;
            }
        }
        if (orderByList != null && this.isTableValueConstructor(resultSetNode)) {
            throw StandardException.newException("42X01", "ORDER BY");
        }
        if ((valueNode != null || valueNode2 != null) && this.isTableValueConstructor(resultSetNode)) {
            throw StandardException.newException("42X01", valueNode != null ? "OFFSET" : "FETCH");
        }
        return (StatementNode)this.nodeFactory.getNode(138, queryTreeNode, resultColumnList, resultSetNode, properties, orderByList, valueNode, valueNode2, this.getContextManager());
    }

    public final ResultColumnList insertColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnQualifiedNameList(resultColumnList);
        return resultColumnList;
    }

    public final void columnQualifiedNameList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.columnQualifiedNameItem(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[170] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.columnQualifiedNameItem(resultColumnList);
        }
    }

    public final void columnQualifiedNameItem(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ColumnReference columnReference = this.columnReference();
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnReference, null, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final ResultSetNode rowValueConstructor(ResultSetNode resultSetNode) throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        if (this.rowValueConstructorListFollows()) {
            this.jj_consume_token(446);
            this.rowValueConstructorList(resultColumnList);
            this.jj_consume_token(447);
            ResultSetNode resultSetNode2 = (ResultSetNode)this.nodeFactory.getNode(105, resultColumnList, null, this.getContextManager());
            if (resultSetNode != null) {
                if (resultSetNode.getResultColumns().size() != resultSetNode2.getResultColumns().size()) {
                    throw StandardException.newException("42X59");
                }
                resultSetNode2 = (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode2, Boolean.TRUE, Boolean.TRUE, null, this.getContextManager());
            }
            return resultSetNode2;
        }
        this.rowValueConstructorElement(resultColumnList);
        ResultSetNode resultSetNode3 = (ResultSetNode)this.nodeFactory.getNode(105, resultColumnList, null, this.getContextManager());
        if (resultSetNode != null) {
            if (resultSetNode.getResultColumns().size() != resultSetNode3.getResultColumns().size()) {
                throw StandardException.newException("42X59");
            }
            resultSetNode3 = (ResultSetNode)this.nodeFactory.getNode(142, resultSetNode, resultSetNode3, Boolean.TRUE, Boolean.TRUE, null, this.getContextManager());
        }
        return resultSetNode3;
    }

    public final void rowValueConstructorElement(ResultColumnList resultColumnList) throws ParseException, StandardException {
        if (this.jj_2_50(1)) {
            ValueNode valueNode = this.orExpression(null);
            resultColumnList.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, valueNode, this.getContextManager()));
        } else {
            switch (this.jj_nt.kind) {
                case 191: {
                    ValueNode valueNode = this.nullSpecification();
                    resultColumnList.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, valueNode, this.getContextManager()));
                    break;
                }
                case 119: {
                    this.jj_consume_token(119);
                    resultColumnList.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, (ValueNode)this.nodeFactory.getNode(100, null, this.getContextManager()), this.getContextManager()));
                    break;
                }
                default: {
                    this.jj_la1[171] = this.jj_gen;
                    throw StandardException.newException("42X80");
                }
            }
        }
    }

    public final void rowValueConstructorList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.rowValueConstructorElement(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[172] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.rowValueConstructorElement(resultColumnList);
        }
    }

    public final SubqueryNode tableSubquery(int n, ValueNode valueNode) throws ParseException, StandardException {
        SubqueryNode subqueryNode = this.subquery(n, valueNode);
        return subqueryNode;
    }

    public final SubqueryNode subquery(int n, ValueNode valueNode) throws ParseException, StandardException {
        OrderByList orderByList = null;
        ValueNode valueNode2 = null;
        ValueNode valueNode3 = null;
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 319: {
                valueNode2 = this.offsetClause();
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 141: {
                valueNode3 = this.fetchFirstClause();
                break;
            }
            default: {
                this.jj_la1[175] = this.jj_gen;
            }
        }
        SubqueryNode subqueryNode = (SubqueryNode)this.nodeFactory.getNode(93, resultSetNode, ReuseFactory.getInteger(n), valueNode, orderByList, valueNode2, valueNode3, this.getContextManager());
        return subqueryNode;
    }

    public final ValueNode inPredicateValue(ValueNode valueNode) throws ParseException, StandardException {
        ValueNode valueNode2;
        this.jj_consume_token(446);
        if (this.subqueryFollows()) {
            valueNode2 = this.tableSubquery(1, valueNode);
        } else if (this.jj_2_51(1)) {
            valueNode2 = this.inValueList(valueNode);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(447);
        return valueNode2;
    }

    public final ValueNode inValueList(ValueNode valueNode) throws ParseException, StandardException {
        ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
        this.inElement(valueNodeList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[176] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.inElement(valueNodeList);
        }
        return (ValueNode)this.nodeFactory.getNode(55, valueNode, valueNodeList, this.getContextManager());
    }

    public final void inElement(ValueNodeList valueNodeList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        valueNodeList.addElement(valueNode);
    }

    public final int quantifier(int n) throws ParseException, StandardException {
        int n2 = 0;
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                switch (n) {
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        n2 = 6;
                        break;
                    }
                    case 11: {
                        n2 = 14;
                        break;
                    }
                    case 10: {
                        n2 = 12;
                        break;
                    }
                    case 9: {
                        n2 = 10;
                        break;
                    }
                    case 8: {
                        n2 = 8;
                        break;
                    }
                }
                return n2;
            }
            case 70: 
            case 229: {
                this.some();
                switch (n) {
                    case 6: {
                        n2 = 3;
                        break;
                    }
                    case 7: {
                        n2 = 5;
                        break;
                    }
                    case 11: {
                        n2 = 13;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    case 9: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 7;
                        break;
                    }
                }
                return n2;
            }
        }
        this.jj_la1[177] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void some() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 229: {
                this.jj_consume_token(229);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SubqueryNode existsExpression() throws ParseException, StandardException {
        this.jj_consume_token(138);
        this.jj_consume_token(446);
        SubqueryNode subqueryNode = this.tableSubquery(15, null);
        this.jj_consume_token(447);
        return subqueryNode;
    }

    public final SelectNode tableExpression(ResultColumnList resultColumnList) throws ParseException, StandardException {
        ValueNode valueNode = null;
        GroupByList groupByList = null;
        ValueNode valueNode2 = null;
        WindowList windowList = null;
        FromList fromList = this.fromClause();
        switch (this.jj_nt.kind) {
            case 265: {
                Token token = this.jj_consume_token(265);
                valueNode = this.whereClause(token);
                break;
            }
            default: {
                this.jj_la1[179] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 155: {
                groupByList = this.groupByClause();
                break;
            }
            default: {
                this.jj_la1[180] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 156: {
                valueNode2 = this.havingClause();
                break;
            }
            default: {
                this.jj_la1[181] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 266: {
                windowList = this.windowClause();
                break;
            }
            default: {
                this.jj_la1[182] = this.jj_gen;
            }
        }
        if (valueNode2 != null && groupByList == null) {
            ValueNode valueNode3 = (ValueNode)this.nodeFactory.getNode(115, null, CountAggregateDefinition.class, Boolean.FALSE, "COUNT(*)", this.getContextManager());
            AggregateNode aggregateNode = (AggregateNode)valueNode3;
            aggregateNode.replaceAggregatesWithColumnReferences(resultColumnList, 0);
        }
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, resultColumnList, null, fromList, valueNode, groupByList, valueNode2, windowList, this.getContextManager());
        return selectNode;
    }

    public final FromList fromClause() throws ParseException, StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.jj_consume_token(147);
        Token token = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 59: {
                this.fromListProperties(fromList);
                break;
            }
            default: {
                this.jj_la1[183] = this.jj_gen;
            }
        }
        this.dummyTableReferenceRule(fromList);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[184] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(450);
            this.dummyTableReferenceRule(fromList);
        }
        Token token2 = this.getToken(0);
        fromList.setBeginOffset(token.beginOffset);
        fromList.setEndOffset(token2.endOffset);
        return fromList;
    }

    public final void fromListProperties(FromList fromList) throws ParseException, StandardException {
        Properties properties = this.propertyList(true);
        this.jj_consume_token(64);
        fromList.setProperties(properties);
    }

    public final void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 239 && this.getToken((int)2).kind == 446 && (this.getToken((int)3).kind == 225 || this.getToken((int)3).kind == 259)) {
            this.jj_consume_token(239);
            FromTable fromTable = this.tableReferenceTypes(false);
            fromList.addFromTable(fromTable);
        } else if (this.jj_2_52(1)) {
            FromTable fromTable = this.tableReferenceTypes(false);
            fromList.addFromTable(fromTable);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final FromTable tableReferenceTypes(boolean bl) throws ParseException, StandardException {
        if (this.jj_2_53(1)) {
            FromTable fromTable = this.tableReference(bl);
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 444: {
                this.jj_consume_token(444);
                this.jj_consume_token(405);
                FromTable fromTable = this.tableReference(bl);
                this.jj_consume_token(445);
                return fromTable;
            }
        }
        this.jj_la1[185] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] optionalTableClauses() throws ParseException, StandardException {
        Object[] objectArray = null;
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        String string = null;
        switch (this.jj_nt.kind) {
            case 59: {
                objectArray = this.optionalTableProperties();
                objectArray[1] = resultColumnList;
                objectArray[2] = string;
                return objectArray;
            }
        }
        this.jj_la1[189] = this.jj_gen;
        if (this.jj_2_54(1)) {
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[186] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 446: {
                    this.jj_consume_token(446);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(447);
                    break;
                }
                default: {
                    this.jj_la1[187] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(true);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[188] = this.jj_gen;
                }
            }
        }
        objectArray = new Object[]{properties, resultColumnList, string};
        return objectArray;
    }

    public final Object[] optionalTableProperties() throws ParseException, StandardException {
        Object[] objectArray = null;
        Properties properties = null;
        properties = this.propertyList(true);
        this.jj_consume_token(64);
        objectArray = new Object[3];
        objectArray[0] = properties;
        return objectArray;
    }

    public final FromTable tableReference(boolean bl) throws ParseException, StandardException {
        TableOperatorNode tableOperatorNode = null;
        FromTable fromTable = this.tableFactor();
        while (this.joinedTableExpressionFollows()) {
            tableOperatorNode = this.joinedTableExpression(tableOperatorNode == null ? fromTable : tableOperatorNode, bl);
        }
        return tableOperatorNode == null ? fromTable : tableOperatorNode;
    }

    public final FromTable tableFactor() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLValueNode = null;
        String string = null;
        ResultColumnList resultColumnList = null;
        Object[] objectArray = new Object[3];
        Object var8_5 = null;
        if (this.jj_2_55(1)) {
            if (this.newInvocationFollows(1)) {
                javaToSQLValueNode = this.newInvocation();
            } else {
                switch (this.jj_nt.kind) {
                    case 239: {
                        javaToSQLValueNode = this.vtiTableConstruct();
                        break;
                    }
                    default: {
                        this.jj_la1[190] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[191] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 446: {
                    this.jj_consume_token(446);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(447);
                    break;
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    objectArray = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[193] = this.jj_gen;
                }
            }
            FromTable fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLValueNode.getJavaValueNode(), string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager());
            return fromTable;
        }
        if (this.jj_2_56(1)) {
            TableName tableName = this.qualifiedName(128);
            objectArray = this.optionalTableClauses();
            FromTable fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, (String)objectArray[2], (ResultColumnList)objectArray[1], (Properties)objectArray[0], this.getContextManager());
            return fromTable;
        }
        if (this.getToken((int)1).kind == 446 && (this.getToken((int)2).kind == 225 || this.getToken((int)2).kind == 259)) {
            SubqueryNode subqueryNode = this.derivedTable();
            switch (this.jj_nt.kind) {
                case 72: {
                    this.jj_consume_token(72);
                    break;
                }
                default: {
                    this.jj_la1[194] = this.jj_gen;
                }
            }
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 446: {
                    this.jj_consume_token(446);
                    resultColumnList = this.derivedColumnList();
                    this.jj_consume_token(447);
                    break;
                }
                default: {
                    this.jj_la1[195] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 59: {
                    objectArray = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[196] = this.jj_gen;
                }
            }
            FromTable fromTable = (FromTable)this.nodeFactory.getNode(136, subqueryNode.getResultSet(), subqueryNode.getOrderByList(), subqueryNode.getOffset(), subqueryNode.getFetchFirst(), string, resultColumnList, objectArray != null ? (Properties)objectArray[0] : (Properties)null, this.getContextManager());
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 446: {
                this.jj_consume_token(446);
                FromTable fromTable = this.tableReferenceTypes(true);
                this.jj_consume_token(447);
                FromTable fromTable2 = fromTable;
                return fromTable2;
            }
        }
        this.jj_la1[197] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList derivedColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final void columnNameList(ResultColumnList resultColumnList) throws ParseException, StandardException {
        this.columnNameItem(resultColumnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[198] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.columnNameItem(resultColumnList);
        }
    }

    public final void columnNameItem(ResultColumnList resultColumnList) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager());
        resultColumnList.addResultColumn(resultColumn);
    }

    public final void indexColumnList(Vector vector) throws ParseException, StandardException {
        this.indexColumnItem(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[199] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.indexColumnItem(vector);
        }
    }

    public final void indexColumnItem(Vector vector) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        block0 : switch (this.jj_nt.kind) {
            case 73: 
            case 123: {
                switch (this.jj_nt.kind) {
                    case 73: {
                        this.jj_consume_token(73);
                        break block0;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        string = string + ' ';
                        break block0;
                    }
                }
                this.jj_la1[200] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[201] = this.jj_gen;
            }
        }
        vector.addElement(string);
    }

    public final SubqueryNode derivedTable() throws ParseException, StandardException {
        this.jj_consume_token(446);
        SubqueryNode subqueryNode = this.tableSubquery(0, null);
        this.jj_consume_token(447);
        return subqueryNode;
    }

    public final TableOperatorNode joinedTableExpression(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 107: {
                TableOperatorNode tableOperatorNode = this.crossJoin(resultSetNode, bl);
                return tableOperatorNode;
            }
            case 163: 
            case 173: 
            case 177: 
            case 219: {
                TableOperatorNode tableOperatorNode = this.qualifiedJoin(resultSetNode, bl);
                return tableOperatorNode;
            }
            case 186: {
                TableOperatorNode tableOperatorNode = this.naturalJoin(resultSetNode, bl);
                return tableOperatorNode;
            }
        }
        this.jj_la1[202] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableOperatorNode crossJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        this.jj_consume_token(107);
        this.jj_consume_token(173);
        FromTable fromTable = this.tableFactor();
        JoinNode joinNode = this.newJoinNode(resultSetNode, fromTable, null, null, 1);
        joinNode.setNestedInParens(bl);
        return joinNode;
    }

    public final TableOperatorNode qualifiedJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        int n = 1;
        JoinNode joinNode = null;
        Object[] objectArray = null;
        ResultColumnList resultColumnList = null;
        switch (this.jj_nt.kind) {
            case 163: 
            case 177: 
            case 219: {
                n = this.joinType();
                break;
            }
            default: {
                this.jj_la1[203] = this.jj_gen;
            }
        }
        this.jj_consume_token(173);
        FromTable fromTable = this.tableReferenceTypes(bl);
        objectArray = this.joinSpecification(resultSetNode, fromTable);
        ValueNode valueNode = (ValueNode)objectArray[0];
        resultColumnList = (ResultColumnList)objectArray[1];
        if (valueNode == null && resultColumnList == null) {
            throw StandardException.newException("42Y11", JoinNode.joinTypeToString(n));
        }
        joinNode = this.newJoinNode(resultSetNode, fromTable, valueNode, resultColumnList, n);
        joinNode.setNestedInParens(bl);
        return joinNode;
    }

    public final TableOperatorNode naturalJoin(ResultSetNode resultSetNode, boolean bl) throws ParseException, StandardException {
        int n = 1;
        this.jj_consume_token(186);
        switch (this.jj_nt.kind) {
            case 163: 
            case 177: 
            case 219: {
                n = this.joinType();
                break;
            }
            default: {
                this.jj_la1[204] = this.jj_gen;
            }
        }
        this.jj_consume_token(173);
        FromTable fromTable = this.tableFactor();
        JoinNode joinNode = this.newJoinNode(resultSetNode, fromTable, null, null, n);
        joinNode.setNestedInParens(bl);
        joinNode.setNaturalJoin();
        return joinNode;
    }

    public final int joinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 163: {
                this.jj_consume_token(163);
                return 1;
            }
            case 177: 
            case 219: {
                int n = this.outerJoinType();
                switch (this.jj_nt.kind) {
                    case 201: {
                        this.jj_consume_token(201);
                        break;
                    }
                    default: {
                        this.jj_la1[205] = this.jj_gen;
                    }
                }
                return n;
            }
        }
        this.jj_la1[206] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int outerJoinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 177: {
                this.jj_consume_token(177);
                return 3;
            }
            case 219: {
                this.jj_consume_token(219);
                return 4;
            }
        }
        this.jj_la1[207] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] joinSpecification(ResultSetNode resultSetNode, ResultSetNode resultSetNode2) throws ParseException, StandardException {
        Object[] objectArray = new Object[2];
        ResultColumnList resultColumnList = null;
        ValueNode valueNode = null;
        switch (this.jj_nt.kind) {
            case 195: {
                valueNode = this.joinCondition();
                objectArray[0] = valueNode;
                objectArray[1] = resultColumnList;
                return objectArray;
            }
            case 257: {
                resultColumnList = this.namedColumnsJoin();
                objectArray[0] = valueNode;
                objectArray[1] = resultColumnList;
                return objectArray;
            }
        }
        this.jj_la1[208] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode joinCondition() throws ParseException, StandardException {
        this.jj_consume_token(195);
        ValueNode valueNode = this.valueExpression();
        return valueNode;
    }

    public final ResultColumnList namedColumnsJoin() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.jj_consume_token(257);
        this.jj_consume_token(446);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(447);
        return resultColumnList;
    }

    public final ResultSetNode tableValueConstructor() throws ParseException, StandardException {
        this.jj_consume_token(259);
        ResultSetNode resultSetNode = this.tableValueConstructorList();
        return resultSetNode;
    }

    public final ResultSetNode tableValueConstructorList() throws ParseException, StandardException {
        ResultSetNode resultSetNode = this.rowValueConstructor(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[209] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            resultSetNode = this.rowValueConstructor(resultSetNode);
        }
        if (resultSetNode instanceof UnionNode) {
            ((UnionNode)resultSetNode).markTopTableConstructor();
        }
        return resultSetNode;
    }

    public final ValueNode datetimeValueFunction() throws ParseException, StandardException {
        int n = -1;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 285) {
            this.jj_consume_token(108);
            this.jj_consume_token(285);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 109: {
                this.jj_consume_token(109);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
            }
        }
        this.jj_la1[210] = this.jj_gen;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 346) {
            this.jj_consume_token(108);
            this.jj_consume_token(346);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 110: {
                this.jj_consume_token(110);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
            }
        }
        this.jj_la1[211] = this.jj_gen;
        if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 347) {
            this.jj_consume_token(108);
            this.jj_consume_token(347);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(2), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 111: {
                this.jj_consume_token(111);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(2), this.getContextManager());
            }
        }
        this.jj_la1[212] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode windowOrAggregateFunctionNode() throws ParseException, StandardException {
        QueryTreeNode queryTreeNode = null;
        switch (this.jj_nt.kind) {
            case 105: {
                ValueNode valueNode;
                this.jj_consume_token(105);
                this.jj_consume_token(446);
                switch (this.jj_nt.kind) {
                    case 448: {
                        this.jj_consume_token(448);
                        valueNode = (ValueNode)this.nodeFactory.getNode(115, null, CountAggregateDefinition.class, Boolean.FALSE, "COUNT(*)", this.getContextManager());
                        break;
                    }
                    default: {
                        this.jj_la1[213] = this.jj_gen;
                        if (this.jj_2_57(1)) {
                            valueNode = this.aggregateExpression("COUNT", CountAggregateDefinition.class);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(447);
                if (this.jj_2_58(1)) {
                    queryTreeNode = this.overClause();
                }
                if (queryTreeNode != null) {
                    valueNode = (ValueNode)this.nodeFactory.getNode(226, queryTreeNode, valueNode, this.getContextManager());
                }
                return valueNode;
            }
            case 77: 
            case 181: 
            case 182: 
            case 236: {
                ValueNode valueNode = this.generalAggregate();
                if (this.jj_2_59(1)) {
                    queryTreeNode = this.overClause();
                }
                if (queryTreeNode != null) {
                    valueNode = (ValueNode)this.nodeFactory.getNode(226, queryTreeNode, valueNode, this.getContextManager());
                }
                return valueNode;
            }
            case 369: {
                this.jj_consume_token(369);
                this.jj_consume_token(446);
                this.jj_consume_token(447);
                queryTreeNode = this.overClause();
                ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(227, null, queryTreeNode, this.getContextManager());
                return valueNode;
            }
        }
        this.jj_la1[214] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final QueryTreeNode overClause() throws ParseException, StandardException {
        OrderByList orderByList = null;
        if (this.getToken((int)2).kind != 446 && this.getToken((int)2).kind != 471) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(367);
        switch (this.jj_nt.kind) {
            case 446: {
                this.jj_consume_token(446);
                switch (this.jj_nt.kind) {
                    case 200: {
                        orderByList = this.orderByClause();
                        break;
                    }
                    default: {
                        this.jj_la1[215] = this.jj_gen;
                    }
                }
                this.jj_consume_token(447);
                return this.nodeFactory.getNode(228, null, orderByList, this.getContextManager());
            }
        }
        this.jj_la1[216] = this.jj_gen;
        if (this.jj_2_60(1)) {
            String string = this.identifier(128, true);
            return this.nodeFactory.getNode(229, string, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode aggregateExpression(String string, Class clazz) throws ParseException, StandardException {
        boolean bl = false;
        if (this.jj_2_61(1)) {
            bl = this.setQuantifier();
        }
        ValueNode valueNode = this.additiveExpression(null, 0);
        return (ValueNode)this.nodeFactory.getNode(115, valueNode, clazz, bl ? Boolean.TRUE : Boolean.FALSE, string, this.getContextManager());
    }

    public final ValueNode generalAggregate() throws ParseException, StandardException {
        Token token = this.builtInAggregateType();
        this.jj_consume_token(446);
        ValueNode valueNode = this.aggregateExpression(SQLParser.aggName(token), SQLParser.aggClass(token));
        this.jj_consume_token(447);
        return valueNode;
    }

    public final Token builtInAggregateType() throws ParseException, StandardException {
        Token token;
        switch (this.jj_nt.kind) {
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            case 182: {
                token = this.jj_consume_token(182);
                break;
            }
            case 236: {
                token = this.jj_consume_token(236);
                break;
            }
            default: {
                this.jj_la1[217] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final ValueNode castSpecification() throws ParseException, StandardException {
        int n = -1;
        this.jj_consume_token(87);
        this.jj_consume_token(446);
        ValueNode valueNode = this.castOperand();
        this.jj_consume_token(72);
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeCast();
        this.jj_consume_token(447);
        ValueNode valueNode2 = (ValueNode)this.nodeFactory.getNode(60, valueNode, dataTypeDescriptor, this.getContextManager());
        ((CastNode)valueNode2).setForExternallyGeneratedCASTnode();
        if (dataTypeDescriptor.getTypeId().userType()) {
            valueNode2 = (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(28, valueNode2, this.getContextManager()), this.getContextManager());
        }
        return valueNode2;
    }

    public final ValueNode nextValueExpression() throws ParseException, StandardException {
        this.jj_consume_token(188);
        this.jj_consume_token(258);
        this.jj_consume_token(144);
        TableName tableName = this.qualifiedName(128);
        this.checkVersion(180, "NEXT VALUE");
        ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(231, tableName, this.getContextManager());
        return valueNode;
    }

    public final int charOrVarchar() throws ParseException {
        switch (this.jj_nt.kind) {
            case 88: {
                this.jj_consume_token(88);
                return 1;
            }
            case 261: {
                this.jj_consume_token(261);
                return 12;
            }
        }
        this.jj_la1[218] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode castOperand() throws ParseException, StandardException {
        if (this.jj_2_62(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 191: {
                this.jj_consume_token(191);
                return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
            }
        }
        this.jj_la1[219] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
        this.jj_consume_token(464);
        return this.makeParameterNode();
    }

    public final ValueNode whereClause(Token token) throws ParseException, StandardException {
        ValueNode valueNode = this.valueExpression();
        Token token2 = this.getToken(0);
        valueNode.setBeginOffset(token.endOffset + 1);
        valueNode.setEndOffset(token2.endOffset);
        return valueNode;
    }

    public final GroupByList groupByClause() throws ParseException, StandardException {
        this.jj_consume_token(155);
        this.jj_consume_token(83);
        if (this.getToken((int)1).kind == 327 && this.getToken((int)2).kind == 446) {
            this.jj_consume_token(327);
            this.jj_consume_token(446);
            GroupByList groupByList = this.groupingColumnReferenceList();
            this.jj_consume_token(447);
            groupByList.setRollup();
            return groupByList;
        }
        if (this.jj_2_63(1)) {
            GroupByList groupByList = this.groupingColumnReferenceList();
            return groupByList;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final GroupByList groupingColumnReferenceList() throws ParseException, StandardException {
        GroupByList groupByList = (GroupByList)this.nodeFactory.getNode(3, this.getContextManager());
        this.groupingColumnReference(groupByList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[220] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.groupingColumnReference(groupByList);
        }
        return groupByList;
    }

    public final void groupingColumnReference(GroupByList groupByList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0);
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(AggregateNode.class);
        valueNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42Y26");
        }
        if (valueNode.isParameterNode()) {
            throw StandardException.newException("42X01", "?");
        }
        groupByList.addGroupByColumn((GroupByColumn)this.nodeFactory.getNode(35, valueNode, this.getContextManager()));
    }

    public final ValueNode havingClause() throws ParseException, StandardException {
        this.jj_consume_token(156);
        ValueNode valueNode = this.valueExpression();
        return valueNode;
    }

    public final WindowList windowClause() throws ParseException, StandardException {
        WindowList windowList = new WindowList();
        windowList.setContextManager(this.getContextManager());
        this.jj_consume_token(266);
        windowList = this.windowDefinition(windowList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[221] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            windowList = this.windowDefinition(windowList);
        }
        return windowList;
    }

    public final WindowList windowDefinition(WindowList windowList) throws ParseException, StandardException {
        OrderByList orderByList = null;
        String string = this.identifier(128, true);
        this.jj_consume_token(72);
        this.jj_consume_token(446);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[222] = this.jj_gen;
            }
        }
        this.jj_consume_token(447);
        windowList.addWindow((WindowDefinitionNode)this.nodeFactory.getNode(228, string, orderByList, this.getContextManager()));
        return windowList;
    }

    public final StatementNode schemaDefinition() throws ParseException, StandardException {
        String string = null;
        String string2 = null;
        this.jj_consume_token(222);
        if (this.jj_2_64(1)) {
            string = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 76: {
                    this.jj_consume_token(76);
                    string2 = this.identifier(128, true);
                    break;
                }
                default: {
                    this.jj_la1[223] = this.jj_gen;
                }
            }
            if (string2 != null) {
                this.checkVersion(140, "AUTHORIZATION");
            }
            if (string.startsWith("SYS")) {
                throw StandardException.newException("42939", string);
            }
            return (StatementNode)this.nodeFactory.getNode(134, string, string2, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 76: {
                this.jj_consume_token(76);
                string2 = this.identifier(128, true);
                this.checkVersion(140, "AUTHORIZATION");
                if (string2.startsWith("SYS")) {
                    throw StandardException.newException("42939", string2);
                }
                return (StatementNode)this.nodeFactory.getNode(134, string2, string2, this.getContextManager());
            }
        }
        this.jj_la1[224] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode roleDefinition() throws ParseException, StandardException {
        String string = null;
        this.jj_consume_token(368);
        string = this.identifier(128, true);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("CREATE ROLE");
        if (string.startsWith("SYS")) {
            throw StandardException.newException("4293A", string);
        }
        return (StatementNode)this.nodeFactory.getNode(211, string, this.getContextManager());
    }

    public final StatementNode sequenceDefinition() throws ParseException, StandardException {
        TableName tableName = null;
        DataTypeDescriptor dataTypeDescriptor = null;
        Long l = null;
        Long l2 = null;
        Long l3 = null;
        Long l4 = null;
        Boolean bl = Boolean.FALSE;
        Object[] objectArray = new Object[6];
        this.jj_consume_token(425);
        tableName = this.qualifiedName(128);
        while (this.jj_2_65(1)) {
            this.sequenceGeneratorOption(objectArray);
        }
        this.checkVersion(180, "SEQUENCES");
        if (objectArray[0] != null) {
            dataTypeDescriptor = (DataTypeDescriptor)objectArray[0];
        }
        if (objectArray[1] != null) {
            l = (Long)objectArray[1];
        }
        if (objectArray[2] != null) {
            l2 = (Long)objectArray[2];
        }
        if (objectArray[3] != null && !(objectArray[3] instanceof Boolean)) {
            l3 = (Long)objectArray[3];
        }
        if (objectArray[4] != null && !(objectArray[4] instanceof Boolean)) {
            l4 = (Long)objectArray[4];
        }
        if (objectArray[5] != null) {
            bl = (Boolean)objectArray[5];
        }
        return (StatementNode)this.nodeFactory.getNode(224, tableName, dataTypeDescriptor, l, l2, l3, l4, bl, this.getContextManager());
    }

    public final void sequenceGeneratorOption(Object[] objectArray) throws ParseException, StandardException {
        Serializable serializable = null;
        int n = -1;
        Boolean[] booleanArray = new Boolean[1];
        Object var5_5 = null;
        Token token = null;
        block0 : switch (this.jj_nt.kind) {
            case 72: {
                token = this.jj_consume_token(72);
                serializable = this.exactIntegerType();
                n = 0;
                break;
            }
            case 342: {
                token = this.jj_consume_token(342);
                this.jj_consume_token(267);
                serializable = this.exactIntegerObject();
                n = 1;
                break;
            }
            case 293: {
                token = this.jj_consume_token(293);
                this.jj_consume_token(83);
                serializable = this.exactIntegerObject();
                n = 2;
                break;
            }
            default: {
                this.jj_la1[227] = this.jj_gen;
                if (this.jj_2_66(1)) {
                    switch (this.jj_nt.kind) {
                        case 305: {
                            token = this.jj_consume_token(305);
                            serializable = this.exactIntegerObject();
                            break;
                        }
                        default: {
                            this.jj_la1[225] = this.jj_gen;
                            if (this.getToken((int)2).kind == 305) {
                                this.jj_consume_token(189);
                                token = this.jj_consume_token(305);
                                serializable = Boolean.FALSE;
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    n = 3;
                    break;
                }
                if (this.jj_2_67(1)) {
                    switch (this.jj_nt.kind) {
                        case 306: {
                            token = this.jj_consume_token(306);
                            serializable = this.exactIntegerObject();
                            break;
                        }
                        default: {
                            this.jj_la1[226] = this.jj_gen;
                            if (this.getToken((int)2).kind == 306) {
                                this.jj_consume_token(189);
                                token = this.jj_consume_token(306);
                                serializable = Boolean.FALSE;
                                break;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    n = 4;
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 189: 
                    case 283: {
                        token = this.cycleClause(booleanArray);
                        serializable = booleanArray[0];
                        n = 5;
                        break block0;
                    }
                }
                this.jj_la1[228] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                throw StandardException.newException("42XAJ", token.image);
            }
            objectArray[n] = serializable;
        }
    }

    public final Token cycleClause(Boolean[] booleanArray) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 283: {
                token = this.jj_consume_token(283);
                booleanArray[0] = Boolean.TRUE;
                return token;
            }
            case 189: {
                this.jj_consume_token(189);
                token = this.jj_consume_token(283);
                booleanArray[0] = Boolean.FALSE;
                return token;
            }
        }
        this.jj_la1[229] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Long exactIntegerObject() throws ParseException, StandardException {
        long l = this.exactNumber();
        return new Long(l);
    }

    public final Long stepValue() throws ParseException, StandardException {
        this.jj_consume_token(293);
        this.jj_consume_token(83);
        long l = this.exactNumber();
        return new Long(l);
    }

    public final StatementNode dropSequenceStatement() throws ParseException, StandardException {
        this.jj_consume_token(425);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(217);
        this.checkVersion(180, "SEQUENCES");
        return (StatementNode)this.nodeFactory.getNode(225, tableName, this.getContextManager());
    }

    public final StatementNode tableDefinition() throws ParseException, StandardException {
        char c = 'R';
        Properties properties = null;
        ResultColumnList resultColumnList = null;
        boolean bl = true;
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        if (this.getToken((int)1).kind == 446 && this.getToken((int)3).kind != 450 && this.getToken((int)3).kind != 447) {
            TableElementList tableElementList = this.tableElementList();
            switch (this.jj_nt.kind) {
                case 59: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(64);
                    break;
                }
                default: {
                    this.jj_la1[230] = this.jj_gen;
                }
            }
            return (StatementNode)this.nodeFactory.getNode(141, tableName, tableElementList, properties, new Character(c), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 72: 
            case 446: {
                switch (this.jj_nt.kind) {
                    case 446: {
                        this.jj_consume_token(446);
                        resultColumnList = this.tableColumnList();
                        this.jj_consume_token(447);
                        break;
                    }
                    default: {
                        this.jj_la1[231] = this.jj_gen;
                    }
                }
                this.jj_consume_token(72);
                ResultSetNode resultSetNode = this.queryExpression(null, 0);
                this.jj_consume_token(267);
                switch (this.jj_nt.kind) {
                    case 189: {
                        this.jj_consume_token(189);
                        bl = false;
                        break;
                    }
                    default: {
                        this.jj_la1[232] = this.jj_gen;
                    }
                }
                this.jj_consume_token(284);
                if (bl) {
                    throw StandardException.newException("0A000.S", "WITH DATA");
                }
                HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
                resultSetNode.accept(hasNodeVisitor);
                if (hasNodeVisitor.hasNode()) {
                    throw StandardException.newException("42X99");
                }
                return (StatementNode)this.nodeFactory.getNode(141, tableName, resultColumnList, resultSetNode, this.getContextManager());
            }
        }
        this.jj_la1[233] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList tableColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final Properties propertyList(boolean bl) throws ParseException, StandardException {
        FormatableProperties formatableProperties = new FormatableProperties();
        this.jj_consume_token(59);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getToken((int)1).image, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "=", true);
            if (stringTokenizer2.countTokens() != 3) {
                throw StandardException.newException("XCY04.S");
            }
            String string2 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.nextToken().equals("=")) {
                throw StandardException.newException("XCY04.S");
            }
            String string3 = stringTokenizer2.nextToken().trim();
            SQLParser.verifyImageLength(string3);
            if (formatableProperties.put(string2, string3 = string3.startsWith("'") && string3.endsWith("'") ? StringUtil.compressQuotes(string3.substring(1, string3.length() - 1), SINGLEQUOTES) : (string3.startsWith("\"") && string3.endsWith("\"") ? StringUtil.compressQuotes(string3.substring(1, string3.length() - 1), DOUBLEQUOTES) : string3.toUpperCase())) == null) continue;
            throw StandardException.newException("42Y49", string2);
        }
        if (!bl) {
            this.checkInternalFeature("DERBY-PROPERTIES");
        }
        return formatableProperties;
    }

    public final char DB2lockGranularityClause() throws ParseException, StandardException {
        this.jj_consume_token(303);
        char c = this.lockGranularity();
        return c;
    }

    public final char lockGranularity() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                return 'T';
            }
            case 328: {
                this.jj_consume_token(328);
                return 'R';
            }
        }
        this.jj_la1[234] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode indexDefinition() throws ParseException, StandardException {
        Boolean bl = Boolean.FALSE;
        Properties properties = null;
        Vector vector = new Vector();
        switch (this.jj_nt.kind) {
            case 252: {
                bl = this.unique();
                break;
            }
            default: {
                this.jj_la1[235] = this.jj_gen;
            }
        }
        this.jj_consume_token(393);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(195);
        TableName tableName2 = this.qualifiedName(128);
        this.jj_consume_token(446);
        this.indexColumnList(vector);
        this.jj_consume_token(447);
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[236] = this.jj_gen;
            }
        }
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(tableName2.getSchemaName());
        } else if (tableName2.getSchemaName() == null) {
            tableName2.setSchemaName(tableName.getSchemaName());
        } else if (!tableName.getSchemaName().equals(tableName2.getSchemaName())) {
            throw StandardException.newException("X0Y26.S", (Object)tableName, (Object)tableName2);
        }
        return (StatementNode)this.nodeFactory.getNode(146, bl, DEFAULT_INDEX_TYPE, tableName, tableName2, vector, properties, this.getContextManager());
    }

    public final Boolean unique() throws ParseException, StandardException {
        this.jj_consume_token(252);
        return Boolean.TRUE;
    }

    public final StatementNode procedureDefinition() throws ParseException, StandardException {
        Object[] objectArray = new Object[11];
        this.jj_consume_token(211);
        TableName tableName = this.qualifiedName(128);
        objectArray[0] = this.procedureParameterList();
        block3: while (true) {
            this.routineElement(true, false, objectArray);
            switch (this.jj_nt.kind) {
                case 139: 
                case 189: 
                case 190: 
                case 277: 
                case 282: 
                case 288: 
                case 289: 
                case 298: 
                case 308: 
                case 326: 
                case 410: 
                case 414: 
                case 419: 
                case 430: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[237] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, objectArray);
        return this.getCreateAliasNode(tableName, (String)objectArray[4], objectArray, 'P', Boolean.FALSE);
    }

    public final void routineElement(boolean bl, boolean bl2, Object[] objectArray) throws ParseException, StandardException {
        int n = -1;
        Object object = null;
        block0 : switch (this.jj_nt.kind) {
            case 430: {
                this.jj_consume_token(430);
                object = this.qualifiedName(128);
                n = 1;
                throw StandardException.newException("0A000.S", "SPECIFIC identifier");
            }
            case 289: 
            case 419: {
                switch (this.jj_nt.kind) {
                    case 289: {
                        this.jj_consume_token(289);
                        break;
                    }
                    default: {
                        this.jj_la1[238] = this.jj_gen;
                    }
                }
                this.jj_consume_token(419);
                this.jj_consume_token(427);
                int n2 = this.uint_value();
                if (!bl) {
                    throw StandardException.newException("42X01", "RESULT SETS");
                }
                object = ReuseFactory.getInteger(n2);
                n = 2;
                break;
            }
            case 298: {
                this.jj_consume_token(298);
                this.jj_consume_token(395);
                object = "JAVA";
                n = 3;
                break;
            }
            case 288: {
                this.jj_consume_token(288);
                object = Boolean.TRUE;
                n = 7;
                this.checkVersion(170, "DETERMINISTIC");
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(288);
                object = Boolean.FALSE;
                n = 7;
                this.checkVersion(170, "DETERMINISTIC");
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                switch (this.jj_nt.kind) {
                    case 313: {
                        this.jj_consume_token(313);
                        object = this.string();
                        n = 4;
                        break block0;
                    }
                    case 331: {
                        this.jj_consume_token(331);
                        this.checkVersion(190, "EXTERNAL SECURITY");
                        this.checkSqlStandardAccess("EXTERNAL SECURITY");
                        object = new Boolean(this.routineSecurityClause());
                        n = 10;
                        break block0;
                    }
                }
                this.jj_la1[239] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 410: {
                this.jj_consume_token(410);
                this.jj_consume_token(434);
                object = this.parameterStyle(bl2);
                n = 5;
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(231);
                object = ReuseFactory.getShort((short)3);
                n = 6;
                break;
            }
            case 282: {
                this.jj_consume_token(282);
                this.jj_consume_token(231);
                object = ReuseFactory.getShort((short)2);
                n = 6;
                break;
            }
            case 414: {
                this.jj_consume_token(414);
                this.jj_consume_token(231);
                this.jj_consume_token(284);
                object = ReuseFactory.getShort((short)1);
                n = 6;
                break;
            }
            case 308: {
                this.jj_consume_token(308);
                this.jj_consume_token(231);
                this.jj_consume_token(284);
                if (!bl) {
                    throw StandardException.newException("42X01", "MODIFIES SQL DATA");
                }
                object = ReuseFactory.getShort((short)0);
                n = 6;
                break;
            }
            case 277: 
            case 326: {
                object = this.calledOnNullInput(bl);
                n = 8;
                break;
            }
            default: {
                this.jj_la1[240] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (n != -1) {
            if (objectArray[n] != null) {
                String string = ROUTINE_CLAUSE_NAMES[n];
                throw StandardException.newException("42613", string);
            }
            objectArray[n] = object;
        }
    }

    public final Boolean calledOnNullInput(boolean bl) throws ParseException, StandardException {
        Boolean bl2;
        switch (this.jj_nt.kind) {
            case 277: {
                this.jj_consume_token(277);
                bl2 = Boolean.TRUE;
                break;
            }
            case 326: {
                this.jj_consume_token(326);
                this.jj_consume_token(191);
                if (bl) {
                    throw StandardException.newException("42X01", "RETURNS NULL ON NULL INPUT");
                }
                bl2 = Boolean.FALSE;
                break;
            }
            default: {
                this.jj_la1[241] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(195);
        this.jj_consume_token(191);
        this.jj_consume_token(164);
        return bl2;
    }

    public final boolean routineSecurityClause() throws ParseException, StandardException {
        boolean bl = false;
        switch (this.jj_nt.kind) {
            case 297: {
                this.jj_consume_token(297);
                bl = false;
                break;
            }
            case 287: {
                this.jj_consume_token(287);
                bl = true;
                break;
            }
            default: {
                this.jj_la1[242] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return bl;
    }

    public final Short parameterStyle(boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 395: {
                this.jj_consume_token(395);
                if (bl) {
                    throw StandardException.newException("42ZB2");
                }
                return ReuseFactory.getShort((short)0);
            }
            case 385: {
                this.jj_consume_token(385);
                if (!bl) {
                    throw StandardException.newException("42ZB1");
                }
                return ReuseFactory.getShort((short)1);
            }
        }
        this.jj_la1[243] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] procedureParameterList() throws ParseException, StandardException {
        Object[] objectArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        this.jj_consume_token(446);
        if (this.jj_2_68(1)) {
            this.procedureParameterDefinition((Vector[])objectArray);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 450: {
                        break;
                    }
                    default: {
                        this.jj_la1[244] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(450);
                this.procedureParameterDefinition((Vector[])objectArray);
            }
        }
        this.jj_consume_token(447);
        return objectArray;
    }

    public final void procedureParameterDefinition(Vector[] vectorArray) throws ParseException, StandardException {
        String string = "";
        Integer n = this.inoutParameter();
        if (this.dataTypeCheck(2)) {
            string = this.identifier(128, true);
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        vectorArray[0].addElement(string);
        vectorArray[1].addElement(dataTypeDescriptor.getCatalogType());
        vectorArray[2].addElement(n);
    }

    public final Integer inoutParameter() throws ParseException {
        int n = 1;
        block0 : switch (this.jj_nt.kind) {
            case 160: 
            case 295: 
            case 409: {
                switch (this.jj_nt.kind) {
                    case 160: {
                        this.jj_consume_token(160);
                        break block0;
                    }
                    case 409: {
                        this.jj_consume_token(409);
                        n = 4;
                        break block0;
                    }
                    case 295: {
                        this.jj_consume_token(295);
                        n = 2;
                        break block0;
                    }
                }
                this.jj_la1[245] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[246] = this.jj_gen;
            }
        }
        return ReuseFactory.getInteger(n);
    }

    public final StatementNode functionDefinition() throws ParseException, StandardException {
        Object[] objectArray = new Object[11];
        this.jj_consume_token(149);
        TableName tableName = this.qualifiedName(128);
        objectArray[0] = this.functionParameterList();
        this.jj_consume_token(326);
        TypeDescriptor typeDescriptor = this.functionReturnDataType();
        block3: while (true) {
            this.routineElement(false, typeDescriptor.isRowMultiSet(), objectArray);
            switch (this.jj_nt.kind) {
                case 139: 
                case 189: 
                case 190: 
                case 277: 
                case 282: 
                case 288: 
                case 289: 
                case 298: 
                case 308: 
                case 326: 
                case 410: 
                case 414: 
                case 419: 
                case 430: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[247] = this.jj_gen;
        objectArray[9] = typeDescriptor;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, objectArray);
        return this.getCreateAliasNode(tableName, (String)objectArray[4], objectArray, 'F', Boolean.FALSE);
    }

    public final Object[] functionParameterList() throws ParseException, StandardException {
        Object[] objectArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        this.jj_consume_token(446);
        if (this.jj_2_69(1)) {
            this.functionParameterDefinition((Vector[])objectArray);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 450: {
                        break;
                    }
                    default: {
                        this.jj_la1[248] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(450);
                this.functionParameterDefinition((Vector[])objectArray);
            }
        }
        this.jj_consume_token(447);
        return objectArray;
    }

    public final void functionParameterDefinition(Vector[] vectorArray) throws ParseException, StandardException {
        String string = "";
        if (this.dataTypeCheck(2)) {
            string = this.identifier(128, true);
        }
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        vectorArray[0].addElement(string);
        vectorArray[1].addElement(dataTypeDescriptor.getCatalogType());
        vectorArray[2].addElement(ReuseFactory.getInteger(1));
    }

    public final TypeDescriptor functionReturnDataType() throws ParseException, StandardException {
        TypeDescriptor typeDescriptor;
        if (this.jj_2_70(1)) {
            typeDescriptor = this.catalogType();
        } else {
            switch (this.jj_nt.kind) {
                case 239: {
                    typeDescriptor = this.functionTableType();
                    break;
                }
                default: {
                    this.jj_la1[249] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeDescriptor;
    }

    public final TypeDescriptor functionTableType() throws ParseException, StandardException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.jj_consume_token(239);
        this.jj_consume_token(446);
        this.functionTableReturnColumn(arrayList, arrayList2);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[250] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.functionTableReturnColumn(arrayList, arrayList2);
        }
        this.jj_consume_token(447);
        this.checkVersion(160, "CREATE FUNCTION...RETURNS TABLE");
        int n = arrayList.size();
        String[] stringArray = new String[n];
        arrayList.toArray(stringArray);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[n];
        arrayList2.toArray(typeDescriptorArray);
        for (int i = 0; i < n; ++i) {
            if (typeDescriptorArray[i].getJDBCTypeId() != 2009) continue;
            throw StandardException.newException("42ZB3");
        }
        return DataTypeDescriptor.getRowMultiSet(stringArray, typeDescriptorArray);
    }

    public final void functionTableReturnColumn(ArrayList arrayList, ArrayList arrayList2) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        DataTypeDescriptor dataTypeDescriptor = this.dataTypeDDL();
        arrayList.add(string);
        arrayList2.add(dataTypeDescriptor.getCatalogType());
    }

    public final StatementNode udtDefinition() throws ParseException, StandardException {
        this.jj_consume_token(351);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(139);
        this.jj_consume_token(313);
        String string = this.string();
        this.jj_consume_token(298);
        this.jj_consume_token(395);
        this.checkVersion(180, "CREATE TYPE");
        return this.getCreateAliasNode(tableName, string, null, 'A', Boolean.FALSE);
    }

    public final StatementNode viewDefinition(Token token) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        Object var6_3 = null;
        OrderByList orderByList = null;
        ValueNode valueNode = null;
        ValueNode valueNode2 = null;
        this.jj_consume_token(263);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 446: {
                this.jj_consume_token(446);
                resultColumnList = this.viewColumnList();
                this.jj_consume_token(447);
                break;
            }
            default: {
                this.jj_la1[251] = this.jj_gen;
            }
        }
        this.jj_consume_token(72);
        ResultSetNode resultSetNode = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 200: {
                orderByList = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[252] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 319: {
                valueNode = this.offsetClause();
                break;
            }
            default: {
                this.jj_la1[253] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 141: {
                valueNode2 = this.fetchFirstClause();
                break;
            }
            default: {
                this.jj_la1[254] = this.jj_gen;
            }
        }
        int n = 0;
        Token token2 = this.getToken(0);
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
        resultSetNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42X98");
        }
        return (StatementNode)this.nodeFactory.getNode(130, tableName, resultColumnList, resultSetNode, ReuseFactory.getInteger(n), StringUtil.slice(this.statementSQLText, token.beginOffset, token2.endOffset, false), orderByList, valueNode, valueNode2, this.getContextManager());
    }

    public final ResultColumnList viewColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final StatementNode triggerDefinition() throws ParseException, StandardException {
        Boolean bl = Boolean.FALSE;
        Token[] tokenArray = new Token[1];
        Object var7_3 = null;
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        Vector vector = null;
        this.jj_consume_token(435);
        TableName tableName = this.qualifiedName(128);
        Boolean bl2 = this.beforeOrAfter();
        int n = this.triggerEvent(resultColumnList);
        this.jj_consume_token(195);
        TableName tableName2 = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 416: {
                vector = this.triggerReferencingClause();
                break;
            }
            default: {
                this.jj_la1[255] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 144: {
                this.jj_consume_token(144);
                this.jj_consume_token(389);
                bl = this.rowOrStatement();
                break;
            }
            default: {
                this.jj_la1[256] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 401: {
                this.jj_consume_token(401);
                this.jj_consume_token(384);
                break;
            }
            default: {
                this.jj_la1[257] = this.jj_gen;
            }
        }
        StatementNode statementNode = this.proceduralStatement(tokenArray);
        int n2 = this.getToken((int)0).endOffset;
        int n3 = tokenArray[0].beginOffset;
        if (bl2.booleanValue() && statementNode instanceof DMLModStatementNode) {
            throw StandardException.newException("42Z9D", (Object)statementNode.statementToString(), (Object)"BEFORE");
        }
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(ParameterNode.class);
        statementNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42Y27");
        }
        return (StatementNode)this.nodeFactory.getNode(143, tableName, tableName2, ReuseFactory.getInteger(n), resultColumnList, bl2, bl, Boolean.TRUE, vector, null, null, ReuseFactory.getInteger(0), statementNode, StringUtil.slice(this.statementSQLText, n3, n2, false), ReuseFactory.getInteger(n3), this.getContextManager());
    }

    public final StatementNode synonymDefinition() throws ParseException, StandardException {
        this.jj_consume_token(344);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(144);
        TableName tableName2 = this.qualifiedName(128);
        this.checkVersion(130, "CREATE SYNONYM");
        return (StatementNode)this.getNodeFactory().getCreateAliasNode(tableName, tableName2, null, 'S', Boolean.FALSE, this.getContextManager());
    }

    public final Boolean beforeOrAfter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(84);
                this.jj_consume_token(378);
                return Boolean.TRUE;
            }
            case 377: {
                this.jj_consume_token(377);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[258] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int triggerEvent(ResultColumnList resultColumnList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 166: {
                this.jj_consume_token(166);
                return 4;
            }
            case 122: {
                this.jj_consume_token(122);
                return 2;
            }
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        this.columnNameList(resultColumnList);
                        break;
                    }
                    default: {
                        this.jj_la1[259] = this.jj_gen;
                    }
                }
                return 1;
            }
        }
        this.jj_la1[260] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Boolean rowOrStatement() throws ParseException {
        switch (this.jj_nt.kind) {
            case 328: {
                this.token = this.jj_consume_token(328);
                return Boolean.TRUE;
            }
            case 343: {
                this.token = this.jj_consume_token(343);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[261] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Vector triggerReferencingClause() throws ParseException, StandardException {
        Vector vector = new Vector();
        this.jj_consume_token(416);
        this.triggerReferencingExpression(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 402: 
                case 403: 
                case 407: 
                case 408: {
                    break;
                }
                default: {
                    this.jj_la1[262] = this.jj_gen;
                    break block3;
                }
            }
            this.triggerReferencingExpression(vector);
        }
        return vector;
    }

    public final void triggerReferencingExpression(Vector vector) throws ParseException, StandardException {
        boolean bl = true;
        boolean bl2 = true;
        block0 : switch (this.jj_nt.kind) {
            case 402: {
                this.jj_consume_token(402);
                switch (this.jj_nt.kind) {
                    case 239: 
                    case 328: {
                        switch (this.jj_nt.kind) {
                            case 328: {
                                this.jj_consume_token(328);
                                break block0;
                            }
                            case 239: {
                                this.jj_consume_token(239);
                                bl2 = false;
                                break block0;
                            }
                        }
                        this.jj_la1[263] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[264] = this.jj_gen;
                break;
            }
            case 407: {
                this.jj_consume_token(407);
                bl = false;
                switch (this.jj_nt.kind) {
                    case 239: 
                    case 328: {
                        switch (this.jj_nt.kind) {
                            case 328: {
                                this.jj_consume_token(328);
                                break block0;
                            }
                            case 239: {
                                this.jj_consume_token(239);
                                bl2 = false;
                                break block0;
                            }
                        }
                        this.jj_la1[265] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[266] = this.jj_gen;
                break;
            }
            case 403: {
                this.jj_consume_token(403);
                bl2 = false;
                break;
            }
            case 408: {
                this.jj_consume_token(408);
                bl = false;
                bl2 = false;
                break;
            }
            default: {
                this.jj_la1[267] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(72);
        String string = this.identifier(128, true);
        vector.addElement(new TriggerReferencingStruct(bl2, bl, string));
    }

    public final ValueNode defaultClause(long[] lArray, String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 119: 
            case 267: {
                switch (this.jj_nt.kind) {
                    case 267: {
                        this.jj_consume_token(267);
                        break;
                    }
                    default: {
                        this.jj_la1[268] = this.jj_gen;
                    }
                }
                Token token = this.jj_consume_token(119);
                ValueNode valueNode = this.defaultOption(token, lArray, string);
                return valueNode;
            }
            case 291: {
                ValueNode valueNode = this.generatedColumnOption(lArray);
                return valueNode;
            }
        }
        this.jj_la1[269] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
        this.jj_consume_token(119);
        this.jj_consume_token(191);
        return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
    }

    public final ValueNode generatedColumnOption(long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        lArray[0] = 1L;
        lArray[1] = 1L;
        lArray[2] = 1L;
        lArray[3] = 0L;
        this.jj_consume_token(291);
        switch (this.jj_nt.kind) {
            case 274: {
                valueNode = this.generatedAlways(lArray);
                return valueNode;
            }
            case 83: {
                valueNode = this.generatedByDefault(lArray);
                return valueNode;
            }
        }
        this.jj_la1[270] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generatedAlways(long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        this.jj_consume_token(274);
        if (this.getToken((int)1).kind == 72 && this.getToken((int)2).kind == 158) {
            this.asIdentity(lArray);
            return valueNode;
        }
        if (this.getToken((int)1).kind == 72 && this.getToken((int)2).kind == 446) {
            valueNode = this.generationClause();
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generatedByDefault(long[] lArray) throws ParseException, StandardException {
        ValueNode valueNode = null;
        this.jj_consume_token(83);
        this.jj_consume_token(119);
        this.asIdentity(lArray);
        this.checkVersion(130, "GENERATED BY DEFAULT");
        valueNode = (ValueNode)this.nodeFactory.getNode(100, this.getContextManager());
        return valueNode;
    }

    public final void asIdentity(long[] lArray) throws ParseException, StandardException {
        this.jj_consume_token(72);
        this.jj_consume_token(158);
        switch (this.jj_nt.kind) {
            case 446: {
                this.jj_consume_token(446);
                this.autoIncrementBeginEnd(lArray);
                this.jj_consume_token(447);
                break;
            }
            default: {
                this.jj_la1[271] = this.jj_gen;
            }
        }
    }

    public final ValueNode generationClause() throws ParseException, StandardException {
        ValueNode valueNode = null;
        Token token = null;
        Token token2 = null;
        this.jj_consume_token(72);
        token = this.jj_consume_token(446);
        valueNode = this.valueExpression();
        token2 = this.jj_consume_token(447);
        this.checkVersion(170, "GENERATED COLUMN");
        return (ValueNode)this.nodeFactory.getNode(222, valueNode, StringUtil.slice(this.statementSQLText, token.endOffset + 1, token2.beginOffset - 1, true), this.getContextManager());
    }

    public final void autoIncrementBeginEnd(long[] lArray) throws ParseException, StandardException {
        long l = 1L;
        long l2 = 1L;
        switch (this.jj_nt.kind) {
            case 293: {
                this.jj_consume_token(293);
                this.jj_consume_token(83);
                lArray[1] = l2 = this.exactNumber();
                lArray[3] = 0L;
                return;
            }
            case 342: {
                this.jj_consume_token(342);
                this.jj_consume_token(267);
                l = this.exactNumber();
                switch (this.jj_nt.kind) {
                    case 450: {
                        this.jj_consume_token(450);
                        this.jj_consume_token(293);
                        this.jj_consume_token(83);
                        l2 = this.exactNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[272] = this.jj_gen;
                    }
                }
                lArray[0] = l;
                lArray[1] = l2;
                lArray[3] = 0L;
                return;
            }
        }
        this.jj_la1[273] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultOption(Token token, long[] lArray, String string) throws ParseException, StandardException {
        Object var5_4 = null;
        Object var6_5 = null;
        if (this.getToken((int)1).kind == 191 && this.getToken((int)2).kind != 452 && this.getToken((int)2).kind != 455) {
            this.jj_consume_token(191);
            return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
        }
        if (this.jj_2_71(1)) {
            ValueNode valueNode = this.DB2DefaultOption(string);
            Token token2 = this.getToken(0);
            valueNode.setBeginOffset(token.beginOffset);
            valueNode.setEndOffset(token2.endOffset);
            valueNode = (ValueNode)this.nodeFactory.getNode(100, valueNode, StringUtil.slice(this.statementSQLText, token.beginOffset + 7, token2.endOffset, true), this.getContextManager());
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode DB2DefaultOption(String string) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 429) {
            this.jj_consume_token(108);
            switch (this.jj_nt.kind) {
                case 222: {
                    this.jj_consume_token(222);
                    break;
                }
                case 429: {
                    this.jj_consume_token(429);
                    break;
                }
                default: {
                    this.jj_la1[274] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return (ValueNode)this.nodeFactory.getNode(6, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 112: 
            case 226: 
            case 256: {
                ValueNode valueNode = this.userNode();
                return valueNode;
            }
            case 358: {
                ValueNode valueNode = this.currentRoleNode();
                return valueNode;
            }
        }
        this.jj_la1[275] = this.jj_gen;
        if (this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 346 || this.getToken((int)1).kind == 347) {
            ValueNode valueNode = this.miscBuiltins();
            return valueNode;
        }
        if (this.getToken((int)2).kind == 446 || this.getToken((int)4).kind == 446 && this.getToken((int)2).kind != 450) {
            ValueNode valueNode = this.miscBuiltins();
            throw StandardException.newException("42894", string);
        }
        if (this.jj_2_72(1)) {
            ValueNode valueNode = this.datetimeValueFunction();
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 140: 
            case 249: 
            case 444: 
            case 449: 
            case 451: 
            case 478: 
            case 481: 
            case 482: 
            case 483: {
                ValueNode valueNode = this.literal();
                return valueNode;
            }
        }
        this.jj_la1[276] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode literal() throws ParseException, StandardException {
        String string = "";
        switch (this.jj_nt.kind) {
            case 449: 
            case 451: 
            case 478: 
            case 483: {
                switch (this.jj_nt.kind) {
                    case 449: 
                    case 451: {
                        string = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[277] = this.jj_gen;
                    }
                }
                ValueNode valueNode = this.numericLiteral(string);
                return valueNode;
            }
            case 481: {
                CharConstantNode charConstantNode = this.stringLiteral();
                return charConstantNode;
            }
            case 482: {
                ValueNode valueNode = this.hexLiteral();
                return valueNode;
            }
            case 444: {
                ValueNode valueNode = this.dateTimeLiteral();
                return valueNode;
            }
            case 140: 
            case 249: {
                Token token = this.booleanLiteral();
                return (ValueNode)this.nodeFactory.getNode(38, StringUtil.SQLEqualsIgnoreCase(token.image, "true") ? Boolean.TRUE : Boolean.FALSE, this.getContextManager());
            }
        }
        this.jj_la1[278] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericConstantNode intLiteral() throws ParseException, StandardException {
        NumericConstantNode numericConstantNode;
        String string = null;
        switch (this.jj_nt.kind) {
            case 449: 
            case 451: {
                string = this.sign();
                break;
            }
            default: {
                this.jj_la1[279] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(478);
        String string2 = token.image;
        if (string != null && string.equals("-")) {
            string2 = string.concat(string2);
        }
        try {
            numericConstantNode = this.getNumericNode(string2, true);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42X20");
        }
        return numericConstantNode;
    }

    public final ValueNode numericLiteral(String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 478: {
                Token token = this.jj_consume_token(478);
                String string2 = token.image;
                if (string.equals("-")) {
                    string2 = string.concat(string2);
                }
                return this.getNumericNode(string2, false);
            }
            case 483: {
                Double d;
                Token token = this.jj_consume_token(483);
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(token.image);
                String string3 = stringBuffer.toString();
                int n = string3.indexOf(69);
                if (n == -1) {
                    n = string3.indexOf(101);
                }
                if (string3.length() > 30) {
                    throw StandardException.newException("42820", (Object)string3, (Object)"DOUBLE");
                }
                int n2 = string3.substring(0, n).indexOf(46);
                if (n2 == -1) {
                    stringBuffer.insert(n, '.');
                    string3 = stringBuffer.toString();
                    ++n;
                }
                try {
                    d = Double.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "DOUBLE");
                }
                double d2 = d;
                if (d2 == 0.0 && Double.parseDouble(string3.substring(0, n - 1)) != 0.0) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                return (ValueNode)this.nodeFactory.getNode(68, d, this.getContextManager());
            }
        }
        this.jj_la1[280] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeLiteral() throws ParseException, StandardException {
        this.jj_consume_token(444);
        ValueNode valueNode = this.escapedDateTimeLiteral();
        this.jj_consume_token(445);
        return valueNode;
    }

    public final ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 114: {
                this.jj_consume_token(114);
                ValueNode valueNode = this.bareDateLiteral();
                return valueNode;
            }
            case 238: {
                this.jj_consume_token(238);
                ValueNode valueNode = this.bareTimeLiteral();
                return valueNode;
            }
            case 250: {
                this.jj_consume_token(250);
                ValueNode valueNode = this.bareTimestampLiteral();
                return valueNode;
            }
        }
        this.jj_la1[281] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode bareDateLiteral() throws ParseException, StandardException {
        String string = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getDateValue(string, true), this.getContextManager());
    }

    public final ValueNode bareTimeLiteral() throws ParseException, StandardException {
        String string = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getTimeValue(string, true), this.getContextManager());
    }

    public final ValueNode bareTimestampLiteral() throws ParseException, StandardException {
        String string = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getTimestampValue(string, true), this.getContextManager());
    }

    public final String string() throws ParseException, StandardException {
        Token token = this.jj_consume_token(481);
        SQLParser.verifyImageLength(token.image);
        return StringUtil.compressQuotes(token.image.substring(1, token.image.length() - 1), SINGLEQUOTES);
    }

    public final CharConstantNode stringLiteral() throws ParseException, StandardException {
        Token token = this.jj_consume_token(481);
        if (token.image.length() - 2 > 32672) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(token.image));
        }
        String string = StringUtil.compressQuotes(token.image.substring(1, token.image.length() - 1), SINGLEQUOTES);
        return (CharConstantNode)this.nodeFactory.getNode(61, string, this.getContextManager());
    }

    public final ValueNode hexLiteral() throws ParseException, StandardException {
        Token token = this.jj_consume_token(482);
        String string = token.image;
        if (string.length() - 3 > 16336) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(string));
        }
        if ((string.length() - 3) % 2 == 1) {
            throw StandardException.newException("42606", StringUtil.formatForPrint(string));
        }
        int n = (string.length() - 3) / 2;
        return (ValueNode)this.nodeFactory.getNode(59, string.substring(2, string.length() - 1), ReuseFactory.getInteger(n), this.getContextManager());
    }

    public final TableName constraintNameDefinition() throws ParseException, StandardException {
        this.jj_consume_token(100);
        TableName tableName = this.qualifiedName(128);
        return tableName;
    }

    public final ConstraintDefinitionNode checkConstraintDefinition(TableName tableName, String string) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        this.jj_consume_token(91);
        Token token = this.jj_consume_token(446);
        ValueNode valueNode = this.valueExpression();
        Token token2 = this.jj_consume_token(447);
        if (string != null) {
            resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
            resultColumnList.addElement((ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager()));
        }
        valueNode.setBeginOffset(token.beginOffset);
        valueNode.setEndOffset(token2.endOffset);
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(4), resultColumnList, null, valueNode, StringUtil.slice(this.statementSQLText, token.beginOffset, token2.endOffset, true), this.getContextManager());
    }

    public final StatementNode spsRenameStatement() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(417);
        switch (this.jj_nt.kind) {
            case 239: {
                statementNode = this.renameTableStatement();
                break;
            }
            case 393: {
                statementNode = this.renameIndexStatement();
                break;
            }
            case 96: {
                statementNode = this.renameColumnStatement();
                break;
            }
            default: {
                this.jj_la1[282] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode renameTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(243);
        String string = this.identifier(128, true);
        return (StatementNode)this.nodeFactory.getNode(191, tableName, null, string, Boolean.FALSE, ReuseFactory.getInteger(1), this.getContextManager());
    }

    public final StatementNode renameIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(393);
        String string = this.identifier(128, true);
        this.jj_consume_token(243);
        String string2 = this.identifier(128, true);
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(191, null, string, string2, Boolean.FALSE, ReuseFactory.getInteger(3), this.getContextManager());
        return statementNode;
    }

    public final StatementNode renameColumnStatement() throws ParseException, StandardException {
        this.jj_consume_token(96);
        ColumnReference columnReference = this.columnReference();
        this.jj_consume_token(243);
        String string = this.identifier(128, true);
        if (columnReference.getTableNameNode() == null) {
            throw StandardException.newException("42Y55", (Object)"RENAME COLUMN", (Object)columnReference.getColumnName());
        }
        return (StatementNode)this.nodeFactory.getNode(191, columnReference.getTableNameNode(), columnReference.getColumnName(), string, Boolean.FALSE, ReuseFactory.getInteger(2), this.getContextManager());
    }

    public final StatementNode lockStatement() throws ParseException, StandardException {
        this.jj_consume_token(398);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(160);
        Boolean bl = this.lockMode();
        this.jj_consume_token(401);
        return (StatementNode)this.nodeFactory.getNode(112, tableName, bl, this.getContextManager());
    }

    public final Boolean lockMode() throws ParseException {
        switch (this.jj_nt.kind) {
            case 391: {
                this.jj_consume_token(391);
                return Boolean.TRUE;
            }
            case 428: {
                this.jj_consume_token(428);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[283] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode execStatement() throws ParseException, StandardException {
        this.jj_consume_token(137);
        this.jj_consume_token(343);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(118, tableName, this.getContextManager());
    }

    public final TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {
        this.setIsolationHeader();
        block0 : switch (this.jj_nt.kind) {
            case 243: 
            case 459: {
                switch (this.jj_nt.kind) {
                    case 459: {
                        this.jj_consume_token(459);
                        break block0;
                    }
                    case 243: {
                        this.jj_consume_token(243);
                        break block0;
                    }
                }
                this.jj_la1[284] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[285] = this.jj_gen;
            }
        }
        TransactionStatementNode transactionStatementNode = this.transactionMode();
        return transactionStatementNode;
    }

    public final void setIsolationHeader() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 172: {
                this.jj_consume_token(172);
                break;
            }
            default: {
                this.jj_la1[286] = this.jj_gen;
                if (this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 172) {
                    this.jj_consume_token(108);
                    this.jj_consume_token(172);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TransactionStatementNode transactionMode() throws ParseException, StandardException {
        int n = this.isolationLevelDB2OrReset();
        return (TransactionStatementNode)this.nodeFactory.getNode(21, ReuseFactory.getInteger(n), this.getContextManager());
    }

    public final int isolationLevelDB2OrReset() throws ParseException {
        switch (this.jj_nt.kind) {
            case 418: {
                this.jj_consume_token(418);
                return 0;
            }
        }
        this.jj_la1[287] = this.jj_gen;
        if (this.jj_2_73(1)) {
            int n = this.isolationLevelDB2();
            return n;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2() throws ParseException {
        switch (this.jj_nt.kind) {
            case 382: 
            case 422: 
            case 423: 
            case 438: {
                int n = this.isolationLevelDB2Abbrev();
                return n;
            }
            case 324: 
            case 332: {
                switch (this.jj_nt.kind) {
                    case 324: {
                        this.jj_consume_token(324);
                        this.jj_consume_token(213);
                        break;
                    }
                    case 332: {
                        this.jj_consume_token(332);
                        break;
                    }
                    default: {
                        this.jj_la1[288] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 4;
            }
            case 113: {
                this.jj_consume_token(113);
                this.jj_consume_token(432);
                return 2;
            }
            case 387: {
                this.jj_consume_token(387);
                this.jj_consume_token(213);
                return 1;
            }
        }
        this.jj_la1[289] = this.jj_gen;
        if (this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 280) {
            this.jj_consume_token(213);
            this.jj_consume_token(280);
            return 2;
        }
        if (this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 352) {
            this.jj_consume_token(213);
            this.jj_consume_token(352);
            return 1;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2Abbrev() throws ParseException {
        switch (this.jj_nt.kind) {
            case 422: {
                this.jj_consume_token(422);
                return 4;
            }
            case 423: {
                this.jj_consume_token(423);
                return 3;
            }
            case 382: {
                this.jj_consume_token(382);
                return 2;
            }
            case 438: {
                this.jj_consume_token(438);
                return 1;
            }
        }
        this.jj_la1[290] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevel() throws ParseException {
        this.jj_consume_token(172);
        this.jj_consume_token(301);
        int n = this.levelOfIsolation();
        return n;
    }

    public final int levelOfIsolation() throws ParseException {
        switch (this.jj_nt.kind) {
            case 213: {
                this.jj_consume_token(213);
                return this.levelOfIsolationRead();
            }
            case 324: {
                this.jj_consume_token(324);
                this.jj_consume_token(213);
                return 3;
            }
            case 332: {
                this.jj_consume_token(332);
                return 4;
            }
        }
        this.jj_la1[291] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int levelOfIsolationRead() throws ParseException {
        switch (this.jj_nt.kind) {
            case 352: {
                this.jj_consume_token(352);
                return 1;
            }
            case 280: {
                this.jj_consume_token(280);
                return 2;
            }
        }
        this.jj_la1[292] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode simpleValueSpecification() throws ParseException, StandardException {
        ValueNode valueNode = this.literal();
        return valueNode;
    }

    public final StatementNode setRoleStatement() throws ParseException, StandardException {
        this.jj_consume_token(368);
        StatementNode statementNode = this.setRoleSpecification();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(0);
            parameterNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return statementNode;
    }

    public final StatementNode setRoleSpecification() throws ParseException, StandardException {
        String string = null;
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("SET ROLE");
        switch (this.jj_nt.kind) {
            case 366: {
                this.jj_consume_token(366);
                return (StatementNode)this.nodeFactory.getNode(212, string, null, this.getContextManager());
            }
        }
        this.jj_la1[293] = this.jj_gen;
        if (this.jj_2_74(1)) {
            string = this.identifier(128, true);
            return (StatementNode)this.nodeFactory.getNode(212, string, null, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 464: {
                this.dynamicParameterSpecification();
                return (StatementNode)this.nodeFactory.getNode(212, null, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 481: {
                string = this.string();
                string = IdUtil.parseRoleId(string);
                return (StatementNode)this.nodeFactory.getNode(212, string, null, this.getContextManager());
            }
        }
        this.jj_la1[294] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setSchemaStatement() throws ParseException, StandardException {
        this.setSchemaHeader();
        switch (this.jj_nt.kind) {
            case 459: {
                this.jj_consume_token(459);
                break;
            }
            default: {
                this.jj_la1[295] = this.jj_gen;
            }
        }
        StatementNode statementNode = this.setSchemaValues();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode parameterNode = (ParameterNode)this.parameterList.elementAt(0);
            parameterNode.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return statementNode;
    }

    public final void setSchemaHeader() throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 222: {
                this.jj_consume_token(222);
                break;
            }
            default: {
                this.jj_la1[297] = this.jj_gen;
                if (this.getToken((int)1).kind == 108 && (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 429)) {
                    this.jj_consume_token(108);
                    switch (this.jj_nt.kind) {
                        case 222: {
                            this.jj_consume_token(222);
                            break block0;
                        }
                        case 429: {
                            this.jj_consume_token(429);
                            break block0;
                        }
                    }
                    this.jj_la1[296] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode setSchemaValues() throws ParseException, StandardException {
        if (this.jj_2_75(1)) {
            String string = this.identifier(128, true);
            return (StatementNode)this.nodeFactory.getNode(81, string, null, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 256: {
                this.jj_consume_token(256);
                return (StatementNode)this.nodeFactory.getNode(81, null, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 464: {
                this.dynamicParameterSpecification();
                return (StatementNode)this.nodeFactory.getNode(81, null, ReuseFactory.getInteger(2), this.getContextManager());
            }
            case 481: {
                String string = this.string();
                IdUtil.checkIdentifierLengthLimit(string, 128);
                return (StatementNode)this.nodeFactory.getNode(81, string, null, this.getContextManager());
            }
        }
        this.jj_la1[298] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setMessageLocaleStatement() throws ParseException, StandardException {
        this.jj_consume_token(399);
        String string = this.string();
        this.getContextManager().setMessageLocale(string);
        return (StatementNode)this.nodeFactory.getNode(19, this.getContextManager());
    }

    public final ValueNode valueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 140: 
            case 249: 
            case 444: 
            case 449: 
            case 451: 
            case 478: 
            case 481: 
            case 482: 
            case 483: {
                ValueNode valueNode = this.literal();
                return valueNode;
            }
            case 112: 
            case 226: 
            case 256: 
            case 358: 
            case 464: {
                ValueNode valueNode = this.generalValueSpecification();
                return valueNode;
            }
            case 192: {
                this.jj_consume_token(192);
                this.jj_consume_token(446);
                ValueNode valueNode = this.additiveExpression(null, 0);
                this.jj_consume_token(450);
                ValueNode valueNode2 = this.additiveExpression(null, 0);
                this.jj_consume_token(447);
                ContextManager contextManager = this.getContextManager();
                ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, contextManager);
                valueNodeList.addElement((ValueNode)this.nodeFactory.getNode(13, contextManager));
                valueNodeList.addElement(valueNode);
                return (ValueNode)this.nodeFactory.getNode(54, (ValueNode)this.nodeFactory.getNode(41, valueNode, valueNode2, contextManager), valueNodeList, Boolean.TRUE, contextManager);
            }
            case 86: {
                this.jj_consume_token(86);
                ValueNode valueNode = this.whenThenExpression();
                return valueNode;
            }
        }
        this.jj_la1[299] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode caseExpression() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 131: {
                this.jj_consume_token(131);
                ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(60, (ValueNode)this.nodeFactory.getNode(13, this.getContextManager()), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), this.getContextManager());
                ((CastNode)valueNode).setForExternallyGeneratedCASTnode();
                return valueNode;
            }
            case 130: {
                this.jj_consume_token(130);
                ValueNode valueNode = this.thenElseExpression();
                this.jj_consume_token(131);
                return valueNode;
            }
            case 354: {
                ValueNode valueNode = this.whenThenExpression();
                return valueNode;
            }
        }
        this.jj_la1[300] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode whenThenExpression() throws ParseException, StandardException {
        this.jj_consume_token(354);
        ValueNode valueNode = this.orExpression(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 199: {
                    break;
                }
                default: {
                    this.jj_la1[301] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(199);
            valueNode = this.orExpression(valueNode);
        }
        this.jj_consume_token(345);
        ValueNode valueNode2 = this.thenElseExpression();
        ValueNode valueNode3 = this.caseExpression();
        ContextManager contextManager = this.getContextManager();
        ValueNodeList valueNodeList = (ValueNodeList)this.nodeFactory.getNode(15, contextManager);
        valueNodeList.addElement(valueNode2);
        valueNodeList.addElement(valueNode3);
        return (ValueNode)this.nodeFactory.getNode(54, valueNode, valueNodeList, Boolean.FALSE, contextManager);
    }

    public final ValueNode thenElseExpression() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 191) {
            this.jj_consume_token(191);
            ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(60, (ValueNode)this.nodeFactory.getNode(13, this.getContextManager()), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), this.getContextManager());
            ((CastNode)valueNode).setForExternallyGeneratedCASTnode();
            return valueNode;
        }
        if (this.jj_2_76(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0);
            return valueNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode tableConstraintDefinition() throws ParseException, StandardException {
        Properties properties = null;
        TableName tableName = null;
        this.explicitNotNull = false;
        this.explicitNull = false;
        switch (this.jj_nt.kind) {
            case 100: {
                tableName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[302] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode constraintDefinitionNode = this.tableConstraint(tableName);
        switch (this.jj_nt.kind) {
            case 59: {
                properties = this.propertyList(false);
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[303] = this.jj_gen;
            }
        }
        if (properties != null) {
            constraintDefinitionNode.setProperties(properties);
        }
        return constraintDefinitionNode;
    }

    public final ConstraintDefinitionNode tableConstraint(TableName tableName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 208: 
            case 252: {
                ConstraintDefinitionNode constraintDefinitionNode = this.uniqueConstraintDefinition(tableName);
                return constraintDefinitionNode;
            }
            case 145: {
                ConstraintDefinitionNode constraintDefinitionNode = this.referentialConstraintDefinition(tableName);
                return constraintDefinitionNode;
            }
            case 91: {
                ConstraintDefinitionNode constraintDefinitionNode = this.checkConstraintDefinition(tableName, null);
                return constraintDefinitionNode;
            }
        }
        this.jj_la1[304] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConstraintDefinitionNode uniqueConstraintDefinition(TableName tableName) throws ParseException, StandardException {
        int n = this.uniqueSpecification(null);
        this.jj_consume_token(446);
        ResultColumnList resultColumnList = this.uniqueColumnList();
        this.jj_consume_token(447);
        if (n == 2) {
            for (int i = 0; i < resultColumnList.size(); ++i) {
                String string = ((ResultColumn)resultColumnList.elementAt(i)).getName();
                if (!this.explicitlyNullableColumnsList.contains(string)) continue;
                String string2 = this.checkVersion(160, null) ? "42831.S.1" : "42831";
                throw StandardException.newException(string2, string);
            }
        }
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(n), resultColumnList, null, null, null, this.getContextManager());
    }

    public final int uniqueSpecification(String string) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 252: {
                this.jj_consume_token(252);
                return 3;
            }
            case 208: {
                this.jj_consume_token(208);
                this.jj_consume_token(174);
                if (this.explicitNull) {
                    String string2 = this.checkVersion(160, null) ? "42831.S.1" : "42831";
                    throw StandardException.newException(string2, string);
                }
                return 2;
            }
        }
        this.jj_la1[305] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList uniqueColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumnList);
        return resultColumnList;
    }

    public final ConstraintDefinitionNode referentialConstraintDefinition(TableName tableName) throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        ResultColumnList resultColumnList2 = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        int[] nArray = new int[]{2, 2};
        this.jj_consume_token(145);
        this.jj_consume_token(174);
        this.jj_consume_token(446);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(447);
        TableName tableName2 = this.referencesSpecification(resultColumnList2, nArray);
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(119, tableName, tableName2, resultColumnList, resultColumnList2, nArray, this.getContextManager());
    }

    public final TableName referencesSpecification(ResultColumnList resultColumnList, int[] nArray) throws ParseException, StandardException {
        TableName tableName = null;
        this.jj_consume_token(215);
        tableName = this.referencedTableAndColumns(resultColumnList);
        switch (this.jj_nt.kind) {
            case 195: {
                this.jj_consume_token(195);
                this.referentialTriggeredAction(nArray);
                break;
            }
            default: {
                this.jj_la1[306] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final TableName referencedTableAndColumns(ResultColumnList resultColumnList) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 446: {
                this.jj_consume_token(446);
                this.columnNameList(resultColumnList);
                this.jj_consume_token(447);
                break;
            }
            default: {
                this.jj_la1[307] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final void referentialTriggeredAction(int[] nArray) throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 254: {
                nArray[1] = this.updateRule();
                switch (this.jj_nt.kind) {
                    case 195: {
                        this.jj_consume_token(195);
                        nArray[0] = this.deleteRule();
                        break block0;
                    }
                }
                this.jj_la1[308] = this.jj_gen;
                break;
            }
            case 122: {
                nArray[0] = this.deleteRule();
                switch (this.jj_nt.kind) {
                    case 195: {
                        this.jj_consume_token(195);
                        nArray[1] = this.updateRule();
                        break block0;
                    }
                }
                this.jj_la1[309] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[310] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int updateRule() throws ParseException {
        this.jj_consume_token(254);
        int n = this.updateReferentialAction();
        return n;
    }

    public final int deleteRule() throws ParseException {
        this.jj_consume_token(122);
        int n = this.deleteReferentialAction();
        return n;
    }

    public final int updateReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 217: {
                this.jj_consume_token(217);
                return 1;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(273);
                return 2;
            }
        }
        this.jj_la1[311] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int deleteReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 84: {
                this.jj_consume_token(84);
                return 0;
            }
            case 217: {
                this.jj_consume_token(217);
                return 1;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(273);
                return 2;
            }
            case 227: {
                this.jj_consume_token(227);
                switch (this.jj_nt.kind) {
                    case 191: {
                        this.jj_consume_token(191);
                        return 3;
                    }
                    case 119: {
                        this.jj_consume_token(119);
                        return 4;
                    }
                }
                this.jj_la1[312] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[313] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void columnConstraintDefinition(DataTypeDescriptor[] dataTypeDescriptorArray, TableElementList tableElementList, String string) throws ParseException, StandardException {
        TableName tableName = null;
        switch (this.jj_nt.kind) {
            case 100: {
                tableName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[314] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode constraintDefinitionNode = this.columnConstraint(tableName, dataTypeDescriptorArray, string);
        if (constraintDefinitionNode == null) {
            return;
        }
        tableElementList.addTableElement(constraintDefinitionNode);
    }

    public final ConstraintDefinitionNode columnConstraint(TableName tableName, DataTypeDescriptor[] dataTypeDescriptorArray, String string) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        int[] nArray = new int[]{2, 2};
        switch (this.jj_nt.kind) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(191);
                this.explicitNotNull = true;
                if (this.explicitNull) {
                    throw StandardException.newException("42X83", string);
                }
                if (dataTypeDescriptorArray[0] == null) {
                    throw StandardException.newException("42XAB");
                }
                dataTypeDescriptorArray[0] = dataTypeDescriptorArray[0].getNullabilityType(false);
                return null;
            }
            case 208: 
            case 252: {
                int n = this.uniqueSpecification(string);
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[315] = this.jj_gen;
                    }
                }
                ResultColumnList resultColumnList2 = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
                resultColumnList2.addElement((ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager()));
                return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(n), resultColumnList2, properties, null, null, this.getContextManager());
            }
            case 215: {
                TableName tableName2 = this.referencesSpecification(resultColumnList, nArray);
                switch (this.jj_nt.kind) {
                    case 59: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[316] = this.jj_gen;
                    }
                }
                ResultColumnList resultColumnList3 = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
                resultColumnList3.addElement((ResultColumn)this.nodeFactory.getNode(80, string, null, this.getContextManager()));
                ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)this.nodeFactory.getNode(119, tableName, tableName2, resultColumnList3, resultColumnList, nArray, this.getContextManager());
                if (properties != null) {
                    constraintDefinitionNode.setProperties(properties);
                }
                return constraintDefinitionNode;
            }
            case 91: {
                ConstraintDefinitionNode constraintDefinitionNode = this.checkConstraintDefinition(tableName, string);
                return constraintDefinitionNode;
            }
        }
        this.jj_la1[317] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropRoleStatement() throws ParseException, StandardException {
        this.jj_consume_token(368);
        String string = this.identifier(128, true);
        this.checkVersion(170, "ROLES");
        this.checkSqlStandardAccess("DROP ROLE");
        return (StatementNode)this.nodeFactory.getNode(214, string, this.getContextManager());
    }

    public final StatementNode dropSchemaStatement() throws ParseException, StandardException {
        this.jj_consume_token(222);
        String string = this.identifier(128, true);
        this.jj_consume_token(217);
        StatementNode statementNode = (StatementNode)this.nodeFactory.getNode(90, string, new Integer(1), this.getContextManager());
        return statementNode;
    }

    public final StatementNode alterTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        StatementNode statementNode = this.alterTableBody(tableName);
        return statementNode;
    }

    public final StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {
        char c = '\u0000';
        TableElementList tableElementList = (TableElementList)this.nodeFactory.getNode(12, this.getContextManager());
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (this.jj_nt.kind) {
            case 380: {
                StatementNode statementNode;
                this.jj_consume_token(380);
                switch (this.jj_nt.kind) {
                    case 394: {
                        statementNode = this.inplaceCompress(tableName);
                        break;
                    }
                    default: {
                        this.jj_la1[318] = this.jj_gen;
                        statementNode = this.sequentialCompress(tableName);
                    }
                }
                return statementNode;
            }
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(254);
                this.jj_consume_token(424);
                this.checkVersion(170, "SYSCS_UPDATE_STATISTICS");
                this.checkInternalFeature("UPDATE STATISTICS");
                return (StatementNode)this.nodeFactory.getNode(114, tableName, Boolean.TRUE, null, this.getContextManager());
            }
            case 254: {
                this.jj_consume_token(254);
                this.jj_consume_token(424);
                string = this.identifier(128, true);
                this.checkVersion(170, "SYSCS_UPDATE_STATISTICS");
                this.checkInternalFeature("UPDATE STATISTICS");
                return (StatementNode)this.nodeFactory.getNode(114, tableName, Boolean.FALSE, string, this.getContextManager());
            }
            case 65: 
            case 68: 
            case 129: 
            case 303: {
                c = this.alterTableAction(tableElementList, nArray, nArray2);
                return (StatementNode)this.nodeFactory.getNode(114, tableName, tableElementList, new Character(c), nArray, nArray2, this.getContextManager());
            }
        }
        this.jj_la1[319] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode inplaceCompress(TableName tableName) throws ParseException, StandardException {
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        this.jj_consume_token(394);
        switch (this.jj_nt.kind) {
            case 413: {
                token = this.jj_consume_token(413);
                break;
            }
            default: {
                this.jj_la1[320] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 386: {
                token2 = this.jj_consume_token(386);
                break;
            }
            default: {
                this.jj_la1[321] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 436: {
                token3 = this.jj_consume_token(436);
                break;
            }
            default: {
                this.jj_la1[322] = this.jj_gen;
            }
        }
        this.checkInternalFeature("COMPRESS");
        return (StatementNode)this.nodeFactory.getNode(114, tableName, new Boolean(token != null), new Boolean(token2 != null), new Boolean(token3 != null), this.getContextManager());
    }

    public final StatementNode sequentialCompress(TableName tableName) throws ParseException, StandardException {
        Token token = null;
        switch (this.jj_nt.kind) {
            case 426: {
                token = this.jj_consume_token(426);
                break;
            }
            default: {
                this.jj_la1[323] = this.jj_gen;
            }
        }
        this.checkInternalFeature("COMPRESS");
        return (StatementNode)this.nodeFactory.getNode(114, tableName, new Boolean(token != null), this.getContextManager());
    }

    public final char alterTableAction(TableElementList tableElementList, int[] nArray, int[] nArray2) throws ParseException, StandardException {
        char c = '\u0000';
        Object var7_5 = null;
        long[] lArray = new long[4];
        switch (this.jj_nt.kind) {
            case 65: {
                ColumnDefinitionNode columnDefinitionNode;
                TableElementNode tableElementNode;
                this.jj_consume_token(65);
                if (this.jj_2_77(1)) {
                    tableElementNode = this.addColumnDefinition(tableElementList);
                } else {
                    switch (this.jj_nt.kind) {
                        case 91: 
                        case 100: 
                        case 145: 
                        case 208: 
                        case 252: {
                            tableElementNode = this.tableConstraintDefinition();
                            break;
                        }
                        default: {
                            this.jj_la1[324] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (tableElementNode instanceof ColumnDefinitionNode && (columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).isAutoincrementColumn()) {
                    throw StandardException.newException("42601.S.372");
                }
                nArray[0] = 1;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
            case 68: {
                this.jj_consume_token(68);
                switch (this.jj_nt.kind) {
                    case 96: {
                        this.jj_consume_token(96);
                        break;
                    }
                    default: {
                        this.jj_la1[325] = this.jj_gen;
                    }
                }
                String string = this.identifier(128, true);
                TableElementNode tableElementNode = this.columnAlterClause(string);
                nArray[0] = 3;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
            case 129: {
                TableElementNode tableElementNode;
                this.jj_consume_token(129);
                if (this.jj_2_78(1)) {
                    tableElementNode = this.dropColumnDefinition(nArray2);
                } else if (this.jj_2_79(1)) {
                    tableElementNode = this.dropTableConstraintDefinition();
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                nArray[0] = 2;
                tableElementList.addTableElement(tableElementNode);
                return c;
            }
            case 303: {
                c = this.DB2lockGranularityClause();
                nArray[0] = 4;
                return c;
            }
        }
        this.jj_la1[326] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode dropColumnDefinition(int[] nArray) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[327] = this.jj_gen;
            }
        }
        String string = this.identifier(128, true);
        this.dropColumnReferentialAction(nArray);
        return (TableElementNode)this.nodeFactory.getNode(113, string, null, null, null, this.getContextManager());
    }

    public final void dropColumnReferentialAction(int[] nArray) throws ParseException {
        int n = 0;
        block0 : switch (this.jj_nt.kind) {
            case 84: 
            case 217: {
                switch (this.jj_nt.kind) {
                    case 84: {
                        this.jj_consume_token(84);
                        n = 0;
                        break block0;
                    }
                    case 217: {
                        this.jj_consume_token(217);
                        n = 1;
                        break block0;
                    }
                }
                this.jj_la1[328] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[329] = this.jj_gen;
            }
        }
        nArray[0] = n;
    }

    public final TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[330] = this.jj_gen;
            }
        }
        TableElementNode tableElementNode = this.columnDefinition(tableElementList);
        return tableElementNode;
    }

    public final TableElementNode columnAlterClause(String string) throws ParseException, StandardException {
        long[] lArray = new long[4];
        long l = 1L;
        long l2 = 1L;
        DataTypeDescriptor dataTypeDescriptor = null;
        if (this.getToken((int)2).kind == 284) {
            this.jj_consume_token(227);
            this.jj_consume_token(284);
            this.jj_consume_token(351);
            dataTypeDescriptor = this.dataTypeDDL();
            return (TableElementNode)this.nodeFactory.getNode(186, string, null, dataTypeDescriptor, null, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 293) {
            this.jj_consume_token(227);
            this.jj_consume_token(293);
            this.jj_consume_token(83);
            lArray[1] = l = this.exactNumber();
            lArray[3] = 2L;
            return (TableElementNode)this.nodeFactory.getNode(97, string, null, null, lArray, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 325: {
                this.jj_consume_token(325);
                this.jj_consume_token(267);
                lArray[0] = l2 = this.exactNumber();
                lArray[3] = 1L;
                return (TableElementNode)this.nodeFactory.getNode(97, string, null, null, lArray, this.getContextManager());
            }
        }
        this.jj_la1[332] = this.jj_gen;
        if (this.getToken((int)1).kind == 267 || this.getToken((int)1).kind == 119 || this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 119) {
            switch (this.jj_nt.kind) {
                case 227: {
                    this.jj_consume_token(227);
                    break;
                }
                default: {
                    this.jj_la1[331] = this.jj_gen;
                }
            }
            ValueNode valueNode = this.defaultClause(lArray, string);
            return this.wrapAlterColumnDefaultValue(valueNode, string, lArray);
        }
        switch (this.jj_nt.kind) {
            case 129: {
                this.jj_consume_token(129);
                this.jj_consume_token(119);
                ValueNode valueNode = (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
                return this.wrapAlterColumnDefaultValue(valueNode, string, lArray);
            }
        }
        this.jj_la1[333] = this.jj_gen;
        if (this.getToken((int)1).kind == 191) {
            this.jj_consume_token(191);
            return (TableElementNode)this.nodeFactory.getNode(187, string, null, null, null, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 190) {
            this.jj_consume_token(190);
            this.jj_consume_token(191);
            return (TableElementNode)this.nodeFactory.getNode(193, string, null, null, null, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 100) {
            this.jj_consume_token(100);
            TableName tableName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 208) {
            this.jj_consume_token(208);
            this.jj_consume_token(174);
            return (TableElementNode)this.nodeFactory.getNode(131, null, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 145) {
            this.jj_consume_token(145);
            this.jj_consume_token(174);
            TableName tableName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(6), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 252) {
            this.jj_consume_token(252);
            TableName tableName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(3), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 91: {
                this.jj_consume_token(91);
                TableName tableName = this.qualifiedName(128);
                return (TableElementNode)this.nodeFactory.getNode(131, tableName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(4), this.getContextManager());
            }
        }
        this.jj_la1[334] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(91, tableName, new Integer(2), this.getContextManager());
    }

    public final StatementNode dropIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(393);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(63, tableName, this.getContextManager());
    }

    public final StatementNode dropAliasStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 211: {
                this.jj_consume_token(211);
                TableName tableName = this.qualifiedName(128);
                return this.dropAliasNode(tableName, 'P');
            }
            case 149: {
                this.jj_consume_token(149);
                TableName tableName = this.qualifiedName(128);
                return this.dropAliasNode(tableName, 'F');
            }
            case 344: {
                this.jj_consume_token(344);
                TableName tableName = this.qualifiedName(128);
                this.checkVersion(130, "DROP SYNONYM");
                return this.dropAliasNode(tableName, 'S');
            }
            case 351: {
                this.jj_consume_token(351);
                TableName tableName = this.qualifiedName(128);
                this.jj_consume_token(217);
                this.checkVersion(180, "DROP TYPE");
                return this.dropAliasNode(tableName, 'A');
            }
        }
        this.jj_la1[335] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropViewStatement() throws ParseException, StandardException {
        this.jj_consume_token(263);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(92, tableName, this.getContextManager());
    }

    public final StatementNode dropTriggerStatement() throws ParseException, StandardException {
        this.jj_consume_token(435);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(65, tableName, this.getContextManager());
    }

    public final StatementNode truncateTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(350);
        this.jj_consume_token(239);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(114, tableName, this.getContextManager());
    }

    public final StatementNode grantStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            StatementNode statementNode;
            this.jj_consume_token(154);
            this.checkVersion(140, "GRANT");
            this.checkSqlStandardAccess("GRANT");
            switch (this.jj_nt.kind) {
                case 66: 
                case 122: 
                case 166: 
                case 215: 
                case 225: 
                case 254: 
                case 435: {
                    statementNode = this.tableGrantStatement();
                    break;
                }
                case 137: {
                    statementNode = this.routineGrantStatement();
                    break;
                }
                case 353: {
                    statementNode = this.usageGrantStatement();
                    break;
                }
                default: {
                    this.jj_la1[336] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 243) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            this.jj_consume_token(154);
            StatementNode statementNode = this.roleGrantStatement();
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableGrantStatement() throws ParseException, StandardException {
        PrivilegeNode privilegeNode = this.tablePrivileges();
        this.jj_consume_token(243);
        List list = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(89, privilegeNode, list, this.getContextManager());
    }

    public final PrivilegeNode tablePrivileges() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = null;
        TableName tableName = null;
        tablePrivilegesNode = this.tableActions();
        this.jj_consume_token(195);
        switch (this.jj_nt.kind) {
            case 239: {
                this.jj_consume_token(239);
                break;
            }
            default: {
                this.jj_la1[337] = this.jj_gen;
            }
        }
        tableName = this.qualifiedName(128);
        return (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(0), tableName, tablePrivilegesNode, this.getContextManager());
    }

    public final TablePrivilegesNode tableActions() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = (TablePrivilegesNode)this.nodeFactory.getNode(106, this.getContextManager());
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(210);
                tablePrivilegesNode.addAll();
                return tablePrivilegesNode;
            }
            case 122: 
            case 166: 
            case 215: 
            case 225: 
            case 254: 
            case 435: {
                this.tableAction(tablePrivilegesNode);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 450: {
                            break;
                        }
                        default: {
                            this.jj_la1[338] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(450);
                    this.tableAction(tablePrivilegesNode);
                }
                return tablePrivilegesNode;
            }
        }
        this.jj_la1[339] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode routineGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(137);
        this.jj_consume_token(195);
        RoutineDesignator routineDesignator = this.routineDesignator();
        this.jj_consume_token(243);
        List list = this.granteeList();
        PrivilegeNode privilegeNode = (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(1), routineDesignator, null, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(89, privilegeNode, list, this.getContextManager());
    }

    public final StatementNode usageGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(353);
        this.jj_consume_token(195);
        Integer n = this.usableObjects();
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(243);
        List list = this.granteeList();
        this.checkVersion(180, "GRANT USAGE");
        PrivilegeNode privilegeNode = (PrivilegeNode)this.nodeFactory.getNode(103, n, tableName, "USAGE", Boolean.FALSE, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(89, privilegeNode, list, this.getContextManager());
    }

    public final Integer usableObjects() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 425: {
                this.jj_consume_token(425);
                return ReuseFactory.getInteger(2);
            }
            case 351: {
                this.jj_consume_token(351);
                return ReuseFactory.getInteger(3);
            }
        }
        this.jj_la1[340] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final RoutineDesignator routineDesignator() throws ParseException, StandardException {
        Token token;
        List list = null;
        switch (this.jj_nt.kind) {
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 211: {
                token = this.jj_consume_token(211);
                break;
            }
            default: {
                this.jj_la1[341] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 446: {
                this.jj_consume_token(446);
                list = this.parameterTypeList();
                this.jj_consume_token(447);
                break;
            }
            default: {
                this.jj_la1[342] = this.jj_gen;
            }
        }
        return new RoutineDesignator(false, tableName, token.kind == 149, list);
    }

    public final List parameterTypeList() throws ParseException, StandardException {
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>();
        if (this.jj_2_80(1)) {
            TypeDescriptor typeDescriptor = this.catalogType();
            arrayList.add(typeDescriptor);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 450: {
                        break;
                    }
                    default: {
                        this.jj_la1[343] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(450);
                typeDescriptor = this.catalogType();
                arrayList.add(typeDescriptor);
            }
        }
        return arrayList;
    }

    public final void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {
        ResultColumnList resultColumnList = null;
        switch (this.jj_nt.kind) {
            case 225: {
                this.jj_consume_token(225);
                switch (this.jj_nt.kind) {
                    case 446: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[344] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(0, resultColumnList);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                tablePrivilegesNode.addAction(1, null);
                break;
            }
            case 166: {
                this.jj_consume_token(166);
                tablePrivilegesNode.addAction(2, null);
                break;
            }
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 446: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[345] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(3, resultColumnList);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                switch (this.jj_nt.kind) {
                    case 446: {
                        resultColumnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[346] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(4, resultColumnList);
                break;
            }
            case 435: {
                this.jj_consume_token(435);
                tablePrivilegesNode.addAction(5, null);
                break;
            }
            default: {
                this.jj_la1[347] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ResultColumnList privilegeColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.jj_consume_token(446);
        this.columnNameList(resultColumnList);
        this.jj_consume_token(447);
        return resultColumnList;
    }

    public final List granteeList() throws ParseException, StandardException {
        ArrayList arrayList = new ArrayList();
        this.grantee(arrayList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[348] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.grantee(arrayList);
        }
        return arrayList;
    }

    public final void grantee(List list) throws ParseException, StandardException {
        if (this.jj_2_81(1)) {
            String string = this.identifier(128, true);
            list.add(string);
        } else {
            switch (this.jj_nt.kind) {
                case 212: {
                    this.jj_consume_token(212);
                    list.add("PUBLIC");
                    break;
                }
                default: {
                    this.jj_la1[349] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final StatementNode roleGrantStatement() throws ParseException, StandardException {
        List list = this.roleList();
        this.jj_consume_token(243);
        List list2 = this.granteeList();
        this.checkSqlStandardAccess("GRANT <role>");
        this.checkVersion(170, "ROLES");
        return (StatementNode)this.nodeFactory.getNode(215, list, list2, this.getContextManager());
    }

    public final List roleList() throws ParseException, StandardException {
        ArrayList arrayList = new ArrayList();
        this.roleElement(arrayList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 450: {
                    break;
                }
                default: {
                    this.jj_la1[350] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(450);
            this.roleElement(arrayList);
        }
        return arrayList;
    }

    public final void roleElement(List list) throws ParseException, StandardException {
        String string = this.identifier(128, true);
        list.add(string);
    }

    public final StatementNode revokeStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            StatementNode statementNode;
            this.jj_consume_token(218);
            this.checkVersion(140, "REVOKE");
            this.checkSqlStandardAccess("REVOKE");
            switch (this.jj_nt.kind) {
                case 66: 
                case 122: 
                case 166: 
                case 215: 
                case 225: 
                case 254: 
                case 435: {
                    statementNode = this.tableRevokeStatement();
                    break;
                }
                case 137: {
                    statementNode = this.routineRevokeStatement();
                    break;
                }
                case 353: {
                    statementNode = this.usageRevokeStatement();
                    break;
                }
                default: {
                    this.jj_la1[351] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 147) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind))) {
            this.jj_consume_token(218);
            this.checkVersion(170, "ROLES");
            this.checkSqlStandardAccess("REVOKE <role>");
            StatementNode statementNode = this.roleRevokeStatement();
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableRevokeStatement() throws ParseException, StandardException {
        PrivilegeNode privilegeNode = null;
        privilegeNode = this.tablePrivileges();
        this.jj_consume_token(147);
        List list = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(86, privilegeNode, list, this.getContextManager());
    }

    public final StatementNode routineRevokeStatement() throws ParseException, StandardException {
        RoutineDesignator routineDesignator = null;
        this.jj_consume_token(137);
        this.jj_consume_token(195);
        routineDesignator = this.routineDesignator();
        this.jj_consume_token(147);
        List list = this.granteeList();
        this.jj_consume_token(217);
        PrivilegeNode privilegeNode = (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(1), routineDesignator, null, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(86, privilegeNode, list, this.getContextManager());
    }

    public final StatementNode usageRevokeStatement() throws ParseException, StandardException {
        this.jj_consume_token(353);
        this.jj_consume_token(195);
        Integer n = this.usableObjects();
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(147);
        List list = this.granteeList();
        this.jj_consume_token(217);
        this.checkVersion(180, "REVOKE USAGE");
        PrivilegeNode privilegeNode = (PrivilegeNode)this.nodeFactory.getNode(103, n, tableName, "USAGE", Boolean.TRUE, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(86, privilegeNode, list, this.getContextManager());
    }

    public final StatementNode roleRevokeStatement() throws ParseException, StandardException {
        List list = this.roleList();
        this.jj_consume_token(147);
        List list2 = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(216, list, list2, this.getContextManager());
    }

    public final String internalIdentifier(int n, boolean bl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 471: {
                Token token = this.jj_consume_token(471);
                String string = StringUtil.SQLToUpperCase(token.image);
                if (bl) {
                    IdUtil.checkIdentifierLengthLimit(string, n);
                }
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = Boolean.FALSE;
                this.nextToLastIdentifierToken = this.lastIdentifierToken;
                this.lastIdentifierToken = token;
                return string;
            }
            case 477: {
                String string = this.delimitedIdentifier();
                if (bl) {
                    IdUtil.checkIdentifierLengthLimit(string, n);
                }
                return string;
            }
        }
        this.jj_la1[352] = this.jj_gen;
        if (this.jj_2_82(1)) {
            String string = this.nonReservedKeyword();
            return StringUtil.SQLToUpperCase(string);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier(int n, boolean bl) throws ParseException, StandardException {
        String string = this.internalIdentifier(n, bl);
        return string;
    }

    public final String delimitedIdentifier() throws ParseException {
        Token token = this.jj_consume_token(477);
        String string = token.image.substring(1, token.image.length() - 1);
        string = SQLParser.normalizeDelimitedID(string);
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.TRUE;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = token;
        return string;
    }

    public final String reservedKeyword() throws ParseException {
        Token token;
        switch (this.jj_nt.kind) {
            case 65: {
                token = this.jj_consume_token(65);
                break;
            }
            case 66: {
                token = this.jj_consume_token(66);
                break;
            }
            case 67: {
                token = this.jj_consume_token(67);
                break;
            }
            case 68: {
                token = this.jj_consume_token(68);
                break;
            }
            case 69: {
                token = this.jj_consume_token(69);
                break;
            }
            case 70: {
                token = this.jj_consume_token(70);
                break;
            }
            case 71: {
                token = this.jj_consume_token(71);
                break;
            }
            case 72: {
                token = this.jj_consume_token(72);
                break;
            }
            case 73: {
                token = this.jj_consume_token(73);
                break;
            }
            case 74: {
                token = this.jj_consume_token(74);
                break;
            }
            case 75: {
                token = this.jj_consume_token(75);
                break;
            }
            case 76: {
                token = this.jj_consume_token(76);
                break;
            }
            case 77: {
                token = this.jj_consume_token(77);
                break;
            }
            case 78: {
                token = this.jj_consume_token(78);
                break;
            }
            case 79: {
                token = this.jj_consume_token(79);
                break;
            }
            case 81: {
                token = this.jj_consume_token(81);
                break;
            }
            case 82: {
                token = this.jj_consume_token(82);
                break;
            }
            case 83: {
                token = this.jj_consume_token(83);
                break;
            }
            case 84: {
                token = this.jj_consume_token(84);
                break;
            }
            case 85: {
                token = this.jj_consume_token(85);
                break;
            }
            case 86: {
                token = this.jj_consume_token(86);
                break;
            }
            case 87: {
                token = this.jj_consume_token(87);
                break;
            }
            case 88: {
                token = this.jj_consume_token(88);
                break;
            }
            case 89: {
                token = this.jj_consume_token(89);
                break;
            }
            case 91: {
                token = this.jj_consume_token(91);
                break;
            }
            case 92: {
                token = this.jj_consume_token(92);
                break;
            }
            case 94: {
                token = this.jj_consume_token(94);
                break;
            }
            case 95: {
                token = this.jj_consume_token(95);
                break;
            }
            case 96: {
                token = this.jj_consume_token(96);
                break;
            }
            case 97: {
                token = this.jj_consume_token(97);
                break;
            }
            case 98: {
                token = this.jj_consume_token(98);
                break;
            }
            case 99: {
                token = this.jj_consume_token(99);
                break;
            }
            case 100: {
                token = this.jj_consume_token(100);
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            case 102: {
                token = this.jj_consume_token(102);
                break;
            }
            case 103: {
                token = this.jj_consume_token(103);
                break;
            }
            case 104: {
                token = this.jj_consume_token(104);
                break;
            }
            case 106: {
                token = this.jj_consume_token(106);
                break;
            }
            case 107: {
                token = this.jj_consume_token(107);
                break;
            }
            case 108: {
                token = this.jj_consume_token(108);
                break;
            }
            case 109: {
                token = this.jj_consume_token(109);
                break;
            }
            case 110: {
                token = this.jj_consume_token(110);
                break;
            }
            case 111: {
                token = this.jj_consume_token(111);
                break;
            }
            case 112: {
                token = this.jj_consume_token(112);
                break;
            }
            case 113: {
                token = this.jj_consume_token(113);
                break;
            }
            case 115: {
                token = this.jj_consume_token(115);
                break;
            }
            case 116: {
                token = this.jj_consume_token(116);
                break;
            }
            case 117: {
                token = this.jj_consume_token(117);
                break;
            }
            case 118: {
                token = this.jj_consume_token(118);
                break;
            }
            case 119: {
                token = this.jj_consume_token(119);
                break;
            }
            case 120: {
                token = this.jj_consume_token(120);
                break;
            }
            case 121: {
                token = this.jj_consume_token(121);
                break;
            }
            case 122: {
                token = this.jj_consume_token(122);
                break;
            }
            case 123: {
                token = this.jj_consume_token(123);
                break;
            }
            case 124: {
                token = this.jj_consume_token(124);
                break;
            }
            case 125: {
                token = this.jj_consume_token(125);
                break;
            }
            case 126: {
                token = this.jj_consume_token(126);
                break;
            }
            case 127: {
                token = this.jj_consume_token(127);
                break;
            }
            case 128: {
                token = this.jj_consume_token(128);
                break;
            }
            case 129: {
                token = this.jj_consume_token(129);
                break;
            }
            case 130: {
                token = this.jj_consume_token(130);
                break;
            }
            case 131: {
                token = this.jj_consume_token(131);
                break;
            }
            case 132: {
                token = this.jj_consume_token(132);
                break;
            }
            case 133: {
                token = this.jj_consume_token(133);
                break;
            }
            case 134: {
                token = this.jj_consume_token(134);
                break;
            }
            case 135: {
                token = this.jj_consume_token(135);
                break;
            }
            case 136: {
                token = this.jj_consume_token(136);
                break;
            }
            case 137: {
                token = this.jj_consume_token(137);
                break;
            }
            case 138: {
                token = this.jj_consume_token(138);
                break;
            }
            case 139: {
                token = this.jj_consume_token(139);
                break;
            }
            case 140: {
                token = this.jj_consume_token(140);
                break;
            }
            case 141: {
                token = this.jj_consume_token(141);
                break;
            }
            case 142: {
                token = this.jj_consume_token(142);
                break;
            }
            case 143: {
                token = this.jj_consume_token(143);
                break;
            }
            case 144: {
                token = this.jj_consume_token(144);
                break;
            }
            case 145: {
                token = this.jj_consume_token(145);
                break;
            }
            case 146: {
                token = this.jj_consume_token(146);
                break;
            }
            case 147: {
                token = this.jj_consume_token(147);
                break;
            }
            case 148: {
                token = this.jj_consume_token(148);
                break;
            }
            case 149: {
                token = this.jj_consume_token(149);
                break;
            }
            case 150: {
                token = this.jj_consume_token(150);
                break;
            }
            case 361: {
                token = this.jj_consume_token(361);
                break;
            }
            case 151: {
                token = this.jj_consume_token(151);
                break;
            }
            case 152: {
                token = this.jj_consume_token(152);
                break;
            }
            case 153: {
                token = this.jj_consume_token(153);
                break;
            }
            case 154: {
                token = this.jj_consume_token(154);
                break;
            }
            case 155: {
                token = this.jj_consume_token(155);
                break;
            }
            case 156: {
                token = this.jj_consume_token(156);
                break;
            }
            case 157: {
                token = this.jj_consume_token(157);
                break;
            }
            case 158: {
                token = this.jj_consume_token(158);
                break;
            }
            case 159: {
                token = this.jj_consume_token(159);
                break;
            }
            case 160: {
                token = this.jj_consume_token(160);
                break;
            }
            case 161: {
                token = this.jj_consume_token(161);
                break;
            }
            case 162: {
                token = this.jj_consume_token(162);
                break;
            }
            case 163: {
                token = this.jj_consume_token(163);
                break;
            }
            case 295: {
                token = this.jj_consume_token(295);
                break;
            }
            case 164: {
                token = this.jj_consume_token(164);
                break;
            }
            case 165: {
                token = this.jj_consume_token(165);
                break;
            }
            case 166: {
                token = this.jj_consume_token(166);
                break;
            }
            case 167: {
                token = this.jj_consume_token(167);
                break;
            }
            case 168: {
                token = this.jj_consume_token(168);
                break;
            }
            case 169: {
                token = this.jj_consume_token(169);
                break;
            }
            case 170: {
                token = this.jj_consume_token(170);
                break;
            }
            case 171: {
                token = this.jj_consume_token(171);
                break;
            }
            case 172: {
                token = this.jj_consume_token(172);
                break;
            }
            case 173: {
                token = this.jj_consume_token(173);
                break;
            }
            case 174: {
                token = this.jj_consume_token(174);
                break;
            }
            case 175: {
                token = this.jj_consume_token(175);
                break;
            }
            case 176: {
                token = this.jj_consume_token(176);
                break;
            }
            case 177: {
                token = this.jj_consume_token(177);
                break;
            }
            case 178: {
                token = this.jj_consume_token(178);
                break;
            }
            case 179: {
                token = this.jj_consume_token(179);
                break;
            }
            case 180: {
                token = this.jj_consume_token(180);
                break;
            }
            case 181: {
                token = this.jj_consume_token(181);
                break;
            }
            case 182: {
                token = this.jj_consume_token(182);
                break;
            }
            case 183: {
                token = this.jj_consume_token(183);
                break;
            }
            case 185: {
                token = this.jj_consume_token(185);
                break;
            }
            case 186: {
                token = this.jj_consume_token(186);
                break;
            }
            case 187: {
                token = this.jj_consume_token(187);
                break;
            }
            case 404: {
                token = this.jj_consume_token(404);
                break;
            }
            case 188: {
                token = this.jj_consume_token(188);
                break;
            }
            case 189: {
                token = this.jj_consume_token(189);
                break;
            }
            case 366: {
                token = this.jj_consume_token(366);
                break;
            }
            case 190: {
                token = this.jj_consume_token(190);
                break;
            }
            case 191: {
                token = this.jj_consume_token(191);
                break;
            }
            case 192: {
                token = this.jj_consume_token(192);
                break;
            }
            case 193: {
                token = this.jj_consume_token(193);
                break;
            }
            case 194: {
                token = this.jj_consume_token(194);
                break;
            }
            case 195: {
                token = this.jj_consume_token(195);
                break;
            }
            case 196: {
                token = this.jj_consume_token(196);
                break;
            }
            case 197: {
                token = this.jj_consume_token(197);
                break;
            }
            case 198: {
                token = this.jj_consume_token(198);
                break;
            }
            case 199: {
                token = this.jj_consume_token(199);
                break;
            }
            case 200: {
                token = this.jj_consume_token(200);
                break;
            }
            case 409: {
                token = this.jj_consume_token(409);
                break;
            }
            case 201: {
                token = this.jj_consume_token(201);
                break;
            }
            case 202: {
                token = this.jj_consume_token(202);
                break;
            }
            case 203: {
                token = this.jj_consume_token(203);
                break;
            }
            case 204: {
                token = this.jj_consume_token(204);
                break;
            }
            case 205: {
                token = this.jj_consume_token(205);
                break;
            }
            case 206: {
                token = this.jj_consume_token(206);
                break;
            }
            case 207: {
                token = this.jj_consume_token(207);
                break;
            }
            case 208: {
                token = this.jj_consume_token(208);
                break;
            }
            case 209: {
                token = this.jj_consume_token(209);
                break;
            }
            case 210: {
                token = this.jj_consume_token(210);
                break;
            }
            case 211: {
                token = this.jj_consume_token(211);
                break;
            }
            case 212: {
                token = this.jj_consume_token(212);
                break;
            }
            case 213: {
                token = this.jj_consume_token(213);
                break;
            }
            case 214: {
                token = this.jj_consume_token(214);
                break;
            }
            case 215: {
                token = this.jj_consume_token(215);
                break;
            }
            case 216: {
                token = this.jj_consume_token(216);
                break;
            }
            case 217: {
                token = this.jj_consume_token(217);
                break;
            }
            case 218: {
                token = this.jj_consume_token(218);
                break;
            }
            case 219: {
                token = this.jj_consume_token(219);
                break;
            }
            case 220: {
                token = this.jj_consume_token(220);
                break;
            }
            case 221: {
                token = this.jj_consume_token(221);
                break;
            }
            case 222: {
                token = this.jj_consume_token(222);
                break;
            }
            case 223: {
                token = this.jj_consume_token(223);
                break;
            }
            case 224: {
                token = this.jj_consume_token(224);
                break;
            }
            case 225: {
                token = this.jj_consume_token(225);
                break;
            }
            case 226: {
                token = this.jj_consume_token(226);
                break;
            }
            case 227: {
                token = this.jj_consume_token(227);
                break;
            }
            case 228: {
                token = this.jj_consume_token(228);
                break;
            }
            case 229: {
                token = this.jj_consume_token(229);
                break;
            }
            case 230: {
                token = this.jj_consume_token(230);
                break;
            }
            case 231: {
                token = this.jj_consume_token(231);
                break;
            }
            case 232: {
                token = this.jj_consume_token(232);
                break;
            }
            case 233: {
                token = this.jj_consume_token(233);
                break;
            }
            case 234: {
                token = this.jj_consume_token(234);
                break;
            }
            case 235: {
                token = this.jj_consume_token(235);
                break;
            }
            case 236: {
                token = this.jj_consume_token(236);
                break;
            }
            case 237: {
                token = this.jj_consume_token(237);
                break;
            }
            case 239: {
                token = this.jj_consume_token(239);
                break;
            }
            case 240: {
                token = this.jj_consume_token(240);
                break;
            }
            case 241: {
                token = this.jj_consume_token(241);
                break;
            }
            case 242: {
                token = this.jj_consume_token(242);
                break;
            }
            case 243: {
                token = this.jj_consume_token(243);
                break;
            }
            case 247: {
                token = this.jj_consume_token(247);
                break;
            }
            case 244: {
                token = this.jj_consume_token(244);
                break;
            }
            case 245: {
                token = this.jj_consume_token(245);
                break;
            }
            case 246: {
                token = this.jj_consume_token(246);
                break;
            }
            case 249: {
                token = this.jj_consume_token(249);
                break;
            }
            case 251: {
                token = this.jj_consume_token(251);
                break;
            }
            case 252: {
                token = this.jj_consume_token(252);
                break;
            }
            case 253: {
                token = this.jj_consume_token(253);
                break;
            }
            case 254: {
                token = this.jj_consume_token(254);
                break;
            }
            case 255: {
                token = this.jj_consume_token(255);
                break;
            }
            case 256: {
                token = this.jj_consume_token(256);
                break;
            }
            case 257: {
                token = this.jj_consume_token(257);
                break;
            }
            case 259: {
                token = this.jj_consume_token(259);
                break;
            }
            case 261: {
                token = this.jj_consume_token(261);
                break;
            }
            case 262: {
                token = this.jj_consume_token(262);
                break;
            }
            case 263: {
                token = this.jj_consume_token(263);
                break;
            }
            case 264: {
                token = this.jj_consume_token(264);
                break;
            }
            case 265: {
                token = this.jj_consume_token(265);
                break;
            }
            case 267: {
                token = this.jj_consume_token(267);
                break;
            }
            case 268: {
                token = this.jj_consume_token(268);
                break;
            }
            case 269: {
                token = this.jj_consume_token(269);
                break;
            }
            case 270: {
                token = this.jj_consume_token(270);
                break;
            }
            case 355: {
                token = this.jj_consume_token(355);
                break;
            }
            case 356: {
                token = this.jj_consume_token(356);
                break;
            }
            case 358: {
                token = this.jj_consume_token(358);
                break;
            }
            case 362: {
                token = this.jj_consume_token(362);
                break;
            }
            case 363: {
                token = this.jj_consume_token(363);
                break;
            }
            case 365: {
                token = this.jj_consume_token(365);
                break;
            }
            case 370: {
                token = this.jj_consume_token(370);
                break;
            }
            case 248: {
                token = this.jj_consume_token(248);
                break;
            }
            case 371: {
                token = this.jj_consume_token(371);
                break;
            }
            case 372: {
                token = this.jj_consume_token(372);
                break;
            }
            case 374: {
                token = this.jj_consume_token(374);
                break;
            }
            case 376: {
                token = this.jj_consume_token(376);
                break;
            }
            case 373: {
                token = this.jj_consume_token(373);
                break;
            }
            case 375: {
                token = this.jj_consume_token(375);
                break;
            }
            default: {
                this.jj_la1[353] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.FALSE;
        return token.image;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token token;
        block0 : switch (this.jj_nt.kind) {
            case 271: {
                token = this.jj_consume_token(271);
                break;
            }
            case 272: {
                token = this.jj_consume_token(272);
                break;
            }
            case 273: {
                token = this.jj_consume_token(273);
                break;
            }
            case 377: {
                token = this.jj_consume_token(377);
                break;
            }
            case 274: {
                token = this.jj_consume_token(274);
                break;
            }
            case 378: {
                token = this.jj_consume_token(378);
                break;
            }
            case 80: {
                token = this.jj_consume_token(80);
                break;
            }
            case 275: {
                token = this.jj_consume_token(275);
                break;
            }
            case 276: {
                token = this.jj_consume_token(276);
                break;
            }
            case 277: {
                token = this.jj_consume_token(277);
                break;
            }
            case 379: {
                token = this.jj_consume_token(379);
                break;
            }
            case 278: {
                token = this.jj_consume_token(278);
                break;
            }
            case 93: {
                token = this.jj_consume_token(93);
                break;
            }
            case 279: {
                token = this.jj_consume_token(279);
                break;
            }
            case 280: {
                token = this.jj_consume_token(280);
                break;
            }
            case 380: {
                token = this.jj_consume_token(380);
                break;
            }
            case 281: {
                token = this.jj_consume_token(281);
                break;
            }
            case 282: {
                token = this.jj_consume_token(282);
                break;
            }
            case 381: {
                token = this.jj_consume_token(381);
                break;
            }
            case 105: {
                token = this.jj_consume_token(105);
                break;
            }
            case 382: {
                token = this.jj_consume_token(382);
                break;
            }
            case 357: {
                token = this.jj_consume_token(357);
                break;
            }
            case 359: {
                token = this.jj_consume_token(359);
                break;
            }
            case 283: {
                token = this.jj_consume_token(283);
                break;
            }
            case 114: {
                token = this.jj_consume_token(114);
                break;
            }
            case 284: {
                token = this.jj_consume_token(284);
                break;
            }
            case 285: {
                token = this.jj_consume_token(285);
                break;
            }
            case 286: {
                token = this.jj_consume_token(286);
                break;
            }
            case 386: {
                token = this.jj_consume_token(386);
                break;
            }
            case 387: {
                token = this.jj_consume_token(387);
                break;
            }
            case 289: {
                token = this.jj_consume_token(289);
                break;
            }
            case 360: {
                token = this.jj_consume_token(360);
                break;
            }
            case 384: {
                token = this.jj_consume_token(384);
                break;
            }
            case 385: {
                token = this.jj_consume_token(385);
                break;
            }
            case 388: {
                token = this.jj_consume_token(388);
                break;
            }
            case 389: {
                token = this.jj_consume_token(389);
                break;
            }
            case 390: {
                token = this.jj_consume_token(390);
                break;
            }
            case 391: {
                token = this.jj_consume_token(391);
                break;
            }
            case 392: {
                token = this.jj_consume_token(392);
                break;
            }
            case 290: {
                token = this.jj_consume_token(290);
                break;
            }
            case 291: {
                token = this.jj_consume_token(291);
                break;
            }
            case 292: {
                token = this.jj_consume_token(292);
                break;
            }
            case 293: {
                token = this.jj_consume_token(293);
                break;
            }
            case 393: {
                token = this.jj_consume_token(393);
                break;
            }
            case 294: {
                token = this.jj_consume_token(294);
                break;
            }
            case 394: {
                token = this.jj_consume_token(394);
                break;
            }
            case 296: {
                token = this.jj_consume_token(296);
                break;
            }
            case 395: {
                token = this.jj_consume_token(395);
                break;
            }
            case 298: {
                token = this.jj_consume_token(298);
                break;
            }
            case 299: {
                token = this.jj_consume_token(299);
                break;
            }
            case 396: {
                token = this.jj_consume_token(396);
                break;
            }
            case 300: {
                token = this.jj_consume_token(300);
                break;
            }
            case 301: {
                token = this.jj_consume_token(301);
                break;
            }
            case 397: {
                token = this.jj_consume_token(397);
                break;
            }
            case 398: {
                token = this.jj_consume_token(398);
                break;
            }
            case 302: {
                token = this.jj_consume_token(302);
                break;
            }
            case 303: {
                token = this.jj_consume_token(303);
                break;
            }
            case 304: {
                token = this.jj_consume_token(304);
                break;
            }
            case 364: {
                token = this.jj_consume_token(364);
                break;
            }
            case 305: {
                token = this.jj_consume_token(305);
                break;
            }
            case 306: {
                token = this.jj_consume_token(306);
                break;
            }
            case 399: {
                token = this.jj_consume_token(399);
                break;
            }
            case 400: {
                token = this.jj_consume_token(400);
                break;
            }
            case 307: {
                token = this.jj_consume_token(307);
                break;
            }
            case 401: {
                token = this.jj_consume_token(401);
                break;
            }
            case 308: {
                token = this.jj_consume_token(308);
                break;
            }
            case 309: {
                token = this.jj_consume_token(309);
                break;
            }
            case 184: {
                token = this.jj_consume_token(184);
                break;
            }
            case 310: {
                token = this.jj_consume_token(310);
                break;
            }
            case 311: {
                token = this.jj_consume_token(311);
                break;
            }
            case 312: {
                token = this.jj_consume_token(312);
                break;
            }
            case 313: {
                token = this.jj_consume_token(313);
                break;
            }
            case 314: {
                token = this.jj_consume_token(314);
                break;
            }
            case 402: {
                token = this.jj_consume_token(402);
                break;
            }
            case 403: {
                token = this.jj_consume_token(403);
                break;
            }
            case 315: {
                token = this.jj_consume_token(315);
                break;
            }
            case 316: {
                token = this.jj_consume_token(316);
                break;
            }
            case 317: {
                token = this.jj_consume_token(317);
                break;
            }
            case 318: {
                token = this.jj_consume_token(318);
                break;
            }
            case 406: {
                token = this.jj_consume_token(406);
                break;
            }
            default: {
                this.jj_la1[354] = this.jj_gen;
                if (this.getToken((int)1).kind == 319 && !this.seeingOffsetClause()) {
                    token = this.jj_consume_token(319);
                    break;
                }
                switch (this.jj_nt.kind) {
                    case 407: {
                        token = this.jj_consume_token(407);
                        break block0;
                    }
                    case 408: {
                        token = this.jj_consume_token(408);
                        break block0;
                    }
                    case 405: {
                        token = this.jj_consume_token(405);
                        break block0;
                    }
                    case 367: {
                        token = this.jj_consume_token(367);
                        break block0;
                    }
                    case 320: {
                        token = this.jj_consume_token(320);
                        break block0;
                    }
                    case 411: {
                        token = this.jj_consume_token(411);
                        break block0;
                    }
                    case 321: {
                        token = this.jj_consume_token(321);
                        break block0;
                    }
                    case 322: {
                        token = this.jj_consume_token(322);
                        break block0;
                    }
                    case 412: {
                        token = this.jj_consume_token(412);
                        break block0;
                    }
                    case 413: {
                        token = this.jj_consume_token(413);
                        break block0;
                    }
                    case 414: {
                        token = this.jj_consume_token(414);
                        break block0;
                    }
                    case 415: {
                        token = this.jj_consume_token(415);
                        break block0;
                    }
                    case 323: {
                        token = this.jj_consume_token(323);
                        break block0;
                    }
                    case 417: {
                        token = this.jj_consume_token(417);
                        break block0;
                    }
                    case 324: {
                        token = this.jj_consume_token(324);
                        break block0;
                    }
                    case 416: {
                        token = this.jj_consume_token(416);
                        break block0;
                    }
                    case 418: {
                        token = this.jj_consume_token(418);
                        break block0;
                    }
                    case 325: {
                        token = this.jj_consume_token(325);
                        break block0;
                    }
                    case 419: {
                        token = this.jj_consume_token(419);
                        break block0;
                    }
                    case 420: {
                        token = this.jj_consume_token(420);
                        break block0;
                    }
                    case 421: {
                        token = this.jj_consume_token(421);
                        break block0;
                    }
                    case 326: {
                        token = this.jj_consume_token(326);
                        break block0;
                    }
                    case 368: {
                        token = this.jj_consume_token(368);
                        break block0;
                    }
                    case 327: {
                        token = this.jj_consume_token(327);
                        break block0;
                    }
                    case 328: {
                        token = this.jj_consume_token(328);
                        break block0;
                    }
                    case 369: {
                        token = this.jj_consume_token(369);
                        break block0;
                    }
                    case 422: {
                        token = this.jj_consume_token(422);
                        break block0;
                    }
                    case 423: {
                        token = this.jj_consume_token(423);
                        break block0;
                    }
                    case 330: {
                        token = this.jj_consume_token(330);
                        break block0;
                    }
                    case 329: {
                        token = this.jj_consume_token(329);
                        break block0;
                    }
                    case 331: {
                        token = this.jj_consume_token(331);
                        break block0;
                    }
                    case 425: {
                        token = this.jj_consume_token(425);
                        break block0;
                    }
                    case 426: {
                        token = this.jj_consume_token(426);
                        break block0;
                    }
                    case 332: {
                        token = this.jj_consume_token(332);
                        break block0;
                    }
                    case 427: {
                        token = this.jj_consume_token(427);
                        break block0;
                    }
                    case 428: {
                        token = this.jj_consume_token(428);
                        break block0;
                    }
                    case 430: {
                        token = this.jj_consume_token(430);
                        break block0;
                    }
                    case 429: {
                        token = this.jj_consume_token(429);
                        break block0;
                    }
                    case 333: {
                        token = this.jj_consume_token(333);
                        break block0;
                    }
                    case 334: {
                        token = this.jj_consume_token(334);
                        break block0;
                    }
                    case 335: {
                        token = this.jj_consume_token(335);
                        break block0;
                    }
                    case 336: {
                        token = this.jj_consume_token(336);
                        break block0;
                    }
                    case 337: {
                        token = this.jj_consume_token(337);
                        break block0;
                    }
                    case 338: {
                        token = this.jj_consume_token(338);
                        break block0;
                    }
                    case 339: {
                        token = this.jj_consume_token(339);
                        break block0;
                    }
                    case 340: {
                        token = this.jj_consume_token(340);
                        break block0;
                    }
                    case 341: {
                        token = this.jj_consume_token(341);
                        break block0;
                    }
                    case 431: {
                        token = this.jj_consume_token(431);
                        break block0;
                    }
                    case 432: {
                        token = this.jj_consume_token(432);
                        break block0;
                    }
                    case 342: {
                        token = this.jj_consume_token(342);
                        break block0;
                    }
                    case 343: {
                        token = this.jj_consume_token(343);
                        break block0;
                    }
                    case 424: {
                        token = this.jj_consume_token(424);
                        break block0;
                    }
                    case 433: {
                        token = this.jj_consume_token(433);
                        break block0;
                    }
                    case 344: {
                        token = this.jj_consume_token(344);
                        break block0;
                    }
                    case 434: {
                        token = this.jj_consume_token(434);
                        break block0;
                    }
                    case 238: {
                        token = this.jj_consume_token(238);
                        break block0;
                    }
                    case 345: {
                        token = this.jj_consume_token(345);
                        break block0;
                    }
                    case 346: {
                        token = this.jj_consume_token(346);
                        break block0;
                    }
                    case 347: {
                        token = this.jj_consume_token(347);
                        break block0;
                    }
                    case 348: {
                        token = this.jj_consume_token(348);
                        break block0;
                    }
                    case 349: {
                        token = this.jj_consume_token(349);
                        break block0;
                    }
                    case 435: {
                        token = this.jj_consume_token(435);
                        break block0;
                    }
                    case 350: {
                        token = this.jj_consume_token(350);
                        break block0;
                    }
                    case 436: {
                        token = this.jj_consume_token(436);
                        break block0;
                    }
                    case 250: {
                        token = this.jj_consume_token(250);
                        break block0;
                    }
                    case 351: {
                        token = this.jj_consume_token(351);
                        break block0;
                    }
                    case 437: {
                        token = this.jj_consume_token(437);
                        break block0;
                    }
                    case 352: {
                        token = this.jj_consume_token(352);
                        break block0;
                    }
                    case 438: {
                        token = this.jj_consume_token(438);
                        break block0;
                    }
                    case 353: {
                        token = this.jj_consume_token(353);
                        break block0;
                    }
                    case 258: {
                        token = this.jj_consume_token(258);
                        break block0;
                    }
                    case 260: {
                        token = this.jj_consume_token(260);
                        break block0;
                    }
                    case 410: {
                        token = this.jj_consume_token(410);
                        break block0;
                    }
                    case 354: {
                        token = this.jj_consume_token(354);
                        break block0;
                    }
                    case 439: {
                        token = this.jj_consume_token(439);
                        break block0;
                    }
                }
                this.jj_la1[355] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.FALSE;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = token;
        return token.image;
    }

    public final String caseSensitiveIdentifierPlusReservedWords() throws ParseException {
        if (this.jj_2_83(1)) {
            String string = this.caseSensitiveIdentifier();
            return string;
        }
        switch (this.jj_nt.kind) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 295: 
            case 355: 
            case 356: 
            case 358: 
            case 361: 
            case 362: 
            case 363: 
            case 365: 
            case 366: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 404: 
            case 409: {
                String string = this.reservedKeyword();
                return string;
            }
        }
        this.jj_la1[356] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {
        if (this.jj_2_84(1)) {
            String string = this.identifier(128, true);
            return string;
        }
        switch (this.jj_nt.kind) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 259: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 295: 
            case 355: 
            case 356: 
            case 358: 
            case 361: 
            case 362: 
            case 363: 
            case 365: 
            case 366: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 404: 
            case 409: {
                String string = this.reservedKeyword();
                return StringUtil.SQLToUpperCase(string);
            }
        }
        this.jj_la1[357] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        switch (this.jj_nt.kind) {
            case 471: {
                Token token = this.jj_consume_token(471);
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = Boolean.FALSE;
                return token.image;
            }
            case 477: {
                String string = this.delimitedIdentifier();
                return string;
            }
        }
        this.jj_la1[358] = this.jj_gen;
        if (this.jj_2_85(1)) {
            String string = this.nonReservedKeyword();
            return string;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_53(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_54(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_55(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_56(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_57(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_58(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_59(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_60(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_61(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_62(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_63(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_64(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_65(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_66(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_67(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_68(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_69(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_70(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_71(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_72(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_73(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_74(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_75(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_76(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_77(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_78(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_79(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_80(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_81(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_82(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_83(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_84(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_85(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, n);
        }
    }

    private final boolean jj_3R_393() {
        return this.jj_scan_token(286);
    }

    private final boolean jj_3R_197() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_72() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_164() {
        return this.jj_3R_244();
    }

    private final boolean jj_3R_392() {
        return this.jj_scan_token(310);
    }

    private final boolean jj_3R_133() {
        return this.jj_scan_token(195);
    }

    private final boolean jj_3R_317() {
        return this.jj_scan_token(226);
    }

    private final boolean jj_3R_104() {
        if (this.jj_3R_196()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_197()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_62();
    }

    private final boolean jj_3R_132() {
        return this.jj_scan_token(195);
    }

    private final boolean jj_3R_163() {
        return this.jj_3R_243();
    }

    private final boolean jj_3R_391() {
        return this.jj_scan_token(270);
    }

    private final boolean jj_3R_386() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_391()) {
            this.jj_scanpos = token;
            if (this.jj_3R_392()) {
                this.jj_scanpos = token;
                if (this.jj_3R_393()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_394()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_395()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_131() {
        return this.jj_scan_token(190);
    }

    private final boolean jj_3R_150() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(190)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_236();
    }

    private final boolean jj_3R_316() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3R_250() {
        return this.jj_3R_309();
    }

    private final boolean jj_3_80() {
        return this.jj_3R_106();
    }

    private final boolean jj_3_68() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_120() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_60() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 97;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_132()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 195 && this.getToken((int)2).kind == 220;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_133()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_80() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_162()) {
            this.jj_scanpos = token;
            if (this.jj_3R_163()) {
                this.jj_scanpos = token;
                if (this.jj_3R_164()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_41()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_165()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_166()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_167()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_168()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_162() {
        return this.jj_scan_token(361);
    }

    private final boolean jj_3R_315() {
        return this.jj_scan_token(256);
    }

    private final boolean jj_3R_254() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_315()) {
            this.jj_scanpos = token;
            if (this.jj_3R_316()) {
                this.jj_scanpos = token;
                if (this.jj_3R_317()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_203() {
        return this.jj_3R_239();
    }

    private final boolean jj_3R_354() {
        return this.jj_3R_382();
    }

    private final boolean jj_3R_249() {
        return this.jj_scan_token(191);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_126();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_46();
    }

    private final boolean jj_3R_191() {
        return this.jj_3R_75();
    }

    private final boolean jj_3_2() {
        return this.jj_3R_45();
    }

    private final boolean jj_3R_369() {
        return this.jj_3R_255();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_125();
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_161();
    }

    private final boolean jj_3R_202() {
        return this.jj_3R_239();
    }

    private final boolean jj_3R_368() {
        return this.jj_3R_254();
    }

    private final boolean jj_3_15() {
        return this.jj_3R_60();
    }

    private final boolean jj_3R_77() {
        return this.jj_3R_150();
    }

    private final boolean jj_3R_201() {
        return this.jj_3R_255();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_382() {
        return this.jj_3R_161();
    }

    private final boolean jj_3R_367() {
        return this.jj_3R_384();
    }

    private final boolean jj_3R_342() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_367()) {
            this.jj_scanpos = token;
            if (this.jj_3R_368()) {
                this.jj_scanpos = token;
                if (this.jj_3R_369()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_124();
    }

    private final boolean jj_3R_98() {
        return this.jj_3R_191();
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_123();
    }

    private final boolean jj_3_40() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_122();
    }

    private final boolean jj_3_56() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_121();
    }

    private final boolean jj_3R_200() {
        return this.jj_3R_254();
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_120();
    }

    private final boolean jj_3_33() {
        return this.jj_3R_79();
    }

    private final boolean jj_3_39() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_123() {
        return this.jj_scan_token(118);
    }

    private final boolean jj_3_4() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = token;
            if (this.jj_3R_48()) {
                this.jj_scanpos = token;
                if (this.jj_3R_49()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_50()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_51()) {
                            this.jj_scanpos = token;
                            if (this.jj_3_1()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_52()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3_2()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3_3()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_53()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_49() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_107() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 429;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_199()) {
            this.jj_scanpos = token;
            if (this.jj_3R_200()) {
                this.jj_scanpos = token;
                if (this.jj_3R_201()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 346 || this.getToken((int)1).kind == 347;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_202()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)2).kind == 446 || this.getToken((int)4).kind == 446 && this.getToken((int)2).kind != 450;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_203()) {
                            this.jj_scanpos = token;
                            if (this.jj_3_72()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_204()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_199() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_378() {
        return this.jj_scan_token(140);
    }

    private final boolean jj_3R_81() {
        return this.jj_3R_77();
    }

    private final boolean jj_3_63() {
        return this.jj_3R_98();
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_95() {
        return this.jj_3R_189();
    }

    private final boolean jj_3R_377() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_351() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_377()) {
            this.jj_scanpos = token;
            if (this.jj_3R_378()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_94() {
        return this.jj_3R_188();
    }

    private final boolean jj_3_55() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.newInvocationFollows(1);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_94()) {
            this.jj_scanpos = token;
            if (this.jj_3R_95()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_187() {
        Token token = this.jj_scanpos;
        if (this.jj_3_55()) {
            this.jj_scanpos = token;
            if (this.jj_3_56()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 446 && (this.getToken((int)2).kind == 225 || this.getToken((int)2).kind == 259);
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_250()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_251()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_266() {
        return this.jj_3R_333();
    }

    private final boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3_27() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_81();
    }

    private final boolean jj_3_32() {
        return this.jj_3R_78();
    }

    private final boolean jj_3_14() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_71() {
        return this.jj_3R_107();
    }

    private final boolean jj_3R_129() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.javaClassFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_226()) {
            this.jj_scanpos = token;
            if (this.jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_226() {
        return this.jj_3R_266();
    }

    private final boolean jj_3R_93() {
        return this.jj_3R_187();
    }

    private final boolean jj_3R_384() {
        return this.jj_scan_token(464);
    }

    private final boolean jj_3R_73() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_326() {
        return this.jj_scan_token(438);
    }

    private final boolean jj_3R_284() {
        return this.jj_3R_80();
    }

    private final boolean jj_3R_239() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = (this.getToken((int)1).kind == 361 || this.getToken((int)1).kind == 271 || this.getToken((int)1).kind == 272 || this.getToken((int)1).kind == 431 || this.getToken((int)1).kind == 307 || this.getToken((int)1).kind == 93 || this.getToken((int)1).kind == 258 || this.getToken((int)1).kind == 292 || this.getToken((int)1).kind == 235 || this.getToken((int)1).kind == 371 || this.getToken((int)1).kind == 255 || this.getToken((int)1).kind == 179 || this.getToken((int)1).kind == 437 || this.getToken((int)1).kind == 396 || this.getToken((int)1).kind == 365 || this.getToken((int)1).kind == 370 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 285 || this.getToken((int)1).kind == 346 || this.getToken((int)1).kind == 347 || this.getToken((int)1).kind == 128 || this.getToken((int)1).kind == 88 || this.getToken((int)1).kind == 261 || this.getToken((int)1).kind == 168 || this.getToken((int)1).kind == 167 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 363 || this.getToken((int)1).kind == 270 || this.getToken((int)1).kind == 310 || this.getToken((int)1).kind == 286 || this.getToken((int)1).kind == 157 || this.getToken((int)1).kind == 183 || this.getToken((int)1).kind == 224 || this.getToken((int)1).kind == 300 || this.getToken((int)1).kind == 397 || this.getToken((int)1).kind == 374 || this.getToken((int)1).kind == 376 || this.getToken((int)1).kind == 373 || this.getToken((int)1).kind == 375) && this.getToken((int)2).kind == 446;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_284()) {
            this.jj_scanpos = token;
            if (this.jj_3_39()) {
                this.jj_scanpos = token;
                if (this.jj_3_40()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_325() {
        return this.jj_scan_token(382);
    }

    private final boolean jj_3R_337() {
        return this.jj_scan_token(372);
    }

    private final boolean jj_3R_324() {
        return this.jj_scan_token(423);
    }

    private final boolean jj_3R_303() {
        return this.jj_3R_345();
    }

    private final boolean jj_3R_182() {
        return this.jj_3R_249();
    }

    private final boolean jj_3R_323() {
        return this.jj_scan_token(422);
    }

    private final boolean jj_3R_302() {
        return this.jj_scan_token(347);
    }

    private final boolean jj_3R_89() {
        Token token = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = token;
            if (this.jj_3R_182()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_31() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_112() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(271)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(272)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(273)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(377)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(274)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(378)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(80)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(275)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(276)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(277)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(379)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(278)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(93)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(279)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(280)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(380)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(281)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(282)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(381)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(105)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(382)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(357)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(359)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(283)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(114)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(284)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(285)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(286)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(386)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(387)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(289)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(360)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(384)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(385)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(388)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(389)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(390)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(391)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(392)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(290)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(291)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(292)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(293)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(393)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(294)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(394)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(296)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(395)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(298)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(299)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(396)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(300)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(301)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(397)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(398)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(302)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(303)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(304)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(364)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(305)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(306)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(399)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(400)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(307)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(401)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(308)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(309)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(184)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(310)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(311)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(312)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(313)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(314)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(402)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(403)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(315)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(316)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(317)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(318)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(406)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        this.lookingAhead = true;
                                                                                                                                                                                                                                                                                                                                        this.jj_semLA = this.getToken((int)1).kind == 319 && !this.seeingOffsetClause();
                                                                                                                                                                                                                                                                                                                                        this.lookingAhead = false;
                                                                                                                                                                                                                                                                                                                                        if (!this.jj_semLA || this.jj_scan_token(319)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(407)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(408)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(405)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(367)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(320)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(411)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(321)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(322)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(412)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(413)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(414)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(415)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(323)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(417)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(324)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(416)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(418)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(325)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(419)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(420)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(421)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(326)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(368)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(327)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(328)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(369)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(422)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(423)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(330)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(329)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(331)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(425)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(426)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(332)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(427)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(428)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(430)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(429)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(333)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(334)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(335)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(336)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(337)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(338)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(339)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(340)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(341)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(431)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(432)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(342)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(343)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(424)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(433)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(344)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(434)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(238)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(345)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(346)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(347)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(348)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(349)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(435)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(350)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(436)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(250)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(351)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(437)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(352)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(438)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(353)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(258)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(260)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(410)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(354)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(439)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_210() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3_26() {
        return this.jj_3R_73();
    }

    private final boolean jj_3_62() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_332() {
        return this.jj_scan_token(323);
    }

    private final boolean jj_3R_301() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_257() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_323()) {
            this.jj_scanpos = token;
            if (this.jj_3R_324()) {
                this.jj_scanpos = token;
                if (this.jj_3R_325()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_326()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_209() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3_54() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3R_331() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3_37() {
        return this.jj_3R_81();
    }

    private final boolean jj_3R_160() {
        return this.jj_3R_241();
    }

    private final boolean jj_3R_159() {
        return this.jj_3R_240();
    }

    private final boolean jj_3R_305() {
        return this.jj_scan_token(261);
    }

    private final boolean jj_3R_208() {
        return this.jj_scan_token(387);
    }

    private final boolean jj_3R_330() {
        return this.jj_scan_token(329);
    }

    private final boolean jj_3R_300() {
        return this.jj_scan_token(346);
    }

    private final boolean jj_3R_246() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_300()) {
            this.jj_scanpos = token;
            if (this.jj_3R_301()) {
                this.jj_scanpos = token;
                if (this.jj_3R_302()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_303()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_265() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_330()) {
            this.jj_scanpos = token;
            if (this.jj_3R_331()) {
                this.jj_scanpos = token;
                if (this.jj_3R_332()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_258() {
        return this.jj_scan_token(324);
    }

    private final boolean jj_3R_207() {
        return this.jj_scan_token(113);
    }

    private final boolean jj_3R_304() {
        return this.jj_scan_token(88);
    }

    private final boolean jj_3R_247() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_304()) {
            this.jj_scanpos = token;
            if (this.jj_3R_305()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_206() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_258()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(332)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_147() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 452 && (this.getToken((int)3).kind == 448 || this.getToken((int)4).kind == 452 && this.getToken((int)5).kind == 448);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_232()) {
            this.jj_scanpos = token;
            if (this.jj_3_26()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_232() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_205() {
        return this.jj_3R_257();
    }

    private final boolean jj_3R_335() {
        return this.jj_scan_token(364);
    }

    private final boolean jj_3R_186() {
        return this.jj_scan_token(444);
    }

    private final boolean jj_3_73() {
        return this.jj_3R_108();
    }

    private final boolean jj_3R_108() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_205()) {
            this.jj_scanpos = token;
            if (this.jj_3R_206()) {
                this.jj_scanpos = token;
                if (this.jj_3R_207()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_208()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 280;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_209()) {
                            this.jj_scanpos = token;
                            this.lookingAhead = true;
                            this.jj_semLA = this.getToken((int)1).kind == 213 && this.getToken((int)2).kind == 352;
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_210()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_158() {
        return this.jj_scan_token(446);
    }

    private final boolean jj_3R_177() {
        return this.jj_3R_248();
    }

    private final boolean jj_3R_92() {
        Token token = this.jj_scanpos;
        if (this.jj_3_53()) {
            this.jj_scanpos = token;
            if (this.jj_3R_186()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_53() {
        return this.jj_3R_93();
    }

    private final boolean jj_3_38() {
        return this.jj_3R_82();
    }

    private final boolean jj_3_13() {
        return this.jj_3R_58();
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(128);
    }

    private final boolean jj_3R_72() {
        return this.jj_3R_147();
    }

    private final boolean jj_3R_241() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_70() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 322;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_144()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(128)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_86() {
        Token token = this.jj_scanpos;
        if (this.jj_3_46()) {
            this.jj_scanpos = token;
            if (this.jj_3R_177()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_46() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_157() {
        return this.jj_3R_239();
    }

    private final boolean jj_3_52() {
        return this.jj_3R_92();
    }

    private final boolean jj_3_23() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_340() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_275() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 452 && this.getToken((int)4).kind == 446;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_340()) {
            this.jj_scanpos = token;
            if (this.jj_3_13()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_25() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_156() {
        return this.jj_3R_238();
    }

    private final boolean jj_3R_143() {
        return this.jj_scan_token(214);
    }

    private final boolean jj_3R_155() {
        return this.jj_3R_188();
    }

    private final boolean jj_3_48() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_224() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_154() {
        return this.jj_3R_237();
    }

    private final boolean jj_3R_127() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(172)) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 172;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_224()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_117() {
        return this.jj_scan_token(154);
    }

    private final boolean jj_3R_240() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_153() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_127();
    }

    private final boolean jj_3R_235() {
        return this.jj_scan_token(452);
    }

    private final boolean jj_3R_152() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_181() {
        return this.jj_scan_token(421);
    }

    private final boolean jj_3R_146() {
        return this.jj_scan_token(66);
    }

    private final boolean jj_3R_184() {
        return this.jj_scan_token(316);
    }

    private final boolean jj_3R_78() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.escapedValueFunctionFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_151()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 429;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_152()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)2).kind == 172;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_153()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_154()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.newInvocationFollows(1);
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_155()) {
                            this.jj_scanpos = token;
                            this.lookingAhead = true;
                            this.jj_semLA = this.windowOrAggregateFunctionFollows();
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_156()) {
                                this.jj_scanpos = token;
                                this.lookingAhead = true;
                                this.jj_semLA = this.miscBuiltinFollows();
                                this.lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_157()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3_38()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_158()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_159()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_160()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_151() {
        return this.jj_scan_token(444);
    }

    private final boolean jj_3R_45() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_116()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 154 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 243) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_117()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(154);
    }

    private final boolean jj_3R_88() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 425;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_180()) {
            this.jj_scanpos = token;
            if (this.jj_3R_181()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_180() {
        return this.jj_scan_token(421);
    }

    private final boolean jj_3R_126() {
        return this.jj_scan_token(137);
    }

    private final boolean jj_3R_370() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(181)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(77)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(182)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(236)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_69() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_142()) {
            this.jj_scanpos = token;
            if (this.jj_3R_143()) {
                this.jj_scanpos = token;
                if (this.jj_3_23()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(143);
    }

    private final boolean jj_3R_90() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 175;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_183()) {
            this.jj_scanpos = token;
            if (this.jj_3R_184()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_183() {
        return this.jj_scan_token(316);
    }

    private final boolean jj_3R_381() {
        return this.jj_3R_384();
    }

    private final boolean jj_3R_71() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 127 && this.getToken((int)2).kind != 452 && this.getToken((int)2).kind != 455;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_145()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 66 && this.getToken((int)2).kind != 452 && this.getToken((int)2).kind != 455;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_146()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_145() {
        return this.jj_scan_token(127);
    }

    private final boolean jj_3R_390() {
        return this.jj_scan_token(365);
    }

    private final boolean jj_3R_308() {
        return this.jj_scan_token(363);
    }

    private final boolean jj_3_24() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_149() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind == 446;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_234()) {
            this.jj_scanpos = token;
            if (this.jj_3R_235()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_234() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(470)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(452)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_389() {
        return this.jj_scan_token(370);
    }

    private final boolean jj_3R_385() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_389()) {
            this.jj_scanpos = token;
            if (this.jj_3R_390()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_307() {
        return this.jj_scan_token(228);
    }

    private final boolean jj_3R_343() {
        return this.jj_3R_370();
    }

    private final boolean jj_3R_380() {
        return this.jj_scan_token(356);
    }

    private final boolean jj_3R_353() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_380()) {
            this.jj_scanpos = token;
            if (this.jj_3R_381()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_306() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(168)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(167)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_248() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_306()) {
            this.jj_scanpos = token;
            if (this.jj_3R_307()) {
                this.jj_scanpos = token;
                if (this.jj_3R_308()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_399() {
        return this.jj_scan_token(225);
    }

    private final boolean jj_3R_125() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_273() {
        return this.jj_3R_248();
    }

    private final boolean jj_3R_179() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_76() {
        return this.jj_3R_149();
    }

    private final boolean jj_3R_329() {
        return this.jj_scan_token(444);
    }

    private final boolean jj_3R_328() {
        return this.jj_3R_353();
    }

    private final boolean jj_3R_87() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 415;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_178()) {
            this.jj_scanpos = token;
            if (this.jj_3R_179()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_178() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3_61() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_96() {
        Token token = this.jj_scanpos;
        if (this.jj_3_61()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_75();
    }

    private final boolean jj_3R_398() {
        return this.jj_3R_400();
    }

    private final boolean jj_3_30() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_264() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_328()) {
            this.jj_scanpos = token;
            if (this.jj_3R_329()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_397() {
        return this.jj_3R_399();
    }

    private final boolean jj_3R_396() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_397()) {
            this.jj_scanpos = token;
            if (this.jj_3R_398()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_129();
    }

    private final boolean jj_3R_365() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_388() {
        return this.jj_scan_token(446);
    }

    private final boolean jj_3_35() {
        return this.jj_scan_token(147);
    }

    private final boolean jj_3_60() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_36() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_364() {
        return this.jj_scan_token(449);
    }

    private final boolean jj_3R_339() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_364()) {
            this.jj_scanpos = token;
            if (this.jj_3R_365()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_387() {
        return this.jj_3R_396();
    }

    private final boolean jj_3R_379() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_387()) {
            this.jj_scanpos = token;
            if (this.jj_3R_388()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_190() {
        return false;
    }

    private final boolean jj_3_11() {
        return this.jj_3R_56();
    }

    private final boolean jj_3_59() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_338() {
        return this.jj_scan_token(193);
    }

    private final boolean jj_3R_272() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_338()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(117)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(116)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_231() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_272()) {
            this.jj_scanpos = token;
            if (this.jj_3R_273()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_97() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 446 || this.getToken((int)2).kind == 471;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_190()) {
            return true;
        }
        return this.jj_scan_token(367);
    }

    private final boolean jj_3R_383() {
        return this.jj_scan_token(138);
    }

    private final boolean jj_3R_283() {
        return this.jj_scan_token(369);
    }

    private final boolean jj_3_45() {
        return this.jj_3R_87();
    }

    private final boolean jj_3_58() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_372() {
        return this.jj_scan_token(248);
    }

    private final boolean jj_3_22() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_371() {
        return this.jj_3R_385();
    }

    private final boolean jj_3R_344() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_371()) {
            this.jj_scanpos = token;
            if (this.jj_3R_372()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_12() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_68() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = token;
            if (this.jj_3_22()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_141() {
        return this.jj_3R_231();
    }

    private final boolean jj_3R_282() {
        return this.jj_3R_343();
    }

    private final boolean jj_3R_274() {
        return this.jj_3R_339();
    }

    private final boolean jj_3_57() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_363() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3R_362() {
        return this.jj_3R_230();
    }

    private final boolean jj_3R_233() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_274()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_275();
    }

    private final boolean jj_3R_361() {
        return this.jj_scan_token(80);
    }

    private final boolean jj_3R_281() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_238() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_281()) {
            this.jj_scanpos = token;
            if (this.jj_3R_282()) {
                this.jj_scanpos = token;
                if (this.jj_3R_283()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_360() {
        return this.jj_scan_token(314);
    }

    private final boolean jj_3R_295() {
        return this.jj_scan_token(397);
    }

    private final boolean jj_3R_294() {
        return this.jj_3R_344();
    }

    private final boolean jj_3R_359() {
        return this.jj_scan_token(278);
    }

    private final boolean jj_3R_285() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(65)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(66)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(67)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(68)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(69)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(70)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(71)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(72)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_scan_token(73)) {
                                            this.jj_scanpos = token;
                                            if (this.jj_scan_token(74)) {
                                                this.jj_scanpos = token;
                                                if (this.jj_scan_token(75)) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_scan_token(76)) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_scan_token(77)) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_scan_token(78)) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_scan_token(79)) {
                                                                    this.jj_scanpos = token;
                                                                    if (this.jj_scan_token(81)) {
                                                                        this.jj_scanpos = token;
                                                                        if (this.jj_scan_token(82)) {
                                                                            this.jj_scanpos = token;
                                                                            if (this.jj_scan_token(83)) {
                                                                                this.jj_scanpos = token;
                                                                                if (this.jj_scan_token(84)) {
                                                                                    this.jj_scanpos = token;
                                                                                    if (this.jj_scan_token(85)) {
                                                                                        this.jj_scanpos = token;
                                                                                        if (this.jj_scan_token(86)) {
                                                                                            this.jj_scanpos = token;
                                                                                            if (this.jj_scan_token(87)) {
                                                                                                this.jj_scanpos = token;
                                                                                                if (this.jj_scan_token(88)) {
                                                                                                    this.jj_scanpos = token;
                                                                                                    if (this.jj_scan_token(89)) {
                                                                                                        this.jj_scanpos = token;
                                                                                                        if (this.jj_scan_token(91)) {
                                                                                                            this.jj_scanpos = token;
                                                                                                            if (this.jj_scan_token(92)) {
                                                                                                                this.jj_scanpos = token;
                                                                                                                if (this.jj_scan_token(94)) {
                                                                                                                    this.jj_scanpos = token;
                                                                                                                    if (this.jj_scan_token(95)) {
                                                                                                                        this.jj_scanpos = token;
                                                                                                                        if (this.jj_scan_token(96)) {
                                                                                                                            this.jj_scanpos = token;
                                                                                                                            if (this.jj_scan_token(97)) {
                                                                                                                                this.jj_scanpos = token;
                                                                                                                                if (this.jj_scan_token(98)) {
                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                    if (this.jj_scan_token(99)) {
                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                        if (this.jj_scan_token(100)) {
                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                            if (this.jj_scan_token(101)) {
                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                if (this.jj_scan_token(102)) {
                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                    if (this.jj_scan_token(103)) {
                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                        if (this.jj_scan_token(104)) {
                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                if (this.jj_scan_token(107)) {
                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                    if (this.jj_scan_token(108)) {
                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                        if (this.jj_scan_token(109)) {
                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                            if (this.jj_scan_token(110)) {
                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                if (this.jj_scan_token(111)) {
                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                    if (this.jj_scan_token(112)) {
                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                        if (this.jj_scan_token(113)) {
                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                            if (this.jj_scan_token(115)) {
                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                if (this.jj_scan_token(116)) {
                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                    if (this.jj_scan_token(117)) {
                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                        if (this.jj_scan_token(118)) {
                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                            if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                    if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                        if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                            if (this.jj_scan_token(123)) {
                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                if (this.jj_scan_token(124)) {
                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                    if (this.jj_scan_token(125)) {
                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                        if (this.jj_scan_token(126)) {
                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                            if (this.jj_scan_token(127)) {
                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                if (this.jj_scan_token(128)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(129)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(130)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(133)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(134)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(137)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(138)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(141)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(142)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(146)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(147)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(150)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(361)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(151)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(154)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(155)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(159)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(160)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(161)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(162)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(163)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(295)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(164)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(165)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(166)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(167)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(168)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(169)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(170)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(171)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(172)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(173)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(174)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(175)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(176)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(177)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(178)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(179)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(180)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(183)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(185)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(186)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(187)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(404)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(188)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(189)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(366)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(190)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(191)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(192)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(194)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(195)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(196)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(197)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(199)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(200)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(409)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(201)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(202)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(203)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(204)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(205)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(206)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(207)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(208)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(209)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(210)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(211)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(212)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(213)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(214)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(215)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(216)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(217)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(218)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(219)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(220)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(221)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(222)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(223)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(224)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(225)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(226)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(227)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(228)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(229)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(230)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(231)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(232)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(233)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(234)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(235)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(236)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(237)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(239)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(240)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(241)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(242)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(243)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(247)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(244)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(245)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(246)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(249)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(251)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(252)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(253)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(254)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(255)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(256)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(257)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(259)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(261)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(262)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(263)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(264)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(265)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(267)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(268)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(269)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(270)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(355)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(356)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(358)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(362)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(363)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(365)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(370)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(248)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(371)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(372)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(374)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(376)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(373)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = token;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(375)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_358() {
        return this.jj_scan_token(275);
    }

    private final boolean jj_3R_293() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(437)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(396)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_174() {
        return this.jj_scan_token(111);
    }

    private final boolean jj_3R_336() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_358()) {
            this.jj_scanpos = token;
            if (this.jj_3R_359()) {
                this.jj_scanpos = token;
                if (this.jj_3R_360()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_361()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_362()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_363()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_215() {
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_292() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(255)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(179)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_291() {
        return this.jj_scan_token(371);
    }

    private final boolean jj_3R_263() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3R_244() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_291()) {
            this.jj_scanpos = token;
            if (this.jj_3R_292()) {
                this.jj_scanpos = token;
                if (this.jj_3R_293()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_294()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_295()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_173() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_172() {
        return this.jj_scan_token(110);
    }

    private final boolean jj_3R_214() {
        return this.jj_scan_token(252);
    }

    private final boolean jj_3R_259() {
        return this.jj_scan_token(477);
    }

    private final boolean jj_3R_352() {
        return this.jj_3R_379();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_140() {
        return this.jj_scan_token(404);
    }

    private final boolean jj_3R_171() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3R_374() {
        return this.jj_scan_token(224);
    }

    private final boolean jj_3_43() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_373() {
        return this.jj_3R_386();
    }

    private final boolean jj_3R_345() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_373()) {
            this.jj_scanpos = token;
            if (this.jj_3R_374()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_170() {
        return this.jj_scan_token(109);
    }

    private final boolean jj_3R_213() {
        return this.jj_scan_token(145);
    }

    private final boolean jj_3R_148() {
        return this.jj_3R_233();
    }

    private final boolean jj_3R_185() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_139() {
        return this.jj_scan_token(187);
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_130();
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_83() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 285;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_169()) {
            this.jj_scanpos = token;
            if (this.jj_3R_170()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 346;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_171()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_172()) {
                        this.jj_scanpos = token;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 108 && this.getToken((int)2).kind == 347;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_173()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_174()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_169() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3_82() {
        return this.jj_3R_112();
    }

    private final boolean jj_3R_212() {
        return this.jj_scan_token(208);
    }

    private final boolean jj_3R_138() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3_44() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_91() {
        return this.jj_3R_185();
    }

    private final boolean jj_3R_228() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_349() {
        return this.jj_scan_token(482);
    }

    private final boolean jj_3R_262() {
        return this.jj_scan_token(166);
    }

    private final boolean jj_3R_67() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_138()) {
            this.jj_scanpos = token;
            if (this.jj_3R_139()) {
                this.jj_scanpos = token;
                if (this.jj_3R_140()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_51() {
        return this.jj_3R_91();
    }

    private final boolean jj_3R_111() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 100;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_211()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 208;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_212()) {
                this.jj_scanpos = token;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 145;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_213()) {
                    this.jj_scanpos = token;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 252;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_214()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_215()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_211() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_130() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_227()) {
            this.jj_scanpos = token;
            if (this.jj_3R_228()) {
                this.jj_scanpos = token;
                if (this.jj_3_82()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_227() {
        return this.jj_scan_token(471);
    }

    private final boolean jj_3R_327() {
        return this.jj_3R_352();
    }

    private final boolean jj_3R_348() {
        return this.jj_scan_token(481);
    }

    private final boolean jj_3R_400() {
        return this.jj_scan_token(259);
    }

    private final boolean jj_3R_230() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(88)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(89)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_261() {
        return this.jj_3R_327();
    }

    private final boolean jj_3R_75() {
        return this.jj_3R_148();
    }

    private final boolean jj_3_76() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_290() {
        return this.jj_scan_token(292);
    }

    private final boolean jj_3R_289() {
        return this.jj_scan_token(307);
    }

    private final boolean jj_3R_137() {
        return this.jj_3R_230();
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_136() {
        return this.jj_scan_token(261);
    }

    private final boolean jj_3R_288() {
        return this.jj_scan_token(431);
    }

    private final boolean jj_3R_311() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_65() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = token;
            if (this.jj_3R_137()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_287() {
        return this.jj_scan_token(272);
    }

    private final boolean jj_3R_310() {
        return this.jj_scan_token(283);
    }

    private final boolean jj_3R_252() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = token;
            if (this.jj_3R_311()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_286() {
        return this.jj_scan_token(271);
    }

    private final boolean jj_3R_243() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_286()) {
            this.jj_scanpos = token;
            if (this.jj_3R_287()) {
                this.jj_scanpos = token;
                if (this.jj_3R_288()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_289()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_290()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_271() {
        return this.jj_3R_337();
    }

    private final boolean jj_3R_270() {
        return this.jj_3R_336();
    }

    private final boolean jj_3R_269() {
        return this.jj_3R_335();
    }

    private final boolean jj_3R_66() {
        return false;
    }

    private final boolean jj_3_9() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_333() {
        return this.jj_3R_354();
    }

    private final boolean jj_3R_64() {
        return false;
    }

    private final boolean jj_3R_267() {
        return this.jj_3R_334();
    }

    private final boolean jj_3_21() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_195() {
        return this.jj_3R_252();
    }

    private final boolean jj_3R_357() {
        return this.jj_scan_token(347);
    }

    private final boolean jj_3R_103() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_268() {
        return this.jj_scan_token(355);
    }

    private final boolean jj_3_20() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind != 299;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_66()) {
            return true;
        }
        return this.jj_3R_67();
    }

    private final boolean jj_3R_102() {
        return this.jj_scan_token(306);
    }

    private final boolean jj_3_19() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind != 299;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_64()) {
            return true;
        }
        return this.jj_3R_65();
    }

    private final boolean jj_3_67() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_102()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 306;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_103()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_101() {
        return this.jj_scan_token(189);
    }

    private final boolean jj_3R_109() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_61();
    }

    private final boolean jj_3R_100() {
        return this.jj_scan_token(305);
    }

    private final boolean jj_3_66() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 305;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_101()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_194() {
        return this.jj_scan_token(293);
    }

    private final boolean jj_3R_356() {
        return this.jj_scan_token(346);
    }

    private final boolean jj_3_50() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_350() {
        return this.jj_scan_token(444);
    }

    private final boolean jj_3R_193() {
        return this.jj_scan_token(342);
    }

    private final boolean jj_3R_229() {
        Token token = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = token;
            if (this.jj_3_20()) {
                this.jj_scanpos = token;
                if (this.jj_3_21()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_267()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_268()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_269()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_270()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_271()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_355() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_334() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_355()) {
            this.jj_scanpos = token;
            if (this.jj_3R_356()) {
                this.jj_scanpos = token;
                if (this.jj_3R_357()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_192() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_119() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_84() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_99() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_192()) {
            this.jj_scanpos = token;
            if (this.jj_3R_193()) {
                this.jj_scanpos = token;
                if (this.jj_3R_194()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_66()) {
                        this.jj_scanpos = token;
                        if (this.jj_3_67()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_195()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_18() {
        return this.jj_3R_63();
    }

    private final boolean jj_3_47() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_280() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_110() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(96)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3_29() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_46() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 195) || this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_118()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 218 && (this.getToken((int)2).kind == 435 && (this.getToken((int)3).kind == 450 && !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)4).kind) || this.getToken((int)3).kind == 147) || !this.isPrivilegeKeywordExceptTrigger(this.getToken((int)2).kind));
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_119()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_118() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_106() {
        return this.jj_3R_62();
    }

    private final boolean jj_3_79() {
        return this.jj_3R_111();
    }

    private final boolean jj_3_78() {
        return this.jj_3R_110();
    }

    private final boolean jj_3R_279() {
        return this.jj_scan_token(192);
    }

    private final boolean jj_3R_278() {
        return this.jj_3R_342();
    }

    private final boolean jj_3R_260() {
        return this.jj_scan_token(122);
    }

    private final boolean jj_3R_277() {
        return this.jj_3R_256();
    }

    private final boolean jj_3R_237() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_277()) {
            this.jj_scanpos = token;
            if (this.jj_3R_278()) {
                this.jj_scanpos = token;
                if (this.jj_3R_279()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_280()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_135() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_62() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.commonDatatypeName(false);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_134()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind != 291;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_135()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_134() {
        return this.jj_3R_229();
    }

    private final boolean jj_3_65() {
        return this.jj_3R_99();
    }

    private final boolean jj_3_77() {
        return this.jj_3R_109();
    }

    private final boolean jj_3R_223() {
        return this.jj_3R_265();
    }

    private final boolean jj_3R_376() {
        return this.jj_scan_token(483);
    }

    private final boolean jj_3R_299() {
        return this.jj_scan_token(375);
    }

    private final boolean jj_3R_222() {
        return this.jj_3R_264();
    }

    private final boolean jj_3_85() {
        return this.jj_3R_112();
    }

    private final boolean jj_3R_298() {
        return this.jj_scan_token(373);
    }

    private final boolean jj_3R_221() {
        return this.jj_3R_263();
    }

    private final boolean jj_3R_217() {
        return this.jj_3R_259();
    }

    private final boolean jj_3R_309() {
        return this.jj_scan_token(446);
    }

    private final boolean jj_3R_297() {
        return this.jj_scan_token(376);
    }

    private final boolean jj_3R_220() {
        return this.jj_3R_262();
    }

    private final boolean jj_3_70() {
        return this.jj_3R_106();
    }

    private final boolean jj_3R_375() {
        return this.jj_scan_token(478);
    }

    private final boolean jj_3R_347() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_375()) {
            this.jj_scanpos = token;
            if (this.jj_3R_376()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_219() {
        return this.jj_3R_261();
    }

    private final boolean jj_3R_113() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_216()) {
            this.jj_scanpos = token;
            if (this.jj_3R_217()) {
                this.jj_scanpos = token;
                if (this.jj_3_85()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_216() {
        return this.jj_scan_token(471);
    }

    private final boolean jj_3R_296() {
        return this.jj_scan_token(374);
    }

    private final boolean jj_3R_245() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_296()) {
            this.jj_scanpos = token;
            if (this.jj_3R_297()) {
                this.jj_scanpos = token;
                if (this.jj_3R_298()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_299()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_124() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_218()) {
            this.jj_scanpos = token;
            if (this.jj_3R_219()) {
                this.jj_scanpos = token;
                if (this.jj_3R_220()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_221()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_222()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_223()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_218() {
        return this.jj_3R_260();
    }

    private final boolean jj_3R_198() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_105() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_198()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_62();
    }

    private final boolean jj_3R_366() {
        return this.jj_3R_383();
    }

    private final boolean jj_3_17() {
        return this.jj_3R_62();
    }

    private final boolean jj_3_84() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_28() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_189() {
        return this.jj_scan_token(239);
    }

    private final boolean jj_3_8() {
        return this.jj_3R_54();
    }

    private final boolean jj_3_7() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_61() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_69() {
        return this.jj_3R_105();
    }

    private final boolean jj_3R_341() {
        Token token = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_366()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_176() {
        return this.jj_3R_247();
    }

    private final boolean jj_3_75() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_115() {
        return this.jj_scan_token(227);
    }

    private final boolean jj_3_5() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_242() {
        return this.jj_3R_285();
    }

    private final boolean jj_3_81() {
        return this.jj_3R_59();
    }

    private final boolean jj_3_83() {
        return this.jj_3R_113();
    }

    private final boolean jj_3R_161() {
        Token token = this.jj_scanpos;
        if (this.jj_3_83()) {
            this.jj_scanpos = token;
            if (this.jj_3R_242()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_225() {
        return this.jj_scan_token(108);
    }

    private final boolean jj_3_64() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_276() {
        return this.jj_3R_341();
    }

    private final boolean jj_3R_128() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(222)) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 108 && (this.getToken((int)2).kind == 222 || this.getToken((int)2).kind == 429);
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_225()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_44() {
        Token token = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 227 && this.getToken((int)2).kind != 108;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_114()) {
            this.jj_scanpos = token;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 227 && this.getToken((int)2).kind == 108;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_115()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_114() {
        return this.jj_scan_token(227);
    }

    private final boolean jj_3_42() {
        return this.jj_3R_86();
    }

    private final boolean jj_3_16() {
        return this.jj_3R_61();
    }

    private final boolean jj_3R_85() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_175()) {
            this.jj_scanpos = token;
            if (this.jj_3_42()) {
                this.jj_scanpos = token;
                if (this.jj_3R_176()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_175() {
        return this.jj_3R_246();
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_128();
    }

    private final boolean jj_3R_122() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_322() {
        return this.jj_3R_351();
    }

    private final boolean jj_3R_321() {
        return this.jj_3R_350();
    }

    private final boolean jj_3R_168() {
        return this.jj_3R_245();
    }

    private final boolean jj_3R_320() {
        return this.jj_3R_349();
    }

    private final boolean jj_3R_188() {
        return this.jj_scan_token(402);
    }

    private final boolean jj_3R_319() {
        return this.jj_3R_348();
    }

    private final boolean jj_3R_236() {
        return this.jj_3R_276();
    }

    private final boolean jj_3_34() {
        return this.jj_3R_80();
    }

    private final boolean jj_3R_346() {
        return this.jj_3R_339();
    }

    private final boolean jj_3R_314() {
        return this.jj_scan_token(295);
    }

    private final boolean jj_3R_313() {
        return this.jj_scan_token(409);
    }

    private final boolean jj_3R_318() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_346()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_347();
    }

    private final boolean jj_3R_312() {
        return this.jj_scan_token(160);
    }

    private final boolean jj_3R_256() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_318()) {
            this.jj_scanpos = token;
            if (this.jj_3R_319()) {
                this.jj_scanpos = token;
                if (this.jj_3R_320()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_321()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_322()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_253() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_312()) {
            this.jj_scanpos = token;
            if (this.jj_3R_313()) {
                this.jj_scanpos = token;
                if (this.jj_3R_314()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_121() {
        return this.jj_scan_token(129);
    }

    private final boolean jj_3R_167() {
        return this.jj_scan_token(300);
    }

    private final boolean jj_3R_251() {
        return this.jj_scan_token(446);
    }

    private final boolean jj_3R_196() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_253()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private final boolean jj_3R_166() {
        return this.jj_scan_token(258);
    }

    private final boolean jj_3R_255() {
        return this.jj_scan_token(358);
    }

    private final boolean jj_3R_395() {
        return this.jj_scan_token(183);
    }

    private final boolean jj_3_74() {
        return this.jj_3R_59();
    }

    private final boolean jj_3R_165() {
        return this.jj_scan_token(93);
    }

    private final boolean jj_3R_394() {
        return this.jj_scan_token(157);
    }

    private final boolean jj_3R_204() {
        return this.jj_3R_256();
    }

    private final boolean jj_3_41() {
        return this.jj_3R_85();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0x8000000, 0x8000000, 0, 0, 0, 0x8000000, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x8000000, 0x8000000, 0x8000000, 0, 0x8000000, 0x8000000, 0x3010000, 0, 0, 0x3000000, 0, 0x3000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3010000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 0, 0, 4, 4, 0, 0, 0, 0, 256, 0, 32, 0, 0, 0, 0, 32768, 0, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0, 0, 0x400000, 0x800000, 0, 0x20000000, 0, 0, 0x1000000, 0, 0, 256, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 64, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 256, 0, 0, 256, 0, 0, 0, 0, 0, 512, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 8192, 0x1000000, 0, 0, 0, 0, 4096, 4096, 0, 0, 256, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0x8000000, 0, 22, 0, 0, 0, 0, 0x8000000, 0, 18, 0, 0x100000, 0x100000, 0, 0, 0, 0, 0x8000000, 0, 4, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, -604045314, 0x20010000, 0, -604045314, -604045314, 0};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{0x4000000, 0, 0x4400400, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 16, 0x800010, 16, 16, 0x800000, 16, 0x800010, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x300000, 0x300000, 0, 0, 0x300000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 65536, 0, 0, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0x8000000, 2048, 0, 0, 0, 0, 0, 0, 0, 8192, 16384, 32768, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 262144, 1, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0x800000, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0x4000000, 0, -262657, 262656, 0, -262657, -262657, 0};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{0, 0, 2, 0, 512, 0, 0, 0x200000, 0x200000, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 8192, 65536, 0, 0