/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;

public class DDdependableFinder
implements DependableFinder,
Formatable {
    private final int formatId;

    public DDdependableFinder(int n) {
        this.formatId = n;
    }

    public String toString() {
        return this.getSQLObjectType();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public final int getTypeFormatId() {
        return this.formatId;
    }

    public String getSQLObjectType() {
        switch (this.formatId) {
            case 136: {
                return "Alias";
            }
            case 135: {
                return "Conglomerate";
            }
            case 208: {
                return "Constraint";
            }
            case 325: {
                return "Default";
            }
            case 273: {
                return "File";
            }
            case 371: {
                return "Schema";
            }
            case 226: {
                return "StoredPreparedStatement";
            }
            case 137: {
                return "Table";
            }
            case 393: {
                return "ColumnsInTable";
            }
            case 320: {
                return "Trigger";
            }
            case 145: {
                return "View";
            }
            case 462: {
                return "TablePrivilege";
            }
            case 463: {
                return "ColumnsPrivilege";
            }
            case 461: {
                return "RoutinePrivilege";
            }
            case 471: {
                return "RoleGrant";
            }
            case 472: {
                return "Sequence";
            }
            case 473: {
                return "Perm";
            }
        }
        return null;
    }

    public final Dependable getDependable(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        Dependable dependable = this.findDependable(dataDictionary, uUID);
        if (dependable == null) {
            throw StandardException.newException("42X94", (Object)this.getSQLObjectType(), (Object)uUID);
        }
        return dependable;
    }

    Dependable findDependable(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        switch (this.formatId) {
            case 136: {
                return dataDictionary.getAliasDescriptor(uUID);
            }
            case 135: {
                return dataDictionary.getConglomerateDescriptor(uUID);
            }
            case 208: {
                return dataDictionary.getConstraintDescriptor(uUID);
            }
            case 325: {
                ColumnDescriptor columnDescriptor = dataDictionary.getColumnDescriptorByDefaultId(uUID);
                if (columnDescriptor != null) {
                    return new DefaultDescriptor(dataDictionary, columnDescriptor.getDefaultUUID(), columnDescriptor.getReferencingUUID(), columnDescriptor.getPosition());
                }
                return null;
            }
            case 273: {
                return dataDictionary.getFileInfoDescriptor(uUID);
            }
            case 371: {
                return dataDictionary.getSchemaDescriptor(uUID, null);
            }
            case 226: {
                return dataDictionary.getSPSDescriptor(uUID);
            }
            case 137: {
                return dataDictionary.getTableDescriptor(uUID);
            }
            case 320: {
                return dataDictionary.getTriggerDescriptor(uUID);
            }
            case 145: {
                return dataDictionary.getViewDescriptor(uUID);
            }
            case 463: {
                return dataDictionary.getColumnPermissions(uUID);
            }
            case 462: {
                return dataDictionary.getTablePermissions(uUID);
            }
            case 461: {
                return dataDictionary.getRoutinePermissions(uUID);
            }
            case 471: {
                return dataDictionary.getRoleGrantDescriptor(uUID);
            }
            case 472: {
                return dataDictionary.getSequenceDescriptor(uUID);
            }
            case 473: {
                return dataDictionary.getGenericPermissions(uUID);
            }
        }
        return null;
    }
}

