/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.openjpa.util.AbstractChangeTracker;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.InternalException;

public class CollectionChangeTrackerImpl
extends AbstractChangeTracker
implements CollectionChangeTracker {
    protected final Collection _coll;
    protected final boolean _dups;
    protected final boolean _order;

    public CollectionChangeTrackerImpl(Collection coll, boolean dups, boolean order, boolean autoOff) {
        this._coll = coll;
        this._dups = dups;
        this._order = order;
        this.setAutoOff(autoOff);
    }

    public boolean allowsDuplicates() {
        return this._dups;
    }

    public boolean isOrdered() {
        return this._order;
    }

    @Override
    public void added(Object elem) {
        super.added(elem);
    }

    @Override
    public void removed(Object elem) {
        super.removed(elem);
    }

    @Override
    protected int initialSequence() {
        if (this._order) {
            return this._coll.size();
        }
        return super.initialSequence();
    }

    @Override
    protected void add(Object elem) {
        if (this.rem == null || !this.rem.remove(elem)) {
            if (this.getAutoOff() && this.getAdded().size() + this.getRemoved().size() >= this._coll.size()) {
                this.stopTracking();
            } else {
                if (this.add == null) {
                    this.add = this._dups || this._order ? new ArrayList() : this.newSet();
                }
                this.add.add(elem);
            }
        } else if (this._order) {
            this.stopTracking();
        } else {
            if (this.change == null) {
                this.change = this.newSet();
            }
            this.change.add(elem);
        }
    }

    @Override
    protected void remove(Object elem) {
        if (this._dups && this.getAutoOff() && this._coll.contains(elem)) {
            this.stopTracking();
        } else if (this.add == null || !this.add.remove(elem)) {
            if (this.getAutoOff() && this.getRemoved().size() + this.getAdded().size() >= this._coll.size()) {
                this.stopTracking();
            } else {
                if (this.rem == null) {
                    this.rem = this.newSet();
                }
                this.rem.add(elem);
            }
        }
    }

    @Override
    protected void change(Object elem) {
        throw new InternalException();
    }
}

