/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.IOException;
import javax.persistence.Persistence;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jest.JESTContext;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.ProcessingException;

public class JESTServlet
extends HttpServlet {
    public static final String INIT_PARA_UNIT = "persistence.unit";
    public static final String INIT_PARA_STANDALONE = "standalone";
    private String _unit;
    private boolean _debug;
    private OpenJPAEntityManagerFactory _emf;
    protected static Localizer _loc = Localizer.forPackage(JESTServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._debug = "true".equalsIgnoreCase(config.getInitParameter("debug"));
        this._unit = config.getInitParameter(INIT_PARA_UNIT);
        if (this._unit == null) {
            throw new ServletException(_loc.get("no-persistence-unit-param").toString());
        }
        boolean standalone = "true".equalsIgnoreCase(config.getInitParameter(INIT_PARA_STANDALONE));
        System.err.println("Standalone Deployment Mode " + standalone);
        if (standalone) {
            this.createPersistenceUnit();
        }
        if (this.findPersistenceUnit()) {
            config.getServletContext().log(_loc.get("servlet-init", this._unit).toString());
        } else {
            config.getServletContext().log(_loc.get("servlet-not-init", this._unit).toString());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug(request);
        if (this.findPersistenceUnit()) {
            JESTContext ctx = new JESTContext(this._unit, this._emf, request, response);
            try {
                ctx.execute();
            }
            catch (Exception e) {
                this.handleError(ctx, e);
            }
        } else {
            throw new ServletException(_loc.get("no-persistence-unit", this._unit).toString());
        }
    }

    protected void createPersistenceUnit() throws ServletException {
        try {
            System.err.println("Creating Standalone Persistent Unit  " + this._unit);
            this._emf = OpenJPAPersistence.cast(Persistence.createEntityManagerFactory((String)this._unit));
            System.err.println("Created Standalone Persistent Unit  " + this._unit + ":" + this._emf);
        }
        catch (Exception e) {
            System.err.println("Can not creating Standalone Persistent Unit  " + this._unit);
            e.printStackTrace();
            throw new ServletException(_loc.get("no-persistence-unit-standalone", this._unit).toString(), (Throwable)e);
        }
    }

    protected boolean findPersistenceUnit() {
        if (this._emf == null) {
            System.err.println("Discovering auxiliary Persistent Unit  " + this._unit);
            AbstractBrokerFactory bf = AbstractBrokerFactory.getPooledFactoryForKey(this._unit);
            if (bf != null) {
                this._emf = (OpenJPAEntityManagerFactory)bf.getUserObject("org.apache.openjpa.persistence.EntityManagerFactory");
            }
            System.err.println("Discovered auxiliary Persistent Unit  " + this._unit + ":" + this._emf);
        }
        return this._emf != null;
    }

    protected void handleError(JPAServletContext ctx, Throwable t) throws IOException {
        if (t instanceof ProcessingException) {
            ((ProcessingException)t).printStackTrace();
        } else {
            new ProcessingException(ctx, t).printStackTrace();
        }
    }

    public void destroy() {
        this._emf = null;
        this._unit = null;
    }

    private void debug(HttpServletRequest r) {
        if (!this._debug) {
            return;
        }
        this.log(r.getRemoteUser() + "@" + r.getRemoteHost() + ":" + r.getRemotePort() + "[" + r.getPathInfo() + "]");
    }

    public void log(String s) {
        System.err.println(s);
        super.log(s);
    }
}

