/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jest.JESTCommand;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.JSONObjectFormatter;
import org.apache.openjpa.persistence.jest.ObjectFormatter;
import org.apache.openjpa.persistence.jest.ProcessingException;
import org.apache.openjpa.persistence.jest.PrototypeFactory;
import org.apache.openjpa.persistence.jest.XMLFormatter;

abstract class AbstractCommand
implements JESTCommand {
    public static final char EQUAL = '=';
    public static final String PATH_SEPARATOR = "/";
    public static final Collection<String> EMPTY_LIST = Collections.emptySet();
    protected ObjectFormatter<?> _formatter;
    private Map<String, String> _qualifiers = new HashMap<String, String>();
    private Map<String, String> _args = new HashMap<String, String>();
    private Map<String, String> _margs = new HashMap<String, String>();
    protected final JPAServletContext _ctx;
    private static PrototypeFactory<JESTCommand.Format, ObjectFormatter<?>> _formatterFactory = new PrototypeFactory();
    protected static Localizer _loc = Localizer.forPackage(AbstractCommand.class);

    protected AbstractCommand(JPAServletContext ctx) {
        this._ctx = ctx;
    }

    @Override
    public JPAServletContext getExecutionContext() {
        return this._ctx;
    }

    public String getMandatoryArgument(String key) {
        return this.get(key, this._margs);
    }

    @Override
    public String getArgument(String key) {
        return this.get(key, this._args);
    }

    @Override
    public boolean hasArgument(String key) {
        return this.has(key, this._args);
    }

    @Override
    public Map<String, String> getArguments() {
        return this._args;
    }

    @Override
    public String getQualifier(String key) {
        return this.get(key, this._qualifiers);
    }

    @Override
    public boolean hasQualifier(String key) {
        return this.has(key, this._qualifiers);
    }

    protected boolean isBooleanQualifier(String key) {
        if (this.hasQualifier(key)) {
            String value = this.getQualifier(key);
            return value == null || "true".equalsIgnoreCase(value.toString());
        }
        return false;
    }

    @Override
    public Map<String, String> getQualifiers() {
        return this._qualifiers;
    }

    @Override
    public void parse() throws ProcessingException {
        HttpServletRequest request = this._ctx.getRequest();
        String path = request.getPathInfo();
        if (path != null) {
            path = path.substring(1);
            String[] segments = path.split(PATH_SEPARATOR);
            for (int i = 1; i < segments.length; ++i) {
                String segment = segments[i];
                int idx = segment.indexOf(61);
                if (idx == -1) {
                    this._qualifiers.put(segment, null);
                    continue;
                }
                this._qualifiers.put(segment.substring(0, idx), segment.substring(idx + 1));
            }
        }
        this._qualifiers = Collections.unmodifiableMap(this._qualifiers);
        Enumeration names = request.getParameterNames();
        Collection<String> mandatoryArgs = this.getMandatoryArguments();
        while (names.hasMoreElements()) {
            String key = names.nextElement().toString();
            if (key.startsWith("dojo.")) continue;
            this.put(key, request.getParameter(key), mandatoryArgs.contains(key) ? this._margs : this._args);
        }
        this._args = Collections.unmodifiableMap(this._args);
        this._margs = Collections.unmodifiableMap(this._margs);
        this.validate();
    }

    protected Collection<String> getMandatoryArguments() {
        return EMPTY_LIST;
    }

    protected int getMinimumArguments() {
        return 0;
    }

    protected int getMaximumArguments() {
        return Integer.MAX_VALUE;
    }

    protected JESTCommand.Format getDefaultFormat() {
        return JESTCommand.Format.xml;
    }

    protected Collection<String> getValidQualifiers() {
        return EMPTY_LIST;
    }

    protected void validate() {
        HttpServletRequest request = this._ctx.getRequest();
        Collection<String> validQualifiers = this.getValidQualifiers();
        for (String key : this._qualifiers.keySet()) {
            if (validQualifiers.contains(key)) continue;
            throw new ProcessingException(this._ctx, _loc.get("parse-invalid-qualifier", this, key, validQualifiers), 400);
        }
        Collection<String> mandatoryArgs = this.getMandatoryArguments();
        for (String key : mandatoryArgs) {
            if (request.getParameter(key) != null) continue;
            throw new ProcessingException(this._ctx, _loc.get("parse-missing-mandatory-argument", this, key, request.getParameterMap().keySet()), 400);
        }
        if (this._args.size() < this.getMinimumArguments()) {
            throw new ProcessingException(this._ctx, _loc.get("parse-less-argument", this, this._args.keySet(), this.getMinimumArguments()), 400);
        }
        if (this._args.size() > this.getMaximumArguments()) {
            throw new ProcessingException(this._ctx, _loc.get("parse-less-argument", this, this._args.keySet(), this.getMinimumArguments()), 400);
        }
    }

    private String get(String key, Map<String, String> map) {
        return map.get(key);
    }

    private String put(String key, String value, Map<String, String> map) {
        return map.put(key, value);
    }

    private boolean has(String key, Map<String, String> map) {
        return map.containsKey(key);
    }

    public ObjectFormatter<?> getObjectFormatter() {
        if (this._formatter == null) {
            String rformat = this.getQualifier("format");
            JESTCommand.Format format = null;
            if (rformat == null) {
                format = this.getDefaultFormat();
            } else {
                try {
                    format = JESTCommand.Format.valueOf(rformat);
                }
                catch (Exception e) {
                    throw new ProcessingException(this._ctx, _loc.get("format-not-supported", new Object[]{format, this._ctx.getRequest().getPathInfo(), _formatterFactory.getRegisteredKeys()}), 400);
                }
            }
            this._formatter = _formatterFactory.newInstance(format, new Object[0]);
            if (this._formatter == null) {
                throw new ProcessingException(this._ctx, _loc.get("format-not-supported", new Object[]{format, this._ctx.getRequest().getPathInfo(), _formatterFactory.getRegisteredKeys()}), 400);
            }
        }
        return this._formatter;
    }

    protected OpenJPAStateManager toStateManager(Object obj) {
        if (obj instanceof OpenJPAStateManager) {
            return (OpenJPAStateManager)obj;
        }
        if (obj instanceof PersistenceCapable) {
            return (OpenJPAStateManager)((PersistenceCapable)obj).pcGetStateManager();
        }
        return null;
    }

    protected List<OpenJPAStateManager> toStateManager(Collection<?> objects) {
        ArrayList<OpenJPAStateManager> sms = new ArrayList<OpenJPAStateManager>();
        for (Object o : objects) {
            OpenJPAStateManager sm = this.toStateManager(o);
            if (sm == null) continue;
            sms.add(sm);
        }
        return sms;
    }

    protected void pushFetchPlan(Object target) {
        String[] plans;
        if (!this.hasQualifier("plan")) {
            return;
        }
        OpenJPAEntityManager em = this._ctx.getPersistenceContext();
        FetchPlan plan = em.pushFetchPlan();
        BrokerImpl broker = (BrokerImpl)JPAFacadeHelper.toBroker(em);
        if (target instanceof OpenJPAEntityManager) {
            broker.setCacheFinderQuery(false);
        } else if (target instanceof OpenJPAQuery) {
            broker.setCachePreparedQuery(false);
        }
        for (String p : plans = this.getQualifier("plan").split(",")) {
            if ((p = p.trim()).charAt(0) == '-') {
                plan.removeFetchGroup(p.substring(1));
                continue;
            }
            plan.addFetchGroup(p);
        }
    }

    protected void popFetchPlan(boolean finder) {
        if (!this.hasQualifier("plan")) {
            return;
        }
        OpenJPAEntityManager em = this._ctx.getPersistenceContext();
        BrokerImpl broker = (BrokerImpl)JPAFacadeHelper.toBroker(em);
        if (finder) {
            broker.setCacheFinderQuery(false);
        } else {
            broker.setCachePreparedQuery(false);
        }
    }

    protected void debug(HttpServletRequest request, HttpServletResponse response, JPAServletContext ctx) throws IOException {
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.println("URI             = [" + request.getRequestURI() + "]");
        writer.println("URL             = [" + request.getRequestURL() + "]");
        writer.println("Servlet Path    = [" + request.getServletPath() + "]");
        writer.println("Context Path    = [" + request.getContextPath() + "]");
        writer.println("Translated Path = [" + request.getPathTranslated() + "]");
        writer.println("Path Info       = [" + request.getPathInfo() + "]");
        String query = request.getQueryString();
        if (query != null) {
            query = URLDecoder.decode(request.getQueryString(), "UTF-8");
        }
        writer.println("Query           = [" + query + "]");
        int i = 0;
        for (Map.Entry<String, String> e : this._qualifiers.entrySet()) {
            writer.println("Qualifier [" + i + "] = [" + e.getKey() + ": " + e.getValue() + "]");
            ++i;
        }
        i = 0;
        for (Map.Entry<String, String> e : this._args.entrySet()) {
            writer.println("Parameter [" + i + "] = [" + e.getKey() + ": " + e.getValue() + "]");
            ++i;
        }
    }

    static {
        _formatterFactory.register(JESTCommand.Format.xml, XMLFormatter.class);
        _formatterFactory.register(JESTCommand.Format.json, JSONObjectFormatter.class);
    }
}

