/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.LogicalUnion;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.SelectImpl;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FinderQuery;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.Id;

public class FinderQueryImpl
implements FinderQuery<ClassMapping, SelectExecutor, Result> {
    private final ClassMapping _mapping;
    private final SelectImpl _select;
    private final Column[] _pkCols;
    private final Joinable[] _joins;
    private final int[] _pkIndices;
    private final SQLBuffer _buffer;
    private final String _sql;

    static FinderQueryImpl newFinder(ClassMapping mapping, SelectExecutor select) {
        SelectImpl impl = FinderQueryImpl.extractImplementation(select);
        if (impl == null) {
            return null;
        }
        SQLBuffer buffer = impl.getSQL();
        Column[] pkCols = mapping.getPrimaryKeyColumns();
        boolean canCache = pkCols.length == buffer.getParameters().size();
        return canCache ? new FinderQueryImpl(mapping, impl, buffer) : null;
    }

    private FinderQueryImpl(ClassMapping mapping, SelectImpl select, SQLBuffer buffer) {
        int i;
        this._mapping = mapping;
        this._select = select;
        this._buffer = buffer;
        this._sql = this._buffer.getSQL();
        this._pkCols = this._mapping.getPrimaryKeyColumns();
        this._joins = new Joinable[this._pkCols.length];
        for (i = 0; i < this._pkCols.length; ++i) {
            this._joins[i] = this._mapping.assertJoinable(this._pkCols[i]);
        }
        this._pkIndices = new int[this._pkCols.length];
        for (i = 0; i < this._pkCols.length; ++i) {
            FieldMetaData pk = this._mapping.getField(this._joins[i].getFieldIndex());
            this._pkIndices[i] = pk == null ? 0 : pk.getPrimaryKeyIndex();
        }
    }

    @Override
    public ClassMapping getIdentifier() {
        return this._mapping;
    }

    @Override
    public SelectExecutor getDelegate() {
        return this._select;
    }

    @Override
    public String getQueryString() {
        return this._sql;
    }

    public Column[] getPKColumns() {
        return this._pkCols;
    }

    private Object[] getPKValues(OpenJPAStateManager sm, JDBCStore store) {
        Object[] pks = null;
        Object oid = sm.getObjectId();
        if (this._mapping.getIdentityType() == 2) {
            pks = ApplicationIds.toPKValues(oid, this._mapping);
        }
        Object[] val = new Object[this._pkCols.length];
        int count = 0;
        int i = 0;
        while (i < this._pkCols.length) {
            if (pks == null) {
                val[0] = oid == null ? null : Long.valueOf(((Id)oid).getId());
            } else {
                val[i] = this._joins[i].getJoinValue(pks[this._pkIndices[i]], this._pkCols[i], store);
            }
            ++i;
            ++count;
        }
        return val;
    }

    @Override
    public Result execute(OpenJPAStateManager sm, StoreManager store, FetchConfiguration fetch) {
        boolean forUpdate = false;
        JDBCStore jstore = (JDBCStore)((Object)store);
        Connection conn = jstore.getConnection();
        DBDictionary dict = jstore.getDBDictionary();
        PreparedStatement stmnt = null;
        ResultSet rs = null;
        try {
            stmnt = this._select.prepareStatement(conn, this._sql);
            Object[] params = this.getPKValues(sm, jstore);
            if (stmnt != null) {
                for (int i = 0; i < params.length; ++i) {
                    dict.setUnknown(stmnt, i + 1, params[i], this._pkCols[i]);
                }
            }
            dict.setTimeouts(stmnt, (JDBCFetchConfiguration)fetch, forUpdate);
            rs = this._select.executeQuery(conn, stmnt, this.getQueryString(), jstore, params, this._pkCols);
            return this._select.getEagerResult(conn, stmnt, rs, jstore, (JDBCFetchConfiguration)fetch, forUpdate, this._buffer);
        }
        catch (SQLException se) {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se2) {
                    // empty catch block
                }
            }
            try {
                conn.close();
            }
            catch (SQLException se2) {
                // empty catch block
            }
            throw new RuntimeException(se);
        }
    }

    private static SelectImpl extractImplementation(SelectExecutor selector) {
        if (selector == null || selector.hasMultipleSelects()) {
            return null;
        }
        if (selector instanceof SelectImpl) {
            return (SelectImpl)selector;
        }
        if (selector instanceof LogicalUnion.UnionSelect) {
            return ((LogicalUnion.UnionSelect)selector).getDelegate();
        }
        if (selector instanceof Union) {
            return FinderQueryImpl.extractImplementation(((Union)selector).getSelects()[0]);
        }
        return null;
    }

    public String toString() {
        return this._mapping + ": [" + this.getQueryString() + "]";
    }
}

