/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.visitor.BCVisitor;

public class ConstantValue
extends Attribute {
    int _valueIndex = 0;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    ConstantValue(int nameIndex, Attributes owner) {
        super(nameIndex, owner);
    }

    int getLength() {
        return 2;
    }

    public BCField getField() {
        return (BCField)this.getOwner();
    }

    public int getValueIndex() {
        return this._valueIndex;
    }

    public void setValueIndex(int valueIndex) {
        this._valueIndex = valueIndex;
    }

    public String getTypeName() {
        Class type = this.getType();
        if (type == null) {
            return null;
        }
        return type.getName();
    }

    public Class getType() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConstantValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = ConstantValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = ConstantValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = ConstantValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        return class$java$lang$String == null ? (class$java$lang$String = ConstantValue.class$("java.lang.String")) : class$java$lang$String;
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getType());
    }

    public Object getValue() {
        if (this._valueIndex <= 0) {
            return null;
        }
        return ((ConstantEntry)((Object)this.getPool().getEntry(this._valueIndex))).getConstant();
    }

    public void setValue(Object value) {
        Class<?> type = value.getClass();
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConstantValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            this.setIntValue((Boolean)value != false ? 1 : 0);
        } else if (type == (class$java$lang$Character == null ? (class$java$lang$Character = ConstantValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            this.setIntValue(((Character)value).charValue());
        } else if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = ConstantValue.class$("java.lang.Byte")) : class$java$lang$Byte) || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConstantValue.class$("java.lang.Integer")) : class$java$lang$Integer) || type == (class$java$lang$Short == null ? (class$java$lang$Short = ConstantValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            this.setIntValue(((Number)value).intValue());
        } else if (type == (class$java$lang$Float == null ? (class$java$lang$Float = ConstantValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            this.setFloatValue(((Number)value).floatValue());
        } else if (type == (class$java$lang$Double == null ? (class$java$lang$Double = ConstantValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            this.setDoubleValue(((Number)value).doubleValue());
        } else if (type == (class$java$lang$Long == null ? (class$java$lang$Long = ConstantValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            this.setLongValue(((Number)value).longValue());
        } else {
            this.setStringValue(value.toString());
        }
    }

    public int getIntValue() {
        if (this.getValueIndex() <= 0) {
            return 0;
        }
        return ((IntEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setIntValue(int value) {
        this.setValueIndex(this.getPool().findIntEntry(value, true));
    }

    public float getFloatValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0f;
        }
        return ((FloatEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setFloatValue(float value) {
        this.setValueIndex(this.getPool().findFloatEntry(value, true));
    }

    public double getDoubleValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0;
        }
        return ((DoubleEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setDoubleValue(double value) {
        this.setValueIndex(this.getPool().findDoubleEntry(value, true));
    }

    public long getLongValue() {
        if (this.getValueIndex() <= 0) {
            return 0L;
        }
        return ((LongEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setLongValue(long value) {
        this.setValueIndex(this.getPool().findLongEntry(value, true));
    }

    public String getStringValue() {
        if (this.getValueIndex() <= 0) {
            return null;
        }
        return ((StringEntry)this.getPool().getEntry(this.getValueIndex())).getStringEntry().getValue();
    }

    public void setStringValue(String value) {
        this.setValueIndex(this.getPool().findStringEntry(value, true));
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterConstantValue(this);
        visit.exitConstantValue(this);
    }

    void read(Attribute other) {
        this.setValue(((ConstantValue)other).getValue());
    }

    void read(DataInput in, int length) throws IOException {
        this.setValueIndex(in.readUnsignedShort());
    }

    void write(DataOutput out, int length) throws IOException {
        out.writeShort(this.getValueIndex());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

