/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class ReturnInstruction
extends TypedInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}};
    static /* synthetic */ Class class$java$lang$Object;

    ReturnInstruction(Code owner) {
        super(owner);
    }

    ReturnInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 172: {
                return Integer.TYPE.getName();
            }
            case 173: {
                return Long.TYPE.getName();
            }
            case 174: {
                return Float.TYPE.getName();
            }
            case 175: {
                return Double.TYPE.getName();
            }
            case 176: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = ReturnInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
            case 177: {
                return Void.TYPE.getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String type) {
        if ((type = this.mapType(type, _mappings, true)) == null) {
            return (TypedInstruction)this.setOpcode(0);
        }
        switch (type.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(172);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(173);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(174);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(175);
            }
            case 'v': {
                return (TypedInstruction)this.setOpcode(177);
            }
        }
        return (TypedInstruction)this.setOpcode(176);
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 0: 
            case 177: {
                return 0;
            }
            case 173: 
            case 175: {
                return -2;
            }
        }
        return -1;
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterReturnInstruction(this);
        visit.exitReturnInstruction(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

