/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassStrategy;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.DiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;

public class MappingStrategyInstaller
extends StrategyInstaller {
    public MappingStrategyInstaller(MappingRepository repos) {
        super(repos);
    }

    @Override
    public boolean isAdapting() {
        return true;
    }

    @Override
    public void installStrategy(ClassMapping cls) {
        ClassStrategy strat = this.repos.namedStrategy(cls);
        if (strat == null) {
            strat = this.repos.defaultStrategy(cls, true);
        }
        cls.setStrategy(strat, Boolean.TRUE);
        cls.setSourceMode(2, true);
    }

    @Override
    public void installStrategy(FieldMapping field) {
        FieldStrategy strategy = this.repos.namedStrategy(field, true);
        if (strategy == null) {
            strategy = this.repos.defaultStrategy(field, true, true);
        }
        field.setStrategy(strategy, Boolean.TRUE);
    }

    @Override
    public void installStrategy(Version version) {
        VersionStrategy strat = this.repos.namedStrategy(version);
        if (strat == null) {
            strat = this.repos.defaultStrategy(version, true);
        }
        version.setStrategy(strat, Boolean.TRUE);
    }

    @Override
    public void installStrategy(Discriminator discrim) {
        DiscriminatorStrategy strat = this.repos.namedStrategy(discrim);
        if (strat == null) {
            strat = this.repos.defaultStrategy(discrim, true);
        }
        discrim.setStrategy(strat, Boolean.TRUE);
    }
}

