/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.prefer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.server.api.prefer.Preferences;

public class PreferParser {
    private static final String TOKEN = "(?:[-!#$%&'*+.^_`|~]|\\w)+";
    private static final String QUOTED_STRING = "(?:\"(?:[\\t !#-\\[\\]-~\\x80-\\xFF]|(?:\\\\[\\t !-~\\x80-\\xFF]))*\")";
    private static final String NAMED_VALUE = "((?:[-!#$%&'*+.^_`|~]|\\w)+)(?:\\s*=\\s*((?:[-!#$%&'*+.^_`|~]|\\w)+|(?:\"(?:[\\t !#-\\[\\]-~\\x80-\\xFF]|(?:\\\\[\\t !-~\\x80-\\xFF]))*\")))?";
    private static final Pattern PREFERENCE = Pattern.compile("\\s*(,\\s*)+|(?:((?:[-!#$%&'*+.^_`|~]|\\w)+)(?:\\s*=\\s*((?:[-!#$%&'*+.^_`|~]|\\w)+|(?:\"(?:[\\t !#-\\[\\]-~\\x80-\\xFF]|(?:\\\\[\\t !-~\\x80-\\xFF]))*\")))?((?:\\s*;\\s*(?:((?:[-!#$%&'*+.^_`|~]|\\w)+)(?:\\s*=\\s*((?:[-!#$%&'*+.^_`|~]|\\w)+|(?:\"(?:[\\t !#-\\[\\]-~\\x80-\\xFF]|(?:\\\\[\\t !-~\\x80-\\xFF]))*\")))?)?)*))");
    private static final Pattern PARAMETER = Pattern.compile("\\s*(;\\s*)+|(?:((?:[-!#$%&'*+.^_`|~]|\\w)+)(?:\\s*=\\s*((?:[-!#$%&'*+.^_`|~]|\\w)+|(?:\"(?:[\\t !#-\\[\\]-~\\x80-\\xFF]|(?:\\\\[\\t !-~\\x80-\\xFF]))*\")))?)");

    private PreferParser() {
    }

    protected static Map<String, Preferences.Preference> parse(Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Preferences.Preference> result = new HashMap<String, Preferences.Preference>();
        for (String value : values) {
            if (value == null || value.isEmpty()) continue;
            PreferParser.parse(value, result);
        }
        return result;
    }

    private static void parse(String value, Map<String, Preferences.Preference> result) {
        HashMap<String, Preferences.Preference> partResult = new HashMap<String, Preferences.Preference>();
        String separator = "";
        int start = 0;
        Matcher matcher = PREFERENCE.matcher(value.trim());
        while (matcher.find() && matcher.start() == start) {
            start = matcher.end();
            if (matcher.group(1) != null) {
                separator = matcher.group(1);
                continue;
            }
            if (separator != null) {
                String name = matcher.group(2).toLowerCase(Locale.ROOT);
                if (!partResult.containsKey(name)) {
                    String preferenceValue = PreferParser.getValue(matcher.group(3));
                    Map<String, String> parameters = matcher.group(4) == null || matcher.group(4).isEmpty() ? null : PreferParser.parseParameters(matcher.group(4));
                    partResult.put(name, new Preferences.Preference(preferenceValue, parameters));
                }
                separator = null;
                continue;
            }
            return;
        }
        if (matcher.hitEnd()) {
            for (Map.Entry entry : partResult.entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put((String)entry.getKey(), (Preferences.Preference)entry.getValue());
            }
        }
    }

    private static Map<String, String> parseParameters(String parameters) {
        HashMap<String, String> result = new HashMap<String, String>();
        String separator = "";
        int start = 0;
        Matcher matcher = PARAMETER.matcher(parameters.trim());
        while (matcher.find() && matcher.start() == start) {
            start = matcher.end();
            if (matcher.group(1) != null) {
                separator = matcher.group(1);
                continue;
            }
            if (separator != null) {
                String name = matcher.group(2).toLowerCase(Locale.ROOT);
                if (!result.containsKey(name)) {
                    result.put(name, PreferParser.getValue(matcher.group(3)));
                }
                separator = null;
                continue;
            }
            return null;
        }
        return matcher.hitEnd() ? Collections.unmodifiableMap(result) : null;
    }

    private static String getValue(String value) {
        if (value == null) {
            return null;
        }
        String result = value;
        if (value.startsWith("\"")) {
            result = value.substring(1, value.length() - 1);
        }
        if (result.indexOf(92) >= 0) {
            result = result.replaceAll("\\\\(.)", "$1");
        }
        return result;
    }
}

