/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_x11-misc-fixed-9x15.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __LIBS_LIBNX_NXFONTS_NXFONTS_X11_MISC_FIXED_9X15_H
#define __LIBS_LIBNX_NXFONTS_NXFONTS_X11_MISC_FIXED_9X15_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_X11_MISC_FIXED_9X15

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  15
#define NXFONT_MAXWIDTH   9

/* The width of a space */

#define NXFONT_SPACEWIDTH 9

/* exclam (33) */
#define NXFONT_METRICS_33 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_33 {0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_34 {0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x12, 0x0, 0x12, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_35 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x24, 0x0, 0x7e, 0x0, 0x24, 0x0, 0x24, 0x0, 0x7e, 0x0, 0x24, 0x0, 0x24, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_36 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x49, 0x0, 0x48, 0x0, 0x28, 0x0, 0x1c, 0x0, 0xa, 0x0, 0x9, 0x0, 0x49, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_37 {0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x52, 0x0, 0x52, 0x0, 0x24, 0x0, 0x8, 0x0, 0x8, 0x0, 0x12, 0x0, 0x25, 0x0, 0x25, 0x0, 0x42, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_38 {0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x48, 0x0, 0x48, 0x0, 0x48, 0x0, 0x30, 0x0, 0x31, 0x0, 0x4a, 0x0, 0x44, 0x0, 0x4a, 0x0, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_39 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* parenleft (40) */
#define NXFONT_METRICS_40 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_40 {0x0, 0x0, 0x4, 0x0, 0x8, 0x0, 0x8, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x8, 0x0, 0x8, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0}

/* parenright (41) */
#define NXFONT_METRICS_41 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_41 {0x0, 0x0, 0x10, 0x0, 0x8, 0x0, 0x8, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x8, 0x0, 0x8, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_42 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x49, 0x0, 0x2a, 0x0, 0x1c, 0x0, 0x2a, 0x0, 0x49, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_43 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x7f, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* comma (44) */
#define NXFONT_METRICS_44 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_44 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x4, 0x0, 0x4, 0x0, 0x8, 0x0}

/* hyphen (45) */
#define NXFONT_METRICS_45 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_45 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* period (46) */
#define NXFONT_METRICS_46 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_46 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* slash (47) */
#define NXFONT_METRICS_47 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_47 {0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x20, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_48 {0x0, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* one (49) */
#define NXFONT_METRICS_49 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_49 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x18, 0x0, 0x28, 0x0, 0x48, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* two (50) */
#define NXFONT_METRICS_50 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_50 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x40, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* three (51) */
#define NXFONT_METRICS_51 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_51 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x1, 0x0, 0x2, 0x0, 0x4, 0x0, 0xe, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_52 {0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x6, 0x0, 0xa, 0x0, 0x12, 0x0, 0x22, 0x0, 0x42, 0x0, 0x7f, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* five (53) */
#define NXFONT_METRICS_53 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_53 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_54 {0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x20, 0x0, 0x40, 0x0, 0x40, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_55 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x1, 0x0, 0x2, 0x0, 0x2, 0x0, 0x4, 0x0, 0x4, 0x0, 0x8, 0x0, 0x8, 0x0, 0x10, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_56 {0x0, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x22, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_57 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_58 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* semicolon (59) */
#define NXFONT_METRICS_59 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_59 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x4, 0x0, 0x4, 0x0, 0x8, 0x0}

/* less (60) */
#define NXFONT_METRICS_60 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_60 {0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x4, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_61 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_62 {0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x4, 0x0, 0x2, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_63 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x1, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* at (64) */
#define NXFONT_METRICS_64 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_64 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x4f, 0x0, 0x51, 0x0, 0x53, 0x0, 0x4d, 0x0, 0x40, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_65 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* B (66) */
#define NXFONT_METRICS_66 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_66 {0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x42, 0x0, 0x41, 0x0, 0x42, 0x0, 0x7c, 0x0, 0x42, 0x0, 0x41, 0x0, 0x41, 0x0, 0x42, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* C (67) */
#define NXFONT_METRICS_67 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_67 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* D (68) */
#define NXFONT_METRICS_68 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_68 {0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x42, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x42, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* E (69) */
#define NXFONT_METRICS_69 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_69 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x7c, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* F (70) */
#define NXFONT_METRICS_70 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_70 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x7c, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_71 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x47, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* H (72) */
#define NXFONT_METRICS_72 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_72 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* I (73) */
#define NXFONT_METRICS_73 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_73 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* J (74) */
#define NXFONT_METRICS_74 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_74 {0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x42, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* K (75) */
#define NXFONT_METRICS_75 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_75 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x42, 0x0, 0x44, 0x0, 0x48, 0x0, 0x70, 0x0, 0x50, 0x0, 0x48, 0x0, 0x44, 0x0, 0x42, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* L (76) */
#define NXFONT_METRICS_76 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_76 {0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* M (77) */
#define NXFONT_METRICS_77 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_77 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x63, 0x0, 0x55, 0x0, 0x55, 0x0, 0x49, 0x0, 0x49, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* N (78) */
#define NXFONT_METRICS_78 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_78 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x61, 0x0, 0x51, 0x0, 0x49, 0x0, 0x45, 0x0, 0x43, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* O (79) */
#define NXFONT_METRICS_79 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_79 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* P (80) */
#define NXFONT_METRICS_80 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_80 {0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7e, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_81 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x51, 0x0, 0x49, 0x0, 0x3e, 0x0, 0x4, 0x0, 0x3, 0x0, 0x0, 0x0}

/* R (82) */
#define NXFONT_METRICS_82 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_82 {0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7e, 0x0, 0x48, 0x0, 0x44, 0x0, 0x42, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* S (83) */
#define NXFONT_METRICS_83 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_83 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x40, 0x0, 0x38, 0x0, 0x6, 0x0, 0x1, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* T (84) */
#define NXFONT_METRICS_84 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_84 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* U (85) */
#define NXFONT_METRICS_85 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_85 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* V (86) */
#define NXFONT_METRICS_86 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_86 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x22, 0x0, 0x22, 0x0, 0x14, 0x0, 0x14, 0x0, 0x14, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_87 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x49, 0x0, 0x49, 0x0, 0x49, 0x0, 0x49, 0x0, 0x55, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* X (88) */
#define NXFONT_METRICS_88 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_88 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x14, 0x0, 0x8, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Y (89) */
#define NXFONT_METRICS_89 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_89 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x14, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_90 {0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x1, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x40, 0x0, 0x40, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_91 {0x0, 0x0, 0x1e, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0}

/* backslash (92) */
#define NXFONT_METRICS_92 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_92 {0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x20, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x8, 0x0, 0x4, 0x0, 0x2, 0x0, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* bracketright (93) */
#define NXFONT_METRICS_93 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_93 {0x0, 0x0, 0x3c, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x4, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_94 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* underscore (95) */
#define NXFONT_METRICS_95 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_95 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0}

/* grave (96) */
#define NXFONT_METRICS_96 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_96 {0x0, 0x0, 0x10, 0x0, 0x8, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* a (97) */
#define NXFONT_METRICS_97 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_97 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* b (98) */
#define NXFONT_METRICS_98 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_98 {0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x61, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_99 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_100 {0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3d, 0x0, 0x43, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* e (101) */
#define NXFONT_METRICS_101 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_101 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* f (102) */
#define NXFONT_METRICS_102 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_102 {0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0x11, 0x0, 0x11, 0x0, 0x10, 0x0, 0x10, 0x0, 0x7c, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* g (103) */
#define NXFONT_METRICS_103 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_103 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3c, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0}

/* h (104) */
#define NXFONT_METRICS_104 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_104 {0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* i (105) */
#define NXFONT_METRICS_105 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_105 {0x0, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* j (106) */
#define NXFONT_METRICS_106 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_106 {0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3c, 0x0}

/* k (107) */
#define NXFONT_METRICS_107 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_107 {0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x41, 0x0, 0x46, 0x0, 0x58, 0x0, 0x60, 0x0, 0x58, 0x0, 0x46, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* l (108) */
#define NXFONT_METRICS_108 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_108 {0x0, 0x0, 0x0, 0x0, 0x38, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* m (109) */
#define NXFONT_METRICS_109 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_109 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x76, 0x0, 0x49, 0x0, 0x49, 0x0, 0x49, 0x0, 0x49, 0x0, 0x49, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* n (110) */
#define NXFONT_METRICS_110 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_110 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* o (111) */
#define NXFONT_METRICS_111 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_111 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_112 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x61, 0x0, 0x5e, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_113 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0x0, 0x43, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0}

/* r (114) */
#define NXFONT_METRICS_114 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_114 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x0, 0x31, 0x0, 0x21, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_115 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* t (116) */
#define NXFONT_METRICS_116 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_116 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0, 0x7e, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x10, 0x0, 0x11, 0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* u (117) */
#define NXFONT_METRICS_117 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_117 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* v (118) */
#define NXFONT_METRICS_118 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_118 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x22, 0x0, 0x14, 0x0, 0x14, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_119 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x49, 0x0, 0x49, 0x0, 0x49, 0x0, 0x55, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_120 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x22, 0x0, 0x14, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* y (121) */
#define NXFONT_METRICS_121 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_121 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x46, 0x0, 0x3a, 0x0, 0x2, 0x0, 0x42, 0x0, 0x3c, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_122 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* braceleft (123) */
#define NXFONT_METRICS_123 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_123 {0x0, 0x0, 0x7, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x4, 0x0, 0x18, 0x0, 0x18, 0x0, 0x4, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0}

/* bar (124) */
#define NXFONT_METRICS_124 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_124 {0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0}

/* braceright (125) */
#define NXFONT_METRICS_125 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_125 {0x0, 0x0, 0x70, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x10, 0x0, 0xc, 0x0, 0xc, 0x0, 0x10, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_126 {0x0, 0x0, 0x0, 0x0, 0x31, 0x0, 0x49, 0x0, 0x46, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_161 {0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_162 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x3c, 0x0, 0x4a, 0x0, 0x48, 0x0, 0x50, 0x0, 0x52, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_163 {0x0, 0x0, 0x0, 0x0, 0xe, 0x0, 0x11, 0x0, 0x10, 0x0, 0x10, 0x0, 0x7c, 0x0, 0x10, 0x0, 0x10, 0x0, 0x30, 0x0, 0x51, 0x0, 0x2e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_164 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x22, 0x0, 0x22, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* yen (165) */
#define NXFONT_METRICS_165 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_165 {0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x14, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_166 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_167 {0x0, 0x0, 0x0, 0x0, 0x18, 0x0, 0x24, 0x0, 0x20, 0x0, 0x18, 0x0, 0x24, 0x0, 0x24, 0x0, 0x24, 0x0, 0x18, 0x0, 0x4, 0x0, 0x24, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0}

/* dieresis (168) */
#define NXFONT_METRICS_168 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_168 {0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* copyright (169) */
#define NXFONT_METRICS_169 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_169 {0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x42, 0x0, 0x99, 0x0, 0xa5, 0x0, 0xa1, 0x0, 0xa5, 0x0, 0x99, 0x0, 0x42, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_170 {0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x48, 0x0, 0x38, 0x0, 0x48, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_171 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x0, 0x12, 0x0, 0x24, 0x0, 0x48, 0x0, 0x48, 0x0, 0x24, 0x0, 0x12, 0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_172 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* hyphen (173) */
#define NXFONT_METRICS_173 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_173 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* registered (174) */
#define NXFONT_METRICS_174 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_174 {0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x42, 0x0, 0xb9, 0x0, 0xa5, 0x0, 0xb9, 0x0, 0xa9, 0x0, 0xa5, 0x0, 0x42, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_175 {0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* degree (176) */
#define NXFONT_METRICS_176 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_176 {0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x12, 0x0, 0x12, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_177 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x7f, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_178 {0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x48, 0x0, 0x8, 0x0, 0x30, 0x0, 0x40, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_179 {0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x48, 0x0, 0x10, 0x0, 0x8, 0x0, 0x48, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* acute (180) */
#define NXFONT_METRICS_180 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_180 {0x0, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_181 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x63, 0x0, 0x5d, 0x0, 0x40, 0x0, 0x40, 0x0, 0x0, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_182 {0x0, 0x0, 0x0, 0x0, 0x3f, 0x0, 0x45, 0x0, 0x45, 0x0, 0x45, 0x0, 0x3d, 0x0, 0x5, 0x0, 0x5, 0x0, 0x5, 0x0, 0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_183 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* cedilla (184) */
#define NXFONT_METRICS_184 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_184 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x24, 0x0, 0x18, 0x0}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_185 {0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x60, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_186 {0x0, 0x0, 0x0, 0x0, 0x38, 0x0, 0x44, 0x0, 0x44, 0x0, 0x38, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_187 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x48, 0x0, 0x24, 0x0, 0x12, 0x0, 0x9, 0x0, 0x9, 0x0, 0x12, 0x0, 0x24, 0x0, 0x48, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_188 {0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x60, 0x0, 0x20, 0x0, 0x20, 0x0, 0x21, 0x0, 0x73, 0x0, 0x5, 0x0, 0x9, 0x0, 0xd, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* onehalf (189) */
#define NXFONT_METRICS_189 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_189 {0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x60, 0x0, 0x20, 0x0, 0x20, 0x0, 0x26, 0x0, 0x79, 0x0, 0x1, 0x0, 0x6, 0x0, 0x8, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* threequarters (190) */
#define NXFONT_METRICS_190 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_190 {0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x48, 0x0, 0x10, 0x0, 0x8, 0x0, 0x49, 0x0, 0x33, 0x0, 0x5, 0x0, 0x9, 0x0, 0xd, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* questiondown (191) */
#define NXFONT_METRICS_191 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_191 {0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x8, 0x0, 0x8, 0x0, 0x10, 0x0, 0x20, 0x0, 0x40, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Agrave (192) */
#define NXFONT_METRICS_192 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_192 {0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Aacute (193) */
#define NXFONT_METRICS_193 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_193 {0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_194 {0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Atilde (195) */
#define NXFONT_METRICS_195 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_195 {0x0, 0x0, 0x31, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_196 {0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Aring (197) */
#define NXFONT_METRICS_197 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_197 {0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x1c, 0x0, 0x14, 0x0, 0x22, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* AE (198) */
#define NXFONT_METRICS_198 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_198 {0x0, 0x0, 0x0, 0x0, 0x37, 0x0, 0x48, 0x0, 0x48, 0x0, 0x48, 0x0, 0x48, 0x0, 0x7e, 0x0, 0x48, 0x0, 0x48, 0x0, 0x48, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_199 {0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x41, 0x0, 0x3e, 0x0, 0xc, 0x0, 0x24, 0x0, 0x18, 0x0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_200 {0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x20, 0x0, 0x20, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Eacute (201) */
#define NXFONT_METRICS_201 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_201 {0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x20, 0x0, 0x20, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_202 {0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x20, 0x0, 0x20, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_203 {0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x20, 0x0, 0x20, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Igrave (204) */
#define NXFONT_METRICS_204 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_204 {0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Iacute (205) */
#define NXFONT_METRICS_205 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_205 {0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_206 {0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_207 {0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Eth (208) */
#define NXFONT_METRICS_208 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_208 {0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x42, 0x0, 0x41, 0x0, 0x41, 0x0, 0xe1, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x42, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_209 {0x0, 0x0, 0x31, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x41, 0x0, 0x61, 0x0, 0x51, 0x0, 0x49, 0x0, 0x49, 0x0, 0x45, 0x0, 0x43, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ograve (210) */
#define NXFONT_METRICS_210 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_210 {0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_211 {0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_212 {0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_213 {0x0, 0x0, 0x31, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_214 {0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_215 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x22, 0x0, 0x14, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Oslash (216) */
#define NXFONT_METRICS_216 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_216 {0x0, 0x0, 0x1, 0x0, 0x3e, 0x0, 0x43, 0x0, 0x45, 0x0, 0x45, 0x0, 0x49, 0x0, 0x49, 0x0, 0x51, 0x0, 0x51, 0x0, 0x61, 0x0, 0x3e, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_217 {0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_218 {0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_219 {0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_220 {0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_221 {0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x41, 0x0, 0x41, 0x0, 0x22, 0x0, 0x14, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_222 {0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0x7e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7e, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_223 {0x0, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x22, 0x0, 0x22, 0x0, 0x24, 0x0, 0x68, 0x0, 0x24, 0x0, 0x22, 0x0, 0x22, 0x0, 0x22, 0x0, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_224 {0x0, 0x0, 0x10, 0x0, 0x8, 0x0, 0x4, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_225 {0x0, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_226 {0x0, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_227 {0x0, 0x0, 0x0, 0x0, 0x19, 0x0, 0x26, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_228 {0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_229 {0x0, 0x0, 0xc, 0x0, 0x12, 0x0, 0xc, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3f, 0x0, 0x41, 0x0, 0x43, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ae (230) */
#define NXFONT_METRICS_230 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_230 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36, 0x0, 0x49, 0x0, 0x9, 0x0, 0x3e, 0x0, 0x48, 0x0, 0x49, 0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_231 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x41, 0x0, 0x3e, 0x0, 0xc, 0x0, 0x24, 0x0, 0x18, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_232 {0x0, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_233 {0x0, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_234 {0x0, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_235 {0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x7f, 0x0, 0x40, 0x0, 0x40, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* igrave (236) */
#define NXFONT_METRICS_236 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_236 {0x0, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x38, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* iacute (237) */
#define NXFONT_METRICS_237 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_237 {0x0, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x0, 0x0, 0x38, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* icircumflex (238) */
#define NXFONT_METRICS_238 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_238 {0x0, 0x0, 0x10, 0x0, 0x28, 0x0, 0x44, 0x0, 0x0, 0x0, 0x38, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* idieresis (239) */
#define NXFONT_METRICS_239 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_239 {0x0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x24, 0x0, 0x0, 0x0, 0x38, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x8, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_240 {0x0, 0x0, 0x24, 0x0, 0x18, 0x0, 0x28, 0x0, 0x4, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_241 {0x0, 0x0, 0x0, 0x0, 0x31, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_242 {0x0, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_243 {0x0, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_244 {0x0, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_245 {0x0, 0x0, 0x0, 0x0, 0x31, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_246 {0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x22, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x41, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_247 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x1c, 0x0, 0x8, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x8, 0x0, 0x1c, 0x0, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_248 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3e, 0x0, 0x45, 0x0, 0x45, 0x0, 0x49, 0x0, 0x51, 0x0, 0x51, 0x0, 0x3e, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_249 {0x0, 0x0, 0x20, 0x0, 0x10, 0x0, 0x8, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_250 {0x0, 0x0, 0x2, 0x0, 0x4, 0x0, 0x8, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_251 {0x0, 0x0, 0x8, 0x0, 0x14, 0x0, 0x22, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_252 {0x0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x24, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x3d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_253 {0x0, 0x0, 0x4, 0x0, 0x8, 0x0, 0x10, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x46, 0x0, 0x3a, 0x0, 0x2, 0x0, 0x42, 0x0, 0x3c, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_254 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0, 0x5e, 0x0, 0x61, 0x0, 0x41, 0x0, 0x41, 0x0, 0x61, 0x0, 0x5e, 0x0, 0x40, 0x0, 0x40, 0x0, 0x40, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 9, 15, 0, 0, 0}
#define NXFONT_BITMAP_255 {0x0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x24, 0x0, 0x0, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x42, 0x0, 0x46, 0x0, 0x3a, 0x0, 0x2, 0x0, 0x42, 0x0, 0x3c, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions Definitions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBS_LIBNX_NXFONTS_NXFONTS_X11_MISC_FIXED_9X15_H */
