/****************************************************************************
 * apps/netutils/ftpc/ftpc_config.h
 *
 *   Copyright (C) 2011 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef __APPS_NETUTILS_FTPC_FTPC_CONFIG_H
#define __APPS_NETUTILS_FTPC_FTPC_CONFIG_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/
/* This is a mindless little wrapper around include/nuttx/config.h.  Every
 * file in the ftpc directory includes this file at the very beginning of
 * of the file (instead of include/nuttx/config.h).  The only purpose of
 * this file is to muck with some of the settings to support some debug
 * features.
 *
 * The FPT client uses common networking debug macros (ndbg and ninfo).
 * This can be overwhelming if there is a lot of networking debug output
 * as well.  But by defining CONFIG_DEBUG_FTPC, this file will force
 * networking debug ON only for the files within this directory.
 */

#if !defined(CONFIG_DEBUG_NET) && defined(CONFIG_DEBUG_FTPC)
#  undef  CONFIG_DEBUG_NET
#  define CONFIG_DEBUG_NET 1
#  undef  CONFIG_DEBUG_NET_ERROR
#  define CONFIG_DEBUG_NET_ERROR 1
#  undef  CONFIG_DEBUG_NET_WARN
#  define CONFIG_DEBUG_NET_WARN 1
#  undef  CONFIG_DEBUG_NET_INFO
#  define CONFIG_DEBUG_NET_INFO 1
#endif

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Functions
 ****************************************************************************/

#endif /* __APPS_NETUTILS_FTPC_FTPC_CONFIG_H */
