/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.MessageBus;
import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorFactory;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.WaitProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.http.processors.StaticContentProcessor;
import io.questdb.cutlass.http.processors.TableStatusCheckProcessor;
import io.questdb.cutlass.http.processors.TextImportProcessor;
import io.questdb.cutlass.http.processors.TextQueryProcessor;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.FanOut;
import io.questdb.mp.Job;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.MutableIOContextFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.io.Closeable;

public class HttpServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    private final IODispatcher<HttpConnectionContext> dispatcher;
    private final HttpContextFactory httpContextFactory;
    private final WaitProcessor rescheduleContext;
    private final ObjList<HttpRequestProcessorSelectorImpl> selectors;
    private final int workerCount;

    public HttpServer(HttpMinServerConfiguration configuration, MessageBus messageBus, Metrics metrics, WorkerPool pool) {
        int i;
        this.workerCount = pool.getWorkerCount();
        this.selectors = new ObjList(this.workerCount);
        for (i = 0; i < this.workerCount; ++i) {
            this.selectors.add(new HttpRequestProcessorSelectorImpl());
        }
        this.httpContextFactory = new HttpContextFactory(configuration.getHttpContextConfiguration(), metrics);
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), this.httpContextFactory);
        pool.assign(this.dispatcher);
        this.rescheduleContext = new WaitProcessor(configuration.getWaitProcessorConfiguration());
        pool.assign(this.rescheduleContext);
        for (i = 0; i < this.workerCount; ++i) {
            final int index = i;
            final SCSequence queryCacheEventSubSeq = new SCSequence();
            FanOut queryCacheEventFanOut = messageBus.getQueryCacheEventFanOut();
            queryCacheEventFanOut.and(queryCacheEventSubSeq);
            pool.assign(i, new Job(){
                private final HttpRequestProcessorSelector selector;
                private final IORequestProcessor<HttpConnectionContext> processor;
                {
                    this.selector = (HttpRequestProcessorSelector)HttpServer.this.selectors.getQuick(index);
                    this.processor = (operation, context) -> context.handleClientOperation(operation, this.selector, HttpServer.this.rescheduleContext);
                }

                @Override
                public boolean run(int workerId) {
                    long seq = queryCacheEventSubSeq.next();
                    if (seq > -1L) {
                        LOG.info().$("flushing HTTP server query cache [worker=").$(workerId).$(']').$();
                        QueryCache queryCache = QueryCache.getWeakThreadLocalInstance();
                        if (queryCache != null) {
                            queryCache.clear();
                        }
                        queryCacheEventSubSeq.done(seq);
                    }
                    boolean useful = HttpServer.this.dispatcher.processIOQueue(this.processor);
                    return useful |= HttpServer.this.rescheduleContext.runReruns(this.selector);
                }
            });
            pool.assignThreadLocalCleaner(i, () -> {
                this.httpContextFactory.freeThreadLocal();
                Misc.free(QueryCache.getWeakThreadLocalInstance());
            });
            pool.freeOnExit(() -> {
                messageBus.getQueryCacheEventFanOut().remove(queryCacheEventSubSeq);
                queryCacheEventSubSeq.clear();
            });
        }
    }

    public static void addDefaultEndpoints(HttpServer server, final HttpServerConfiguration configuration, final CairoEngine cairoEngine, final WorkerPool workerPool, final int sharedWorkerCount, final HttpRequestProcessorBuilder jsonQueryProcessorBuilder, final FunctionFactoryCache functionFactoryCache, final DatabaseSnapshotAgent snapshotAgent) {
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public String getUrl() {
                return "/exec";
            }

            @Override
            public HttpRequestProcessor newInstance() {
                return jsonQueryProcessorBuilder.newInstance();
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public String getUrl() {
                return "/imp";
            }

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextImportProcessor(cairoEngine);
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public String getUrl() {
                return "/exp";
            }

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, workerPool.getWorkerCount(), sharedWorkerCount, functionFactoryCache, snapshotAgent);
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public String getUrl() {
                return "/chk";
            }

            @Override
            public HttpRequestProcessor newInstance() {
                return new TableStatusCheckProcessor(cairoEngine, configuration.getJsonQueryProcessorConfiguration());
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public String getUrl() {
                return "*";
            }

            @Override
            public HttpRequestProcessor newInstance() {
                return new StaticContentProcessor(configuration);
            }
        });
    }

    public void bind(HttpRequestProcessorFactory factory) {
        this.bind(factory, false);
    }

    public void bind(HttpRequestProcessorFactory factory, boolean useAsDefault) {
        String url = factory.getUrl();
        assert (url != null);
        for (int i = 0; i < this.workerCount; ++i) {
            HttpRequestProcessorSelectorImpl selector = this.selectors.getQuick(i);
            if ("*".equals(url)) {
                selector.defaultRequestProcessor = factory.newInstance();
                continue;
            }
            HttpRequestProcessor processor = factory.newInstance();
            selector.processorMap.put(url, processor);
            if (!useAsDefault) continue;
            selector.defaultRequestProcessor = processor;
        }
    }

    @Override
    public void close() {
        Misc.free(this.dispatcher);
        Misc.free(this.rescheduleContext);
        Misc.freeObjListAndClear(this.selectors);
        Misc.free(this.httpContextFactory);
    }

    private static class HttpRequestProcessorSelectorImpl
    implements HttpRequestProcessorSelector {
        private final CharSequenceObjHashMap<HttpRequestProcessor> processorMap = new CharSequenceObjHashMap();
        private HttpRequestProcessor defaultRequestProcessor = null;

        private HttpRequestProcessorSelectorImpl() {
        }

        @Override
        public void close() {
            Misc.freeIfCloseable(this.defaultRequestProcessor);
            ObjList<CharSequence> processorKeys = this.processorMap.keys();
            int n = processorKeys.size();
            for (int i = 0; i < n; ++i) {
                Misc.freeIfCloseable(this.processorMap.get(processorKeys.getQuick(i)));
            }
        }

        @Override
        public HttpRequestProcessor getDefaultProcessor() {
            return this.defaultRequestProcessor;
        }

        @Override
        public HttpRequestProcessor select(CharSequence url) {
            return this.processorMap.get(url);
        }
    }

    private static class HttpContextFactory
    extends MutableIOContextFactory<HttpConnectionContext> {
        public HttpContextFactory(HttpContextConfiguration configuration, Metrics metrics) {
            super(() -> new HttpConnectionContext(configuration, metrics), configuration.getConnectionPoolInitialCapacity());
        }
    }

    @FunctionalInterface
    public static interface HttpRequestProcessorBuilder {
        public HttpRequestProcessor newInstance();
    }
}

