/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.ReadableProperties;

public class StandardReadableProperties
implements ReadableProperties {
    private final Properties rawProperties = new Properties();

    public StandardReadableProperties(Properties properties) {
        this.rawProperties.putAll((Map<?, ?>)properties);
    }

    public StandardReadableProperties(Map<String, String> properties) {
        this.rawProperties.putAll(properties);
    }

    @Override
    public String getProperty(String key) {
        return this.rawProperties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.rawProperties.getProperty(key, defaultValue);
    }

    @Override
    public Set<String> getPropertyKeys() {
        HashSet<String> propertyNames = new HashSet<String>();
        Enumeration<?> e = this.rawProperties.propertyNames();
        while (e.hasMoreElements()) {
            propertyNames.add((String)e.nextElement());
        }
        return propertyNames;
    }

    protected Properties getRawProperties() {
        return this.rawProperties;
    }

    public int size() {
        return this.rawProperties.size();
    }
}

