/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.logging.ComponentLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);
    private static Map<Class<?>, Map<Annotations, List<Method>>> annotationCache = new WeakHashMap();

    public static void invokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ReflectionUtils.invokeMethodsWithAnnotations(annotation, null, instance, args);
    }

    public static void invokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray;
        if (alternateAnnotation != null) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = preferredAnnotation;
            classArray = classArray2;
            classArray2[1] = alternateAnnotation;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = preferredAnnotation;
        }
        Class[] annotationArray = classArray;
        ReflectionUtils.invokeMethodsWithAnnotations(false, null, instance, annotationArray, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(annotation, null, instance, null, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, ComponentLog logger, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(annotation, null, instance, logger, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(preferredAnnotation, alternateAnnotation, instance, null, args);
    }

    private static boolean invokeMethodsWithAnnotations(boolean quietly, ComponentLog logger, Object instance, Class<? extends Annotation>[] annotations, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionUtils.invokeMethodsWithAnnotations(quietly, logger, instance, instance.getClass(), annotations, args);
    }

    private static boolean invokeMethodsWithAnnotations(boolean quietly, ComponentLog logger, Object instance, Class<?> clazz, Class<? extends Annotation>[] annotations, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean isSuccess = true;
        List<Method> methods = ReflectionUtils.findMethodsWithAnnotations(clazz, annotations);
        for (Method method : methods) {
            Object[] modifiedArgs = ReflectionUtils.buildUpdatedArgumentsList(quietly, method, annotations, logger, args);
            if (modifiedArgs == null) continue;
            try {
                method.invoke(instance, modifiedArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                isSuccess = false;
                if (quietly) {
                    Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                    ReflectionUtils.logErrorMessage("Failed while invoking annotated method '" + method + "' with arguments '" + Arrays.asList(modifiedArgs) + "'.", logger, cause);
                    continue;
                }
                throw e;
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> findMethodsWithAnnotations(Class<?> clazz, Class<? extends Annotation>[] annotationClasses) {
        Annotations annotations = new Annotations(annotationClasses);
        Map<Class<?>, Map<Annotations, List<Method>>> map = annotationCache;
        synchronized (map) {
            List<Method> methods;
            Map<Annotations, List<Method>> innerMap = annotationCache.get(clazz);
            if (innerMap != null && (methods = innerMap.get(annotations)) != null) {
                return methods;
            }
        }
        List<Method> methods = ReflectionUtils.discoverMethodsWithAnnotations(clazz, annotationClasses);
        Map<Class<?>, Map<Annotations, List<Method>>> map2 = annotationCache;
        synchronized (map2) {
            Map innerMap = annotationCache.computeIfAbsent(clazz, key -> new ConcurrentHashMap());
            innerMap.putIfAbsent(annotations, methods);
        }
        return methods;
    }

    private static List<Method> discoverMethodsWithAnnotations(Class<?> clazz, Class<? extends Annotation>[] annotations) {
        Comparator<Method> comparator = Comparator.comparing(Method::getName).thenComparing(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return this.createString(o1.getParameterTypes()).compareTo(this.createString(o2.getParameterTypes()));
            }

            private String createString(Class<?>[] parameters) {
                StringBuilder sb = new StringBuilder();
                for (Class<?> param : parameters) {
                    sb.append(param).append(",");
                }
                return sb.toString();
            }
        });
        TreeSet<Method> methods = new TreeSet<Method>(comparator);
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isAnyAnnotationPresent(method, annotations)) continue;
            methods.add(method);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            List<Method> superMethods = ReflectionUtils.discoverMethodsWithAnnotations(superClass, annotations);
            methods.addAll(superMethods);
        }
        return new ArrayList<Method>(methods);
    }

    private static boolean isAnyAnnotationPresent(Method method, Class<? extends Annotation>[] annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!ReflectionUtils.isAnnotationPresent(method, annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        Annotation annotation = method.getAnnotation(annotationClass);
        return annotation != null;
    }

    private static Object[] buildUpdatedArgumentsList(boolean quietly, Method method, Class<?>[] annotations, ComponentLog processLogger, Object ... args) {
        boolean parametersCompatible = true;
        int argsCount = 0;
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; parametersCompatible && i < paramTypes.length && i < args.length; ++i) {
            if (paramTypes[i].isAssignableFrom(args[i].getClass())) {
                ++argsCount;
                continue;
            }
            ReflectionUtils.logErrorMessage("Can not invoke method '" + method + "' with provided arguments since argument " + i + " of type '" + paramTypes[i] + "' is not assignable from provided value of type '" + args[i].getClass() + "'.", processLogger, null);
            if (quietly) {
                parametersCompatible = false;
                continue;
            }
            ++argsCount;
        }
        Object[] updatedArguments = null;
        if (parametersCompatible) {
            updatedArguments = Arrays.copyOf(args, argsCount);
        }
        return updatedArguments;
    }

    private static void logErrorMessage(String message, ComponentLog processLogger, Throwable e) {
        if (processLogger != null) {
            if (e != null) {
                processLogger.error(message, e);
            } else {
                processLogger.error(message);
            }
        } else if (e != null) {
            LOG.error(message, e);
        } else {
            LOG.error(message);
        }
    }

    public static boolean quietlyInvokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, ComponentLog logger, Object ... args) {
        Class[] classArray;
        if (alternateAnnotation != null) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = preferredAnnotation;
            classArray = classArray2;
            classArray2[1] = alternateAnnotation;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = preferredAnnotation;
        }
        Class[] annotationArray = classArray;
        try {
            return ReflectionUtils.invokeMethodsWithAnnotations(true, logger, instance, annotationArray, args);
        }
        catch (Exception e) {
            LOG.error("Failed while attempting to invoke methods with '" + Arrays.asList(annotationArray) + "' annotations", (Throwable)e);
            return false;
        }
    }

    private static class Annotations {
        private final Class<? extends Annotation>[] array;

        public Annotations(Class<? extends Annotation>[] array) {
            this.array = array;
        }

        public Class<? extends Annotation>[] getArray() {
            return this.array;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof Annotations)) {
                return false;
            }
            Annotations otherAnnotations = (Annotations)other;
            return Arrays.equals(this.array, otherAnnotations.array);
        }
    }
}

