/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Set;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.service.ControllerServiceProvider;

public class ComponentSpecificControllerServiceLookup
implements ControllerServiceLookup {
    private final ControllerServiceProvider serviceProvider;
    private final String componentId;
    private final String groupId;

    public ComponentSpecificControllerServiceLookup(ControllerServiceProvider serviceProvider, String componentId, String groupId) {
        this.serviceProvider = serviceProvider;
        this.componentId = componentId;
        this.groupId = groupId;
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.serviceProvider.getControllerServiceForComponent(serviceIdentifier, this.componentId);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.serviceProvider.isControllerServiceEnabled(service);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) throws IllegalArgumentException {
        return this.serviceProvider.getControllerServiceIdentifiers(serviceType, this.groupId);
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.serviceProvider.getControllerServiceName(serviceIdentifier);
    }
}

