/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import jetbrains.exodus.ByteIterator;
import org.jetbrains.annotations.NotNull;

public interface ByteIterable
extends Comparable<ByteIterable> {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final ByteIterator EMPTY_ITERATOR = new ByteIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public byte next() {
            return 0;
        }

        @Override
        public long skip(long bytes) {
            return 0L;
        }
    };
    public static final ByteIterable EMPTY = new ByteIterable(){

        @Override
        public ByteIterator iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int compareTo(@NotNull ByteIterable right) {
            return right.iterator().hasNext() ? -1 : 0;
        }

        @Override
        public byte[] getBytesUnsafe() {
            return EMPTY_BYTES;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        @NotNull
        public ByteIterable subIterable(int offset, int length) {
            return this;
        }

        public String toString() {
            return "[ByteIterable.EMPTY]";
        }
    };

    public ByteIterator iterator();

    public byte[] getBytesUnsafe();

    public int getLength();

    @NotNull
    public ByteIterable subIterable(int var1, int var2);
}

