/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.cache.WriteableConfiguration;
import org.apache.nifi.minifi.c2.api.util.DelegatingOutputStream;
import org.apache.nifi.minifi.c2.cache.filesystem.FileSystemConfigurationCache;

public class FileSystemWritableConfiguration
implements WriteableConfiguration {
    private final FileSystemConfigurationCache cache;
    private final Path path;
    private final String version;

    public FileSystemWritableConfiguration(FileSystemConfigurationCache cache, Path path, String version) {
        this.cache = cache;
        this.path = path;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public OutputStream getOutputStream() throws ConfigurationProviderException {
        try {
            Path parent = this.path.getParent();
            Files.createDirectories(parent, new FileAttribute[0]);
            final Path tmpPath = this.cache.resolveChildAndVerifyParent(parent, this.path.getFileName().toString() + "." + UUID.randomUUID().toString());
            return new DelegatingOutputStream(Files.newOutputStream(tmpPath, new OpenOption[0])){

                public void close() throws IOException {
                    super.close();
                    Files.move(tmpPath, FileSystemWritableConfiguration.this.path, new CopyOption[0]);
                }
            };
        }
        catch (IOException e) {
            throw new ConfigurationProviderException("Unable to open " + this.path + " for writing.", (Throwable)e);
        }
    }

    public InputStream getInputStream() throws ConfigurationProviderException {
        try {
            return Files.newInputStream(this.path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            if (Files.exists(this.path, new LinkOption[0])) {
                throw new ConfigurationProviderException("Unable to open " + this.path + " for reading.", (Throwable)e);
            }
            throw new InvalidParameterException("File not found: " + this.path, (Throwable)e);
        }
    }

    public URL getURL() throws ConfigurationProviderException {
        try {
            return this.path.toUri().toURL();
        }
        catch (MalformedURLException murle) {
            throw new ConfigurationProviderException("Could not determine URL of " + this.path, (Throwable)murle);
        }
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public String toString() {
        return "FileSystemWritableConfiguration{path=" + this.path + ", version='" + this.version + "'}";
    }
}

