/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.rpm;

import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import org.apache.netbeans.nbpackage.Template;
import org.apache.netbeans.nbpackage.rpm.RpmTask;

public class RpmPackager
implements Packager {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle(RpmPackager.class.getPackageName() + ".Messages");
    static final Option<Path> ICON_PATH = Option.ofPath("package.rpm.icon", MESSAGES.getString("option.icon.help"));
    static final Option<Path> SVG_ICON_PATH = Option.ofPath("package.rpm.svg-icon", MESSAGES.getString("option.svg.help"));
    static final Option<String> DESKTOP_FILENAME = Option.ofString("package.rpm.desktop-filename", MESSAGES.getString("option.desktopfilename.help"));
    static final Option<String> DESKTOP_WMCLASS = Option.ofString("package.rpm.wmclass", MESSAGES.getString("option.wmclass.default"), MESSAGES.getString("option.wmclass.help"));
    static final Option<String> DESKTOP_CATEGORY = Option.ofString("package.rpm.category", MESSAGES.getString("option.category.default"), MESSAGES.getString("option.category.help"));
    static final Option<String> RPM_MAINTAINER = Option.ofString("package.rpm.maintainer", MESSAGES.getString("option.maintainer.help"));
    static final Option<String> RPM_LICENSE = Option.ofString("package.rpm.license", MESSAGES.getString("option.license.default"), MESSAGES.getString("option.license.help"));
    static final Option<String> RPM_GROUP = Option.ofString("package.rpm.group", MESSAGES.getString("option.group.default"), MESSAGES.getString("option.group.help"));
    static final Option<Path> SPEC_TEMPLATE_PATH = Option.ofPath("package.rpm.spec-template", MESSAGES.getString("option.control_template.help"));
    static final Template SPEC_TEMPLATE = Template.of(SPEC_TEMPLATE_PATH, "rpm.spec.template", () -> RpmPackager.class.getResourceAsStream("rpm.spec.template"));
    static final Option<Path> DESKTOP_TEMPLATE_PATH = Option.ofPath("package.rpm.desktop-template", MESSAGES.getString("option.desktop_template.help"));
    static final Template DESKTOP_TEMPLATE = Template.of(DESKTOP_TEMPLATE_PATH, "rpm.desktop.template", () -> RpmPackager.class.getResourceAsStream("rpm.desktop.template"));
    static final Option<Path> LAUNCHER_TEMPLATE_PATH = Option.ofPath("package.rpm.launcher-template", MESSAGES.getString("option.launcher_template.help"));
    static final Template LAUNCHER_TEMPLATE = Template.of(LAUNCHER_TEMPLATE_PATH, "rpm.launcher.template", () -> RpmPackager.class.getResourceAsStream("rpm.launcher.template"));
    private static final List<Option<?>> RPM_OPTIONS = List.of(ICON_PATH, SVG_ICON_PATH, DESKTOP_FILENAME, DESKTOP_WMCLASS, DESKTOP_CATEGORY, RPM_MAINTAINER, RPM_LICENSE, RPM_GROUP, SPEC_TEMPLATE_PATH, DESKTOP_TEMPLATE_PATH, LAUNCHER_TEMPLATE_PATH);
    private static final List<Template> RPM_TEMPLATES = List.of(SPEC_TEMPLATE, DESKTOP_TEMPLATE, LAUNCHER_TEMPLATE);

    @Override
    public Packager.Task createTask(ExecutionContext context) {
        return new RpmTask(context);
    }

    @Override
    public String name() {
        return "linux-rpm";
    }

    @Override
    public Stream<Option<?>> options() {
        return RPM_OPTIONS.stream();
    }

    @Override
    public Stream<Template> templates() {
        return RPM_TEMPLATES.stream();
    }
}

