/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.text.MessageFormat;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.netbeans.nbpackage.NBPackage;

public class StringUtils {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    private StringUtils() {
    }

    public static String replaceTokens(String input, Map<String, String> tokenValues) {
        return StringUtils.replaceTokensImpl(input, tokenValues::get, true);
    }

    public static String replaceTokensOrFail(String input, Map<String, String> tokenValues) {
        return StringUtils.replaceTokensImpl(input, tokenValues::get, false);
    }

    public static String replaceTokens(String input, Function<String, String> tokenValueSource) {
        return StringUtils.replaceTokensImpl(input, tokenValueSource, true);
    }

    public static String replaceTokensOrFail(String input, Function<String, String> tokenValueSource) {
        return StringUtils.replaceTokensImpl(input, tokenValueSource, false);
    }

    private static String replaceTokensImpl(String input, Function<String, String> tokenSource, boolean lenient) {
        Matcher matcher = TOKEN_PATTERN.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String token = matcher.group(1);
            Object replacement = tokenSource.apply(token);
            if (replacement == null) {
                if (lenient) {
                    replacement = "${" + token + "}";
                } else {
                    String msg = MessageFormat.format(NBPackage.MESSAGES.getString("message.invalidtoken"), token);
                    throw new IllegalArgumentException(msg);
                }
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement((String)replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

