/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ant.ui.VariablesModel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class VariablePanel
extends JPanel
implements DocumentListener {
    private VariablesModel model;
    private DialogDescriptor dd;
    private VariablesModel.Variable variableBeingEditted;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField locationTextField;
    private JTextField nameTextField;

    public VariablePanel(VariablesModel model, VariablesModel.Variable variableBeingEditted) {
        this.model = model;
        this.variableBeingEditted = variableBeingEditted;
        this.initComponents();
        if (variableBeingEditted != null) {
            this.nameTextField.setText(variableBeingEditted.getName());
            this.nameTextField.setEditable(false);
            this.locationTextField.setText(variableBeingEditted.getValue().getAbsolutePath());
        }
        this.nameTextField.getDocument().addDocumentListener(this);
        this.locationTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameTextField = new JTextField();
        this.locationTextField = new JTextField();
        this.browseButton = new JButton();
        this.errorLabel = new JLabel();
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText(this.jLabel1, NbBundle.getMessage(VariablePanel.class, "VariablePanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.locationTextField);
        Mnemonics.setLocalizedText(this.jLabel2, NbBundle.getMessage(VariablePanel.class, "VariablePanel.jLabel2.text"));
        Mnemonics.setLocalizedText(this.browseButton, NbBundle.getMessage(VariablePanel.class, "VariablePanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariablePanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.errorLabel.setForeground(Color.red);
        Mnemonics.setLocalizedText(this.errorLabel, " ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, -1, 413, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField, -1, 242, Short.MAX_VALUE).addComponent(this.locationTextField, -1, 242, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.browseButton).addComponent(this.locationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.locationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariablePanel.class, "ACSD_VariablePanel_NA"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getBundle(VariablePanel.class).getString("MSG_Choose_Folder"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile(chooser.getSelectedFile());
            this.locationTextField.setText(file.getAbsolutePath());
        }
    }

    void setDialogDescriptor(DialogDescriptor dd) {
        assert (this.dd == null);
        this.dd = dd;
        this.checkValidity();
    }

    private void checkValidity() {
        String error = null;
        if (this.nameTextField.getText().length() == 0) {
            error = NbBundle.getBundle(VariablePanel.class).getString("MSG_Invalid_Name");
        } else if (this.variableBeingEditted == null && this.model.find(this.nameTextField.getText()) != null) {
            error = NbBundle.getBundle(VariablePanel.class).getString("MSG_Variable_Already_Exists");
        } else if (this.locationTextField.getText().length() == 0 || !this.getVariableLocation().exists()) {
            error = NbBundle.getBundle(VariablePanel.class).getString("MSG_Invalid_Location");
        } else if (this.variableBeingEditted == null && !PropertyUtils.isUsablePropertyName(this.nameTextField.getText())) {
            error = NbBundle.getBundle(VariablePanel.class).getString("MSG_Invalid_Name");
        }
        this.dd.setValid(error == null);
        this.errorLabel.setText(error == null ? " " : error);
    }

    public String getVariableName() {
        return this.nameTextField.getText();
    }

    public File getVariableLocation() {
        return FileUtil.normalizeFile(new File(this.locationTextField.getText()));
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.checkValidity();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.checkValidity();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.checkValidity();
    }
}

