/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.parsing.impl.indexing.ArchiveTimeStamps;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.ConstrainedBinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class ProxyBinaryIndexerFactory
extends BinaryIndexerFactory {
    private static final String ATTR_DELEGATE = "delegate";
    private static final String ATTR_INDEXER_NAME = "name";
    private static final String ATTR_INDEXER_VERSION = "version";
    private static final String ATTR_REQUIRED_RES = "requiredResource";
    private static final String ATTR_REQUIRED_MIME = "mimeType";
    private static final String ATTR_NAME_PATTERN = "namePattern";
    private static final String PROP_CHECKED = "ProxyBinaryIndexerFactory_checked";
    private static final String PROP_MATCHED_FILES = "ProxyBinaryIndexerFactory_matchedFiles";
    private static final String MIME_UNKNOWN = "content/unknown";
    private static final int USED = 1;
    private final Map<String, Object> params;
    private final String indexerName;
    private final int indexerVersion;
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Set<URL> activeRoots;

    public ProxyBinaryIndexerFactory(@NonNull Map<String, Object> params) {
        Parameters.notNull("params", params);
        this.params = params;
        this.indexerName = (String)params.get(ATTR_INDEXER_NAME);
        Parameters.notNull("indexerName", this.indexerName);
        Integer iv = (Integer)params.get(ATTR_INDEXER_VERSION);
        Parameters.notNull(ATTR_INDEXER_VERSION, iv);
        this.indexerVersion = iv;
        this.activeRoots = new HashSet<URL>();
    }

    @Override
    public String getIndexerName() {
        return this.indexerName;
    }

    @Override
    public int getIndexVersion() {
        return this.indexerVersion;
    }

    @Override
    public BinaryIndexer createIndexer() {
        return new Indexer();
    }

    @Override
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part. Already verified by PathRegistry and RepositoryUpdater.")
    public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        HashSet<URL> filtered = new HashSet<URL>();
        for (URL uRL : removedRoots) {
            if (!this.activeRoots.remove(uRL)) continue;
            filtered.add(uRL);
        }
        if (!filtered.isEmpty()) {
            SPIAccessor.getInstance().rootsRemoved(this.getDelegate(), Collections.unmodifiableSet(filtered));
        }
    }

    @Override
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part. Already verified by PathRegistry and RepositoryUpdater.")
    public boolean scanStarted(Context context) {
        if (this.supports(context) != null) {
            return SPIAccessor.getInstance().scanStarted(this.getDelegate(), context);
        }
        boolean vote = true;
        if (ProxyBinaryIndexerFactory.isUpToDate(context) && ArchiveTimeStamps.getIndexerState(context) == 1) {
            vote = SPIAccessor.getInstance().scanStarted(this.getDelegate(), context);
            if (!vote) {
                SPIAccessor.getInstance().putProperty(context, PROP_CHECKED, Boolean.FALSE);
            } else {
                this.activeRoots.add(context.getRootURI());
            }
        }
        return vote;
    }

    @Override
    public void scanFinished(Context context) {
        if (this.supports(context) != null) {
            SPIAccessor.getInstance().scanFinished(this.getDelegate(), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private Map<String, ? extends Iterable<? extends FileObject>> supports(@NonNull Context ctx) {
        FileObject root = ctx.getRoot();
        if (root == null) {
            return null;
        }
        if (Boolean.TRUE == SPIAccessor.getInstance().getProperty(ctx, PROP_CHECKED)) {
            return (Map)SPIAccessor.getInstance().getProperty(ctx, PROP_MATCHED_FILES);
        }
        HashMap<String, ArrayDeque<FileObject>> matchedFiles = new HashMap<String, ArrayDeque<FileObject>>();
        String s = (String)this.params.get(ATTR_REQUIRED_RES);
        String[] requiredResources = s == null ? null : s.split(",");
        s = (String)this.params.get(ATTR_REQUIRED_MIME);
        String[] mimeTypes = s == null ? null : s.split(",");
        s = (String)this.params.get(ATTR_NAME_PATTERN);
        Pattern pattern = s == null ? null : Pattern.compile(s);
        try {
            if (ProxyBinaryIndexerFactory.isUpToDate(ctx)) {
                Map<String, ? extends Iterable<? extends FileObject>> map = null;
                return map;
            }
            if (requiredResources != null) {
                boolean found = false;
                for (String r : requiredResources) {
                    if (root.getFileObject(r) == null) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Map<String, ? extends Iterable<? extends FileObject>> map = null;
                    return map;
                }
            }
            if (mimeTypes != null || pattern != null) {
                HashSet<String> hashSet;
                Enumeration<? extends FileObject> fos = root.getChildren(true);
                HashSet<String> hashSet2 = hashSet = mimeTypes == null ? null : new HashSet<String>(Arrays.asList(mimeTypes));
                while (fos.hasMoreElements()) {
                    String name;
                    FileObject f = fos.nextElement();
                    if (pattern != null && !pattern.matcher(name = f.getNameExt()).matches()) continue;
                    String mt = MIME_UNKNOWN;
                    if (mimeTypes != null && !hashSet.contains(mt = f.getMIMEType(mimeTypes))) continue;
                    ArrayDeque<FileObject> q = (ArrayDeque<FileObject>)matchedFiles.get(mt);
                    if (q == null) {
                        q = new ArrayDeque<FileObject>();
                        matchedFiles.put(mt, q);
                    }
                    q.offer(f);
                }
                if (matchedFiles.isEmpty()) {
                    Map<String, ? extends Iterable<? extends FileObject>> map = null;
                    return map;
                }
            }
            Map res = Collections.unmodifiableMap(matchedFiles);
            SPIAccessor.getInstance().putProperty(ctx, PROP_MATCHED_FILES, res);
            Map map = res;
            return map;
        }
        finally {
            SPIAccessor.getInstance().putProperty(ctx, PROP_CHECKED, Boolean.TRUE);
        }
    }

    @NonNull
    private ConstrainedBinaryIndexer getDelegate() {
        Object delegate = this.params.get(ATTR_DELEGATE);
        if (!(delegate instanceof ConstrainedBinaryIndexer)) {
            throw new IllegalArgumentException(String.format("Invalid indexer %s registered as %s %d", delegate, this.indexerName, this.indexerVersion));
        }
        return (ConstrainedBinaryIndexer)delegate;
    }

    private static boolean isUpToDate(@NonNull Context ctx) {
        return !ctx.isAllFilesIndexing();
    }

    private final class Indexer
    extends BinaryIndexer {
        private Indexer() {
        }

        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part. Already verified by PathRegistry and RepositoryUpdater.")
        protected void index(@NonNull Context context) {
            Map matchedFiles = ProxyBinaryIndexerFactory.this.supports(context);
            if (matchedFiles != null) {
                ProxyBinaryIndexerFactory.this.activeRoots.add(context.getRootURI());
                SPIAccessor.getInstance().index(ProxyBinaryIndexerFactory.this.getDelegate(), matchedFiles, context);
                ArchiveTimeStamps.setIndexerState(context, 1);
            }
        }
    }
}

