/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import jpt.sun.tools.javac.api.JavacTrees;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaIndexerPlugin;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.indexing.CheckSums;
import org.netbeans.modules.java.source.indexing.FQN2Files;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.SourceAnalyzerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public final class JavaParsingContext {
    private final Context ctx;
    private final boolean rootNotNeeded;
    private final ClasspathInfo cpInfo;
    private final ClassIndexImpl uq;
    private SourceLevelQuery.Result sourceLevel;
    private boolean sourceLevelInitialized;
    private JavaFileFilterImplementation filter;
    private boolean filterInitialized;
    private Charset encoding;
    private boolean encodingInitialized;
    private SourceAnalyzerFactory.StorableAnalyzer sa;
    private CheckSums checkSums;
    private FQN2Files fqn2Files;
    private Iterable<? extends JavaIndexerPlugin> pluginsCache;
    private ProcessorGenerated processorGenerated;

    JavaParsingContext(Context context, boolean allowNonExistentRoot) throws IOException {
        this.ctx = context;
        this.rootNotNeeded = allowNonExistentRoot && context.getRoot() == null;
        this.uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
        if (!this.rootNotNeeded) {
            ClassPath moduleSrcPath;
            ClassPath srcPath;
            ClassPath moduleClassPath;
            ClassPath moduleCompilePath;
            ClassPath compilePath;
            ClassPath moduleBootPath;
            ClassPath bootPath = ClassPath.getClassPath(this.ctx.getRoot(), "classpath/boot");
            if (bootPath == null) {
                bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
            }
            if ((moduleBootPath = ClassPath.getClassPath(this.ctx.getRoot(), "modules/boot")) == null) {
                moduleBootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
            }
            if ((compilePath = ClassPath.getClassPath(this.ctx.getRoot(), "classpath/compile")) == null) {
                compilePath = ClassPath.EMPTY;
            }
            if ((moduleCompilePath = ClassPath.getClassPath(this.ctx.getRoot(), "modules/compile")) == null) {
                moduleCompilePath = ClassPath.EMPTY;
            }
            if ((moduleClassPath = ClassPath.getClassPath(this.ctx.getRoot(), "modules/classpath")) == null) {
                moduleClassPath = ClassPath.EMPTY;
            }
            if ((srcPath = ClassPath.getClassPath(this.ctx.getRoot(), "classpath/source")) == null) {
                srcPath = ClassPath.EMPTY;
            }
            if ((moduleSrcPath = ClassPath.getClassPath(this.ctx.getRoot(), "modules/source")) == null) {
                moduleSrcPath = ClassPath.EMPTY;
            }
            this.cpInfo = ClasspathInfoAccessor.getINSTANCE().create(bootPath, moduleBootPath, compilePath, moduleCompilePath, moduleClassPath, srcPath, moduleSrcPath, null, true, context.isSourceForBinaryRootIndexing(), false, context.checkForEditorModifications(), false, null);
        } else {
            this.cpInfo = null;
        }
    }

    public JavaParsingContext(Context context, ClassPath bootPath, ClassPath moduleBootPath, ClassPath compilePath, ClassPath moduleCompilePath, ClassPath moduleClassPath, ClassPath sourcePath, ClassPath moduleSourcePath, Collection<? extends JavaCustomIndexer.CompileTuple> virtualSources) throws IOException {
        this.ctx = context;
        this.rootNotNeeded = false;
        this.uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
        this.cpInfo = ClasspathInfoAccessor.getINSTANCE().create(bootPath, moduleBootPath, compilePath, moduleCompilePath, moduleClassPath, sourcePath, moduleSourcePath, this.filter, true, context.isSourceForBinaryRootIndexing(), !virtualSources.isEmpty(), context.checkForEditorModifications(), true, null);
        JavaParsingContext.registerVirtualSources(this.cpInfo, virtualSources);
    }

    @CheckForNull
    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    @CheckForNull
    ClassIndexImpl getClassIndexImpl() throws IOException {
        return this.uq;
    }

    @CheckForNull
    public String getSourceLevel() {
        SourceLevelQuery.Result sl = this.initSourceLevel();
        return sl == null ? null : sl.getSourceLevel();
    }

    @CheckForNull
    public SourceLevelQuery.Profile getProfile() {
        SourceLevelQuery.Result sl = this.initSourceLevel();
        return sl == null ? null : sl.getProfile();
    }

    @CheckForNull
    JavaFileFilterImplementation getJavaFileFilter() {
        if (!this.filterInitialized) {
            this.filter = this.rootNotNeeded ? null : JavaFileFilterQuery.getFilter(this.ctx.getRoot());
            this.filterInitialized = true;
        }
        return this.filter;
    }

    @CheckForNull
    Charset getEncoding() {
        if (!this.encodingInitialized) {
            this.encoding = this.rootNotNeeded ? null : FileEncodingQuery.getEncoding(this.ctx.getRoot());
            this.encodingInitialized = true;
        }
        return this.encoding;
    }

    @CheckForNull
    SourceAnalyzerFactory.StorableAnalyzer getSourceAnalyzer() throws IOException {
        if (this.sa == null) {
            this.sa = this.uq == null ? null : this.uq.getSourceAnalyser();
        }
        return this.sa;
    }

    @NonNull
    public CheckSums getCheckSums() throws IOException {
        if (this.checkSums == null) {
            try {
                this.checkSums = CheckSums.forContext(this.ctx);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }
        return this.checkSums;
    }

    @NonNull
    public FQN2Files getFQNs() throws IOException {
        if (this.fqn2Files == null) {
            this.fqn2Files = FQN2Files.forRoot(this.ctx.getRootURI());
        }
        return this.fqn2Files;
    }

    @NonNull
    ProcessorGenerated getProcessorGeneratedFiles() {
        if (this.processorGenerated == null) {
            this.processorGenerated = TransactionContext.get().get(ProcessorGenerated.class);
        }
        return this.processorGenerated;
    }

    @CheckForNull
    public String getModuleName() {
        try {
            return JavaIndex.getAttribute(this.ctx.getRootURI(), "moduleName", null);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void analyze(@NonNull Iterable<? extends CompilationUnitTree> trees, @NonNull JavacTaskImpl jt, @NonNull JavaCustomIndexer.CompileTuple active, @NonNull Set<? super ElementHandle<TypeElement>> newTypes, @NonNull Set<? super ElementHandle<ModuleElement>> newModules, @NonNull boolean[] mainMethod) throws IOException {
        SourceAnalyzerFactory.StorableAnalyzer analyzer = this.getSourceAnalyzer();
        assert (analyzer != null);
        analyzer.analyse(trees, jt, active, newTypes, newModules, mainMethod);
        Lookup pluginServices = this.getPluginServices(jt);
        for (CompilationUnitTree compilationUnitTree : trees) {
            for (JavaIndexerPlugin javaIndexerPlugin : this.getPlugins()) {
                javaIndexerPlugin.process(compilationUnitTree, active.indexable, pluginServices);
            }
        }
    }

    void delete(@NonNull Indexable indexable, @NonNull List<Pair<String, String>> toDelete) throws IOException {
        for (Pair<String, String> pair : toDelete) {
            SourceAnalyzerFactory.StorableAnalyzer analyzer = this.getSourceAnalyzer();
            assert (analyzer != null);
            analyzer.delete(pair);
        }
        for (JavaIndexerPlugin javaIndexerPlugin : this.getPlugins()) {
            javaIndexerPlugin.delete(indexable);
        }
    }

    void store() throws IOException {
        if (this.checkSums != null) {
            this.checkSums.store();
        }
        if (this.fqn2Files != null) {
            this.fqn2Files.store();
        }
        if (this.sa != null) {
            try {
                this.sa.store();
            }
            catch (IOException ioe) {
                throw new BrokenIndexException(ioe);
            }
        }
    }

    void finish() {
        for (JavaIndexerPlugin javaIndexerPlugin : this.getPlugins()) {
            javaIndexerPlugin.finish();
        }
    }

    @NonNull
    private Iterable<? extends JavaIndexerPlugin> getPlugins() {
        if (this.pluginsCache == null) {
            this.pluginsCache = JavaParsingContext.createPlugins(this.ctx.getRootURI(), this.ctx.getIndexFolder());
        }
        return this.pluginsCache;
    }

    private static Iterable<? extends JavaIndexerPlugin> createPlugins(@NonNull URL root, @NonNull FileObject cacheFolder) {
        ArrayList<JavaIndexerPlugin> plugins = new ArrayList<JavaIndexerPlugin>();
        for (JavaIndexerPlugin.Factory factory : MimeLookup.getLookup(MimePath.parse("text/x-java")).lookupAll(JavaIndexerPlugin.Factory.class)) {
            JavaIndexerPlugin plugin = factory.create(root, cacheFolder);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    @NonNull
    private Lookup getPluginServices(JavacTaskImpl jt) {
        return Lookups.fixed(jt.getElements(), jt.getTypes(), JavacTrees.instance(jt.getContext()), JavaSourceAccessor.getINSTANCE().createElementUtilities(jt));
    }

    private SourceLevelQuery.Result initSourceLevel() {
        if (!this.sourceLevelInitialized) {
            this.sourceLevel = this.rootNotNeeded ? null : SourceLevelQuery.getSourceLevel2(this.ctx.getRoot());
            this.sourceLevelInitialized = true;
        }
        return this.sourceLevel;
    }

    private static void registerVirtualSources(ClasspathInfo cpInfo, Collection<? extends JavaCustomIndexer.CompileTuple> virtualSources) {
        for (JavaCustomIndexer.CompileTuple compileTuple : virtualSources) {
            ClasspathInfoAccessor.getINSTANCE().registerVirtualSource(cpInfo, compileTuple.jfo);
        }
    }

    static class BrokenIndexException
    extends IOException {
        private BrokenIndexException(IOException cause) {
            super(cause);
        }
    }
}

