/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class UseSpecificCatchCustomizer
extends JPanel
implements ActionListener,
DocumentListener,
ListSelectionListener {
    private final Preferences prefs;
    private Color textBkColor;
    private JButton btnAddGeneric;
    private JButton btnRemoveGeneric;
    private JLabel lblGenericList;
    private JList lstGenericTypes;
    private JScrollPane scrGenericTypes;
    private JTextField tfNewType;

    public UseSpecificCatchCustomizer(Preferences prefs) {
        this.prefs = prefs;
        this.initComponents();
        this.lstGenericTypes.setModel(new DefaultListModel());
        this.tfNewType.getDocument().addDocumentListener(this);
        this.lstGenericTypes.addListSelectionListener(this);
        this.btnAddGeneric.addActionListener(this);
        this.btnRemoveGeneric.addActionListener(this);
        this.btnRemoveGeneric.setEnabled(false);
        this.initList(this.lstGenericTypes, prefs.get("specificCatch.exceptions", "java.lang.Throwable, java.lang.Exception"));
    }

    private void initList(JList l, String val) {
        StringTokenizer tukac = new StringTokenizer(val, ", ");
        DefaultListModel m = (DefaultListModel)l.getModel();
        while (tukac.hasMoreTokens()) {
            String s = tukac.nextToken();
            if (s.isEmpty()) continue;
            m.addElement(s);
        }
        this.prefs.put("specificCatch.exceptions", val);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        JList lst = (JList)lse.getSource();
        boolean sel = lst.isEnabled() && !lst.isSelectionEmpty();
        this.btnRemoveGeneric.setEnabled(sel);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        Document d = de.getDocument();
        this.updateControls(d, this.checkIdentifier(d));
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        Document d = de.getDocument();
        this.updateControls(d, this.checkIdentifier(d));
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    private void removeSelected(JList list, String prefKey) {
        DefaultListModel m = (DefaultListModel)list.getModel();
        while (!list.isSelectionEmpty()) {
            m.remove(list.getSelectionModel().getLeadSelectionIndex());
        }
        this.updatePreference(list, prefKey);
    }

    private void addNewType(String t, JList list, String prefKey) {
        ((DefaultListModel)list.getModel()).addElement(t);
        list.setSelectedIndex(list.getModel().getSize() - 1);
        this.updatePreference(list, prefKey);
    }

    private void updatePreference(JList list, String prefKey) {
        StringBuilder sb = new StringBuilder(35);
        Enumeration en = ((DefaultListModel)list.getModel()).elements();
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        this.prefs.put(prefKey, sb.toString());
    }

    private void updateControls(JTextField tf, JButton addButton, int state) {
        if (this.textBkColor == null) {
            this.textBkColor = tf.getBackground();
        }
        switch (state) {
            default: {
                tf.setBackground(Color.pink);
                addButton.setEnabled(false);
                break;
            }
            case -1: {
                tf.setBackground(this.textBkColor);
                addButton.setEnabled(false);
                break;
            }
            case 0: {
                tf.setBackground(this.textBkColor);
                addButton.setEnabled(true);
            }
        }
    }

    private void updateControls(Document d, int state) {
        this.updateControls(this.tfNewType, this.btnAddGeneric, state);
    }

    private int checkIdentifier(Document d) {
        String[] parts;
        String text;
        try {
            text = d.getText(0, d.getLength());
        }
        catch (BadLocationException ex) {
            return -1;
        }
        text = text.trim();
        if (text.isEmpty()) {
            return -1;
        }
        for (String s : parts = text.split("\\.", -1)) {
            if (!s.isEmpty() && Utilities.isJavaIdentifier(s)) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.btnRemoveGeneric) {
            this.removeSelected(this.lstGenericTypes, "specificCatch.exceptions");
        } else if (src == this.btnAddGeneric) {
            this.addNewType(this.tfNewType.getText(), this.lstGenericTypes, "specificCatch.exceptions");
        }
    }

    private void initComponents() {
        this.lblGenericList = new JLabel();
        this.scrGenericTypes = new JScrollPane();
        this.lstGenericTypes = new JList();
        this.btnRemoveGeneric = new JButton();
        this.tfNewType = new JTextField();
        this.btnAddGeneric = new JButton();
        this.setPreferredSize(new Dimension(360, 121));
        Mnemonics.setLocalizedText(this.lblGenericList, NbBundle.getMessage(UseSpecificCatchCustomizer.class, "UseSpecificCatchCustomizer.lblGenericList.text"));
        this.lstGenericTypes.setVisibleRowCount(5);
        this.scrGenericTypes.setViewportView(this.lstGenericTypes);
        Mnemonics.setLocalizedText(this.btnRemoveGeneric, NbBundle.getMessage(UseSpecificCatchCustomizer.class, "UseSpecificCatchCustomizer.btnRemoveGeneric.text"));
        this.tfNewType.setText(NbBundle.getMessage(UseSpecificCatchCustomizer.class, "UseSpecificCatchCustomizer.tfNewType.text"));
        Mnemonics.setLocalizedText(this.btnAddGeneric, NbBundle.getMessage(UseSpecificCatchCustomizer.class, "UseSpecificCatchCustomizer.btnAddGeneric.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrGenericTypes, GroupLayout.Alignment.LEADING).addComponent(this.tfNewType, GroupLayout.Alignment.LEADING)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRemoveGeneric, -1, -1, Short.MAX_VALUE).addComponent(this.btnAddGeneric, -2, 89, -2))).addGroup(layout.createSequentialGroup().addComponent(this.lblGenericList).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblGenericList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrGenericTypes, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfNewType, -2, -1, -2).addComponent(this.btnAddGeneric))).addComponent(this.btnRemoveGeneric))));
    }
}

