/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import jpt.sun.source.tree.EnhancedForLoopTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.ParameterizedTypeTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.tools.javac.code.Type;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.jdk.ConvertVarToExplicitType;
import org.netbeans.modules.java.hints.suggestions.ExpandEnhancedForLoop;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertToVarHint {
    private static final String[] SKIPPED_ERROR_CODES = new String[]{"compiler.err.generic.array.creation"};

    public static ErrorDescription computeExplicitToVarType(HintContext ctx) {
        if (!ConvertToVarHint.preConditionChecker(ctx)) {
            return null;
        }
        if (!ConvertToVarHint.isValidVarType(ctx)) {
            return null;
        }
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.MSG_ConvertibleToVarType(), new JavaFixImpl(ctx.getInfo(), ctx.getPath()).toEditorFix());
    }

    private static boolean preConditionChecker(HintContext ctx) {
        CompilationInfo info = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        if (!ConvertVarToExplicitType.isVariableValidForVarHint(ctx)) {
            return false;
        }
        if (ctx.getInfo().getTreeUtilities().hasError(treePath.getLeaf(), SKIPPED_ERROR_CODES)) {
            return false;
        }
        if (info.getTreeUtilities().isPartOfCompoundVariableDeclaration(treePath.getLeaf())) {
            return false;
        }
        return !info.getTreeUtilities().isVarType(treePath);
    }

    private static boolean isValidVarType(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        TreePath initTreePath = ctx.getVariables().get("$init");
        TreePath expressionTreePath = ctx.getVariables().get("$expression");
        TreePath typeTreePath = ctx.getVariables().get("$type");
        if (initTreePath != null) {
            Tree.Kind kind = initTreePath.getLeaf().getKind();
            switch (kind) {
                case NEW_CLASS: {
                    NewClassTree nct = (NewClassTree)initTreePath.getLeaf();
                    if (nct.getClassBody() == null) break;
                    return false;
                }
                case NEW_ARRAY: {
                    NewArrayTree nat = (NewArrayTree)((VariableTree)treePath.getLeaf()).getInitializer();
                    if (nat.getType() != null) break;
                    return false;
                }
                case LAMBDA_EXPRESSION: {
                    return false;
                }
                case MEMBER_REFERENCE: {
                    return false;
                }
            }
            TypeMirror initTypeMirror = ctx.getInfo().getTrees().getTypeMirror(initTreePath);
            TypeMirror variableTypeMirror = ctx.getInfo().getTrees().getElement(treePath).asType();
            return Utilities.isValidType(initTypeMirror) && ctx.getInfo().getTypes().isSameType(variableTypeMirror, Utilities.resolveCapturedType(ctx.getInfo(), initTypeMirror));
        }
        if (expressionTreePath != null) {
            ExecutableElement iterator = ExpandEnhancedForLoop.findIterable(ctx.getInfo());
            TypeMirror expTypeMirror = ctx.getInfo().getTrees().getTypeMirror(expressionTreePath);
            TypeMirror typeTypeMirror = ctx.getInfo().getTrees().getTypeMirror(typeTreePath);
            if (expTypeMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType dt = (DeclaredType)expTypeMirror;
                if (dt.getTypeArguments().size() > 0) {
                    TypeMirror paramType = dt.getTypeArguments().get(0);
                    if (!Utilities.isValidType(typeTypeMirror) || !ctx.getInfo().getTypes().isSameType(typeTypeMirror, paramType)) {
                        return false;
                    }
                }
            } else {
                Type.ArrayType arrayTypeExp = (Type.ArrayType)Utilities.resolveCapturedType(ctx.getInfo(), expTypeMirror);
                Type arrayTypeExpType = arrayTypeExp.getComponentType();
                if (!Utilities.isValidType(typeTypeMirror) || !ctx.getInfo().getTypes().isSameType(typeTypeMirror, arrayTypeExpType)) {
                    return false;
                }
            }
            return iterator != null;
        }
        return false;
    }

    private static final class JavaFixImpl
    extends JavaFix {
        public JavaFixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ShowMessage();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            WorkingCopy wc = tc.getWorkingCopy();
            TreePath statementPath = tc.getPath();
            TreeMaker make = wc.getTreeMaker();
            if (statementPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                NewClassTree nct;
                VariableTree oldVariableTree = (VariableTree)statementPath.getLeaf();
                ExpressionTree initializerTree = oldVariableTree.getInitializer();
                if (initializerTree == null) {
                    return;
                }
                if (initializerTree.getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)initializerTree).getIdentifier().getKind() == Tree.Kind.PARAMETERIZED_TYPE && oldVariableTree.getType().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    ParameterizedTypeTree ptt = (ParameterizedTypeTree)oldVariableTree.getType();
                    ParameterizedTypeTree nue = (ParameterizedTypeTree)((Object)nct.getIdentifier());
                    if (nue.getTypeArguments().isEmpty() && ptt.getTypeArguments().size() > 0) {
                        wc.rewrite(nue, ptt);
                    }
                }
                VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), oldVariableTree.getName(), make.Type("var"), initializerTree);
                wc.rewrite(oldVariableTree, newVariableTree);
            } else if (statementPath.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP) {
                EnhancedForLoopTree elfTree = (EnhancedForLoopTree)statementPath.getLeaf();
                ExpressionTree expTree = elfTree.getExpression();
                VariableTree vtt = elfTree.getVariable();
                if (expTree == null || vtt == null) {
                    return;
                }
                VariableTree newVariableTree = make.Variable(vtt.getModifiers(), vtt.getName(), make.Type("var"), null);
                StatementTree statement = ((EnhancedForLoopTree)statementPath.getLeaf()).getStatement();
                EnhancedForLoopTree newElfTree = make.EnhancedForLoop(newVariableTree, expTree, statement);
                wc.rewrite(elfTree, newElfTree);
            }
        }
    }
}

