/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.DirectiveTree;
import jpt.sun.source.tree.ModuleTree;
import jpt.sun.source.tree.RequiresTree;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.classpath.ProjectModulesModifier;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

public class DefaultProjectModulesModifier
implements ProjectModulesModifier {
    private static final SpecificationVersion JDK9_SPEC = new SpecificationVersion("9");

    @Override
    public String provideModularClasspath(FileObject projectArtifact, String classPathType) {
        assert (projectArtifact != null);
        assert (classPathType != null);
        Project p = FileOwnerQuery.getOwner(projectArtifact);
        if (p == null) {
            return null;
        }
        ProjectModulesModifier delegate = p.getLookup().lookup(ProjectModulesModifier.class);
        if (delegate != null) {
            return delegate.provideModularClasspath(projectArtifact, classPathType);
        }
        if (DefaultProjectModulesModifier.findModuleInfo(projectArtifact) == null) {
            return null;
        }
        switch (classPathType) {
            case "classpath/compile": {
                return "modules/compile";
            }
            case "classpath/execute": {
                return "modules/execute";
            }
        }
        return null;
    }

    @Override
    public boolean addRequiredModules(String originalPathType, FileObject projectArtifact, Collection<URL> moduleNames) throws IOException {
        assert (projectArtifact != null);
        assert (originalPathType != null);
        Project p = FileOwnerQuery.getOwner(projectArtifact);
        if (p == null) {
            return false;
        }
        FileObject modInfo = DefaultProjectModulesModifier.findModuleInfo(projectArtifact);
        if (modInfo == null) {
            return false;
        }
        ProjectModulesModifier delegate = p.getLookup().lookup(ProjectModulesModifier.class);
        if (delegate != null) {
            return delegate.addRequiredModules(originalPathType, projectArtifact, moduleNames);
        }
        switch (originalPathType) {
            case "classpath/compile": 
            case "classpath/execute": 
            case "modules/compile": 
            case "modules/execute": {
                return DefaultProjectModulesModifier.extendModuleInfo(modInfo, moduleNames);
            }
        }
        return false;
    }

    @Override
    public boolean removeRequiredModules(String originalPathType, FileObject projectArtifact, Collection<URL> moduleNames) throws IOException {
        assert (projectArtifact != null);
        assert (originalPathType != null);
        Project p = FileOwnerQuery.getOwner(projectArtifact);
        if (p == null) {
            return false;
        }
        FileObject modInfo = DefaultProjectModulesModifier.findModuleInfo(projectArtifact);
        if (modInfo == null) {
            return false;
        }
        ProjectModulesModifier delegate = p.getLookup().lookup(ProjectModulesModifier.class);
        if (delegate != null) {
            return delegate.removeRequiredModules(originalPathType, projectArtifact, moduleNames);
        }
        switch (originalPathType) {
            case "classpath/compile": 
            case "classpath/execute": 
            case "modules/compile": 
            case "modules/execute": {
                return DefaultProjectModulesModifier.removeRequiredModuleArtifacts(modInfo, moduleNames);
            }
        }
        return false;
    }

    @CheckForNull
    private static FileObject findModuleInfo(@NonNull FileObject artifact) {
        if (JDK9_SPEC.compareTo(new SpecificationVersion(SourceLevelQuery.getSourceLevel(artifact))) < 0) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath(artifact, "classpath/source");
        return cp == null ? null : cp.findResource("module-info.java");
    }

    public static boolean extendModuleInfo(@NonNull FileObject info, @NonNull Collection<URL> modules) throws IOException {
        if (info == null || modules.isEmpty()) {
            return false;
        }
        Collection moduleNames = modules.stream().map(url -> SourceUtils.getModuleName(url, true)).filter(name -> name != null).collect(Collectors.toList());
        return DefaultProjectModulesModifier.addRequiredModules(info, moduleNames);
    }

    public static boolean addRequiredModules(@NonNull FileObject info, @NonNull Collection<String> moduleNames) throws IOException {
        if (moduleNames.isEmpty()) {
            return false;
        }
        JavaSource js = JavaSource.forFileObject(info);
        if (js == null) {
            return false;
        }
        boolean[] modified = new boolean[1];
        js.runModificationTask(wc -> {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = wc.getCompilationUnit();
            final HashSet knownModules = new HashSet();
            final ModuleTree[] module = new ModuleTree[1];
            final RequiresTree[] lastRequires = new RequiresTree[1];
            cu.accept(new ErrorAwareTreeScanner<Void, Void>(){

                @Override
                public Void visitModule(ModuleTree m, Void p) {
                    module[0] = m;
                    return (Void)super.visitModule(m, p);
                }

                @Override
                public Void visitRequires(RequiresTree r, Void p) {
                    lastRequires[0] = r;
                    knownModules.add(r.getModuleName().toString());
                    return (Void)super.visitRequires(r, p);
                }
            }, null);
            if (module[0] != null) {
                moduleNames.removeAll(knownModules);
                modified[0] = !moduleNames.isEmpty();
                TreeMaker tm = wc.getTreeMaker();
                List newRequires = moduleNames.stream().map(name -> tm.Requires(false, false, tm.QualIdent((String)name))).collect(Collectors.toList());
                ArrayList<Object> newDirectives = new ArrayList<Object>(module[0].getDirectives().size() + newRequires.size());
                if (lastRequires[0] == null) {
                    newDirectives.addAll(newRequires);
                }
                for (DirectiveTree directiveTree : module[0].getDirectives()) {
                    newDirectives.add(directiveTree);
                    if (directiveTree != lastRequires[0]) continue;
                    newDirectives.addAll(newRequires);
                }
                ModuleTree newModule = tm.Module(tm.Modifiers(0L, module[0].getAnnotations()), module[0].getModuleType(), module[0].getName(), newDirectives);
                wc.rewrite(module[0], newModule);
            }
        }).commit();
        DefaultProjectModulesModifier.save(info);
        return modified[0];
    }

    public static boolean removeRequiredModuleArtifacts(FileObject moduleInfo, Collection<URL> modules) {
        return DefaultProjectModulesModifier.removeRequiredModules(moduleInfo, modules.stream().map(url -> SourceUtils.getModuleName(url, true)).filter(name -> name != null).collect(Collectors.toSet()));
    }

    public static boolean removeRequiredModules(FileObject moduleInfo, final Collection<String> modules) {
        if (moduleInfo == null || modules.isEmpty()) {
            return false;
        }
        boolean[] modified = new boolean[1];
        try {
            JavaSource js = JavaSource.forFileObject(moduleInfo);
            if (js != null) {
                js.runModificationTask(wc -> {
                    wc.toPhase(JavaSource.Phase.PARSED);
                    CompilationUnitTree cu = wc.getCompilationUnit();
                    HashSet toRemove = new HashSet();
                    final ModuleTree[] module = new ModuleTree[1];
                    cu.accept(new ErrorAwareTreeScanner<Void, Set<DirectiveTree>>(){

                        @Override
                        public Void visitModule(ModuleTree node, Set<DirectiveTree> param) {
                            module[0] = node;
                            return (Void)super.visitModule(node, param);
                        }

                        @Override
                        public Void visitRequires(RequiresTree node, Set<DirectiveTree> param) {
                            String fqn = node.getModuleName().toString();
                            if (modules.contains(fqn)) {
                                param.add(node);
                            }
                            return (Void)super.visitRequires(node, param);
                        }
                    }, toRemove);
                    if (!toRemove.isEmpty()) {
                        modified[0] = true;
                        ArrayList<DirectiveTree> newDirectives = new ArrayList<DirectiveTree>(module[0].getDirectives().size());
                        for (DirectiveTree directiveTree : module[0].getDirectives()) {
                            if (toRemove.contains(directiveTree)) continue;
                            newDirectives.add(directiveTree);
                        }
                        ModuleTree newModule = wc.getTreeMaker().Module(wc.getTreeMaker().Modifiers(0L, module[0].getAnnotations()), module[0].getModuleType(), module[0].getName(), newDirectives);
                        wc.rewrite(module[0], newModule);
                    }
                }).commit();
                DefaultProjectModulesModifier.save(moduleInfo);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
        }
        return modified[0];
    }

    @Override
    public Map<URL, Collection<ClassPath>> findModuleUsages(FileObject projectArtifact, Collection<URL> locations) {
        return DefaultProjectModulesModifier.doFindModuleUsages(projectArtifact, locations);
    }

    public static Map<URL, Collection<ClassPath>> doFindModuleUsages(FileObject projectArtifact, Collection<URL> locations) {
        Project p = FileOwnerQuery.getOwner(projectArtifact);
        if (p == null) {
            return Collections.emptyMap();
        }
        HashMap<String, URL> modLocations = new HashMap<String, URL>();
        for (URL u : locations) {
            String n = SourceUtils.getModuleName(u, true);
            if (n == null) continue;
            modLocations.put(n, u);
        }
        HashMap<URL, Collection<ClassPath>> resultMap = new HashMap<URL, Collection<ClassPath>>();
        HashSet<List<FileObject>> seenCP = new HashSet<List<FileObject>>();
        for (SourceGroup g : ProjectUtils.getSources(p).getSourceGroups("java")) {
            JavaSource js;
            FileObject r = g.getRootFolder();
            ClassPath src = ClassPath.getClassPath(r, "classpath/source");
            if (!seenCP.add(Arrays.asList(src.getRoots())) || src.findResource("module-info.java") == null || (js = JavaSource.forFileObject(r)) == null) continue;
            try {
                js.runUserActionTask(new S(src, modLocations, resultMap), true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        return resultMap;
    }

    private static void save(@NonNull FileObject file) throws IOException {
        Savable save = file.getLookup().lookup(Savable.class);
        if (save != null) {
            save.save();
        }
    }

    private static class S
    extends ErrorAwareTreeScanner
    implements Task<CompilationController> {
        final Map<URL, Collection<ClassPath>> resultMap;
        final ClassPath g;
        final Map<String, URL> modLocations;

        public S(ClassPath g, Map<String, URL> modLocations, Map<URL, Collection<ClassPath>> resultMap) {
            this.g = g;
            this.modLocations = modLocations;
            this.resultMap = resultMap;
        }

        @Override
        public Object visitRequires(RequiresTree node, Object p) {
            String s = node.getModuleName().toString();
            URL u = this.modLocations.get(s);
            if (u != null) {
                this.resultMap.computeIfAbsent(u, x -> new ArrayList()).add(this.g);
            }
            return null;
        }

        @Override
        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.PARSED);
            this.scan(parameter.getCompilationUnit(), null);
        }
    }
}

