/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;

public class AutoupdateSettings {
    private static String tempIdeIdentity = null;
    private static final Logger err = Logger.getLogger(AutoupdateSettings.class.getName());
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_SUPER_IDENTITY = "superId";
    private static final String PROP_QUALIFIED_IDENTITY = "qualifiedId";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheckTime";
    private static final String DEFAULT_NETBEANS_DIR = ".netbeans";
    private static final String SUPER_IDENTITY_FILE_NAME = ".superId";
    private static final char IDE_ID_DELIMETER = '0';
    private static final char QUALIFIED_ID_DELIMETER = '_';
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int NEVER = 5;
    public static final int CUSTOM_CHECK_INTERVAL = 6;
    private static final String EXPIRATION_RECORD = "expiration";
    private static final String IMPORTED = "imported";
    private static final String[] VERSIONS_FOR_IMPORT = new String[0];
    private static final String[][] KNOWN = new String[][]{{"EVERY_STARTUP", "0"}, {"EVERY_DAY", "1"}, {"EVERY_WEEK", "2"}, {"EVERY_2WEEKS", "3"}, {"EVERY_MONTH", "4"}, {"NEVER", "5"}};
    private static int checkInterval = 0;
    private static String superId;

    private AutoupdateSettings() {
    }

    public static void generateIdentity() {
        AutoupdateSettings.expirationCheck();
        if (tempIdeIdentity instanceof String) {
            return;
        }
        String oldIdeIdentity = AutoupdateSettings.getPreferences().get(PROP_IDE_IDENTITY, null);
        String newIdeIdentity = null;
        newIdeIdentity = oldIdeIdentity == null ? AutoupdateSettings.modifyIdeIdentityIfNeeded('0' + AutoupdateSettings.generateNewId()) : AutoupdateSettings.modifyIdeIdentityIfNeeded(oldIdeIdentity);
        tempIdeIdentity = newIdeIdentity;
        if (!newIdeIdentity.equals(oldIdeIdentity) || !AutoupdateSettings.existsSuperIdentity() || AutoupdateSettings.getPreferences().get(PROP_QUALIFIED_IDENTITY, null) == null) {
            err.log(Level.FINE, "Put new value of PROP_IDE_IDENTITY to " + newIdeIdentity);
            assert (!newIdeIdentity.startsWith("-n+")) : "Generated identity (" + newIdeIdentity + ") is of wrong format. Old identity was [" + oldIdeIdentity + "].";
            AutoupdateSettings.getPreferences().put(PROP_IDE_IDENTITY, newIdeIdentity);
            String sid = AutoupdateSettings.getSuperIdentity();
            if (sid != null) {
                AutoupdateSettings.getPreferences().put(PROP_SUPER_IDENTITY, sid);
            }
            AutoupdateSettings.getPreferences().put(PROP_QUALIFIED_IDENTITY, AutoupdateSettings.getQualifiedIdentity(newIdeIdentity));
        }
    }

    public static int getPeriod() {
        boolean stillDefault = AutoupdateSettings.getPreferences().get(PROP_PERIOD, null) == null;
        Integer defaultCheckInterval = null;
        if (stillDefault) {
            defaultCheckInterval = AutoupdateSettings.parse(Utilities.getCustomCheckIntervalInMinutes());
        }
        if (defaultCheckInterval == null) {
            defaultCheckInterval = 2;
        }
        err.log(Level.FINEST, "getPeriod () returns " + AutoupdateSettings.getPreferences().getInt(PROP_PERIOD, defaultCheckInterval));
        return AutoupdateSettings.getPreferences().getInt(PROP_PERIOD, defaultCheckInterval);
    }

    public static int getCheckInterval() {
        err.log(Level.FINEST, "getCheckInterval () returns " + checkInterval + "ms");
        return checkInterval;
    }

    public static void setPeriod(int period) {
        err.log(Level.FINEST, "Called setPeriod (" + period + ")");
        AutoupdateSettings.getPreferences().putInt(PROP_PERIOD, period);
    }

    public static Date getLastCheck() {
        long t = AutoupdateSettings.getPreferences().getLong(PROP_LAST_CHECK, -1L);
        return t > 0L ? new Date(t) : null;
    }

    public static void setLastCheck(Date lastCheck) {
        err.log(Level.FINER, "Set the last check to " + lastCheck);
        if (lastCheck != null) {
            AutoupdateSettings.getPreferences().putLong(PROP_LAST_CHECK, lastCheck.getTime());
        } else {
            AutoupdateSettings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String oldIdeIdentity) {
        String newPrefix;
        String oldPrefix;
        String id;
        block13: {
            int idx = oldIdeIdentity.indexOf(48);
            String[] ideIdentityArr = oldIdeIdentity.split("\\d");
            id = null;
            oldPrefix = null;
            if (ideIdentityArr.length == 0 || idx == 0) {
                id = oldIdeIdentity;
                oldPrefix = "";
            } else if (idx != -1 && oldIdeIdentity.substring(ideIdentityArr[0].length()).startsWith(new StringBuffer(48).toString())) {
                oldPrefix = oldIdeIdentity.substring(0, idx);
                id = oldIdeIdentity.substring(oldPrefix.length());
            } else {
                oldPrefix = ideIdentityArr[0];
                id = oldIdeIdentity.substring(oldPrefix.length());
            }
            err.log(Level.FINER, "Old IDE Identity Prefix: " + oldPrefix);
            err.log(Level.FINER, "Old IDE Identity ID: " + id);
            newPrefix = "";
            try {
                FileObject fo = FileUtil.getConfigFile("productid");
                if (fo == null) break block13;
                try (InputStream is = fo.getInputStream();){
                    BufferedReader r = new BufferedReader(new InputStreamReader(is));
                    newPrefix = r.readLine().trim();
                    if (newPrefix.length() > 128) {
                        newPrefix = newPrefix.substring(0, 128);
                    }
                }
            }
            catch (IOException ignore) {
                err.log(Level.FINER, ignore.getMessage(), ignore);
            }
        }
        if (!newPrefix.equals(oldPrefix)) {
            err.log(Level.FINER, "New IDE Identity Prefix: " + newPrefix);
        } else {
            err.log(Level.FINER, "No new prefix.");
        }
        assert (!(newPrefix + id).startsWith("-n+")) : "Product Identity is of wrong format, prefix=" + newPrefix + ", id=" + id + ", oldPrefix=" + oldPrefix + ",oldIdeIdentity=" + oldIdeIdentity;
        return newPrefix + id;
    }

    private static String generateNewId() {
        return UUID.randomUUID().toString();
    }

    private static Integer parse(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        Integer period = null;
        for (String[] pair : KNOWN) {
            if (!pair[0].equalsIgnoreCase(s)) continue;
            try {
                period = Integer.parseInt(pair[1]);
            }
            catch (NumberFormatException nfe) {
                assert (false) : "Invalid value " + pair + " throws " + nfe;
            }
        }
        if (period == null) {
            try {
                checkInterval = Long.parseLong(s) * 1000L * 60L > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.parseInt(s) * 1000 * 60;
                period = 6;
                err.log(Level.FINE, "Custom value of " + Utilities.PLUGIN_MANAGER_CHECK_INTERVAL + " is " + s + " minutes.");
            }
            catch (NumberFormatException nfe) {
                err.log(Level.FINE, "Invalid value " + s + " of " + Utilities.PLUGIN_MANAGER_CHECK_INTERVAL + " throws " + nfe);
            }
        } else {
            err.log(Level.FINE, "Custom value of " + Utilities.PLUGIN_MANAGER_CHECK_INTERVAL + " is " + s);
        }
        return period;
    }

    private static void expirationCheck() {
        Preferences p = AutoupdateSettings.getPreferences();
        String exp = p.get(EXPIRATION_RECORD, null);
        HashSet<String> forImport = new HashSet<String>(Arrays.asList(VERSIONS_FOR_IMPORT));
        String currentVersion = new File(System.getProperty("netbeans.user")).getName();
        forImport.add(currentVersion);
        if (exp != null && !forImport.contains(exp)) {
            try {
                List<File> dirs;
                int period = AutoupdateSettings.getPeriod();
                boolean shared = Utilities.isGlobalInstallation() == null ? false : Utilities.isGlobalInstallation();
                p.removeNode();
                AutoupdateSettings.getPreferences().put(IMPORTED, Boolean.toString(true));
                AutoupdateSettings.getPreferences().putInt(PROP_PERIOD, period);
                if (shared && !(dirs = Utilities.sharedDirs()).isEmpty()) {
                    for (File f : dirs) {
                        if (!f.exists() || !f.isDirectory() || Utilities.canWriteInCluster(f)) continue;
                        shared = false;
                        break;
                    }
                    if (shared) {
                        Utilities.setGlobalInstallation(shared);
                    }
                }
                err.log(Level.FINE, "Don't read preferences from userdir " + exp);
            }
            catch (BackingStoreException ex) {
                err.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        } else if (exp == null) {
            err.log(Level.FINEST, "No preferences imported from previous version.");
        } else {
            err.log(Level.FINEST, "Read preferences from userdir " + exp);
        }
        err.log(Level.FINEST, "Store current version " + currentVersion + " for future import.");
        AutoupdateSettings.getPreferences().put(EXPIRATION_RECORD, currentVersion);
    }

    private static boolean existsSuperIdentity() {
        File superFile = AutoupdateSettings.getSuperFile();
        if (superFile == null) {
            return true;
        }
        err.log(Level.FINE, "Does " + superFile + " exist? " + superFile.exists());
        return superFile.exists();
    }

    private static File getSuperFile() {
        String home = System.getProperty("user.home");
        if ("memory".equals(home)) {
            err.log(Level.INFO, "IDE launched as JNLP");
            return null;
        }
        File superFile = AutoupdateSettings.getSuperFileOsSpecific();
        if (superFile != null) {
            err.log(Level.FINE, "Does OS specific " + superFile + " exist? " + superFile.exists());
            if (superFile != null && superFile.exists()) {
                return superFile;
            }
        }
        File nbDir = new File(home, DEFAULT_NETBEANS_DIR);
        err.log(Level.FINE, "Does " + nbDir + " exist? " + nbDir.exists());
        if (nbDir.exists() && superFile != null) {
            String id;
            File oldPlaceSuperFile = new File(nbDir, SUPER_IDENTITY_FILE_NAME);
            err.log(Level.FINE, "Does " + oldPlaceSuperFile + " exist on the old place? " + oldPlaceSuperFile.exists());
            if (oldPlaceSuperFile.exists() && (id = AutoupdateSettings.readSuperFile(oldPlaceSuperFile)) != null) {
                AutoupdateSettings.writeSuperFile(superFile, id);
            }
        } else if (nbDir.exists() && superFile == null) {
            superFile = new File(nbDir, SUPER_IDENTITY_FILE_NAME);
        }
        return superFile;
    }

    private static File getSuperFileOsSpecific() {
        String defaultUserdirRoot = System.getProperty("netbeans.default_userdir_root", null);
        err.log(Level.FINER, "netbeans.default_userdir_root: " + defaultUserdirRoot);
        if (defaultUserdirRoot == null) {
            err.warning("The property \"netbeans.default_userdir_root\" was not set!");
            return null;
        }
        File nbDir = new File(defaultUserdirRoot);
        nbDir.mkdirs();
        return new File(nbDir, SUPER_IDENTITY_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSuperFile(File superFile, String id) {
        Writer os = null;
        try {
            os = new BufferedWriter(new FileWriter(superFile));
            os.write(id);
            superId = id;
            err.log(Level.FINE, "Wrote Super Id: " + superId + " in " + superFile);
        }
        catch (IOException ex) {
            err.log(Level.FINER, null, ex);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                err.log(Level.FINER, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSuperFile(File superFile) {
        String res = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(superFile);
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            res = r.readLine().trim();
            err.log(Level.FINE, "Read Super Id: " + res + " from " + superFile);
        }
        catch (IOException ex) {
            err.log(Level.FINER, null, ex);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                err.log(Level.FINER, null, ex);
            }
        }
        return res;
    }

    private static String getSuperIdentity() {
        if (superId != null) {
            return superId;
        }
        File superFile = AutoupdateSettings.getSuperFile();
        if (superFile == null) {
            err.log(Level.FINE, "superFile was returns null.");
            return null;
        }
        if (superFile.exists()) {
            superId = AutoupdateSettings.readSuperFile(superFile);
        } else {
            superId = AutoupdateSettings.generateNewId();
            AutoupdateSettings.writeSuperFile(superFile, superId);
        }
        if (superId != null) {
            err.log(Level.FINE, "Returns Super Id: " + superId);
            return superId;
        }
        err.log(Level.FINE, "Was problem while handling Super Id. Returns null");
        return null;
    }

    private static String getQualifiedIdentity(String ideIdentity) {
        if (AutoupdateSettings.getSuperIdentity() != null) {
            err.log(Level.FINE, "Returns Qualified Id: " + ideIdentity + '_' + AutoupdateSettings.getSuperIdentity());
            return ideIdentity + '_' + AutoupdateSettings.getSuperIdentity();
        }
        err.log(Level.FINE, "Was problem while handling Qualified Id. Returns only original Id: " + ideIdentity);
        return ideIdentity;
    }
}

