/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.comp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.tree.TreeInfo;
import jpt.sun.tools.javac.tree.TreeScanner;

public class TreeHasher
extends TreeScanner {
    private final Map<Symbol, Integer> symbolHashes;
    private int result = 17;

    public TreeHasher(Map<Symbol, Integer> symbolHashes) {
        this.symbolHashes = Objects.requireNonNull(symbolHashes);
    }

    public static int hash(JCTree tree, Collection<? extends Symbol> symbols) {
        if (tree == null) {
            return 0;
        }
        HashMap<Symbol, Integer> symbolHashes = new HashMap<Symbol, Integer>();
        symbols.forEach(s -> symbolHashes.put((Symbol)s, symbolHashes.size()));
        TreeHasher hasher = new TreeHasher(symbolHashes);
        tree.accept(hasher);
        return hasher.result;
    }

    private void hash(Object object) {
        this.result = 31 * this.result + Objects.hashCode(object);
    }

    @Override
    public void scan(JCTree tree) {
        Object value;
        if (tree == null) {
            return;
        }
        tree = TreeInfo.skipParens(tree);
        if (tree.type != null && (value = tree.type.constValue()) != null) {
            this.hash(value);
            return;
        }
        this.hash((Object)tree.getTag());
        tree.accept(this);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        this.hash(tree.value);
        super.visitLiteral(tree);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Integer hash;
        Symbol sym = tree.sym;
        if (sym != null && (hash = this.symbolHashes.get(sym)) != null) {
            this.hash(hash);
            return;
        }
        this.hash(sym);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.hash(tree.sym);
        super.visitSelect(tree);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        this.symbolHashes.computeIfAbsent(tree.sym, k -> this.symbolHashes.size());
        super.visitVarDef(tree);
    }
}

