/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import java.io.IOException;
import jpt.sun.tools.classfile.AttributeException;
import jpt.sun.tools.classfile.ClassReader;
import jpt.sun.tools.classfile.ConstantPool;

public class Annotation {
    public final int type_index;
    public final int num_element_value_pairs;
    public final element_value_pair[] element_value_pairs;

    Annotation(ClassReader cr) throws IOException, InvalidAnnotation {
        this.type_index = cr.readUnsignedShort();
        this.num_element_value_pairs = cr.readUnsignedShort();
        this.element_value_pairs = new element_value_pair[this.num_element_value_pairs];
        for (int i = 0; i < this.element_value_pairs.length; ++i) {
            this.element_value_pairs[i] = new element_value_pair(cr);
        }
    }

    public Annotation(ConstantPool constant_pool, int type_index, element_value_pair[] element_value_pairs) {
        this.type_index = type_index;
        this.num_element_value_pairs = element_value_pairs.length;
        this.element_value_pairs = element_value_pairs;
    }

    public int length() {
        int n = 4;
        for (element_value_pair pair : this.element_value_pairs) {
            n += pair.length();
        }
        return n;
    }

    public static class element_value_pair {
        public final int element_name_index;
        public final element_value value;

        element_value_pair(ClassReader cr) throws IOException, InvalidAnnotation {
            this.element_name_index = cr.readUnsignedShort();
            this.value = element_value.read(cr);
        }

        public element_value_pair(int element_name_index, element_value value) {
            this.element_name_index = element_name_index;
            this.value = value;
        }

        public int length() {
            return 2 + this.value.length();
        }
    }

    public static class Array_element_value
    extends element_value {
        public final int num_values;
        public final element_value[] values;

        Array_element_value(ClassReader cr, int tag) throws IOException, InvalidAnnotation {
            super(tag);
            this.num_values = cr.readUnsignedShort();
            this.values = new element_value[this.num_values];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = element_value.read(cr);
            }
        }

        public Array_element_value(element_value[] values, int tag) {
            super(tag);
            this.num_values = values.length;
            this.values = values;
        }

        @Override
        public int length() {
            int n = 2;
            for (int i = 0; i < this.values.length; ++i) {
                n += this.values[i].length();
            }
            return n;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitArray(this, p);
        }
    }

    public static class Annotation_element_value
    extends element_value {
        public final Annotation annotation_value;

        Annotation_element_value(ClassReader cr, int tag) throws IOException, InvalidAnnotation {
            super(tag);
            this.annotation_value = new Annotation(cr);
        }

        public Annotation_element_value(Annotation annotation_value, int tag) {
            super(tag);
            this.annotation_value = annotation_value;
        }

        @Override
        public int length() {
            return this.annotation_value.length();
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitAnnotation(this, p);
        }
    }

    public static class Class_element_value
    extends element_value {
        public final int class_info_index;

        Class_element_value(ClassReader cr, int tag) throws IOException {
            super(tag);
            this.class_info_index = cr.readUnsignedShort();
        }

        public Class_element_value(int class_info_index, int tag) {
            super(tag);
            this.class_info_index = class_info_index;
        }

        @Override
        public int length() {
            return 2;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitClass(this, p);
        }
    }

    public static class Enum_element_value
    extends element_value {
        public final int type_name_index;
        public final int const_name_index;

        Enum_element_value(ClassReader cr, int tag) throws IOException {
            super(tag);
            this.type_name_index = cr.readUnsignedShort();
            this.const_name_index = cr.readUnsignedShort();
        }

        public Enum_element_value(int type_name_index, int const_name_index, int tag) {
            super(tag);
            this.type_name_index = type_name_index;
            this.const_name_index = const_name_index;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitEnum(this, p);
        }
    }

    public static class Primitive_element_value
    extends element_value {
        public final int const_value_index;

        Primitive_element_value(ClassReader cr, int tag) throws IOException {
            super(tag);
            this.const_value_index = cr.readUnsignedShort();
        }

        public Primitive_element_value(int const_value_index, int tag) {
            super(tag);
            this.const_value_index = const_value_index;
        }

        @Override
        public int length() {
            return 2;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitPrimitive(this, p);
        }
    }

    public static abstract class element_value {
        public final int tag;

        public static element_value read(ClassReader cr) throws IOException, InvalidAnnotation {
            int tag = cr.readUnsignedByte();
            switch (tag) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 90: 
                case 115: {
                    return new Primitive_element_value(cr, tag);
                }
                case 101: {
                    return new Enum_element_value(cr, tag);
                }
                case 99: {
                    return new Class_element_value(cr, tag);
                }
                case 64: {
                    return new Annotation_element_value(cr, tag);
                }
                case 91: {
                    return new Array_element_value(cr, tag);
                }
            }
            throw new InvalidAnnotation("unrecognized tag: " + tag);
        }

        protected element_value(int tag) {
            this.tag = tag;
        }

        public abstract int length();

        public abstract <R, P> R accept(Visitor<R, P> var1, P var2);

        public static interface Visitor<R, P> {
            public R visitPrimitive(Primitive_element_value var1, P var2);

            public R visitEnum(Enum_element_value var1, P var2);

            public R visitClass(Class_element_value var1, P var2);

            public R visitAnnotation(Annotation_element_value var1, P var2);

            public R visitArray(Array_element_value var1, P var2);
        }
    }

    static class InvalidAnnotation
    extends AttributeException {
        private static final long serialVersionUID = -4620480740735772708L;

        InvalidAnnotation(String msg) {
            super(msg);
        }
    }
}

