/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.api;

import java.beans.PropertyChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistenceapi.PersistenceScopesAccessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class PersistenceScopes {
    public static final String PROP_PERSISTENCE_SCOPES = "persistenceScopes";
    private final PersistenceScopesImplementation impl;

    public static PersistenceScopes getPersistenceScopes(Project project) {
        Parameters.notNull("project", project);
        PersistenceScopesProvider provider = project.getLookup().lookup(PersistenceScopesProvider.class);
        if (provider != null) {
            return provider.getPersistenceScopes();
        }
        return null;
    }

    public static PersistenceScopes getPersistenceScopes(Project project, FileObject fo) {
        Parameters.notNull("project", project);
        PersistenceScopesProvider provider = project.getLookup().lookup(PersistenceScopesProvider.class);
        if (provider != null) {
            return provider.getPersistenceScopes(fo);
        }
        return null;
    }

    private PersistenceScopes(PersistenceScopesImplementation impl) {
        this.impl = impl;
    }

    public PersistenceScope[] getPersistenceScopes() {
        return this.impl.getPersistenceScopes();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    static {
        PersistenceScopesAccessor.DEFAULT = new PersistenceScopesAccessor(){

            @Override
            public PersistenceScopes createPersistenceScopes(PersistenceScopesImplementation impl) {
                return new PersistenceScopes(impl);
            }
        };
    }
}

