/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.StateManagerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.Window;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.TransientHolder;
import org.apache.myfaces.trinidadinternal.application.Structure;
import org.apache.myfaces.trinidadinternal.context.TrinidadPhaseListener;
import org.apache.myfaces.trinidadinternal.util.LRUCache;
import org.apache.myfaces.trinidadinternal.util.ObjectInputStreamResolveClass;
import org.apache.myfaces.trinidadinternal.util.SubKeyMap;
import org.apache.myfaces.trinidadinternal.util.TokenCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManagerWrapper {
    public static final String USE_APPLICATION_VIEW_CACHE_INIT_PARAM = "org.apache.myfaces.trinidad.USE_APPLICATION_VIEW_CACHE";
    public static final String CACHE_VIEW_ROOT_INIT_PARAM = "org.apache.myfaces.trinidad.CACHE_VIEW_ROOT";
    public static final String CLIENT_STATE_METHOD_PARAM_NAME = "org.apache.myfaces.trinidad.CLIENT_STATE_METHOD";
    public static final String CLIENT_STATE_MAX_TOKENS_PARAM_NAME = "org.apache.myfaces.trinidad.CLIENT_STATE_MAX_TOKENS";
    public static final String COMPRESS_VIEW_STATE_PARAM_NAME = "org.apache.myfaces.trinidad.COMPRESS_VIEW_STATE";
    public static final String CLIENT_STATE_METHOD_TOKEN = "token";
    public static final String CLIENT_STATE_METHOD_ALL = "all";
    private static final int _MAX_PER_SESSION_APPLICATION_SIZE = 16;
    private final StateManager _delegate;
    private Boolean _useViewRootCache;
    private Boolean _useApplicationViewCache;
    private Boolean _structureGeneratedByTemplate;
    private static final Character _SUBKEY_SEPARATOR = new Character('.');
    private static final int _DEFAULT_CACHE_SIZE = 15;
    private static final Object _APPLICATION_VIEW_CACHE_LOCK = new Object();
    private static final String _VIEW_CACHE_KEY = "org.apache.myfaces.trinidadinternal.application.VIEW_CACHE";
    private static final String _APPLICATION_VIEW_CACHE_KEY = "org.apache.myfaces.trinidadinternal.application.APPLICATION_VIEW_CACHE";
    private static final String _PER_PAGE_STATE_SAVING = "org.apache.myfaces.trinidadimpl.PER_PAGE_STATE_SAVING";
    private static final String _CACHED_SERIALIZED_VIEW = "org.apache.myfaces.trinidadinternal.application.CachedSerializedView";
    private static final String _REQUEST_STATE_TOKEN_KEY = "org.apache.myfaces.trinidadinternal.application.REQUEST_STATE_TOKEN";
    private static final String _PINNED_STATE_TOKEN_KEY = "org.apache.myfaces.trinidadinternal.application.PINNED_STATE_TOKEN";
    private static final String _REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY = "org.apache.myfaces.trinidadinternal.application.REUSE_REQUEST_TOKEN_FOR_RESPONSE";
    private static final String _ACTIVE_PAGE_TOKEN_SESSION_KEY = "org.apache.myfaces.trinidadinternal.application.StateManagerImp.ACTIVE_PAGE_STATE";
    private static final String _APPLICATION_CACHE_TOKEN = "_a_";
    private static final long serialVersionUID = 1L;
    private static final byte[] _EMPTY = new byte[0];
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StateManagerImpl.class);

    public StateManagerImpl(StateManager delegate) {
        this._delegate = delegate;
    }

    protected StateManager getWrapped() {
        return this._delegate;
    }

    public Object saveView(FacesContext context) {
        assert (context != null);
        if (this.isSavingStateInClient(context)) {
            StateManager.SerializedView view = this._saveSerializedView(context);
            return new Object[]{view.getStructure(), view.getState()};
        }
        return super.saveView(context);
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        assert (context != null);
        if (this.isSavingStateInClient(context)) {
            return this._saveSerializedView(context);
        }
        return this._delegate.saveSerializedView(context);
    }

    public static Object saveComponentTree(FacesContext context, UIComponent component) {
        Structure structure = new Structure(component);
        Object state = component.processSaveState(context);
        return new PageState(context, new Object[]{structure, state}, null);
    }

    public static UIComponent restoreComponentTree(FacesContext context, Object savedState) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (savedState == null) {
            throw new NullPointerException();
        }
        if (!(savedState instanceof PageState)) {
            throw new IllegalArgumentException(_LOG.getMessage("INVALID_SAVED_STATE_OBJECT"));
        }
        PageState viewState = (PageState)savedState;
        Object[] stateArray = (Object[])viewState.getViewState(context);
        Object structure = stateArray[0];
        Object state = stateArray[1];
        UIComponent component = ((Structure)structure).createComponent();
        if (state != null) {
            component.processRestoreState(context, state);
        }
        return component;
    }

    public static Object saveViewRoot(FacesContext context, UIViewRoot root) {
        StateManagerImpl._removeTransientComponents((UIComponent)root);
        Structure structure = new Structure((UIComponent)root);
        Object state = root.processSaveState(context);
        return new PageState(context, new Object[]{structure, state}, root);
    }

    public static UIViewRoot restoreViewRoot(FacesContext context, Object saved) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (saved == null) {
            throw new NullPointerException();
        }
        PageState viewState = (PageState)saved;
        UIViewRoot root = viewState.popRoot(context);
        if (root != null) {
            return root;
        }
        Object[] stateArray = (Object[])viewState.getViewState(context);
        Object structure = stateArray[0];
        Object state = stateArray[1];
        root = (UIViewRoot)((Structure)structure).createComponent();
        if (state != null) {
            root.processRestoreState(context, state);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateManager.SerializedView _saveSerializedView(FacesContext context) {
        Object state;
        StateManager.SerializedView view = this._getCachedSerializedView(context);
        if (view != null) {
            return view;
        }
        UIViewRoot root = context.getViewRoot();
        boolean dontSave = false;
        Map<String, PageState> applicationViewCache = null;
        Map<String, PageState> perSessionApplicationViewCache = null;
        if (this._useApplicationViewCache(context)) {
            applicationViewCache = StateManagerImpl._getApplicationViewCache(context);
            perSessionApplicationViewCache = StateManagerImpl._getPerSessionApplicationViewCache(context);
            Map<String, PageState> map = applicationViewCache;
            synchronized (map) {
                PageState applicationState = applicationViewCache.get(root.getViewId());
                if (applicationState != null) {
                    dontSave = true;
                    perSessionApplicationViewCache.put(root.getViewId(), applicationState);
                }
            }
        }
        StateManagerImpl._removeTransientComponents((UIComponent)root);
        Structure structure = dontSave || !this._needStructure(context) ? null : new Structure((UIComponent)root);
        Object object = state = dontSave ? null : root.processSaveState(context);
        if (this._saveAsToken(context)) {
            String token;
            ExternalContext extContext = context.getExternalContext();
            if (applicationViewCache == null) {
                assert (!dontSave);
                RequestContext trinContext = RequestContext.getCurrentInstance();
                TokenCache cache = this._getViewCache(trinContext, extContext);
                assert (cache != null);
                Map sessionMap = extContext.getSessionMap();
                String subkey = StateManagerImpl._getViewCacheKey(extContext, trinContext, _SUBKEY_SEPARATOR);
                SubKeyMap<PageState> stateMap = new SubKeyMap<PageState>(sessionMap, subkey);
                PageState pageState = new PageState(context, new Object[]{structure, state}, (UIViewRoot)(this._useViewRootCache(context) ? root : null));
                String requestToken = StateManagerImpl._getRequestTokenForResponse(context);
                if (requestToken != null && cache.isAvailable(requestToken)) {
                    stateMap.put(requestToken, pageState);
                    token = requestToken;
                } else {
                    String pinnedToken = (String)extContext.getRequestMap().get(_PINNED_STATE_TOKEN_KEY);
                    token = cache.addNewEntry(pageState, stateMap, pinnedToken);
                }
                Object object2 = extContext.getSession(true);
                synchronized (object2) {
                    String activePageStateKey = StateManagerImpl._getActivePageTokenKey(extContext, trinContext);
                    String activeToken = (String)sessionMap.get(activePageStateKey);
                    if (!token.equals(activeToken)) {
                        PageState activePageState;
                        if (activeToken != null && (activePageState = (PageState)stateMap.get(activeToken)) != null) {
                            activePageState.clearViewRootState();
                        }
                        sessionMap.put(activePageStateKey, token);
                    }
                }
            }
            PageState applicationState = new PageState(context, new Object[]{structure, state}, null);
            if (!dontSave) {
                Map<String, PageState> map = applicationViewCache;
                synchronized (map) {
                    applicationViewCache.put(root.getViewId(), applicationState);
                    perSessionApplicationViewCache.put(root.getViewId(), applicationState);
                }
            }
            token = _APPLICATION_CACHE_TOKEN;
            assert (token != null);
            view = new StateManager.SerializedView((StateManager)this, (Object)token, null);
            extContext.getRequestMap().put(_REQUEST_STATE_TOKEN_KEY, token);
        } else {
            assert (!dontSave);
            view = new StateManager.SerializedView((StateManager)this, (Object)structure, state);
        }
        this._saveCachedSerializedView(context, view);
        return view;
    }

    public static void pinStateToRequest(FacesContext context, String stateToken) {
        context.getExternalContext().getRequestMap().put(_PINNED_STATE_TOKEN_KEY, stateToken);
    }

    public static String getStateToken(FacesContext context) {
        return (String)context.getExternalContext().getRequestMap().get(_REQUEST_STATE_TOKEN_KEY);
    }

    public static void reuseRequestTokenForResponse(ExternalContext ec) {
        ec.getRequestMap().put(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY, Boolean.TRUE);
    }

    public static void clearReuseRequestTokenForResponse(ExternalContext ec) {
        ec.getRequestMap().remove(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY);
    }

    private static void _updateRequestTokenForResponse(FacesContext context, String token) {
        Map requestMap = context.getExternalContext().getRequestMap();
        if (Boolean.TRUE.equals(requestMap.get(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY))) {
            requestMap.put(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY, token);
        }
    }

    private static String _getRequestTokenForResponse(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object token = requestMap.get(_REUSE_REQUEST_TOKEN_FOR_RESPONSE_KEY);
        if (Boolean.TRUE.equals(token)) {
            return null;
        }
        return (String)token;
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        this._delegate.writeState(context, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot root;
        Object state;
        Object structure;
        ExternalContext extContext = context.getExternalContext();
        UIViewRoot launchView = (UIViewRoot)extContext.getRequestMap().remove("org.apache.myfaces.trinidad.PageFlowSourceView");
        if (launchView != null) {
            TrinidadPhaseListener.markPostback(context);
            return launchView;
        }
        if (!this.isSavingStateInClient(context)) {
            return this._delegate.restoreView(context, viewId, renderKitId);
        }
        boolean recalculateLocale = false;
        ResponseStateManager rsm = StateManagerImpl._getResponseStateManager(context, renderKitId);
        if (this._saveAsToken(context)) {
            PageState viewState;
            Object token = rsm.getTreeStructureToRestore(context, viewId);
            if (token == null) {
                _LOG.finest("No token in the request for view \"{0}\";  probably a first view.", (Object)viewId);
                return null;
            }
            assert (token instanceof String);
            _LOG.finer("Restoring saved view state for token {0}", token);
            if (_APPLICATION_CACHE_TOKEN.equals(token)) {
                Map<String, PageState> cache = StateManagerImpl._getApplicationViewCache(context);
                Map<String, PageState> perSessionCache = StateManagerImpl._getPerSessionApplicationViewCache(context);
                Map<String, PageState> map = cache;
                synchronized (map) {
                    viewState = perSessionCache.get(viewId);
                    if (viewState == null && (viewState = cache.get(viewId)) != null) {
                        perSessionCache.put(viewId, viewState);
                    }
                    recalculateLocale = true;
                }
            } else {
                RequestContext trinContext = RequestContext.getCurrentInstance();
                String subkey = StateManagerImpl._getViewCacheKey(extContext, trinContext, _SUBKEY_SEPARATOR);
                SubKeyMap stateMap = new SubKeyMap(extContext.getSessionMap(), subkey);
                viewState = (PageState)stateMap.get(token);
                if (viewState != null) {
                    StateManagerImpl._updateRequestTokenForResponse(context, (String)token);
                }
                boolean isAvailable = this._getViewCache(trinContext, extContext).isAvailable((String)token);
                assert (viewState != null == isAvailable);
            }
            if (viewState == null) {
                _LOG.severe("CANNOT_FIND_SAVED_VIEW_STATE", token);
                return null;
            }
            _LOG.fine("Successfully found view state for token {0}", token);
            UIViewRoot root2 = viewState.popRoot(context);
            if (root2 != null) {
                _LOG.finer("UIViewRoot for token {0} already exists. Bypassing restoreState", token);
                return root2;
            }
            Object[] stateArray = (Object[])viewState.getViewState(context);
            structure = stateArray[0];
            state = stateArray[1];
        } else {
            structure = rsm.getTreeStructureToRestore(context, viewId);
            state = rsm.getComponentStateToRestore(context);
        }
        if (structure == null) {
            root = context.getViewRoot();
            if (root == null && this._needStructure(context)) {
                _LOG.severe("NO_STRUCTURE_ROOT_AVAILABLE");
                return null;
            }
            if (state != null) {
                root.processRestoreState(context, state);
            }
            return root;
        }
        if (!(structure instanceof Structure)) {
            _LOG.severe("NO_STRUCTURE_AVAILABLE");
            return null;
        }
        try {
            root = (UIViewRoot)((Structure)structure).createComponent();
            if (state != null) {
                root.processRestoreState(context, state);
            }
            if (recalculateLocale) {
                root.setLocale((Locale)null);
            }
            _LOG.finer("Restored state for view \"{0}\"", (Object)viewId);
            return root;
        }
        catch (ClassNotFoundException cnfe) {
            _LOG.severe((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            _LOG.severe((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            _LOG.severe((Throwable)iae);
        }
        return null;
    }

    public void setPerViewStateSaving(String perViewStateSaving) {
        Map attrs = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        attrs.put(_PER_PAGE_STATE_SAVING, StateSaving.valueOf(perViewStateSaving.toUpperCase()));
    }

    public boolean isSavingStateInClient(FacesContext context) {
        return this._delegate.isSavingStateInClient(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected Object getComponentStateToSave(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    private TokenCache _getViewCache(RequestContext trinContext, ExternalContext extContext) {
        String cacheKey = StateManagerImpl._getViewCacheKey(extContext, trinContext, null);
        return TokenCache.getTokenCacheFromSession(extContext, cacheKey, true, this._getCacheSize(extContext));
    }

    private static String _getActivePageTokenKey(ExternalContext extContext, RequestContext trinContext) {
        return StateManagerImpl._getPerWindowCacheKey(extContext, trinContext, _ACTIVE_PAGE_TOKEN_SESSION_KEY, null);
    }

    private static String _getViewCacheKey(ExternalContext extContext, RequestContext trinContext, Character suffix) {
        return StateManagerImpl._getPerWindowCacheKey(extContext, trinContext, _VIEW_CACHE_KEY, suffix);
    }

    private static String _getPerWindowCacheKey(ExternalContext eContext, RequestContext trinContext, String prefix, Character suffix) {
        Window currWindow = trinContext.getWindowManager().getCurrentWindow(eContext);
        if (currWindow != null || suffix != null) {
            int windowPartSize;
            String windowId;
            if (currWindow != null) {
                windowId = currWindow.getId();
                windowPartSize = windowId.length() + 1;
            } else {
                windowId = null;
                windowPartSize = 0;
            }
            int builderSize = prefix.length() + windowPartSize;
            if (suffix != null) {
                ++builderSize;
            }
            StringBuilder keyBuilder = new StringBuilder(builderSize);
            keyBuilder.append(prefix);
            if (currWindow != null) {
                keyBuilder.append('.');
                keyBuilder.append(windowId);
            }
            if (suffix != null) {
                keyBuilder.append(suffix);
            }
            return keyBuilder.toString();
        }
        return prefix;
    }

    private boolean _saveAsToken(FacesContext context) {
        Map attrMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        StateSaving stateSaving = (StateSaving)((Object)attrMap.get(_PER_PAGE_STATE_SAVING));
        Boolean forceStateSavingPerView = null;
        if (StateSaving.CLIENT.equals((Object)stateSaving)) {
            forceStateSavingPerView = Boolean.FALSE;
        } else if (StateSaving.SERVER.equals((Object)stateSaving)) {
            forceStateSavingPerView = Boolean.TRUE;
        }
        if (forceStateSavingPerView != null) {
            return forceStateSavingPerView;
        }
        ExternalContext external = context.getExternalContext();
        Object stateSavingMethod = external.getInitParameterMap().get("javax.faces.STATE_SAVING_METHOD");
        if (stateSavingMethod == null || "server".equalsIgnoreCase((String)stateSavingMethod)) {
            return true;
        }
        Object clientMethod = external.getInitParameterMap().get(CLIENT_STATE_METHOD_PARAM_NAME);
        if (clientMethod != null && CLIENT_STATE_METHOD_ALL.equalsIgnoreCase((String)clientMethod)) {
            return false;
        }
        String viewStateValue = (String)external.getRequestParameterMap().get("javax.faces.ViewState");
        if (!this._isViewStateNull(viewStateValue) && !viewStateValue.startsWith("!")) {
            return false;
        }
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        return viewRoot == null || !"HTML_BASIC".equals(viewRoot.getRenderKitId());
    }

    private boolean _isViewStateNull(String viewStateValue) {
        return viewStateValue == null || "org.apache.myfaces.portlet.faces.nullViewState".equals(viewStateValue);
    }

    private int _getCacheSize(ExternalContext extContext) {
        Object maxTokens = extContext.getInitParameterMap().get(CLIENT_STATE_MAX_TOKENS_PARAM_NAME);
        if (maxTokens != null) {
            try {
                return Math.max(1, Integer.parseInt((String)maxTokens));
            }
            catch (NumberFormatException nfe) {
                _LOG.warning("Ignoring servlet init parameter:org.apache.myfaces.trinidad.CLIENT_STATE_MAX_TOKENS\n unable to parse:" + maxTokens, (Throwable)nfe);
                _LOG.warning((Throwable)nfe);
            }
        }
        return 15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PageState> _getApplicationViewCache(FacesContext context) {
        Object object = _APPLICATION_VIEW_CACHE_LOCK;
        synchronized (object) {
            Map appMap = context.getExternalContext().getApplicationMap();
            HashMap cache = (HashMap)appMap.get(_APPLICATION_VIEW_CACHE_KEY);
            if (cache == null) {
                cache = new HashMap(128);
                appMap.put(_APPLICATION_VIEW_CACHE_KEY, cache);
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PageState> _getPerSessionApplicationViewCache(FacesContext context) {
        Map<String, PageState> cache;
        ExternalContext external = context.getExternalContext();
        Object session = external.getSession(true);
        assert (session != null);
        Object object = session;
        synchronized (object) {
            Map sessionMap = external.getSessionMap();
            cache = (Map<String, PageState>)sessionMap.get(_APPLICATION_VIEW_CACHE_KEY);
            if (cache == null) {
                cache = StateManagerImpl._createPerSessionApplicationViewCache();
                sessionMap.put(_APPLICATION_VIEW_CACHE_KEY, cache);
            }
        }
        return cache;
    }

    private static Map<String, PageState> _createPerSessionApplicationViewCache() {
        return new LRUCache<String, PageState>(16);
    }

    private boolean _useApplicationViewCache(FacesContext context) {
        if (this._useApplicationViewCache == Boolean.FALSE) {
            return false;
        }
        if (this._saveAsToken(context) && !RequestContext.getCurrentInstance().isPostback()) {
            if (this._useApplicationViewCache == null) {
                String s = context.getExternalContext().getInitParameter(USE_APPLICATION_VIEW_CACHE_INIT_PARAM);
                Boolean bl = this._useApplicationViewCache = "true".equalsIgnoreCase(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (Boolean.TRUE.equals(this._useApplicationViewCache)) {
                _LOG.severe("USE_APPLICATION_VIEW_CACHE_UNSUPPORTED");
            }
            return this._useApplicationViewCache;
        }
        return false;
    }

    private boolean _useViewRootCache(FacesContext context) {
        if (this._useViewRootCache == null) {
            String s = context.getExternalContext().getInitParameter(CACHE_VIEW_ROOT_INIT_PARAM);
            this._useViewRootCache = !"false".equalsIgnoreCase(s) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._useViewRootCache;
    }

    private boolean _needStructure(FacesContext context) {
        if (this._structureGeneratedByTemplate == null) {
            ExternalContext external = context.getExternalContext();
            String restoreMode = external.getInitParameter("facelets.BUILD_BEFORE_RESTORE");
            this._structureGeneratedByTemplate = "true".equals(restoreMode) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._structureGeneratedByTemplate == false;
    }

    private static ResponseStateManager _getResponseStateManager(FacesContext context, String renderKitId) {
        RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit kit = factory.getRenderKit(context, renderKitId);
        return kit.getResponseStateManager();
    }

    private static void _removeTransientComponents(UIComponent root) {
        ArrayList<UIComponent> components = new ArrayList<UIComponent>();
        StateManagerImpl._gatherTransientComponents(root, components);
        for (UIComponent kid : components) {
            List children;
            UIComponent parent = kid.getParent();
            if (parent.getChildCount() > 0 && (children = parent.getChildren()).remove(kid)) continue;
            Map facets = parent.getFacets();
            Iterator facetIter = facets.values().iterator();
            while (facetIter.hasNext()) {
                if (facetIter.next() != kid) continue;
                facetIter.remove();
            }
            assert (false);
        }
    }

    private static void _gatherTransientComponents(UIComponent component, List<UIComponent> componentsToRemove) {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(component instanceof UIXComponentBase) && kid.isTransient()) {
                componentsToRemove.add(kid);
                continue;
            }
            StateManagerImpl._gatherTransientComponents(kid, componentsToRemove);
        }
    }

    private StateManager.SerializedView _getCachedSerializedView(FacesContext context) {
        return (StateManager.SerializedView)context.getExternalContext().getRequestMap().get(_CACHED_SERIALIZED_VIEW);
    }

    private void _saveCachedSerializedView(FacesContext context, StateManager.SerializedView state) {
        context.getExternalContext().getRequestMap().put(_CACHED_SERIALIZED_VIEW, state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateSaving {
        DEFAULT("default"),
        CLIENT("client"),
        SERVER("server");

        private String _stateSaving;

        private StateSaving(String stateSaving) {
            this._stateSaving = stateSaving;
        }
    }

    private static final class PageState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Object _viewState;
        private transient ViewRootState _cachedState;

        public PageState(FacesContext fc, Object viewState, UIViewRoot root) {
            this._viewState = viewState;
            boolean zipState = this._zipState(fc);
            if (zipState || StateUtils.checkComponentTreeStateSerialization((FacesContext)fc)) {
                if (zipState) {
                    this._zipToBytes(fc, viewState);
                } else {
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(viewState);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(_LOG.getMessage("COMPONENT_TREE_SERIALIZATION_FAILED"), e);
                    }
                }
            }
            this._cachedState = root != null ? new ViewRootState(fc, root) : null;
        }

        public Object getViewState(FacesContext context) {
            if (this._zipState(context)) {
                return this._unzipBytes(context, (byte[])this._viewState);
            }
            return this._viewState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearViewRootState() {
            PageState pageState = this;
            synchronized (pageState) {
                this._cachedState = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UIViewRoot popRoot(FacesContext fc) {
            UIViewRoot root = null;
            Object viewRootState = null;
            PageState pageState = this;
            synchronized (pageState) {
                if (this._cachedState != null) {
                    root = this._cachedState.getViewRoot();
                    viewRootState = this._cachedState.getViewRootState();
                    this._cachedState = null;
                }
            }
            if (root != null) {
                UIViewRoot newRoot = (UIViewRoot)fc.getApplication().createComponent("javax.faces.ViewRoot");
                if (ExternalContextUtils.isPortlet((ExternalContext)fc.getExternalContext())) {
                    try {
                        newRoot = (UIViewRoot)root.getClass().newInstance();
                    }
                    catch (InstantiationException e) {
                        _LOG.finest("Unable to instantiate new root of type class \"{0}\".", root.getClass());
                    }
                    catch (IllegalAccessException e) {
                        _LOG.finest("IllegalAccessException on new root of type class \"{0}\".", root.getClass());
                    }
                }
                newRoot.restoreState(fc, viewRootState);
                ArrayList temp = new ArrayList(root.getChildCount());
                temp.addAll(root.getChildren());
                newRoot.getChildren().addAll(temp);
                return newRoot;
            }
            return null;
        }

        private boolean _zipState(FacesContext fc) {
            String zipStateObject = fc.getExternalContext().getInitParameter(StateManagerImpl.COMPRESS_VIEW_STATE_PARAM_NAME);
            if (zipStateObject == null) {
                return false;
            }
            return zipStateObject.toString().equalsIgnoreCase("true");
        }

        private Object _unzipBytes(FacesContext context, byte[] zippedBytes) {
            Inflater decompressor = null;
            ExternalContext externalContext = context.getExternalContext();
            Map sessionMap = externalContext.getSessionMap();
            try {
                TransientHolder th = (TransientHolder)sessionMap.remove("PAGE_STATE_INFLATER");
                if (th != null) {
                    decompressor = (Inflater)th.getValue();
                }
                if (decompressor == null) {
                    decompressor = new Inflater();
                }
                decompressor.setInput(zippedBytes);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(zippedBytes.length);
                byte[] buf = new byte[zippedBytes.length * 5];
                while (!decompressor.finished()) {
                    try {
                        int count = decompressor.inflate(buf);
                        bos.write(buf, 0, count);
                    }
                    catch (DataFormatException e) {
                        throw new RuntimeException(_LOG.getMessage("UNZIP_STATE_FAILED"), e);
                    }
                }
                ByteArrayInputStream baos = new ByteArrayInputStream(bos.toByteArray());
                ObjectInputStreamResolveClass ois = new ObjectInputStreamResolveClass(baos);
                Object unzippedState = ois.readObject();
                ois.close();
                Object object = unzippedState;
                return object;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(_LOG.getMessage("UNZIP_STATE_FAILED"), cnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(_LOG.getMessage("UNZIP_STATE_FAILED"), ioe);
            }
            finally {
                if (decompressor != null) {
                    decompressor.reset();
                    decompressor.setInput(_EMPTY);
                    TransientHolder th = TransientHolder.newTransientHolder((Object)decompressor);
                    sessionMap.put("PAGE_STATE_INFLATER", th);
                }
            }
        }

        private void _zipToBytes(FacesContext context, Object viewState) {
            Deflater compresser = null;
            ExternalContext externalContext = context.getExternalContext();
            Map sessionMap = externalContext.getSessionMap();
            try {
                TransientHolder th = (TransientHolder)sessionMap.remove("PAGE_STATE_DEFLATER");
                if (th != null) {
                    compresser = (Deflater)th.getValue();
                }
                if (compresser == null) {
                    compresser = new Deflater(1);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(viewState);
                oos.flush();
                oos.close();
                byte[] ret = baos.toByteArray();
                compresser.setInput(ret);
                compresser.finish();
                baos.reset();
                byte[] buf = new byte[ret.length / 5];
                while (!compresser.finished()) {
                    int count = compresser.deflate(buf);
                    baos.write(buf, 0, count);
                }
                this._viewState = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(_LOG.getMessage("ZIP_STATE_FAILED"), e);
            }
            finally {
                if (compresser != null) {
                    compresser.reset();
                    compresser.setInput(_EMPTY);
                    TransientHolder th = TransientHolder.newTransientHolder((Object)compresser);
                    sessionMap.put("PAGE_STATE_DEFLATER", th);
                }
            }
        }
    }

    private static final class ViewRootState {
        private final UIViewRoot _viewRoot;
        private final Object _viewRootState;

        public ViewRootState(FacesContext context, UIViewRoot viewRoot) {
            if (viewRoot == null) {
                throw new NullPointerException();
            }
            this._viewRoot = viewRoot;
            this._viewRootState = viewRoot.saveState(context);
        }

        public UIViewRoot getViewRoot() {
            return this._viewRoot;
        }

        public Object getViewRootState() {
            return this._viewRootState;
        }
    }
}

