/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.PropertyMap;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class StateUtils {
    private static final boolean _CHECK_COMPONENT_TREE_STATE_SERIALIZATION;
    private static final boolean _CHECK_COMPONENT_STATE_SERIALIZATION;
    private static final boolean _CHECK_PROPERTY_STATE_SERIALIZATION;
    private static final boolean _CHECK_SESSION_SERIALIZATION;
    private static final boolean _CHECK_APPLICATION_SERIALIZATION;
    private static final boolean _CHECK_MANAGED_BEAN_MUTATATION;
    private static final boolean _CHECK_AT_END_REQUEST;
    private static final TrinidadLogger _LOG;
    private static final String _CLASS_MAP_KEY = "org.apache.myfaces.trinidad.bean.util.CLASS_MAP_KEY";

    private static boolean _checkPropertyStateSerialization() {
        return _CHECK_PROPERTY_STATE_SERIALIZATION;
    }

    public static boolean checkComponentStateSerialization(FacesContext context) {
        return _CHECK_COMPONENT_STATE_SERIALIZATION;
    }

    public static boolean checkComponentTreeStateSerialization(FacesContext context) {
        return _CHECK_COMPONENT_TREE_STATE_SERIALIZATION;
    }

    public static boolean checkSessionSerialization(ExternalContext extContext) {
        return _CHECK_SESSION_SERIALIZATION;
    }

    public static boolean checkApplicationSerialization(ExternalContext extContext) {
        return _CHECK_APPLICATION_SERIALIZATION;
    }

    public static boolean checkManagedBeanMutation(ExternalContext extContext) {
        return _CHECK_MANAGED_BEAN_MUTATATION;
    }

    public static boolean checkScopesAtEndOfRequest(ExternalContext extContext) {
        return _CHECK_AT_END_REQUEST;
    }

    public static Object saveKey(PropertyKey key) {
        int index = key.getIndex();
        if (index < 0) {
            return key.getName();
        }
        if (index < 128) {
            return (byte)index;
        }
        return index;
    }

    public static PropertyKey restoreKey(FacesBean.Type type, Object value) {
        PropertyKey key;
        if (value instanceof Number) {
            key = type.findKey(((Number)value).intValue());
            if (key == null) {
                throw new IllegalStateException(_LOG.getMessage("INVALID_INDEX"));
            }
        } else {
            key = type.findKey((String)value);
            if (key == null) {
                key = PropertyKey.createPropertyKey((String)value);
            }
        }
        return key;
    }

    public static Object saveState(PropertyMap map, FacesContext context, boolean useStateHolder) {
        int size = map.size();
        if (size == 0) {
            return null;
        }
        Object[] values = new Object[2 * size];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            PropertyKey key = (PropertyKey)entry.getKey();
            if (key.isTransient()) {
                entry.setValue(null);
                continue;
            }
            Object value = entry.getValue();
            values[i] = StateUtils.saveKey(key);
            if (_LOG.isFinest()) {
                _LOG.finest("SAVE {" + key + "=" + value + "}");
            }
            Object saveValue = useStateHolder ? StateUtils.saveStateHolder(context, value) : key.saveValue(context, value);
            if (StateUtils._checkPropertyStateSerialization()) {
                try {
                    new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(saveValue);
                }
                catch (IOException e) {
                    throw new RuntimeException(_LOG.getMessage("UNSERIALIZABLE_PROPERTY_VALUE", new Object[]{saveValue, key, map}), e);
                }
            }
            values[i + 1] = saveValue;
            i += 2;
        }
        return values;
    }

    public static void restoreState(PropertyMap map, FacesContext context, FacesBean.Type type, Object state, boolean useStateHolder) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        int size = values.length / 2;
        for (int i = 0; i < size; ++i) {
            Object savedKey = values[i * 2];
            if (savedKey == null) continue;
            Object savedValue = values[i * 2 + 1];
            PropertyKey key = StateUtils.restoreKey(type, savedKey);
            Object value = useStateHolder ? StateUtils.restoreStateHolder(context, savedValue) : key.restoreValue(context, savedValue);
            if (_LOG.isFinest()) {
                _LOG.finest("RESTORE {" + key + "=" + value + "}");
            }
            map.put(key, value);
        }
    }

    public static Object saveStateHolder(FacesContext context, Object value) {
        if (value == null) {
            return null;
        }
        Saver saver = null;
        if (value instanceof StateHolder) {
            if (((StateHolder)value).isTransient()) {
                return null;
            }
            saver = new SHSaver();
        } else {
            if (value instanceof Serializable) {
                return value;
            }
            saver = new Saver();
        }
        if (saver != null) {
            saver.saveState(context, value);
        }
        return saver;
    }

    public static Object restoreStateHolder(FacesContext context, Object savedValue) {
        if (!(savedValue instanceof Saver)) {
            return savedValue;
        }
        return ((Saver)savedValue).restoreState(context);
    }

    public static Object saveList(FacesContext context, Object value) {
        if (value == null) {
            return null;
        }
        List list = (List)value;
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object[] array = new Object[size];
        int index = 0;
        for (Object object : list) {
            array[index++] = StateUtils.saveStateHolder(context, object);
        }
        return array;
    }

    public static Object restoreList(FacesContext context, Object savedValue) {
        if (savedValue == null) {
            return null;
        }
        Object[] array = (Object[])savedValue;
        int length = array.length;
        if (length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (Object state : array) {
            Object restored = StateUtils.restoreStateHolder(context, state);
            if (restored == null) continue;
            list.add(restored);
        }
        return list;
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = StateUtils.class.getClassLoader();
        }
        return cl;
    }

    static {
        String[] paramArray;
        HashSet<String> serializationFlags;
        String checkSerializationProperty;
        boolean checkPropertyStateSerialization = false;
        boolean checkComponentStateSerialization = false;
        boolean checkComponentTreeStateSerialization = false;
        boolean checkSessionSerialization = false;
        boolean checkApplicationSerialization = false;
        boolean checkMangedBeanMutation = false;
        boolean checkAtEndRequest = false;
        try {
            checkSerializationProperty = System.getProperty("org.apache.myfaces.trinidad.CHECK_STATE_SERIALIZATION");
        }
        catch (Throwable t) {
            checkSerializationProperty = null;
        }
        if (checkSerializationProperty != null && !(serializationFlags = new HashSet<String>(Arrays.asList(paramArray = (checkSerializationProperty = checkSerializationProperty.toUpperCase()).split(",")))).contains("NONE")) {
            if (serializationFlags.contains("ALL")) {
                checkPropertyStateSerialization = true;
                checkComponentStateSerialization = true;
                checkComponentTreeStateSerialization = true;
                checkSessionSerialization = true;
                checkApplicationSerialization = true;
                checkMangedBeanMutation = true;
                checkAtEndRequest = true;
            } else {
                checkPropertyStateSerialization = serializationFlags.contains("PROPERTY");
                checkComponentStateSerialization = serializationFlags.contains("COMPONENT");
                checkComponentTreeStateSerialization = serializationFlags.contains("TREE");
                checkSessionSerialization = serializationFlags.contains("SESSION");
                checkApplicationSerialization = serializationFlags.contains("APPLICATION");
                checkMangedBeanMutation = serializationFlags.contains("BEANS");
                checkAtEndRequest = serializationFlags.contains("REQUEST");
            }
        }
        _CHECK_PROPERTY_STATE_SERIALIZATION = checkPropertyStateSerialization;
        _CHECK_COMPONENT_STATE_SERIALIZATION = checkComponentStateSerialization;
        _CHECK_COMPONENT_TREE_STATE_SERIALIZATION = checkComponentTreeStateSerialization;
        _CHECK_SESSION_SERIALIZATION = checkSessionSerialization;
        _CHECK_APPLICATION_SERIALIZATION = checkApplicationSerialization;
        _CHECK_MANAGED_BEAN_MUTATATION = checkMangedBeanMutation;
        _CHECK_AT_END_REQUEST = checkAtEndRequest;
        _LOG = TrinidadLogger.createTrinidadLogger(StateUtils.class);
    }

    private static class SHSaver
    extends Saver {
        private Object _save;
        private static final long serialVersionUID = 1L;

        private SHSaver() {
        }

        public void saveState(FacesContext context, Object value) {
            super.saveState(context, value);
            this._save = ((StateHolder)value).saveState(context);
        }

        public Object restoreState(FacesContext context) {
            Object o = super.restoreState(context);
            if (o != null) {
                ((StateHolder)o).restoreState(context, this._save);
            }
            return o;
        }
    }

    private static class Saver
    implements Serializable {
        private String _name;
        private static final long serialVersionUID = 1L;

        private Saver() {
        }

        public void saveState(FacesContext context, Object saved) {
            this._name = saved.getClass().getName();
        }

        public Object restoreState(FacesContext context) {
            Class<?> clazz;
            ConcurrentMap<String, Object> appMap = RequestContext.getCurrentInstance().getApplicationScopedConcurrentMap();
            Map<String, Class<Object>> classMap = (HashMap)appMap.get(StateUtils._CLASS_MAP_KEY);
            if (classMap == null) {
                HashMap newClassMap = new HashMap();
                Map oldClassMap = appMap.putIfAbsent(StateUtils._CLASS_MAP_KEY, newClassMap);
                classMap = oldClassMap != null ? oldClassMap : newClassMap;
            }
            if ((clazz = (Class<?>)classMap.get(this._name)) == null) {
                try {
                    ClassLoader cl = StateUtils._getClassLoader();
                    clazz = cl.loadClass(this._name);
                    classMap.put(this._name, clazz);
                }
                catch (Throwable t) {
                    _LOG.severe(t);
                    return null;
                }
            }
            try {
                return clazz.newInstance();
            }
            catch (Throwable t) {
                _LOG.severe(t);
                return null;
            }
        }
    }
}

