/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.util.CollectionUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentAtRuleMatcher {
    private static final Pattern _PROPERTY_SPLITTER = Pattern.compile("\\(\\s*([A-Za-z0-9_-]+)\\s*:\\s*(\\S+)\\s*\\)");
    private static final Pattern _AND_SPLITTER = Pattern.compile("\\s+and\\s+");
    private static final Set<Match> _NO_MATCH = Collections.emptySet();
    private static final Set<Match> _APPLICATION_ONLY_MATCH = Collections.singleton(Match.APPLICATION);
    private static final Set<Match> _APPLICATION_AND_VERSION_MATCH = Collections.unmodifiableSet(EnumSet.of(Match.APPLICATION, Match.VERSION));
    private static final Map<String, Comparison> _COMPARISON_PARSER = new HashMap<String, Comparison>(4);
    private final Map<TrinidadAgent.Application, Set<AgentMatcher>> _selectorAgents;
    private final int _hashCode;

    public AgentAtRuleMatcher(List<TrinidadAgent.Application> browsers, Version[] versions) {
        Map<TrinidadAgent.Application, Set<AgentMatcher>> browserMap;
        Object[] versionMatchers;
        int versionCount;
        int n = versionCount = versions != null ? versions.length : 0;
        if (versionCount == 0) {
            versionMatchers = null;
        } else {
            versionMatchers = new AgentMatcher[versionCount];
            for (int i = 0; i < versionCount; ++i) {
                versionMatchers[i] = new VersionMatcher(versions[i], Comparison.EQUALS);
            }
        }
        Set versionSet = CollectionUtils.asSet((Object[])versionMatchers);
        int browserCount = browsers.size();
        if (browserCount == 0) {
            browserMap = Collections.emptyMap();
        } else if (browserCount == 1) {
            browserMap = Collections.singletonMap(browsers.get(0), versionSet);
        } else {
            browserMap = new HashMap(browserCount);
            for (int i = 0; i < browserCount; ++i) {
                browserMap.put(browsers.get(i), versionSet);
            }
        }
        this._selectorAgents = browserMap;
        this._hashCode = AgentAtRuleMatcher._calculateStableHashCode(browserMap);
    }

    public AgentAtRuleMatcher(String queryString) {
        this(queryString.split(","));
    }

    public AgentAtRuleMatcher(String[] selectors) {
        Map<TrinidadAgent.Application, Set<AgentMatcher>> selectorAgents = Collections.emptyMap();
        for (int selectorIndex = 0; selectorIndex < selectors.length; ++selectorIndex) {
            Set<Object> agentMatchers;
            String currSelector = selectors[selectorIndex];
            String[] sections = _AND_SPLITTER.split(currSelector);
            String agentName = sections[0].trim();
            TrinidadAgent.Application browser = NameUtils.getAgentApplication(agentName);
            if (browser == TrinidadAgent.Application.UNKNOWN) continue;
            int sectionCount = sections.length;
            if (sectionCount == 1) {
                agentMatchers = Collections.emptySet();
            } else {
                AgentMatcher newVersionMatcher;
                if (sectionCount > 2) {
                    ArrayList<AgentMatcher> andedMatchers = new ArrayList<AgentMatcher>(sectionCount - 1);
                    for (int sectionIndex = 1; sectionIndex < sectionCount; ++sectionIndex) {
                        andedMatchers.add(this._getVersionMatcher(sections[sectionIndex]));
                    }
                    newVersionMatcher = new AndMatcher(andedMatchers);
                } else {
                    newVersionMatcher = this._getVersionMatcher(sections[1]);
                }
                agentMatchers = selectorAgents.get((Object)browser);
                if (agentMatchers == null || agentMatchers.isEmpty()) {
                    agentMatchers = Collections.singleton(newVersionMatcher);
                } else if (!agentMatchers.contains(newVersionMatcher)) {
                    if (agentMatchers.size() == 1) {
                        agentMatchers = new HashSet<Object>(agentMatchers);
                    }
                    agentMatchers.add(newVersionMatcher);
                }
            }
            if (selectorAgents.isEmpty()) {
                selectorAgents = Collections.singletonMap(browser, agentMatchers);
                continue;
            }
            if (agentMatchers.equals(selectorAgents.get((Object)browser))) continue;
            if (selectorAgents.size() == 1) {
                HashMap<TrinidadAgent.Application, Set<AgentMatcher>> newSelectorAgents = new HashMap<TrinidadAgent.Application, Set<AgentMatcher>>(3);
                Map.Entry<TrinidadAgent.Application, Set<AgentMatcher>> singleEntry = selectorAgents.entrySet().iterator().next();
                newSelectorAgents.put(singleEntry.getKey(), singleEntry.getValue());
                selectorAgents = newSelectorAgents;
            }
            selectorAgents.put(browser, agentMatchers);
        }
        this._selectorAgents = selectorAgents;
        this._hashCode = AgentAtRuleMatcher._calculateStableHashCode(selectorAgents);
    }

    private static int _calculateStableHashCode(Map<TrinidadAgent.Application, Set<AgentMatcher>> selectorAgents) {
        int hashCode = 0;
        for (Map.Entry<TrinidadAgent.Application, Set<AgentMatcher>> entry : selectorAgents.entrySet()) {
            int stableKeyHashCode = entry.getKey().name().hashCode();
            int entryHashCode = stableKeyHashCode ^ entry.getValue().hashCode();
            hashCode += entryHashCode;
        }
        return hashCode;
    }

    private VersionMatcher _getVersionMatcher(String propertySelector) {
        Matcher m = _PROPERTY_SPLITTER.matcher(propertySelector);
        if (m.find()) {
            String propName = m.group(1);
            String version = m.group(2);
            Comparison comparison = _COMPARISON_PARSER.get(propName);
            if (comparison == null) {
                throw new IllegalArgumentException("Invalid @agent property name: " + propName);
            }
            Version newVersion = new Version(version, "*");
            return new VersionMatcher(newVersion, comparison);
        }
        throw new IllegalArgumentException("Invalid @agent property selector: " + propertySelector);
    }

    public Set<Match> match(TrinidadAgent agent) {
        TrinidadAgent.Application browser = agent.getAgentApplication();
        if (this._selectorAgents.containsKey((Object)browser)) {
            Set<AgentMatcher> agentMatchers = this._selectorAgents.get((Object)browser);
            if (agentMatchers.isEmpty()) {
                return _APPLICATION_ONLY_MATCH;
            }
            for (AgentMatcher currMatcher : agentMatchers) {
                if (!currMatcher.match(agent)) continue;
                return _APPLICATION_AND_VERSION_MATCH;
            }
        }
        return _NO_MATCH;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AgentAtRuleMatcher) {
            return this._selectorAgents.equals(((AgentAtRuleMatcher)other)._selectorAgents);
        }
        return false;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return super.toString() + "agents=" + this._selectorAgents.toString();
    }

    static {
        _COMPARISON_PARSER.put("version", Comparison.EQUALS);
        _COMPARISON_PARSER.put("max-version", Comparison.MAX);
        _COMPARISON_PARSER.put("min-version", Comparison.MIN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndMatcher
    extends AgentMatcher {
        private final List<AgentMatcher> _matchers;
        private final int _hashCode;

        public AndMatcher(List<AgentMatcher> matchers) {
            this._matchers = matchers;
            this._hashCode = matchers.hashCode();
        }

        @Override
        public boolean match(TrinidadAgent agent) {
            int matcherCount = this._matchers.size();
            for (int i = 0; i < matcherCount; ++i) {
                if (this._matchers.get(i).match(agent)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this._hashCode;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof AndMatcher) {
                return this._matchers.equals(((AndMatcher)other)._matchers);
            }
            return false;
        }

        public String toString() {
            return super.toString() + ", matchers=" + this._matchers;
        }
    }

    private static final class VersionMatcher
    extends AgentMatcher {
        private final Version _version;
        private final Comparison _comparison;
        private final int _hashCode;

        public VersionMatcher(Version version, Comparison comparison) {
            this._version = version;
            this._comparison = comparison;
            this._hashCode = this._version.hashCode() * 37 + this._comparison.name().hashCode();
        }

        public boolean match(TrinidadAgent agent) {
            int result = this._version.compareTo(agent.getVersion());
            if (result == 0) {
                return true;
            }
            switch (this._comparison) {
                case MIN: {
                    return result < 0;
                }
                case MAX: {
                    return result > 0;
                }
                case EQUALS: {
                    return false;
                }
            }
            assert (false) : "Unknown comparison type " + (Object)((Object)this._comparison);
            return false;
        }

        public final int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof VersionMatcher) {
                VersionMatcher otherVersionMatcher = (VersionMatcher)other;
                return this._version.equals((Object)otherVersionMatcher._version) && this._comparison.equals((Object)otherVersionMatcher._comparison);
            }
            return false;
        }

        public String toString() {
            return super.toString() + ", version=" + this._version + ", comparison=" + (Object)((Object)this._comparison);
        }
    }

    private static abstract class AgentMatcher {
        private AgentMatcher() {
        }

        public abstract boolean match(TrinidadAgent var1);

        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Comparison {
        EQUALS,
        MIN,
        MAX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Match {
        APPLICATION,
        VERSION;

    }
}

