/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.faces.context.ExternalContext;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.CollectionUtils;
import org.apache.myfaces.trinidad.util.TransientHolder;
import org.apache.myfaces.trinidadinternal.context.external.ServletApplicationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckSerializationConfigurator
extends Configurator {
    private static final String _CHECKED_MAPS_KEY = MutatedBeanChecker.class.getName() + "#MAPS";
    private static final String _SERIALIZATION_CHECKER_KEY = CheckSerializationConfigurator.class.getName() + "#CHECKER";

    public ExternalContext getExternalContext(ExternalContext extContext) {
        SerializationCheckingWrapper checkingContext = SerializationCheckingWrapper.getSerializationWrapper(extContext, true);
        if (checkingContext != null) {
            return checkingContext;
        }
        return extContext;
    }

    public void endRequest(ExternalContext extContext) {
        SerializationCheckingWrapper checkingWrapper = SerializationCheckingWrapper.getSerializationWrapper(extContext, false);
        if (checkingWrapper != null) {
            checkingWrapper.checkForMutations();
        }
    }

    public static FilterConfig getFilterConfig(FilterConfig filterConfig) {
        if (StateUtils.checkApplicationSerialization(null)) {
            return new FilterConfigWrapper(filterConfig);
        }
        return filterConfig;
    }

    public static HttpServletRequest getHttpServletRequest(ExternalContext extContext, HttpServletRequest request) {
        SerializationChecker checker = SerializationChecker.getSerializationChecker(extContext, true);
        if (checker != null) {
            return checker.getWrappedRequest(request);
        }
        return request;
    }

    public static void unregisterSessionAttribute(ExternalContext external, String key) {
        SerializationChecker checker = SerializationChecker.getSerializationChecker(external, false);
        if (checker != null) {
            checker.unregisterSessionAttribute(external, key);
        }
    }

    public static void unregisterApplicationAttribute(ExternalContext external, String key) {
        SerializationChecker checker = SerializationChecker.getSerializationChecker(external, false);
        if (checker != null) {
            checker.unregisterApplicationAttribute(external, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MutatedBeanChecker> _getMutatedBeanList(Map<String, Object> checkedMap, Object mapWriteLock) {
        Object list = checkedMap.get(_CHECKED_MAPS_KEY);
        if (list == null) {
            Object object = mapWriteLock;
            synchronized (object) {
                list = checkedMap.get(_CHECKED_MAPS_KEY);
                if (list == null) {
                    CopyOnWriteArrayList<MutatedBeanChecker> beanList = new CopyOnWriteArrayList<MutatedBeanChecker>();
                    checkedMap.put(_CHECKED_MAPS_KEY, TransientHolder.newTransientHolder(beanList));
                    return beanList;
                }
            }
        }
        return (List)((TransientHolder)list).getValue();
    }

    private static void _notifyBeanCheckersOfChange(List<MutatedBeanChecker> beanCheckers, Object key) {
        for (MutatedBeanChecker beanChecker : beanCheckers) {
            beanChecker._unmutatedKeyValues.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationChecker {
        private final MutatedBeanChecker _sessionBeanChecker;
        private final MutatedBeanChecker _applicationBeanChecker;
        private final Map<String, Object> _sessionMap;
        private final Map<String, Object> _applicationMap;

        public static SerializationChecker getSerializationChecker(ExternalContext extContext, boolean create) {
            Map requestMap = extContext.getRequestMap();
            Object checker = requestMap.get(_SERIALIZATION_CHECKER_KEY);
            if (checker != null) {
                return (SerializationChecker)checker;
            }
            if (create) {
                boolean checkSession = StateUtils.checkSessionSerialization((ExternalContext)extContext);
                boolean checkApplication = StateUtils.checkApplicationSerialization((ExternalContext)extContext);
                boolean checkManagedBeanMutation = StateUtils.checkManagedBeanMutation((ExternalContext)extContext);
                if (checkSession || checkApplication || checkManagedBeanMutation) {
                    SerializationChecker serializationChecker = new SerializationChecker(extContext, checkSession, checkApplication, checkManagedBeanMutation);
                    requestMap.put(_SERIALIZATION_CHECKER_KEY, serializationChecker);
                    return serializationChecker;
                }
            }
            return null;
        }

        private SerializationChecker(ExternalContext extContext, boolean checkSession, boolean checkApplication, boolean checkManagedBeanMutation) {
            Map sessionMap = extContext.getSessionMap();
            Map applicationMap = extContext.getApplicationMap();
            if (checkManagedBeanMutation) {
                this._sessionBeanChecker = new MutatedBeanChecker(sessionMap, "Session", extContext.getSession(true), true);
                sessionMap = CollectionUtils.newMutationHookedMap((Map)sessionMap, (CollectionUtils.MapMutationHooks)this._sessionBeanChecker);
                if (checkApplication) {
                    this._applicationBeanChecker = new MutatedBeanChecker(applicationMap, "Application", extContext.getContext(), false);
                    applicationMap = CollectionUtils.newMutationHookedMap((Map)applicationMap, (CollectionUtils.MapMutationHooks)this._applicationBeanChecker);
                } else {
                    this._applicationBeanChecker = null;
                }
            } else {
                this._sessionBeanChecker = null;
                this._applicationBeanChecker = null;
                if (checkSession) {
                    sessionMap = CollectionUtils.getCheckedSerializationMap((Map)sessionMap, (boolean)true);
                }
                if (checkApplication) {
                    applicationMap = CollectionUtils.getCheckedSerializationMap((Map)applicationMap, (boolean)false);
                }
            }
            this._sessionMap = sessionMap;
            this._applicationMap = applicationMap;
        }

        public void unregisterSessionAttribute(ExternalContext external, String key) {
            SerializationChecker checker = SerializationChecker.getSerializationChecker(external, false);
            if (checker != null && this._sessionBeanChecker != null) {
                this._sessionBeanChecker.unregisterAttribute(key);
            }
        }

        public void unregisterApplicationAttribute(ExternalContext external, String key) {
            SerializationChecker checker = SerializationChecker.getSerializationChecker(external, false);
            if (checker != null && this._applicationBeanChecker != null) {
                this._applicationBeanChecker.unregisterAttribute(key);
            }
        }

        public HttpServletRequest getWrappedRequest(HttpServletRequest request) {
            if (this._sessionBeanChecker != null) {
                return new SessionBeanTracker(request, this._sessionBeanChecker, this._sessionMap, this._applicationMap);
            }
            return request;
        }

        public Map<String, Object> getSessionMap() {
            return this._sessionMap;
        }

        public Map<String, Object> getApplicationMap() {
            return this._applicationMap;
        }

        public void checkForMutations() {
            if (this._sessionBeanChecker != null) {
                this._sessionBeanChecker.checkForMutations();
            }
            if (this._applicationBeanChecker != null) {
                this._applicationBeanChecker.checkForMutations();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class SessionBeanTracker
        extends HttpServletRequestWrapper {
            private final HttpSession _wrappedSession;

            public SessionBeanTracker(HttpServletRequest request, MutatedBeanChecker sessionBeanChecker, Map<String, Object> sessionMap, Map<String, Object> applicationMap) {
                super(request);
                this._wrappedSession = new SessionWrapper(request.getSession(), sessionBeanChecker, sessionMap, applicationMap);
            }

            public HttpSession getSession() {
                return this._wrappedSession;
            }

            public HttpSession getSession(boolean p1) {
                return this._wrappedSession;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static final class SessionWrapper
            implements HttpSession {
                private final HttpSession _delegate;
                private final MutatedBeanChecker _sessionChecker;
                private final Map<String, Object> _sessionMap;
                private final ServletContext _wrappedContext;

                SessionWrapper(HttpSession session, MutatedBeanChecker sessionChecker, Map<String, Object> sessionMap, Map<String, Object> applicationMap) {
                    this._delegate = session;
                    this._sessionChecker = sessionChecker;
                    this._sessionMap = sessionMap;
                    this._wrappedContext = applicationMap != null ? new ContextWrapper(session.getServletContext(), applicationMap) : null;
                }

                public long getCreationTime() {
                    return this._delegate.getCreationTime();
                }

                public String getId() {
                    return this._delegate.getId();
                }

                public long getLastAccessedTime() {
                    return this._delegate.getLastAccessedTime();
                }

                public ServletContext getServletContext() {
                    if (this._wrappedContext != null) {
                        return this._wrappedContext;
                    }
                    return this._delegate.getServletContext();
                }

                public void setMaxInactiveInterval(int maxInterval) {
                    this._delegate.setMaxInactiveInterval(maxInterval);
                }

                public int getMaxInactiveInterval() {
                    return this._delegate.getMaxInactiveInterval();
                }

                public HttpSessionContext getSessionContext() {
                    return this._delegate.getSessionContext();
                }

                public Object getAttribute(String attrName) {
                    return this._delegate.getAttribute(attrName);
                }

                public Object getValue(String attrName) {
                    return this._delegate.getValue(attrName);
                }

                public Enumeration getAttributeNames() {
                    return this._delegate.getAttributeNames();
                }

                public String[] getValueNames() {
                    return this._delegate.getValueNames();
                }

                public void setAttribute(String key, Object value) {
                    this._delegate.setAttribute(key, value);
                    this._sessionChecker.writeNotify(this._sessionMap, key, value);
                }

                public void putValue(String key, Object value) {
                    this._delegate.putValue(key, value);
                    this._sessionChecker.writeNotify(this._sessionMap, key, value);
                }

                public void removeAttribute(String key) {
                    this._delegate.removeAttribute(key);
                    this._sessionChecker.removeNotify(this._sessionMap, key);
                }

                public void removeValue(String key) {
                    this._delegate.removeValue(key);
                    this._sessionChecker.removeNotify(this._sessionMap, key);
                }

                public void invalidate() {
                    this._delegate.invalidate();
                    this._sessionChecker.clearCheckedValues();
                }

                public boolean isNew() {
                    return this._delegate.isNew();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextWrapper
    implements ServletContext {
        private final ServletContext _delegate;
        private final Map<String, Object> _applicationMap;

        ContextWrapper(ServletContext servletContext, Map<String, Object> applicationMap) {
            this._delegate = servletContext;
            this._applicationMap = applicationMap != null ? applicationMap : new ServletApplicationMap(servletContext);
        }

        public String getContextPath() {
            return this._delegate.getContextPath();
        }

        public ServletContext getContext(String string) {
            return this._delegate.getContext(string);
        }

        public int getMajorVersion() {
            return this._delegate.getMajorVersion();
        }

        public int getMinorVersion() {
            return this._delegate.getMinorVersion();
        }

        public String getMimeType(String string) {
            return this._delegate.getMimeType(string);
        }

        public Set getResourcePaths(String string) {
            return this._delegate.getResourcePaths(string);
        }

        public URL getResource(String string) throws MalformedURLException {
            return this._delegate.getResource(string);
        }

        public InputStream getResourceAsStream(String string) {
            return this._delegate.getResourceAsStream(string);
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return this._delegate.getRequestDispatcher(string);
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            return this._delegate.getNamedDispatcher(string);
        }

        public Servlet getServlet(String string) throws ServletException {
            return this._delegate.getServlet(string);
        }

        public Enumeration getServlets() {
            return this._delegate.getServlets();
        }

        public Enumeration getServletNames() {
            return this._delegate.getServletNames();
        }

        public void log(String string) {
            this._delegate.log(string);
        }

        public void log(Exception exception, String string) {
            this._delegate.log(exception, string);
        }

        public void log(String string, Throwable throwable) {
            this._delegate.log(string, throwable);
        }

        public String getRealPath(String string) {
            return this._delegate.getRealPath(string);
        }

        public String getServerInfo() {
            return this._delegate.getServerInfo();
        }

        public String getInitParameter(String string) {
            return this._delegate.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return this._delegate.getInitParameterNames();
        }

        public Object getAttribute(String key) {
            return this._delegate.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            return this._delegate.getAttributeNames();
        }

        public void setAttribute(String key, Object value) {
            this._delegate.setAttribute(key, value);
            CheckSerializationConfigurator._notifyBeanCheckersOfChange(this._getMutatedBeanList(), key);
        }

        public void removeAttribute(String key) {
            this._delegate.removeAttribute(key);
            CheckSerializationConfigurator._notifyBeanCheckersOfChange(this._getMutatedBeanList(), key);
        }

        public String getServletContextName() {
            return this._delegate.getServletContextName();
        }

        private List<MutatedBeanChecker> _getMutatedBeanList() {
            return CheckSerializationConfigurator._getMutatedBeanList(this._applicationMap, this._delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MutatedBeanChecker
    implements CollectionUtils.MapMutationHooks<String, Object> {
        private static final byte[] _EMPTY_BYTE_ARRAY = new byte[0];
        private static final Set<String> _INGNORE_CLASS_NAMES;
        private static final TrinidadLogger _LOG;
        private final Map<String, Object> _unmutatedKeyValues;
        private final Map<String, Object> _checkedMap;
        private final String _mapName;
        private final Object _mapLock;

        public MutatedBeanChecker(Map<String, Object> checkedMap, String mapName, Object mapLock, boolean requireSerialization) {
            this._checkedMap = checkedMap;
            this._mapName = mapName;
            this._mapLock = mapLock;
            this._unmutatedKeyValues = new ConcurrentHashMap<String, Object>(checkedMap.size() * 2);
            this._unmutatedKeyValues.putAll(checkedMap);
            this._getMutatedBeanList().add(this);
            for (String key : this._unmutatedKeyValues.keySet()) {
                Object value;
                byte[] serializedBytes = this._getSerializedValue(key, value = checkedMap.get(key), requireSerialization);
                if (serializedBytes.length > 0) {
                    this._unmutatedKeyValues.put(key, serializedBytes);
                    continue;
                }
                this._unmutatedKeyValues.remove(key);
            }
        }

        public void unregisterAttribute(String key) {
            CheckSerializationConfigurator._notifyBeanCheckersOfChange(this._getMutatedBeanList(), key);
        }

        public void writeNotify(Map<String, Object> map, String key, Object value) {
            this.unregisterAttribute(key);
        }

        public void removeNotify(Map<String, Object> map, Object key) {
            this.unregisterAttribute((String)key);
        }

        public void clearNotify(Map<String, Object> map) {
            for (String key : map.keySet()) {
                this.unregisterAttribute(key);
            }
        }

        public void clearCheckedValues() {
            for (MutatedBeanChecker beanChecker : this._getMutatedBeanList()) {
                beanChecker._unmutatedKeyValues.clear();
            }
        }

        public void checkForMutations() {
            for (Map.Entry<String, Object> checkedEntry : this._unmutatedKeyValues.entrySet()) {
                String key = checkedEntry.getKey();
                Object currValue = this._checkedMap.get(key);
                byte[] currentBytes = this._getSerializedValue(key, currValue, false);
                byte[] oldBytes = (byte[])checkedEntry.getValue();
                if (Arrays.equals(oldBytes, currentBytes)) continue;
                Object oldValue = this._deserializeObject(oldBytes);
                Object newValue = this._deserializeObject(currentBytes);
                oldValue.equals(newValue);
                String message = _LOG.getMessage("SERIALIZABLE_ATTRIBUTE_MUTATED", new Object[]{this._mapName, key, oldValue, newValue});
                _LOG.severe(message);
            }
            this._getMutatedBeanList().remove(this);
        }

        private Object _deserializeObject(byte[] serializedBytes) {
            Object deserializedObject;
            try {
                byte[] copyBytes = Arrays.copyOf(serializedBytes, serializedBytes.length);
                ByteArrayInputStream baos = new ByteArrayInputStream(copyBytes);
                ObjectInputStream ois = new ObjectInputStream(baos);
                deserializedObject = ois.readObject();
                ois.close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            return deserializedObject;
        }

        private List<MutatedBeanChecker> _getMutatedBeanList() {
            return CheckSerializationConfigurator._getMutatedBeanList(this._checkedMap, this._mapLock);
        }

        private byte[] _getSerializedValue(String key, Object value, boolean requireSerialization) {
            if (value == null) {
                return _EMPTY_BYTE_ARRAY;
            }
            Class<?> valueClass = value.getClass();
            if (_INGNORE_CLASS_NAMES.contains(valueClass.getName())) {
                return _EMPTY_BYTE_ARRAY;
            }
            if (!(value instanceof Serializable)) {
                if (requireSerialization) {
                    String message = _LOG.getMessage("ATTRIBUTE_NOT_SERIALIZABLE", new Object[]{this._mapName, key, valueClass});
                }
                return _EMPTY_BYTE_ARRAY;
            }
            try {
                ByteArrayOutputStream outputByteStream = new ByteArrayOutputStream();
                new ObjectOutputStream(outputByteStream).writeObject(value);
                return outputByteStream.toByteArray();
            }
            catch (IOException e) {
                if (requireSerialization) {
                    String message = _LOG.getMessage("ATTRIBUTE_SERIALIZATION_FAILED", new Object[]{this._mapName, key, value});
                    throw new IllegalArgumentException(message, e);
                }
                return _EMPTY_BYTE_ARRAY;
            }
        }

        static {
            String[] classNames = new String[]{"java.lang.Boolean", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "org.apache.myfaces.trinidad.util.TransientHolder"};
            _INGNORE_CLASS_NAMES = new HashSet<String>();
            _INGNORE_CLASS_NAMES.addAll(Arrays.asList(classNames));
            _LOG = TrinidadLogger.createTrinidadLogger(MutatedBeanChecker.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationCheckingWrapper
    extends ExternalContextDecorator {
        private static final String _SERIALIZATION_WRAPPER_KEY = CheckSerializationConfigurator.class.getName() + "#WRAPPER";
        private final ExternalContext _extContext;
        private final SerializationChecker _checker;

        public static SerializationCheckingWrapper getSerializationWrapper(ExternalContext extContext, boolean create) {
            SerializationChecker checker;
            Map requestMap = extContext.getRequestMap();
            Object wrapper = requestMap.get(_SERIALIZATION_WRAPPER_KEY);
            if (wrapper != null) {
                return (SerializationCheckingWrapper)((Object)wrapper);
            }
            if (create && (checker = SerializationChecker.getSerializationChecker(extContext, create)) != null) {
                SerializationCheckingWrapper checkingWrapper = new SerializationCheckingWrapper(extContext, checker);
                requestMap.put(_SERIALIZATION_WRAPPER_KEY, checkingWrapper);
                return checkingWrapper;
            }
            return null;
        }

        private SerializationCheckingWrapper(ExternalContext extContext, SerializationChecker checker) {
            this._extContext = extContext;
            this._checker = checker;
        }

        public void checkForMutations() {
            this._checker.checkForMutations();
        }

        public ExternalContext getExternalContext() {
            return this._extContext;
        }

        public Map<String, Object> getSessionMap() {
            return this._checker.getSessionMap();
        }

        public Map<String, Object> getApplicationMap() {
            return this._checker.getApplicationMap();
        }
    }

    private static class FilterConfigWrapper
    implements FilterConfig {
        private final FilterConfig _delegate;
        private final ServletContext _wrappedContext;

        FilterConfigWrapper(FilterConfig filterConfig) {
            this._delegate = filterConfig;
            this._wrappedContext = new ContextWrapper(filterConfig.getServletContext(), null);
        }

        public String getFilterName() {
            return this._delegate.getFilterName();
        }

        public ServletContext getServletContext() {
            return this._wrappedContext;
        }

        public String getInitParameter(String paramName) {
            return this._delegate.getInitParameter(paramName);
        }

        public Enumeration getInitParameterNames() {
            return this._delegate.getInitParameterNames();
        }
    }
}

