/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.convert;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.convert.ConverterUtils;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "org.apache.myfaces.trinidad.DateTime";
    public static final String CONVERT_DATE_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.DateTimeConverter.CONVERT_DATE";
    public static final String CONVERT_TIME_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.DateTimeConverter.CONVERT_TIME";
    public static final String CONVERT_BOTH_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.DateTimeConverter.CONVERT_BOTH";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _DATE_STYLE_KEY = _TYPE.registerKey("dateStyle", String.class, "shortish");
    private static final PropertyKey _LOCALE_KEY = _TYPE.registerKey("locale", Locale.class);
    private static final PropertyKey _PATTERN_KEY = _TYPE.registerKey("pattern", String.class);
    private static final PropertyKey _SECONDARY_PATTERN_KEY = _TYPE.registerKey("secondaryPattern", String.class);
    private static final PropertyKey _TIME_STYLE_KEY = _TYPE.registerKey("timeStyle", String.class, "short");
    private static final PropertyKey _TIME_ZONE_KEY = _TYPE.registerKey("timeZone", TimeZone.class);
    private static final PropertyKey _TYPE_KEY = _TYPE.registerKey("type", String.class, "date");
    private static final PropertyKey _CONVERT_DATE_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertDate", String.class);
    private static final PropertyKey _CONVERT_TIME_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertTime", String.class);
    private static final PropertyKey _CONVERT_BOTH_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvertBoth", String.class);
    private static final PropertyKey _HINT_DATE_KEY = _TYPE.registerKey("hintDate", String.class);
    private static final PropertyKey _HINT_TIME_KEY = _TYPE.registerKey("hintTime", String.class);
    private static final PropertyKey _HINT_BOTH_KEY = _TYPE.registerKey("hintBoth", String.class);
    private FacesBean _facesBean = ConverterUtils.getFacesBean(_TYPE);
    private boolean _isTransient;
    private static final TimeZone _DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final int _SHORTISH = -2;
    private static final int _TYPE_DATE = 0;
    private static final int _TYPE_TIME = 2;
    private static final int _TYPE_BOTH = 4;
    private static final String _ORA_LOCALE_ELEMENTS_BASE = "org.apache.myfaces.trinidad.resource.LocaleElements";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DateTimeConverter.class);
    private static final Date _EXAMPLE_DATE;
    private static final Map<Locale, List<String>> _CONVENIENCE_PATTERNS;
    private static final List<String> _US_CONVENIENCE_PATTERNS;

    public DateTimeConverter() {
    }

    public DateTimeConverter(String pattern) {
        this();
        this.setPattern(pattern);
    }

    public DateTimeConverter(String pattern, String secondaryPattern) {
        this(pattern);
        this.setSecondaryPattern(secondaryPattern);
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Date date = this._getParsedDate(context, component, value);
        if (date != null) {
            this._fillTimePortion(context, component, date);
        }
        return date;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (null == value) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (!(value instanceof Date)) {
            throw new ClassCastException(_LOG.getMessage("VALUE_IS_NOT_DATE_TYPE_IT_IS", new Object[]{value, value.getClass()}));
        }
        DateFormat format = this._getDateFormat(context, this.getPattern(), false, (Date)value);
        return format.format(value);
    }

    public void setMessageDetailConvertDate(String convertDateMessageDetail) {
        this._facesBean.setProperty(_CONVERT_DATE_MESSAGE_DETAIL_KEY, convertDateMessageDetail);
    }

    public String getMessageDetailConvertDate() {
        Object msg = this._facesBean.getProperty(_CONVERT_DATE_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setMessageDetailConvertTime(String convertTimeMessageDetail) {
        this._facesBean.setProperty(_CONVERT_TIME_MESSAGE_DETAIL_KEY, convertTimeMessageDetail);
    }

    public String getMessageDetailConvertTime() {
        Object msg = this._facesBean.getProperty(_CONVERT_TIME_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setMessageDetailConvertBoth(String convertBothMessageDetail) {
        this._facesBean.setProperty(_CONVERT_BOTH_MESSAGE_DETAIL_KEY, convertBothMessageDetail);
    }

    public String getMessageDetailConvertBoth() {
        Object msg = this._facesBean.getProperty(_CONVERT_BOTH_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(msg);
    }

    public void setHintDate(String hintDate) {
        this._facesBean.setProperty(_HINT_DATE_KEY, hintDate);
    }

    public String getHintDate() {
        Object obj = this._facesBean.getProperty(_HINT_DATE_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintTime(String hintTime) {
        this._facesBean.setProperty(_HINT_TIME_KEY, hintTime);
    }

    public String getHintTime() {
        Object obj = this._facesBean.getProperty(_HINT_TIME_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintBoth(String hintBoth) {
        this._facesBean.setProperty(_HINT_BOTH_KEY, hintBoth);
    }

    public String getHintBoth() {
        Object obj = this._facesBean.getProperty(_HINT_BOTH_KEY);
        return ComponentUtils.resolveString(obj);
    }

    protected Date getDate(FacesContext context, UIComponent component) {
        Object value;
        if (component instanceof ValueHolder && (value = ((ValueHolder)component).getValue()) instanceof Date) {
            return (Date)value;
        }
        return null;
    }

    private Locale _extractConverterLocale(FacesContext context) {
        Locale locale = this.getLocale();
        if (null == locale) {
            RequestContext reqContext = RequestContext.getCurrentInstance();
            if (reqContext != null) {
                locale = reqContext.getFormattingLocale();
            }
            if (locale == null) {
                locale = context.getViewRoot().getLocale();
            }
        }
        return locale;
    }

    private Date _getParsedDate(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (null == value) {
            return null;
        }
        if (1 > (value = value.trim()).length()) {
            return null;
        }
        try {
            DateFormat format;
            String pattern = this.getPattern();
            if (pattern == null && (format = this.getDateFormat(context, null, true, null)) instanceof SimpleDateFormat) {
                pattern = ((SimpleDateFormat)format).toPattern();
            }
            if (pattern != null) {
                return this._doLenientParse(context, component, value, pattern);
            }
            return this._parse(context, component, value, null);
        }
        catch (ConverterException ce) {
            try {
                String secPattern = this.getSecondaryPattern();
                if (secPattern != null) {
                    return this._doLenientParse(context, component, value, secPattern);
                }
            }
            catch (ConverterException secondaryCe) {
                // empty catch block
            }
            throw ce;
        }
    }

    private void _fillTimePortion(FacesContext context, UIComponent component, Date newDate) {
        Date prevDate = this.getDate(context, component);
        if (prevDate == null) {
            return;
        }
        String pattern = this.getPattern();
        if (pattern == null && !"date".equals(this.getType())) {
            return;
        }
        boolean fillMilliSeconds = true;
        boolean fillSeconds = true;
        boolean fillMinutes = true;
        boolean fillHour = true;
        if (pattern != null) {
            int patternLen = pattern.length();
            block6: for (int currCharIndex = 0; currCharIndex < patternLen; ++currCharIndex) {
                switch (pattern.charAt(currCharIndex)) {
                    case 'S': {
                        fillMilliSeconds = false;
                        continue block6;
                    }
                    case 's': {
                        fillSeconds = false;
                        continue block6;
                    }
                    case 'm': {
                        fillMinutes = false;
                        continue block6;
                    }
                    case 'H': 
                    case 'K': 
                    case 'h': 
                    case 'k': {
                        fillHour = false;
                    }
                }
            }
        }
        if (fillMilliSeconds || fillSeconds || fillMinutes || fillHour) {
            TimeZone timeZone = this._getTimeZone();
            Calendar prevCal = Calendar.getInstance(timeZone);
            prevCal.setTime(prevDate);
            Calendar newCal = Calendar.getInstance(timeZone);
            newCal.setTime(newDate);
            if (fillMilliSeconds) {
                newCal.set(14, prevCal.get(14));
            }
            if (fillSeconds) {
                newCal.set(13, prevCal.get(13));
            }
            if (fillMinutes) {
                newCal.set(12, prevCal.get(12));
            }
            if (fillHour) {
                newCal.set(11, prevCal.get(11));
            }
            newDate.setTime(newCal.getTimeInMillis());
        }
    }

    private Date _parse(FacesContext context, UIComponent component, String value, String pattern) {
        DateFormat fmt = this.getDateFormat(context, pattern, true, null);
        try {
            return fmt.parse(value);
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (ParseException pe) {
            Object[] params = this._getPlaceHolderParameters(context, component, value);
            throw new ConverterException(this.getParseErrorMessage(context, component, pattern, params), (Throwable)pe);
        }
    }

    private Date _doLenientParse(FacesContext context, UIComponent component, String value, String pattern) {
        if (pattern.endsWith(" '")) {
            value = value + " ";
        }
        try {
            return this._parse(context, component, value, pattern);
        }
        catch (ConverterException convException) {
            ConverterException ce = convException;
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.add(pattern);
            Locale locale = this._extractConverterLocale(context);
            if (_CONVENIENCE_PATTERNS.containsKey(locale)) {
                patterns.addAll((Collection)_CONVENIENCE_PATTERNS.get(locale));
            }
            ArrayList<String> lenientPatterns = new ArrayList<String>();
            for (String tmpPattern : patterns) {
                lenientPatterns.addAll(DateTimeConverter._getLenientPatterns(tmpPattern));
            }
            for (String lenientPattern : lenientPatterns) {
                try {
                    return this._parse(context, component, value, lenientPattern);
                }
                catch (ConverterException e) {
                }
            }
            throw ce;
        }
    }

    public void setLocale(Locale locale) {
        this._facesBean.setProperty(_LOCALE_KEY, locale);
    }

    public Locale getLocale() {
        Object locale = this._facesBean.getProperty(_LOCALE_KEY);
        return ComponentUtils.resolveLocale(locale);
    }

    public void setPattern(String pattern) {
        this._facesBean.setProperty(_PATTERN_KEY, pattern);
    }

    public String getPattern() {
        Object pattern = this._facesBean.getProperty(_PATTERN_KEY);
        return ComponentUtils.resolveString(pattern);
    }

    public void setTimeZone(TimeZone timeZone) {
        this._facesBean.setProperty(_TIME_ZONE_KEY, timeZone);
    }

    public TimeZone getTimeZone() {
        Object timeZone = this._facesBean.getProperty(_TIME_ZONE_KEY);
        return ComponentUtils.resolveTimeZone(timeZone);
    }

    public void setType(String type) {
        this._facesBean.setProperty(_TYPE_KEY, type);
    }

    public String getType() {
        Object type = this._facesBean.getProperty(_TYPE_KEY);
        return ComponentUtils.resolveString(type, "date");
    }

    public void setDateStyle(String dateStyle) {
        this._facesBean.setProperty(_DATE_STYLE_KEY, dateStyle);
    }

    public String getDateStyle() {
        Object dateStyle = this._facesBean.getProperty(_DATE_STYLE_KEY);
        return ComponentUtils.resolveString(dateStyle, "shortish");
    }

    public void setTimeStyle(String timeStyle) {
        this._facesBean.setProperty(_TIME_STYLE_KEY, timeStyle);
    }

    public String getTimeStyle() {
        Object timeStyle = this._facesBean.getProperty(_TIME_STYLE_KEY);
        return ComponentUtils.resolveString(timeStyle, "short");
    }

    public void setSecondaryPattern(String secondaryPattern) {
        this._facesBean.setProperty(_SECONDARY_PATTERN_KEY, secondaryPattern);
    }

    public String getSecondaryPattern() {
        Object secPattern = this._facesBean.getProperty(_SECONDARY_PATTERN_KEY);
        return ComponentUtils.resolveString(secPattern);
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setTransient(boolean isTransient) {
        this._isTransient = isTransient;
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        ConverterUtils.setValueExpression(this._facesBean, name, expression);
    }

    public ValueExpression getValueExpression(String name) {
        return ConverterUtils.getValueExpression(this._facesBean, name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ConverterUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ConverterUtils.getValueBinding(this._facesBean, name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DateTimeConverter) {
            DateTimeConverter other = (DateTimeConverter)((Object)object);
            if (this.isTransient() == other.isTransient() && ConverterUtils.equals(this.getDateStyle(), other.getDateStyle()) && ConverterUtils.equals(this.getLocale(), other.getLocale()) && ConverterUtils.equals(this.getPattern(), other.getPattern()) && ConverterUtils.equals(this.getTimeStyle(), other.getTimeStyle()) && ConverterUtils.equals(this.getTimeZone(), other.getTimeZone()) && ConverterUtils.equals(this.getType(), other.getType()) && ConverterUtils.equals(this.getSecondaryPattern(), other.getSecondaryPattern()) && ConverterUtils.equals(this.getMessageDetailConvertDate(), other.getMessageDetailConvertDate()) && ConverterUtils.equals(this.getMessageDetailConvertTime(), other.getMessageDetailConvertTime()) && ConverterUtils.equals(this.getMessageDetailConvertBoth(), other.getMessageDetailConvertBoth())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.isTransient() ? 1 : 0);
        result = result * 37 + DateTimeConverter._getHashValue(this.getDateStyle());
        result = result * 37 + DateTimeConverter._getHashValue(this.getLocale());
        result = result * 37 + DateTimeConverter._getHashValue(this.getPattern());
        result = result * 37 + DateTimeConverter._getHashValue(this.getTimeStyle());
        result = result * 37 + DateTimeConverter._getHashValue(this.getTimeZone());
        result = result * 37 + DateTimeConverter._getHashValue(this.getType());
        result = result * 37 + DateTimeConverter._getHashValue(this.getSecondaryPattern());
        result = result * 37 + DateTimeConverter._getHashValue(this.getMessageDetailConvertDate());
        result = result * 37 + DateTimeConverter._getHashValue(this.getMessageDetailConvertTime());
        result = result * 37 + DateTimeConverter._getHashValue(this.getMessageDetailConvertBoth());
        return result;
    }

    protected final DateFormat getDateFormat(FacesContext context, String pattern, boolean forParsing, Date targetDate) throws ConverterException {
        ConverterException exception = null;
        try {
            DateFormat format = this._getDateFormat(context, pattern, forParsing, targetDate);
            return format;
        }
        catch (ConverterException ce) {
            exception = ce;
        }
        catch (Exception e) {
            exception = new ConverterException((Throwable)e);
        }
        throw exception;
    }

    protected TimeZone getFormattingTimeZone(TimeZone tZone) {
        return this.getFormattingTimeZone(tZone, null);
    }

    protected TimeZone getFormattingTimeZone(TimeZone tZone, Date targetDate) {
        return tZone;
    }

    private String[] _getExpectedPatterns(FacesContext context) {
        String pattern = this.getPattern();
        if (pattern != null) {
            return this._getAllowedPatterns(context, pattern, this.getSecondaryPattern());
        }
        String datePattern = null;
        try {
            DateFormat format = this.getDateFormat(context, null, false, null);
            if (format != null && format instanceof SimpleDateFormat) {
                datePattern = ((SimpleDateFormat)format).toPattern();
            }
        }
        catch (ConverterException ce) {
            // empty catch block
        }
        return this._getAllowedPatterns(context, datePattern, this.getSecondaryPattern());
    }

    protected final FacesMessage getParseErrorMessage(FacesContext context, UIComponent component, String pattern, Object[] params) {
        String key = this.getViolationMessageKey(pattern);
        return this._getConvertErrorFacesMessage(context, key, params, component);
    }

    protected final String getExample(FacesContext context) {
        String[] expectedPatterns = this._getExpectedPatterns(context);
        assert (expectedPatterns != null && expectedPatterns.length >= 1);
        String example = expectedPatterns[0];
        return example;
    }

    private String[] _getAllowedPatterns(FacesContext context, String mainPattern, String secondaryPattern) {
        String[] patterns = mainPattern != null ? (secondaryPattern != null ? new String[]{mainPattern, secondaryPattern} : new String[]{mainPattern}) : new String[]{secondaryPattern};
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = this._getExample(context, patterns[i]);
        }
        return patterns;
    }

    private static final int _getDateStyle(String dateStyle) {
        if (dateStyle.equals("shortish")) {
            return -2;
        }
        if (dateStyle.equals("default")) {
            return 2;
        }
        if (dateStyle.equals("short")) {
            return 3;
        }
        if (dateStyle.equals("medium")) {
            return 2;
        }
        if (dateStyle.equals("long")) {
            return 1;
        }
        if (dateStyle.equals("full")) {
            return 0;
        }
        throw new IllegalStateException(_LOG.getMessage("INVALID_DATE_STYLE", dateStyle));
    }

    private static final int _getTimeStyle(String timeStyle) {
        if ("default".equals(timeStyle)) {
            return 2;
        }
        if ("short".equals(timeStyle)) {
            return 3;
        }
        if ("medium".equals(timeStyle)) {
            return 2;
        }
        if ("long".equals(timeStyle)) {
            return 1;
        }
        if ("full".equals(timeStyle)) {
            return 0;
        }
        throw new IllegalStateException(_LOG.getMessage("INVALID_TIME_STYLE", timeStyle));
    }

    private static int _getType(String type) {
        if ("date".equals(type)) {
            return 0;
        }
        if ("time".equals(type)) {
            return 2;
        }
        if ("both".equals(type)) {
            return 4;
        }
        throw new IllegalStateException(_LOG.getMessage("INVALID_TYPE", type));
    }

    private static int _getHashValue(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    private static List<String> _getLenientPatterns(String pattern) {
        ArrayList<String> patterns;
        block8: {
            int i;
            int len;
            String[] leniencyApplicablePatterns;
            block9: {
                int i2;
                block7: {
                    int i3;
                    patterns = new ArrayList<String>();
                    patterns.add(pattern);
                    leniencyApplicablePatterns = new String[]{pattern};
                    if (pattern.indexOf("MMM") != -1) {
                        String str2;
                        leniencyApplicablePatterns = new String[3];
                        leniencyApplicablePatterns[0] = pattern;
                        String str1 = pattern.replaceAll("MMM", "MM");
                        patterns.add(str1);
                        leniencyApplicablePatterns[1] = str1;
                        leniencyApplicablePatterns[2] = str2 = pattern.replaceAll("MMM", "M");
                        patterns.add(str2);
                    }
                    len = leniencyApplicablePatterns.length;
                    if (pattern.indexOf(47) == -1) break block7;
                    for (i3 = 0; i3 < len; ++i3) {
                        patterns.add(leniencyApplicablePatterns[i3].replaceAll("/", "-"));
                    }
                    for (i3 = 0; i3 < len; ++i3) {
                        patterns.add(leniencyApplicablePatterns[i3].replaceAll("/", "."));
                    }
                    break block8;
                }
                if (pattern.indexOf(45) == -1) break block9;
                for (i2 = 0; i2 < len; ++i2) {
                    patterns.add(leniencyApplicablePatterns[i2].replaceAll("-", "/"));
                }
                for (i2 = 0; i2 < len; ++i2) {
                    patterns.add(leniencyApplicablePatterns[i2].replaceAll("-", "."));
                }
                break block8;
            }
            if (pattern.indexOf(46) == -1) break block8;
            for (i = 0; i < len; ++i) {
                patterns.add(leniencyApplicablePatterns[i].replaceAll("\\.", "/"));
            }
            for (i = 0; i < len; ++i) {
                patterns.add(leniencyApplicablePatterns[i].replaceAll("\\.", "-"));
            }
        }
        return patterns;
    }

    private Object[] _getPlaceHolderParameters(FacesContext context, UIComponent component, String value) {
        Object label = ConverterUtils.getComponentLabel(component);
        String example = this.getExample(context);
        Object[] params = new Object[]{label, value, example};
        return params;
    }

    private Object _getRawConvertBothMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_BOTH_MESSAGE_DETAIL_KEY);
    }

    private Object _getRawConvertDateMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_DATE_MESSAGE_DETAIL_KEY);
    }

    private Object _getRawConvertTimeMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_TIME_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getConvertErrorFacesMessage(FacesContext context, String key, Object[] params, UIComponent component) {
        Object msgPattern = this.getMessagePattern(context, key, params, component);
        return MessageFactory.getMessage(context, key, msgPattern, params, component);
    }

    private String _getExample(FacesContext context, String pattern) {
        DateFormat format = this._getDateFormat(context, pattern, false, _EXAMPLE_DATE);
        return format.format(_EXAMPLE_DATE);
    }

    protected Object getMessagePattern(FacesContext context, String key, Object[] params, UIComponent component) {
        Object msgPattern;
        if (CONVERT_DATE_MESSAGE_ID.equals(key)) {
            msgPattern = this._getRawConvertDateMessageDetail();
        } else if (CONVERT_TIME_MESSAGE_ID.equals(key)) {
            msgPattern = this._getRawConvertTimeMessageDetail();
        } else if (CONVERT_BOTH_MESSAGE_ID.equals(key)) {
            msgPattern = this._getRawConvertBothMessageDetail();
        } else {
            throw new IllegalArgumentException(_LOG.getMessage("ILLEGAL_MESSAGE_ID", key));
        }
        return msgPattern;
    }

    protected String getViolationMessageKey(String pattern) {
        String key = null;
        if (this.getPattern() == null || pattern == null) {
            String type = this.getType();
            if ("date".equals(type)) {
                key = CONVERT_DATE_MESSAGE_ID;
            } else if ("time".equals(type)) {
                key = CONVERT_TIME_MESSAGE_ID;
            } else if ("both".equals(type)) {
                key = CONVERT_BOTH_MESSAGE_ID;
            } else if (pattern == null) {
                throw new IllegalArgumentException(_LOG.getMessage("ILLEGAL_ATTRIBUTE_TYPE_VALUE", type));
            }
        }
        if (key == null) {
            key = CONVERT_DATE_MESSAGE_ID;
        }
        return key;
    }

    private SimpleDateFormat _getSimpleDateFormat(String pattern, Locale locale) {
        String variant = locale.getVariant();
        SimpleDateFormat sdf = null;
        if (variant != null && variant.toUpperCase().startsWith("ORACLE")) {
            try {
                ResourceBundle oraElementsData = ResourceBundle.getBundle(_ORA_LOCALE_ELEMENTS_BASE, locale);
                DateFormatSymbols syms = new DateFormatSymbols(locale);
                String[] res = oraElementsData.getStringArray("AmPmMarkers");
                if (res != null) {
                    syms.setAmPmStrings(res);
                }
                if ((res = oraElementsData.getStringArray("Eras")) != null) {
                    syms.setEras(res);
                }
                if ((res = oraElementsData.getStringArray("MonthNames")) != null) {
                    syms.setMonths(res);
                }
                if ((res = oraElementsData.getStringArray("MonthAbbreviations")) != null) {
                    syms.setShortMonths(res);
                }
                if ((res = oraElementsData.getStringArray("DayAbbreviations")) != null) {
                    syms.setShortWeekdays(res);
                }
                if ((res = oraElementsData.getStringArray("DayNames")) != null) {
                    syms.setWeekdays(res);
                }
                sdf = new SimpleDateFormat(pattern, syms);
            }
            catch (MissingResourceException e) {
                sdf = new SimpleDateFormat(pattern, locale);
            }
        } else {
            sdf = new SimpleDateFormat(pattern, locale);
        }
        return sdf;
    }

    private SimpleDateFormat _get4YearFormat(SimpleDateFormat format, Locale loc) {
        String formatPattern = format.toPattern();
        int patternLen = formatPattern.length();
        int firstYIndex = -1;
        int yCount = 0;
        boolean inQuotes = false;
        block4: for (int currCharIndex = 0; currCharIndex < patternLen; ++currCharIndex) {
            char currChar = formatPattern.charAt(currCharIndex);
            switch (currChar) {
                case 'y': {
                    if (inQuotes) continue block4;
                    if (firstYIndex < 0) {
                        firstYIndex = currCharIndex;
                    }
                    ++yCount;
                    continue block4;
                }
                case '\'': {
                    if (inQuotes) {
                        int nextCharIndex = currCharIndex + 1;
                        if (nextCharIndex < patternLen && '\'' == formatPattern.charAt(nextCharIndex)) {
                            ++currCharIndex;
                            continue block4;
                        }
                        inQuotes = false;
                        continue block4;
                    }
                    inQuotes = true;
                }
            }
        }
        if (yCount > 0 && yCount < 4) {
            StringBuffer newFormatPattern = new StringBuffer(patternLen + 4 - yCount);
            if (firstYIndex > 0) {
                newFormatPattern.append(formatPattern.substring(0, firstYIndex));
            }
            while (yCount < 4) {
                newFormatPattern.append('y');
                ++yCount;
            }
            if (firstYIndex < patternLen) {
                newFormatPattern.append(formatPattern.substring(firstYIndex, patternLen));
            }
            format = this._getSimpleDateFormat(newFormatPattern.toString(), loc);
        }
        return format;
    }

    private DateFormat _getDateFormat(FacesContext context, String pattern, boolean forParsing, Date targetDate) {
        TimeZone tZone;
        Locale locale = this._extractConverterLocale(context);
        DateFormat format = this._getCachedFormat(locale, tZone = this._getTimeZone(), pattern);
        if (format != null) {
            format.setTimeZone(tZone);
        } else {
            if (null == pattern || "".equals(pattern)) {
                int type = DateTimeConverter._getType(this.getType());
                if (type == 0 || type == 4) {
                    int actualDateStyle = DateTimeConverter._getDateStyle(this.getDateStyle());
                    int dateStyle = this._changeShortishAsShortIfNeeded(actualDateStyle);
                    if (type == 0) {
                        format = DateFormat.getDateInstance(dateStyle, locale);
                    } else {
                        int timeStyle = DateTimeConverter._getTimeStyle(this.getTimeStyle());
                        format = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                    }
                }
                if (type == 2) {
                    int timeStyle = DateTimeConverter._getTimeStyle(this.getTimeStyle());
                    format = DateFormat.getTimeInstance(timeStyle, locale);
                }
            } else {
                format = this._getSimpleDateFormat(pattern, locale);
            }
            if (format instanceof SimpleDateFormat && !forParsing) {
                GregorianCalendar cal;
                RequestContext reqContext;
                int type;
                SimpleDateFormat simpleFormat = (SimpleDateFormat)format;
                if (null == pattern && "shortish".equals(this.getDateStyle()) && ((type = DateTimeConverter._getType(this.getType())) == 0 || type == 4)) {
                    simpleFormat = this._get4YearFormat(simpleFormat, locale);
                    format = simpleFormat;
                }
                if ((reqContext = RequestContext.getCurrentInstance()) == null) {
                    cal = null;
                    if (_LOG.isWarning()) {
                        _LOG.warning("NO_REQUESTCONTEXT_TWO_DIGIT_YEAR_START_DEFAULT");
                    }
                } else {
                    cal = new GregorianCalendar(reqContext.getTwoDigitYearStart(), 0, 0);
                }
                if (cal != null) {
                    simpleFormat.set2DigitYearStart(cal.getTime());
                }
            }
            format.setLenient(false);
            if (tZone != null) {
                TimeZone formatTZone = this.getFormattingTimeZone(tZone, targetDate);
                format.setTimeZone(formatTZone);
            }
            this._cacheFormat(format, locale, tZone, pattern);
        }
        return format;
    }

    private int _changeShortishAsShortIfNeeded(int dateStyle) {
        if (dateStyle == -2) {
            dateStyle = 3;
        }
        return dateStyle;
    }

    private DateFormat _getCachedFormat(Locale locale, TimeZone tZone, String pattern) {
        return null;
    }

    private void _cacheFormat(DateFormat format, Locale locale, TimeZone tZone, String pattern) {
    }

    private TimeZone _getTimeZone() {
        TimeZone tZone = this.getTimeZone();
        if (tZone == null) {
            RequestContext context = RequestContext.getCurrentInstance();
            if (context == null) {
                _LOG.warning("NO_REQUESTCONTEXT_TIMEZONE_DEFAULT");
            } else {
                tZone = context.getTimeZone();
            }
            if (tZone == null) {
                tZone = _DEFAULT_TIME_ZONE;
            }
        }
        return tZone;
    }

    static {
        _CONVENIENCE_PATTERNS = new HashMap<Locale, List<String>>();
        _US_CONVENIENCE_PATTERNS = Arrays.asList("MMMM dd, yy", "MMMM/dd/yy", "dd-MMMM-yy");
        Calendar dateFactory = Calendar.getInstance();
        dateFactory.set(1998, 10, 29, 15, 45);
        _EXAMPLE_DATE = dateFactory.getTime();
        _CONVENIENCE_PATTERNS.put(Locale.US, _US_CONVENIENCE_PATTERNS);
    }
}

