/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRendererUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;

public abstract class SimpleSelectBooleanRenderer
extends FormInputRenderer {
    private PropertyKey _textKey;
    private PropertyKey _accessKeyKey;

    public SimpleSelectBooleanRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._accessKeyKey = type.findKey("accessKey");
    }

    protected abstract Object getValueAttr(RenderingContext var1);

    protected abstract Object getType();

    protected abstract String getIconName(boolean var1, boolean var2);

    protected abstract String getIconAltTextName(boolean var1);

    protected void renderNameAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
    }

    protected void encodeAllAsElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = LabelAndMessageRenderer.__getCachedClientId(arc);
        boolean getRenderSimpleSpan = this.getRenderSimpleSpan(bean);
        if (getRenderSimpleSpan) {
            writer.startElement("span", component);
            this.renderRootDomElementStyles(context, arc, component, bean);
            this._renderPartialId(context, arc, clientId);
        }
        writer.startElement("span", component);
        if (SimpleSelectBooleanRenderer.supportsScripting(arc)) {
            this.renderSpanEventHandlers(context, bean);
        }
        SimpleSelectBooleanRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)this.getContentStyleClass(bean));
        SimpleSelectBooleanRenderer.renderInlineStyleAttribute(context, arc, this.getContentStyle(bean));
        if (!getRenderSimpleSpan) {
            this._renderPartialId(context, arc, clientId);
        }
        char accessKey = SimpleSelectBooleanRenderer.supportsAccessKeys(arc) ? (char)this.getAccessKey(bean) : (char)'\uffff';
        if (this.isAutoSubmit(bean)) {
            AutoSubmitUtils.writeDependencies(context, arc);
        }
        writer.startElement("input", null);
        this.renderId(context, component);
        this.renderShortDescAttribute(context, arc, bean);
        if (SimpleSelectBooleanRenderer.supportsScripting(arc)) {
            this.renderInputEventHandlers(context, bean);
        }
        this.renderDisabledAttribute(context, arc, bean);
        if (!this.shouldRenderName(context, component)) {
            this.renderNameAttribute(context, arc, bean);
        }
        if (accessKey != '\uffff') {
            writer.writeAttribute("accesskey", (Object)Character.toString(accessKey), null);
        }
        writer.writeAttribute("type", this.getType(), null);
        writer.writeAttribute("value", this.getValueAttr(arc), null);
        Object value = this.getSubmittedValue(bean);
        if (value == null) {
            value = this.getValue(bean);
        }
        if (!(value instanceof Boolean)) {
            value = Boolean.valueOf(this.getConvertedString(context, component, bean));
        }
        if (Boolean.TRUE.equals(value)) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
        writer.endElement("input");
        String text = this.getText(bean);
        boolean renderLabelTags = this._isLabelTagRendered(arc, text, accessKey);
        if (renderLabelTags) {
            writer.startElement("label", null);
            writer.writeAttribute("for", (Object)clientId, null);
            HiddenLabelUtils.rememberLabel(arc, clientId);
        }
        this.renderText(context, arc, component, bean, true, false, text, accessKey);
        if (renderLabelTags) {
            writer.endElement("label");
        }
        if (this.isHiddenLabelRequired(arc)) {
            this.renderShortDescAsHiddenLabel(context, arc, component, bean);
        }
        writer.endElement("span");
        if (getRenderSimpleSpan) {
            writer.endElement("span");
        }
    }

    protected void encodeAllAsNonElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean getRenderSimpleSpan = this.getRenderSimpleSpan(bean);
        String clientId = LabelAndMessageRenderer.__getCachedClientId(arc);
        if (getRenderSimpleSpan) {
            writer.startElement("span", component);
            this.renderRootDomElementStyles(context, arc, component, bean);
            this._renderPartialId(context, arc, clientId);
        }
        writer.startElement("div", component);
        if (!getRenderSimpleSpan) {
            this._renderPartialId(context, arc, clientId);
        }
        SimpleSelectBooleanRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)this.getContentStyleClass(bean));
        SimpleSelectBooleanRenderer.renderInlineStyleAttribute(context, arc, this.getContentStyle(bean));
        this.renderShortDescAttribute(context, arc, bean);
        Object value = this.getSubmittedValue(bean);
        if (value == null) {
            value = this.getValue(bean);
        }
        if (!(value instanceof Boolean)) {
            value = Boolean.valueOf(this.getConvertedString(context, component, bean));
        }
        boolean selected = Boolean.TRUE.equals(value);
        boolean disabled = this.getDisabled(bean);
        String iconName = this.getIconName(selected, disabled);
        Icon icon = arc.getIcon(iconName);
        String altTextName = this.getIconAltTextName(selected);
        String shortDesc = arc.getTranslatedString(altTextName);
        OutputUtils.renderIcon(context, arc, icon, shortDesc, null);
        String text = this.getText(bean);
        if (text != null) {
            writer.writeText((Object)XhtmlConstants.NBSP_STRING, null);
            writer.writeText((Object)text, "text");
        }
        writer.endElement("div");
        if (getRenderSimpleSpan) {
            writer.endElement("span");
        }
    }

    protected void renderSpanEventHandlers(FacesContext context, FacesBean bean) throws IOException {
    }

    protected void renderInputEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        this.renderEventHandlers(context, bean);
    }

    protected void renderAccessKeyAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
    }

    protected void renderText(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean renderAccessKeys, boolean renderID, String text, char accessKey) throws IOException {
        if (text != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", component);
            if (renderID) {
                this.renderId(context, component);
            }
            if (renderAccessKeys && SimpleSelectBooleanRenderer.supportsAccessKeys(arc)) {
                AccessKeyUtils.renderAccessKeyText(context, (Object)text, accessKey, "AFAccessKeyStyle");
            } else {
                writer.writeText((Object)text, null);
            }
            writer.endElement("span");
        }
    }

    protected String getAutoSubmitScript(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String source = LabelAndMessageRenderer.__getCachedClientId(arc);
        boolean immediate = this.isImmediate(bean);
        boolean isRadio = this.isRadio();
        return AutoSubmitUtils.getSubmitScript(arc, source, immediate, isRadio, "autosub", null, true);
    }

    protected boolean isRadio() {
        return false;
    }

    protected String getCompositeId(String clientId) {
        return clientId + "__xc_" + "c";
    }

    protected String getText(FacesBean bean) {
        return SimpleSelectBooleanRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    protected char getAccessKey(FacesBean bean) {
        return SimpleSelectBooleanRenderer.toChar((Object)bean.getProperty(this._accessKeyKey));
    }

    protected boolean getRenderSimpleSpan(FacesBean bean) {
        return this.getSimple(bean);
    }

    private boolean _isLabelTagRendered(RenderingContext arc, String text, char accessKey) {
        if (text == null) {
            return false;
        }
        return !SimpleSelectBooleanRenderer.isInaccessibleMode((RenderingContext)arc) || accessKey != '\uffff';
    }

    private void _renderPartialId(FacesContext context, RenderingContext arc, String clientId) throws IOException {
        if (clientId != null && CoreRendererUtils.supportsPartialRendering(arc)) {
            String compositeId = this.getCompositeId(clientId);
            context.getResponseWriter().writeAttribute("id", (Object)compositeId, null);
        }
    }
}

