/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.Part;
import org.apache.myfaces.tobago.component.SupportFieldId;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.component.SupportsDecorationPosition;
import org.apache.myfaces.tobago.component.SupportsHelp;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.util.MessageUtils;

public abstract class AbstractUIFile
extends UIInput
implements SupportsLabelLayout,
Visual,
ClientBehaviorHolder,
SupportFieldId,
SupportsHelp,
SupportsAutoSpacing,
SupportsDecorationPosition {
    private transient boolean nextToRenderIsLabel;

    public void validate(FacesContext facesContext) {
        if (this.isRequired()) {
            if (this.getSubmittedValue() instanceof Part) {
                Part file = (Part)this.getSubmittedValue();
                if (file == null || file.getName().length() == 0) {
                    this.addErrorMessage(facesContext);
                    this.setValid(false);
                }
            } else {
                this.addErrorMessage(facesContext);
                this.setValid(false);
            }
        }
        super.validate(facesContext);
    }

    private void addErrorMessage(FacesContext facesContext) {
        facesContext.addMessage(this.getClientId(facesContext), MessageUtils.getMessage(facesContext, FacesMessage.SEVERITY_ERROR, "jakarta.faces.component.UIInput.REQUIRED", this.getId()));
    }

    public abstract boolean isDisabled();

    public abstract boolean isReadonly();

    public abstract boolean isMultiple();

    public abstract Integer getTabIndex();

    public abstract String getDropZone();

    @Override
    public String getFieldId(FacesContext facesContext) {
        return this.getClientId(facesContext) + "::" + "field";
    }

    @Override
    public boolean isNextToRenderIsLabel() {
        return this.nextToRenderIsLabel;
    }

    @Override
    public void setNextToRenderIsLabel(boolean nextToRenderIsLabel) {
        this.nextToRenderIsLabel = nextToRenderIsLabel;
    }
}

