/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBadge;
import org.apache.myfaces.tobago.internal.component.AbstractUIButton;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.renderkit.renderer.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.util.ComponentUtils;

public class ButtonRenderer
extends CommandRendererBase {
    @Override
    protected TobagoClass getRendererCssClass() {
        return TobagoClass.BUTTON;
    }

    @Override
    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUICommand command) {
        boolean defaultCommand = ComponentUtils.getBooleanAttribute((UIComponent)command, Attributes.defaultCommand);
        Markup markup = command.getMarkup() != null ? command.getMarkup() : Markup.NULL;
        return new CssItem[]{BootstrapClass.BTN, this.getButtonColor(command.getMarkup(), defaultCommand), markup.contains(Markup.BADGE) ? BootstrapClass.BADGE : null, markup.contains(Markup.BADGE) && markup.contains(Markup.PILL) ? BootstrapClass.BADGE_PILL : null};
    }

    private BootstrapClass getButtonColor(Markup markup, boolean defaultCommand) {
        if (markup != null) {
            if (markup.contains(Markup.NONE)) {
                return null;
            }
            if (markup.contains(Markup.PRIMARY)) {
                return BootstrapClass.BTN_PRIMARY;
            }
            if (markup.contains(Markup.SECONDARY)) {
                return BootstrapClass.BTN_SECONDARY;
            }
            if (markup.contains(Markup.SUCCESS)) {
                return BootstrapClass.BTN_SUCCESS;
            }
            if (markup.contains(Markup.DANGER)) {
                return BootstrapClass.BTN_DANGER;
            }
            if (markup.contains(Markup.WARNING)) {
                return BootstrapClass.BTN_WARNING;
            }
            if (markup.contains(Markup.INFO)) {
                return BootstrapClass.BTN_INFO;
            }
            if (markup.contains(Markup.LIGHT)) {
                return BootstrapClass.BTN_LIGHT;
            }
            if (markup.contains(Markup.DARK)) {
                return BootstrapClass.BTN_DARK;
            }
            if (markup.contains(Markup.OUTLINE_PRIMARY)) {
                return BootstrapClass.BTN_OUTLINE_PRIMARY;
            }
            if (markup.contains(Markup.OUTLINE_SECONDARY)) {
                return BootstrapClass.BTN_OUTLINE_SECONDARY;
            }
            if (markup.contains(Markup.OUTLINE_SUCCESS)) {
                return BootstrapClass.BTN_OUTLINE_SUCCESS;
            }
            if (markup.contains(Markup.OUTLINE_DANGER)) {
                return BootstrapClass.BTN_OUTLINE_DANGER;
            }
            if (markup.contains(Markup.OUTLINE_WARNING)) {
                return BootstrapClass.BTN_OUTLINE_WARNING;
            }
            if (markup.contains(Markup.OUTLINE_INFO)) {
                return BootstrapClass.BTN_OUTLINE_INFO;
            }
            if (markup.contains(Markup.OUTLINE_LIGHT)) {
                return BootstrapClass.BTN_OUTLINE_LIGHT;
            }
            if (markup.contains(Markup.OUTLINE_DARK)) {
                return BootstrapClass.BTN_OUTLINE_DARK;
            }
        }
        return defaultCommand ? BootstrapClass.BTN_PRIMARY : BootstrapClass.BTN_SECONDARY;
    }

    @Override
    protected void encodeBadge(FacesContext facesContext, AbstractUICommand command) throws IOException {
        AbstractUIButton button = (AbstractUIButton)command;
        for (UIComponent child : button.getChildren()) {
            if (!(child instanceof AbstractUIBadge)) continue;
            child.encodeAll(facesContext);
        }
    }
}

