/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class FormRenderer
extends RendererBase {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIForm form = (AbstractUIForm)component;
        if (!form.isPlain()) {
            TobagoResponseWriter writer = this.getResponseWriter(facesContext);
            String clientId = form.getClientId(facesContext);
            boolean inline = form.isInline();
            writer.startElement(HtmlElements.DIV);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(form.getMarkup()), false);
            writer.writeClassAttribute(TobagoClass.FORM, inline ? BootstrapClass.D_INLINE : null, form.getCustomClass());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIForm form = (AbstractUIForm)component;
        if (!form.isPlain()) {
            TobagoResponseWriter writer = this.getResponseWriter(facesContext);
            writer.endElement(HtmlElements.DIV);
        }
    }
}

