/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderersConfigImpl
implements RenderersConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RenderersConfigImpl.class);
    private Map<String, RendererConfig> rendererMap = new HashMap<String, RendererConfig>();
    private boolean merged = false;
    private boolean unmodifiable = false;

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new RuntimeException("The configuration must not be changed after initialization!");
        }
    }

    public void lock() {
        this.unmodifiable = true;
        this.rendererMap = Collections.unmodifiableMap(this.rendererMap);
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.checkLocked();
        this.merged = merged;
    }

    @Override
    public List<RendererConfig> getRendererConfigs() {
        ArrayList<RendererConfig> result = new ArrayList<RendererConfig>();
        result.addAll(this.rendererMap.values());
        return result;
    }

    public void addRenderer(RendererConfig rendererConfig) {
        this.checkLocked();
        String name = rendererConfig.getName();
        if (this.rendererMap.containsKey(name)) {
            this.rendererMap.get(name).merge(rendererConfig);
        } else {
            this.rendererMap.put(name, rendererConfig);
        }
    }

    @Override
    public boolean isMarkupSupported(String rendererName, String markup) {
        RendererConfig rendererConfig = this.rendererMap.get(rendererName);
        if (rendererConfig != null) {
            return rendererConfig.contains(markup);
        }
        LOG.error("Calling isMarkupSupported('{}', '{}'), but no configuration found.", (Object)rendererName, (Object)markup);
        return false;
    }

    public void merge(RenderersConfig renderersConfig, boolean override) {
        this.checkLocked();
        List<RendererConfig> renderers = renderersConfig.getRendererConfigs();
        for (RendererConfig rendererConfig : renderers) {
            this.addRenderer(rendererConfig);
        }
    }

    public String toString() {
        return this.rendererMap.toString();
    }
}

