/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.viewController.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;

import org.apache.myfaces.orchestra.viewController.ViewControllerManager;
import org.apache.myfaces.orchestra.viewController.ViewControllerManagerFactory;

/**
 * Provides a way to access the viewController through the JSF expression language (EL)
 * using the special variable name <code>oxViewController</code>.
 */
public class ViewControllerVariableResolver extends VariableResolver
{
    private final static String VIEW_CONTROLLER_VARIABLE = "oxViewController";

    private final VariableResolver original;

    public ViewControllerVariableResolver(VariableResolver original)
    {
        this.original = original;
    }

    public Object resolveVariable(FacesContext facesContext, String variableName) throws EvaluationException
    {
        if (VIEW_CONTROLLER_VARIABLE.equals(variableName))
        {
            ViewControllerManager manager = ViewControllerManagerFactory.getInstance();
            return manager.getViewController(facesContext.getViewRoot().getViewId());
        }

        return original.resolveVariable(facesContext, variableName);
    }
}
